/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import com.badlogic.gdx.math.Rectangle;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.ItemManagerModel;
import forge.toolbox.FContainer;
import forge.toolbox.FEvent;
import forge.toolbox.FScrollPane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class ItemView<T extends InventoryItem> {
    protected static final float UNOWNED_ALPHA_COMPOSITE = 0.35f;
    protected final ItemManager<T> itemManager;
    protected final ItemManagerModel<T> model;
    protected int minSelections = 0;
    protected int maxSelections = 1;
    private final Scroller scroller = new Scroller();
    private final OptionsPanel pnlOptions = new OptionsPanel();
    private float heightBackup;
    private boolean isIncrementalSearchActive = false;

    private static FSkinColor getBorderColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    protected ItemView(ItemManager<T> itemManager0, ItemManagerModel<T> model0) {
        this.itemManager = itemManager0;
        this.model = model0;
    }

    protected boolean tap(float x, float y, int count) {
        return false;
    }

    protected boolean zoom(float x, float y, float amount) {
        return false;
    }

    protected abstract float getScrollHeight();

    protected abstract void layoutOptionsPanel(float var1, float var2);

    public FScrollPane getScroller() {
        return this.scroller;
    }

    public FContainer getPnlOptions() {
        return this.pnlOptions;
    }

    public float getScrollValue() {
        return this.scroller.getScrollTop();
    }

    public void setScrollValue(float value) {
        this.scroller.setScrollTop(value);
    }

    public boolean isIncrementalSearchActive() {
        return this.isIncrementalSearchActive;
    }

    public void refresh(Iterable<T> itemsToSelect, int backupIndexToSelect, float scrollValueToRestore) {
        this.model.refreshSort();
        this.onRefresh();
        this.fixSelection(itemsToSelect, backupIndexToSelect, scrollValueToRestore);
    }

    protected abstract void onResize(float var1, float var2);

    protected abstract void onRefresh();

    protected void fixSelection(Iterable<T> itemsToSelect, int backupIndexToSelect, float scrollValueToRestore) {
        if (itemsToSelect == null) {
            if (this.itemManager.getMultiSelectMode()) {
                this.setSelectedIndex(-1, false);
            } else {
                this.setSelectedIndex(0, false);
            }
            this.setScrollValue(0.0f);
        } else if (!this.setSelectedItems(itemsToSelect)) {
            this.setSelectedIndex(backupIndexToSelect);
            if (this.itemManager.getMultiSelectMode()) {
                this.setSelectedIndex(-1, false);
            }
        }
    }

    public final T getSelectedItem() {
        return this.getItemAtIndex(this.getSelectedIndex());
    }

    public final Collection<T> getSelectedItems() {
        ArrayList<T> items = new ArrayList<T>();
        for (Integer i : this.getSelectedIndices()) {
            T item = this.getItemAtIndex(i);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public final boolean setSelectedItem(T item) {
        return this.setSelectedItem(item, true);
    }

    public final boolean setSelectedItem(T item, boolean scrollIntoView) {
        int index = this.getIndexOfItem(item);
        if (index != -1) {
            this.setSelectedIndex(index, scrollIntoView);
            return true;
        }
        return false;
    }

    public final boolean setSelectedItems(Iterable<T> items) {
        return this.setSelectedItems(items, true);
    }

    public final boolean setSelectedItems(Iterable<T> items, boolean scrollIntoView) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (InventoryItem item : items) {
            int index = this.getIndexOfItem(item);
            if (index == -1) continue;
            indices.add(index);
        }
        if (indices.size() > 0) {
            this.onSetSelectedIndices(indices);
            if (scrollIntoView) {
                this.scrollSelectionIntoView();
            }
            this.onSelectionChange();
            return true;
        }
        return false;
    }

    public void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true);
    }

    public void setSelectedIndex(int index, boolean scrollIntoView) {
        int count = this.getCount();
        if (count == 0) {
            return;
        }
        if (this.maxSelections == 0) {
            return;
        }
        if (index < 0) {
            if (index == -1 && this.minSelections == 0) {
                if (this.getSelectionCount() > 0) {
                    this.onSetSelectedIndices(new ArrayList<Integer>());
                    this.onSelectionChange();
                }
                return;
            }
            index = 0;
        } else if (index >= count) {
            index = count - 1;
        }
        this.onSetSelectedIndex(index);
        if (scrollIntoView) {
            this.scrollSelectionIntoView();
        }
        this.onSelectionChange();
    }

    public void setSelectedIndices(Iterable<Integer> indices) {
        this.setSelectedIndices(indices, true);
    }

    public void setSelectedIndices(Iterable<Integer> indices, boolean scrollIntoView) {
        int count = this.getCount();
        if (count == 0) {
            return;
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (Integer index : indices) {
            if (index < 0 || index >= count) continue;
            indexList.add(index);
        }
        if (indexList.isEmpty()) {
            Iterator<Integer> iterator = indices.iterator();
            if (iterator.hasNext()) {
                Integer index;
                index = iterator.next();
                this.setSelectedIndex(index);
                return;
            }
            return;
        }
        this.onSetSelectedIndices(indexList);
        if (scrollIntoView) {
            this.scrollSelectionIntoView();
        }
        this.onSelectionChange();
    }

    protected void onSelectionChange() {
        if ((this.getSelectedIndex() != -1 || this.itemManager.getMultiSelectMode()) && this.itemManager.getSelectionChangedHandler() != null) {
            this.itemManager.getSelectionChangedHandler().handleEvent(new FEvent(this.itemManager, FEvent.FEventType.CHANGE));
        }
    }

    public void setSelectionSupport(int minSelections0, int maxSelections0) {
        this.minSelections = minSelections0;
        this.maxSelections = maxSelections0;
    }

    public String toString() {
        return this.getCaption();
    }

    public abstract void setup(ItemManagerConfig var1, Map<ColumnDef, ItemColumn> var2);

    public abstract T getItemAtIndex(int var1);

    public abstract int getIndexOfItem(T var1);

    public abstract int getSelectedIndex();

    public abstract Iterable<Integer> getSelectedIndices();

    public abstract void selectAll();

    public abstract int getCount();

    public abstract int getSelectionCount();

    public abstract int getIndexAtPoint(float var1, float var2);

    public abstract void scrollSelectionIntoView();

    public abstract Rectangle getSelectionBounds();

    public abstract void zoomSelected();

    public abstract FImage getIcon();

    public abstract String getCaption();

    protected abstract void onSetSelectedIndex(int var1);

    protected abstract void onSetSelectedIndices(Iterable<Integer> var1);

    private class OptionsPanel
    extends FContainer {
        private OptionsPanel() {
        }

        @Override
        protected void doLayout(float width, float height) {
            ItemView.this.layoutOptionsPanel(width, height);
        }
    }

    private class Scroller
    extends FScrollPane {
        private Scroller() {
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            ItemView.this.onResize(visibleWidth, visibleHeight);
            return new FScrollPane.ScrollBounds(visibleWidth, ItemView.this.getScrollHeight());
        }

        @Override
        protected void setScrollPositionsAfterLayout(float scrollLeft0, float scrollTop0) {
            if (this.getHeight() != ItemView.this.heightBackup) {
                ItemView.this.heightBackup = this.getHeight();
                ItemView.this.scrollSelectionIntoView();
            } else {
                super.setScrollPositionsAfterLayout(scrollLeft0, scrollTop0);
            }
        }

        @Override
        public boolean tap(float x, float y, int count) {
            return ItemView.this.tap(x, y, count);
        }

        @Override
        public boolean zoom(float x, float y, float amount) {
            return ItemView.this.zoom(x, y, amount);
        }

        @Override
        public void drawOverlay(Graphics g2) {
            super.drawOverlay(g2);
            g2.drawRect(1.5f, ItemView.getBorderColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
    }
}

