/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import com.badlogic.gdx.math.Rectangle;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.ItemManagerModel;
import forge.itemmanager.views.ItemView;
import forge.toolbox.FCheckBox;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class ItemListView<T extends InventoryItem>
extends ItemView<T> {
    private final ItemList list = new ItemList();
    private final ItemListModel listModel;
    private final List<Integer> selectedIndices = new ArrayList<Integer>();

    private static FSkinColor getRowColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ZEBRA);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ZEBRA);
    }

    private static FSkinColor getAltRowColor() {
        return ItemListView.getRowColor().getContrastColor(-20);
    }

    private static FSkinColor getSelColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ACTIVE);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE);
    }

    public ItemListModel getListModel() {
        return this.listModel;
    }

    public ItemListView(ItemManager<T> itemManager0, ItemManagerModel<T> model0) {
        super(itemManager0, model0);
        this.listModel = new ItemListModel(model0);
        this.getPnlOptions().setVisible(false);
        this.getScroller().add(this.list);
    }

    @Override
    public void setup(ItemManagerConfig config, Map<ColumnDef, ItemColumn> colOverrides) {
        this.list.compactModeHandler.setCompactMode(config.getCompactListView());
        this.refresh(null, 0, 0.0f);
    }

    @Override
    public FImage getIcon() {
        return FSkinImage.LIST;
    }

    @Override
    public String getCaption() {
        return Forge.getLocalizer().getMessage("lblListView", new Object[0]);
    }

    @Override
    public int getSelectedIndex() {
        if (this.selectedIndices.isEmpty()) {
            return -1;
        }
        return this.selectedIndices.get(0);
    }

    @Override
    public Iterable<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    @Override
    protected void onSetSelectedIndex(int index) {
        this.selectedIndices.clear();
        this.selectedIndices.add(index);
    }

    @Override
    protected void onSetSelectedIndices(Iterable<Integer> indices) {
        this.selectedIndices.clear();
        for (Integer index : indices) {
            this.selectedIndices.add(index);
        }
    }

    @Override
    public float getScrollValue() {
        return this.list.getScrollTop();
    }

    @Override
    public void setScrollValue(float value) {
        this.list.setScrollTop(value);
    }

    @Override
    public void scrollSelectionIntoView() {
        this.list.scrollIntoView(this.getSelectedIndex());
    }

    @Override
    public Rectangle getSelectionBounds() {
        if (this.selectedIndices.isEmpty()) {
            return null;
        }
        return new Rectangle(this.list.screenPos.x, this.list.screenPos.y + this.list.getItemStartPosition(this.getSelectedIndex()), this.list.getWidth(), this.list.getListItemRenderer().getItemHeight());
    }

    @Override
    public void zoomSelected() {
        if (this.selectedIndices.isEmpty()) {
            return;
        }
        this.list.longPress(this.list.screenPos.x, this.list.screenPos.y + this.list.getItemStartPosition(this.getSelectedIndex()) - this.list.getListItemRenderer().getItemHeight());
    }

    @Override
    public void selectAll() {
        this.selectedIndices.clear();
        IntStream.range(0, this.getCount()).forEach(this.selectedIndices::add);
        this.onSelectionChange();
    }

    @Override
    public int getIndexOfItem(T item) {
        return this.listModel.itemToRow(item);
    }

    @Override
    public T getItemAtIndex(int index) {
        Map.Entry itemEntry = this.listModel.rowToItem(index);
        return (T)(itemEntry != null ? (InventoryItem)itemEntry.getKey() : null);
    }

    @Override
    public int getCount() {
        return this.list.getCount();
    }

    @Override
    public int getSelectionCount() {
        return this.selectedIndices.size();
    }

    @Override
    public int getIndexAtPoint(float x, float y) {
        return 0;
    }

    @Override
    protected void onResize(float visibleWidth, float visibleHeight) {
        this.list.setSize(visibleWidth, visibleHeight);
    }

    @Override
    protected void onRefresh() {
        this.list.setListData(this.model.getOrderedList());
    }

    @Override
    protected float getScrollHeight() {
        return this.getScroller().getHeight();
    }

    @Override
    protected void layoutOptionsPanel(float width, float height) {
    }

    public final class ItemListModel {
        private final ItemManagerModel<T> model;

        public ItemListModel(ItemManagerModel<T> model0) {
            this.model = model0;
        }

        public Map.Entry<T, Integer> rowToItem(int row) {
            List orderedList = this.model.getOrderedList();
            return row >= 0 && row < orderedList.size() ? orderedList.get(row) : null;
        }

        public int itemToRow(T item) {
            List orderedList = this.model.getOrderedList();
            for (int i = 0; i < orderedList.size(); ++i) {
                if (orderedList.get(i).getKey() != item) continue;
                return i;
            }
            return -1;
        }
    }

    public final class ItemList
    extends FList<Map.Entry<T, Integer>> {
        private final ItemManager.ItemRenderer renderer;
        private final FList.CompactModeHandler compactModeHandler = new FList.CompactModeHandler();

        private ItemList() {
            this.renderer = ItemListView.this.itemManager.getListItemRenderer(this.compactModeHandler);
            this.setListItemRenderer(new FList.ListItemRenderer<Map.Entry<T, Integer>>(){
                private int prevTapIndex = -1;

                @Override
                public float getItemHeight() {
                    return ItemList.this.renderer.getItemHeight();
                }

                @Override
                public boolean tap(Integer index, Map.Entry<T, Integer> value, float x, float y, int count) {
                    if (ItemListView.this.maxSelections > 1) {
                        if (!ItemList.this.renderer.tap(index, value, x, y, count)) {
                            if (ItemListView.this.selectedIndices.contains(index)) {
                                if (ItemListView.this.selectedIndices.size() > ItemListView.this.minSelections || ItemListView.this.selectedIndices.size() == ItemListView.this.maxSelections) {
                                    ItemListView.this.selectedIndices.remove(index);
                                    ItemListView.this.onSelectionChange();
                                }
                            } else if (ItemListView.this.selectedIndices.size() < ItemListView.this.maxSelections) {
                                ItemListView.this.selectedIndices.add(index);
                                Collections.sort(ItemListView.this.selectedIndices);
                                ItemListView.this.onSelectionChange();
                            }
                        }
                    } else {
                        ItemListView.this.setSelectedIndex(index);
                        if (!ItemList.this.renderer.tap(index, value, x, y, count)) {
                            if (count == 1) {
                                ItemListView.this.itemManager.showMenu(false);
                            } else if (count == 2 && index == this.prevTapIndex) {
                                ItemListView.this.itemManager.activateSelectedItems();
                            }
                        }
                    }
                    this.prevTapIndex = index;
                    return true;
                }

                @Override
                public boolean showMenu(Integer index, Map.Entry<T, Integer> value, FDisplayObject owner, float x, float y) {
                    return ItemList.this.renderer.longPress(index, value, x, y);
                }

                @Override
                public void drawValue(Graphics g2, Integer index, Map.Entry<T, Integer> value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                    if (ItemListView.this.maxSelections > 1) {
                        if (pressed) {
                            g2.fillRect(ItemListView.getSelColor(), x - FList.PADDING, y - FList.PADDING, w + 2.0f * FList.PADDING, h2 + 2.0f * FList.PADDING);
                        }
                        float checkBoxSize = h2 * 0.4f;
                        float padding = checkBoxSize / 2.0f;
                        FCheckBox.drawCheckBox(g2, ItemListView.this.selectedIndices.contains(index), x + (w -= checkBoxSize + padding), y + (h2 - checkBoxSize) / 2.0f, checkBoxSize, checkBoxSize);
                        w -= padding;
                    }
                    ItemList.this.renderer.drawValue(g2, value, font, foreColor, backColor, pressed, x + 1.0f, y, w - 2.0f, h2);
                }
            });
            this.setFont(FSkinFont.get(14));
        }

        @Override
        protected void drawBackground(Graphics g2) {
        }

        @Override
        public boolean press(float x, float y) {
            if (this.renderer.allowPressEffect(this, x, y)) {
                return super.press(x, y);
            }
            return true;
        }

        @Override
        protected FSkinColor getItemFillColor(int index) {
            if (ItemListView.this.maxSelections == 1 && ItemListView.this.selectedIndices.contains(index)) {
                return ItemListView.getSelColor();
            }
            if (index % 2 == 1) {
                return ItemListView.getAltRowColor();
            }
            return ItemListView.getRowColor();
        }

        @Override
        protected boolean drawLineSeparators() {
            return false;
        }

        @Override
        public boolean zoom(float x, float y, float amount) {
            if (this.compactModeHandler.update(amount)) {
                this.revalidate();
                ItemListView.this.scrollSelectionIntoView();
                ItemListView.this.itemManager.getConfig().setCompactListView(this.compactModeHandler.isCompactMode());
            }
            return true;
        }
    }
}

