/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.adventure.scene.ShopScene;
import forge.assets.FImage;
import forge.assets.FImageComplex;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.ImageCache;
import forge.card.CardFaceSymbols;
import forge.card.CardImageRenderer;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.card.ColorSet;
import forge.deck.ArchetypeDeckGenerator;
import forge.deck.CardThemedDeckGenerator;
import forge.deck.CommanderDeckGenerator;
import forge.deck.DeckProxy;
import forge.deck.FDeckViewer;
import forge.deck.io.DeckPreferences;
import forge.game.card.CardView;
import forge.gamemodes.limited.CardRanker;
import forge.gamemodes.planarconquest.ConquestCommander;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.GroupDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.ItemManagerModel;
import forge.itemmanager.SItemManagerUtil;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.views.ItemView;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.toolbox.FComboBox;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FTextField;
import forge.util.ImageUtil;
import forge.util.TextUtil;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;

public class ImageView<T extends InventoryItem>
extends ItemView<T> {
    private static final float PADDING = Utils.scale(5.0f);
    private static final float PILE_SPACING_Y = 0.1f;
    private static final FSkinFont LABEL_FONT;
    private static final FSkinFont GROUP_HEADER_FONT;
    private static final float GROUP_HEADER_HEIGHT;
    private static final float GROUP_HEADER_GLYPH_WIDTH;
    private static final float GROUP_HEADER_LINE_THICKNESS;
    private static final float SEL_BORDER_SIZE;
    private static final int MIN_COLUMN_COUNT;
    private static final int MAX_COLUMN_COUNT = 10;
    private final List<Integer> selectedIndices = new ArrayList<Integer>();
    private int columnCount = 4;
    private float scrollHeight = 0.0f;
    private ColumnDef pileBy = null;
    private GroupDef groupBy = null;
    private ItemInfo focalItem;
    private boolean updatingLayout;
    private float totalZoomAmount;
    private final List<ItemInfo> orderedItems = new ArrayList<ItemInfo>();
    private final List<Group> groups = new ArrayList<Group>();
    private final ExpandCollapseButton btnExpandCollapseAll = new ExpandCollapseButton();
    private final FComboBox<Object> cbGroupByOptions = new FComboBox(Forge.getLocalizer().getMessage("lblGroups", new Object[0]) + " ");
    private final FComboBox<Object> cbPileByOptions = new FComboBox(Forge.getLocalizer().getMessage("lblPiles", new Object[0]) + " ");

    private static FSkinColor getGroupHeaderForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    private static FSkinColor getGroupHeaderLineColor() {
        return ImageView.getGroupHeaderForeColor().alphaColor(0.5f);
    }

    public ImageView(ItemManager<T> itemManager0, ItemManagerModel<T> model0) {
        super(itemManager0, model0);
        SItemManagerUtil.populateImageViewOptions(itemManager0, this.cbGroupByOptions, this.cbPileByOptions);
        this.cbGroupByOptions.setChangedHandler(e -> {
            if (this.cbGroupByOptions.getSelectedIndex() > 0) {
                this.setGroupBy((GroupDef)((Object)((Object)this.cbGroupByOptions.getSelectedItem())));
            } else {
                this.setGroupBy(null);
            }
        });
        this.cbPileByOptions.setChangedHandler(e -> {
            if (this.cbPileByOptions.getSelectedIndex() > 0) {
                this.setPileBy((ColumnDef)((Object)((Object)this.cbPileByOptions.getSelectedItem())));
            } else {
                this.setPileBy(null);
            }
        });
        this.cbGroupByOptions.setFont(LABEL_FONT);
        this.cbPileByOptions.setFont(LABEL_FONT);
        this.getPnlOptions().add(this.btnExpandCollapseAll);
        this.getPnlOptions().add(this.cbGroupByOptions);
        this.getPnlOptions().add(this.cbPileByOptions);
        Group group = new Group("");
        this.groups.add(group);
        this.getScroller().add(group);
    }

    @Override
    public void setup(ItemManagerConfig config, Map<ColumnDef, ItemColumn> colOverrides) {
        this.setGroupBy(config.getGroupBy(), true);
        this.setPileBy(config.getPileBy(), true);
        this.setColumnCount(config.getImageColumnCount(), true);
    }

    public GroupDef getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupDef groupBy0) {
        this.setGroupBy(groupBy0, false);
    }

    private void setGroupBy(GroupDef groupBy0, boolean forSetup) {
        if (this.groupBy == groupBy0) {
            return;
        }
        this.groupBy = groupBy0;
        if (this.groupBy == null) {
            this.cbGroupByOptions.setSelectedIndex(0);
        } else {
            this.cbGroupByOptions.setSelectedItem((Object)this.groupBy);
        }
        this.groups.clear();
        if (this.groupBy == null) {
            this.groups.add(new Group(""));
            this.btnExpandCollapseAll.updateIsAllCollapsed();
        } else {
            for (String groupName : this.groupBy.getGroups()) {
                this.groups.add(new Group(groupName));
            }
            if (this.btnExpandCollapseAll.isAllCollapsed) {
                for (Group group : this.groups) {
                    group.isCollapsed = true;
                }
            }
        }
        this.getScroller().clear();
        for (Group group : this.groups) {
            this.getScroller().add(group);
        }
        if (!forSetup) {
            if (this.itemManager.getConfig() != null) {
                this.itemManager.getConfig().setGroupBy(this.groupBy);
            }
            this.refresh(null, -1, 0.0f);
        }
    }

    public ColumnDef getPileBy() {
        return this.pileBy;
    }

    public void setPileBy(ColumnDef pileBy0) {
        this.setPileBy(pileBy0, false);
    }

    private void setPileBy(ColumnDef pileBy0, boolean forSetup) {
        if (this.pileBy == pileBy0) {
            return;
        }
        this.pileBy = pileBy0;
        if (this.pileBy == null) {
            this.cbPileByOptions.setSelectedIndex(0);
        } else {
            this.cbPileByOptions.setSelectedItem((Object)this.pileBy);
        }
        if (!forSetup) {
            if (this.itemManager.getConfig() != null) {
                this.itemManager.getConfig().setPileBy(this.pileBy);
            }
            this.refresh(null, -1, 0.0f);
        }
    }

    @Override
    protected void fixSelection(Iterable<T> itemsToSelect, int backupIndexToSelect, float scrollValueToRestore) {
        this.clearSelection();
        this.setScrollValue(scrollValueToRestore);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount0) {
        this.setColumnCount(columnCount0, false);
    }

    private void setColumnCount(int columnCount0, boolean forSetup) {
        if (columnCount0 < MIN_COLUMN_COUNT) {
            columnCount0 = MIN_COLUMN_COUNT;
        } else if (columnCount0 > 10) {
            columnCount0 = 10;
        }
        if (this.columnCount == columnCount0) {
            return;
        }
        this.columnCount = columnCount0;
        if (!forSetup) {
            ItemInfo focalItem0;
            if (this.itemManager.getConfig() != null) {
                this.itemManager.getConfig().setImageColumnCount(this.columnCount);
            }
            if ((focalItem0 = this.getFocalItem()) == null) {
                this.updateLayout(false);
                return;
            }
            float offsetTop = focalItem0.getTop() - this.getScrollValue();
            this.updateLayout(false);
            this.setScrollValue(focalItem0.getTop() - offsetTop);
            this.focalItem = focalItem0;
        }
    }

    private ItemInfo getFocalItem() {
        if (this.focalItem != null) {
            return this.focalItem;
        }
        float visibleTop = this.getScrollValue();
        for (Group group : this.groups) {
            if (group.getBottom() < visibleTop) continue;
            for (Pile pile : group.piles) {
                if (group.getBottom() < visibleTop) continue;
                for (ItemInfo item : pile.items) {
                    if (!(item.getTop() >= visibleTop)) continue;
                    return item;
                }
            }
        }
        if (this.orderedItems.isEmpty()) {
            return null;
        }
        return this.orderedItems.get(0);
    }

    @Override
    protected void onResize(float visibleWidth, float visibleHeight) {
        this.updateLayout(false);
    }

    @Override
    protected void onRefresh() {
        Group otherItems = this.groupBy == null ? this.groups.get(0) : null;
        for (Group group : this.groups) {
            group.items.clear();
        }
        this.clearSelection();
        for (Map.Entry entry : this.model.getOrderedList()) {
            Group group;
            int groupIndex;
            InventoryItem item = (InventoryItem)entry.getKey();
            int qty = (Integer)entry.getValue();
            int n = groupIndex = this.groupBy == null ? -1 : this.groupBy.getItemGroupIndex(item);
            if (groupIndex >= 0) {
                group = this.groups.get(groupIndex);
            } else {
                if (otherItems == null) {
                    if (this.groups.size() > this.groupBy.getGroups().length) {
                        otherItems = this.groups.get(this.groups.size() - 1);
                    } else {
                        otherItems = new Group(Forge.getLocalizer().getMessage("lblOther", new Object[0]));
                        otherItems.isCollapsed = this.btnExpandCollapseAll.isAllCollapsed;
                        this.groups.add(otherItems);
                    }
                }
                group = otherItems;
            }
            for (int i = 0; i < qty; ++i) {
                group.add(new ItemInfo(this, item, group));
            }
        }
        if (otherItems == null && this.groups.size() > this.groupBy.getGroups().length) {
            this.groups.remove(this.groups.size() - 1);
            this.btnExpandCollapseAll.updateIsAllCollapsed();
        }
        this.updateLayout(true);
    }

    @Override
    protected void layoutOptionsPanel(float width, float height) {
        float padding = ItemFilter.PADDING;
        float x = 0.0f;
        float h2 = FTextField.getDefaultHeight(ItemFilter.DEFAULT_FONT);
        float y = padding;
        this.btnExpandCollapseAll.setBounds(x, y, h2, h2);
        float pileByWidth = this.itemManager.getPileByWidth();
        float groupByWidth = width - (x += h2 + padding) - padding - pileByWidth;
        this.cbGroupByOptions.setBounds(x, y, groupByWidth, h2);
        this.cbPileByOptions.setBounds(x += groupByWidth + padding, y, pileByWidth, h2);
    }

    private void updateLayout(boolean forRefresh) {
        if (this.updatingLayout) {
            return;
        }
        this.updatingLayout = true;
        this.focalItem = null;
        float y = PADDING;
        float groupX = PADDING;
        float itemAreaWidth = this.getScroller().getWidth();
        float groupWidth = itemAreaWidth - 2.0f * groupX;
        float gap = (float)((10 - this.columnCount) / 2) + Utils.scale(2.0f);
        float itemWidth = (groupWidth + gap) / (float)this.columnCount - gap;
        if (this.pileBy != null) {
            itemWidth *= 1.0f - 0.2f / (float)this.columnCount;
        }
        float itemHeight = itemWidth * 1.4f;
        float dx = itemWidth + gap;
        float dy = this.pileBy == null ? itemHeight + gap : itemHeight * 0.1f;
        for (int i = 0; i < this.groups.size(); ++i) {
            float x;
            Group group = this.groups.get(i);
            if (forRefresh && this.pileBy != null) {
                ColumnDef groupPileBy = this.groupBy == null ? this.pileBy : this.groupBy.getGroupPileBy(i, this.pileBy);
                TreeMap piles = new TreeMap();
                for (ItemInfo itemInfo2 : group.items) {
                    Pile p;
                    Comparable<?> key = groupPileBy.fnSort.apply(itemInfo2);
                    if (key != null && !piles.containsKey(key)) {
                        piles.put(key, new Pile());
                    }
                    if ((p = key == null ? null : (Pile)piles.getOrDefault(key, null)) == null) continue;
                    p.items.add(itemInfo2);
                }
                group.piles.clear();
                group.piles.addAll(piles.values());
            }
            float groupY = y;
            if (group.items.isEmpty()) {
                group.setBounds(groupX, groupY, groupWidth, 0.0f);
                group.scrollWidth = groupWidth;
                continue;
            }
            if (this.groupBy != null) {
                y += GROUP_HEADER_HEIGHT + PADDING;
                if (group.isCollapsed) {
                    group.setBounds(groupX, groupY, groupWidth, GROUP_HEADER_HEIGHT);
                    group.scrollWidth = groupWidth;
                    continue;
                }
            }
            if (this.pileBy == null) {
                group.piles.clear();
                Pile pile = new Pile();
                x = 0.0f;
                for (Object itemInfo : group.items) {
                    ((ItemInfo)itemInfo).pos = CardRenderer.CardStackPosition.Top;
                    if (pile.items.size() == this.columnCount) {
                        pile = new Pile();
                        x = 0.0f;
                        y += dy;
                    }
                    ((FDisplayObject)itemInfo).setBounds(x, y, itemWidth, itemHeight);
                    if (pile.items.size() == 0) {
                        pile.setBounds(0.0f, y, groupWidth, itemHeight);
                        group.piles.add(pile);
                    }
                    pile.items.add(itemInfo);
                    x += dx;
                }
                y += itemHeight;
                group.scrollWidth = groupWidth;
            } else {
                x = 0.0f;
                float pileY = y;
                float maxPileHeight = 0.0f;
                for (int j = 0; j < group.piles.size(); ++j) {
                    Object itemInfo;
                    Pile pile = (Pile)group.piles.get(j);
                    y = pileY;
                    itemInfo = pile.items.iterator();
                    while (itemInfo.hasNext()) {
                        ItemInfo itemInfo2;
                        itemInfo2 = (ItemInfo)itemInfo.next();
                        itemInfo2.pos = CardRenderer.CardStackPosition.BehindVert;
                        itemInfo2.setBounds(x, y, itemWidth, itemHeight);
                        y += dy;
                    }
                    ((ItemInfo)pile.items.get(pile.items.size() - 1)).pos = CardRenderer.CardStackPosition.Top;
                    float pileHeight = y + itemHeight - dy - pileY;
                    if (pileHeight > maxPileHeight) {
                        maxPileHeight = pileHeight;
                    }
                    pile.setBounds(x, pileY, itemWidth, pileHeight);
                    x += dx;
                }
                y = pileY + maxPileHeight;
                group.scrollWidth = Math.max(x - gap, groupWidth);
            }
            group.setBounds(groupX, groupY, groupWidth, y - groupY);
            y += PADDING;
        }
        this.scrollHeight = y;
        if (forRefresh) {
            int index = 0;
            this.orderedItems.clear();
            for (Group group : this.groups) {
                if (group.isCollapsed || group.items.isEmpty()) continue;
                for (Pile pile : group.piles) {
                    for (ItemInfo itemInfo : pile.items) {
                        itemInfo.index = index++;
                        this.orderedItems.add(itemInfo);
                    }
                }
            }
        }
        this.getScroller().revalidate();
        this.updatingLayout = false;
    }

    @Override
    protected float getScrollHeight() {
        return this.scrollHeight;
    }

    @Override
    protected boolean tap(float x, float y, int count) {
        ItemInfo item = this.getItemAtPoint(x, y);
        if (count == 1) {
            this.selectItem(item);
            this.itemManager.showMenu(false);
        } else if (count == 2 && item != null && item.selected && !(item.getKey() instanceof DeckProxy)) {
            this.itemManager.activateSelectedItems();
        }
        return true;
    }

    @Override
    protected boolean zoom(float x, float y, float amount) {
        this.totalZoomAmount += amount;
        float columnZoomAmount = 2.0f * Utils.AVG_FINGER_WIDTH;
        while (this.totalZoomAmount >= columnZoomAmount) {
            this.setColumnCount(this.getColumnCount() - 1);
            this.totalZoomAmount -= columnZoomAmount;
        }
        while (this.totalZoomAmount <= -columnZoomAmount) {
            this.setColumnCount(this.getColumnCount() + 1);
            this.totalZoomAmount += columnZoomAmount;
        }
        return true;
    }

    private ItemInfo getItemAtPoint(float x, float y) {
        float relY;
        float relX;
        int i;
        for (i = this.selectedIndices.size() - 1; i >= 0; --i) {
            ItemInfo item;
            int currentIndex = this.selectedIndices.get(i);
            if (currentIndex < 0 || this.orderedItems.size() <= currentIndex || !(item = this.orderedItems.get(currentIndex)).contains(relX = x + item.group.getScrollLeft() - item.group.getLeft(), relY = y + this.getScrollValue())) continue;
            return item;
        }
        for (i = this.groups.size() - 1; i >= 0; --i) {
            Group group = this.groups.get(i);
            if (group.isCollapsed) continue;
            for (int j = group.piles.size() - 1; j >= 0; --j) {
                relX = x + group.getScrollLeft() - group.getLeft();
                relY = y + this.getScrollValue();
                Pile pile = (Pile)group.piles.get(j);
                if (!pile.contains(relX, relY)) continue;
                for (int k = pile.items.size() - 1; k >= 0; --k) {
                    ItemInfo item = (ItemInfo)pile.items.get(k);
                    if (!item.contains(relX, relY)) continue;
                    return item;
                }
            }
        }
        return null;
    }

    @Override
    public T getItemAtIndex(int index) {
        if (index >= 0 && index < this.getCount()) {
            return (T)this.orderedItems.get(index).item;
        }
        return null;
    }

    @Override
    public int getIndexOfItem(T item) {
        for (Group group : this.groups) {
            for (ItemInfo itemInfo : group.items) {
                if (itemInfo.item != item) continue;
                if (group.isCollapsed) {
                    group.isCollapsed = false;
                    this.btnExpandCollapseAll.updateIsAllCollapsed();
                    this.clearSelection();
                    this.updateLayout(false);
                }
                return itemInfo.index;
            }
        }
        return -1;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndices.isEmpty() ? -1 : this.selectedIndices.get(0);
    }

    @Override
    public Iterable<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    @Override
    public int getCount() {
        return this.orderedItems.size();
    }

    @Override
    public int getSelectionCount() {
        return this.selectedIndices.size();
    }

    @Override
    public int getIndexAtPoint(float x, float y) {
        ItemInfo item = this.getItemAtPoint(x, y);
        if (item != null) {
            return item.index;
        }
        return -1;
    }

    @Override
    public FImage getIcon() {
        if (this.itemManager.getGenericType().equals(DeckProxy.class)) {
            return FSkinImage.PACK;
        }
        return FSkinImage.CARD_IMAGE;
    }

    @Override
    public String getCaption() {
        return Forge.getLocalizer().getMessage("lblImageView", new Object[0]);
    }

    @Override
    public void selectAll() {
        this.clearSelection();
        IntStream.range(0, this.getCount()).forEach(this.selectedIndices::add);
        this.updateSelection();
        this.onSelectionChange();
    }

    @Override
    protected void onSetSelectedIndex(int index) {
        this.clearSelection();
        this.selectedIndices.add(index);
        this.updateSelection();
    }

    @Override
    protected void onSetSelectedIndices(Iterable<Integer> indices) {
        this.clearSelection();
        for (Integer index : indices) {
            this.selectedIndices.add(index);
        }
        this.updateSelection();
    }

    private void clearSelection() {
        int count = this.getCount();
        for (Integer i : this.selectedIndices) {
            if (i >= count) continue;
            this.orderedItems.get(i).selected = false;
        }
        this.selectedIndices.clear();
    }

    private void updateSelection() {
        for (Integer i : this.selectedIndices) {
            this.orderedItems.get(i).selected = true;
        }
    }

    private boolean selectItem(ItemInfo item) {
        if (item == null) {
            if (!Forge.KeyInputAdapter.isCtrlKeyDown() && !Forge.KeyInputAdapter.isShiftKeyDown() && this.minSelections == 0) {
                this.clearSelection();
                this.onSelectionChange();
            }
            return false;
        }
        if (item.selected) {
            if (this.selectedIndices.size() > this.minSelections) {
                item.selected = false;
                this.selectedIndices.remove((Object)item.index);
                this.onSelectionChange();
                item.group.scrollIntoView(item);
            }
            return true;
        }
        if (this.maxSelections <= 1 || !Forge.KeyInputAdapter.isCtrlKeyDown() && !Forge.KeyInputAdapter.isShiftKeyDown()) {
            this.clearSelection();
        }
        if (this.selectedIndices.size() < this.maxSelections) {
            this.selectedIndices.add(0, item.index);
            item.selected = true;
            this.onSelectionChange();
            item.group.scrollIntoView(item);
            this.getScroller().scrollIntoView(item);
        }
        return true;
    }

    @Override
    public void scrollSelectionIntoView() {
        if (this.selectedIndices.isEmpty()) {
            return;
        }
        int index = this.selectedIndices.get(0);
        if (index < 0 || this.orderedItems.size() <= index) {
            return;
        }
        ItemInfo itemInfo = this.orderedItems.get(index);
        this.getScroller().scrollIntoView(itemInfo);
    }

    @Override
    public Rectangle getSelectionBounds() {
        if (this.selectedIndices.isEmpty()) {
            return new Rectangle();
        }
        int index = this.selectedIndices.get(0);
        if (index < 0 || this.orderedItems.size() <= index) {
            return new Rectangle();
        }
        ItemInfo itemInfo = this.orderedItems.get(index);
        Vector2 relPos = itemInfo.group.getChildRelativePosition(itemInfo);
        return new Rectangle(((ItemInfo)itemInfo).group.screenPos.x + relPos.x - SEL_BORDER_SIZE + itemInfo.group.getLeft(), ((ItemInfo)itemInfo).group.screenPos.y + relPos.y - SEL_BORDER_SIZE, itemInfo.getWidth() + 2.0f * SEL_BORDER_SIZE, itemInfo.getHeight() + 2.0f * SEL_BORDER_SIZE);
    }

    @Override
    public void zoomSelected() {
        if (this.selectedIndices.isEmpty()) {
            return;
        }
        int index = this.selectedIndices.get(0);
        if (index < 0 || this.orderedItems.size() <= index) {
            return;
        }
        ItemInfo itemInfo = this.orderedItems.get(index);
        if (itemInfo != null) {
            if (itemInfo.getKey() instanceof CardThemedDeckGenerator || itemInfo.getKey() instanceof CommanderDeckGenerator || itemInfo.getKey() instanceof ArchetypeDeckGenerator || itemInfo.getKey() instanceof DeckProxy) {
                FDeckViewer.show(((DeckProxy)itemInfo.getKey()).getDeck());
            }
            CardZoom.show(this.orderedItems, this.orderedItems.indexOf(itemInfo), (CardZoom.ActivateHandler)this.itemManager);
        }
    }

    static {
        GROUP_HEADER_FONT = LABEL_FONT = FSkinFont.get(12);
        GROUP_HEADER_HEIGHT = Utils.scale(19.0f);
        GROUP_HEADER_GLYPH_WIDTH = Utils.scale(6.0f);
        GROUP_HEADER_LINE_THICKNESS = Utils.scale(1.0f);
        SEL_BORDER_SIZE = Utils.scale(1.0f);
        MIN_COLUMN_COUNT = Forge.isLandscapeMode() ? 2 : 1;
    }

    private static class ItemInfo
    extends FDisplayObject
    implements Map.Entry<InventoryItem, Integer> {
        private final T item;
        private Integer cardPrice;
        private final Group group;
        private int index;
        private CardRenderer.CardStackPosition pos;
        private boolean selected;
        private final float IMAGE_SIZE = CardRenderer.MANA_SYMBOL_SIZE;
        final /* synthetic */ ImageView this$0;

        private ItemInfo(T item0, Group group0) {
            this.this$0 = var1_1;
            this.item = item0;
            this.group = group0;
        }

        public String toString() {
            return this.item.toString();
        }

        @Override
        public InventoryItem getKey() {
            return this.item;
        }

        @Override
        public Integer getValue() {
            return 1;
        }

        @Override
        public Integer setValue(Integer value) {
            return 1;
        }

        private void drawCardLabel(Graphics g2, String message, Color bgColor, float x, float y, float w, float h2) {
            FSkinFont skinFont = FSkinFont.forHeight(w / 7.0f);
            float fontheight = skinFont.getLineHeight();
            float ymod = h2 / 2.0f - fontheight / 2.0f;
            float oldAlpha = g2.getfloatAlphaComposite();
            g2.setAlphaComposite(0.4f);
            g2.fillRect(bgColor, x, y + ymod, w, fontheight);
            g2.setAlphaComposite(oldAlpha);
            g2.drawText(message, skinFont, Color.WHITE, x, y, w, h2, false, 1, true);
        }

        @Override
        public void draw(Graphics g2) {
            float x = this.getLeft() - this.group.getScrollLeft();
            float y = this.getTop() - this.group.getTop() - this.this$0.getScrollValue();
            float w = this.getWidth();
            float h2 = this.getHeight();
            Texture dpImg = null;
            boolean deckSelectMode = false;
            if (this.item instanceof DeckProxy) {
                dpImg = ImageCache.getImage(this.item);
                deckSelectMode = true;
            }
            if (this.selected && !deckSelectMode) {
                if (Forge.enableUIMask.equals("Full")) {
                    g2.fillRoundRect(Color.GREEN, x - SEL_BORDER_SIZE, y - SEL_BORDER_SIZE, w + 2.0f * SEL_BORDER_SIZE, h2 + 2.0f * SEL_BORDER_SIZE, (h2 - w) / 10.0f);
                    g2.drawRoundRect(1.0f, Color.GREEN, x - SEL_BORDER_SIZE, y - SEL_BORDER_SIZE, w + 1.5f * SEL_BORDER_SIZE, h2 + 1.5f * SEL_BORDER_SIZE, (h2 - w) / 10.0f);
                } else {
                    g2.fillRect(Color.GREEN, x - SEL_BORDER_SIZE, y - SEL_BORDER_SIZE, w + 2.0f * SEL_BORDER_SIZE, h2 + 2.0f * SEL_BORDER_SIZE);
                }
            }
            if (this.item instanceof PaperCard) {
                CardRenderer.drawCard(g2, (PaperCard)this.item, x, y, w, h2, this.pos);
                if (this.this$0.itemManager.getShowRanking() && FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_OVERLAY_DRAFT_RANKING)) {
                    double score = CardRanker.getRawScore((PaperCard)this.item);
                    int draftRank = score <= 0.0 ? 0 : (score > 99.0 ? 99 : (int)Math.round(CardRanker.getRawScore((PaperCard)this.item)));
                    float rankSize = w / 2.0f;
                    float y2 = y + (rankSize - rankSize * 0.1f);
                    float x2 = x + rankSize / 2.0f;
                    if (draftRank >= 90) {
                        g2.drawImage(FSkinImage.DRAFTRANK_S, x2, y2 + 1.0f, rankSize, rankSize);
                    } else if (draftRank >= 80 && draftRank <= 89) {
                        g2.drawImage(FSkinImage.DRAFTRANK_A, x2, y2 + 1.0f, rankSize, rankSize);
                    } else if (draftRank >= 60 && draftRank <= 79) {
                        g2.drawImage(FSkinImage.DRAFTRANK_B, x2, y2 + 1.0f, rankSize, rankSize);
                    } else if (draftRank >= 25 && draftRank <= 59) {
                        g2.drawImage(FSkinImage.DRAFTRANK_C, x2, y2 + 1.0f, rankSize, rankSize);
                    } else {
                        g2.drawImage(FSkinImage.DRAFTRANK_D, x2, y2 + 1.0f, rankSize, rankSize);
                    }
                    String value = String.valueOf(draftRank);
                    g2.drawText(value, FSkinFont.forHeight(rankSize / 4.0f), Color.WHITE, x, y, w, h2, true, 1, true);
                }
                if (Forge.isMobileAdventureMode && Forge.getCurrentScene() instanceof ShopScene) {
                    if (this.cardPrice == null) {
                        this.cardPrice = ((ShopScene)Forge.getCurrentScene()).getCardPrice((PaperCard)this.item);
                    }
                    this.drawCardLabel(g2, "$" + this.cardPrice, Color.GOLD, x, y, w, h2);
                }
            } else if (this.item instanceof ConquestCommander) {
                CardRenderer.drawCard(g2, ((ConquestCommander)this.item).getCard(), x, y, w, h2, this.pos);
            } else if (deckSelectMode) {
                DeckProxy dp = (DeckProxy)this.item;
                ColorSet deckColor = dp.getColor();
                float scale = 0.75f;
                if (dpImg != null) {
                    if (Forge.enableUIMask.equals("Off")) {
                        if (this.selected) {
                            g2.fillRect(Color.GREEN, x - SEL_BORDER_SIZE, y - SEL_BORDER_SIZE, w + 2.0f * SEL_BORDER_SIZE, h2 + 2.0f * SEL_BORDER_SIZE);
                        }
                        g2.drawImage(dpImg, x, y, w, h2);
                    } else {
                        g2.drawImage(FSkin.getDeckbox().get(0), FSkin.getDeckbox().get(0), x, y, w, h2, Color.GREEN, this.selected);
                        PaperCard paperCard = null;
                        String imageKey = this.item.getImageKey(false);
                        if (imageKey != null && imageKey.startsWith("c:")) {
                            paperCard = ImageUtil.getPaperCardFromImageKey(imageKey);
                        }
                        if (paperCard != null && Forge.enableUIMask.equals("Art")) {
                            CardImageRenderer.drawCardImage(g2, CardView.getCardForUi(paperCard), false, x + (w - w * scale) / 2.0f, y + (h2 - h2 * scale) / 1.5f, w * scale, h2 * scale, CardRenderer.CardStackPosition.Top, true, false, false, true);
                        } else {
                            TextureRegion tr = ImageCache.croppedBorderImage(dpImg);
                            g2.drawImage(tr, x + (w - w * scale) / 2.0f, y + (h2 - h2 * scale) / 1.5f, w * scale, h2 * scale);
                        }
                    }
                    g2.drawText(this.item.getName(), GROUP_HEADER_FONT, Color.BLACK, x + PADDING - 1.0f, y + PADDING * 2.0f + 1.0f, w - 2.0f * PADDING, h2 - 2.0f * PADDING, true, 1, false);
                    g2.drawText(this.item.getName(), GROUP_HEADER_FONT, Color.WHITE, x + PADDING, y + PADDING * 2.0f, w - 2.0f * PADDING, h2 - 2.0f * PADDING, true, 1, false);
                } else {
                    if (!dp.isGeneratedDeck()) {
                        if (dp.getDeck().isEmpty()) {
                            g2.drawImage(FSkin.getDeckbox().get(2), FSkin.getDeckbox().get(2), x, y - h2 * 0.25f, w, h2, Color.RED, this.selected);
                        } else {
                            PaperCard paperCard = dp.getDeck().getCommanders().isEmpty() ? dp.getHighestCMCCard() : dp.getDeck().getCommanders().get(0);
                            FImageComplex cardArt = CardRenderer.getCardArt(paperCard);
                            if (cardArt == null) {
                                g2.drawImage(FSkin.getDeckbox().get(2), FSkin.getDeckbox().get(2), x, y - h2 * 0.25f, w, h2, Color.GREEN, this.selected);
                            } else {
                                g2.drawDeckBox(cardArt, scale, FSkin.getDeckbox().get(1), FSkin.getDeckbox().get(2), x, y, w, h2, Color.GREEN, this.selected);
                            }
                        }
                    } else {
                        g2.drawImage(FSkin.getDeckbox().get(2), FSkin.getDeckbox().get(2), x, y - h2 * 0.25f, w, h2, Color.GREEN, this.selected);
                    }
                    if (deckColor != null) {
                        float symbolSize = this.IMAGE_SIZE;
                        if (Forge.isLandscapeMode()) {
                            if (this.this$0.columnCount == 4) {
                                symbolSize = this.IMAGE_SIZE * 1.5f;
                            } else if (this.this$0.columnCount == 3) {
                                symbolSize = this.IMAGE_SIZE * 2.0f;
                            } else if (this.this$0.columnCount == 2) {
                                symbolSize = this.IMAGE_SIZE * 3.0f;
                            } else if (this.this$0.columnCount == 1) {
                                symbolSize = this.IMAGE_SIZE * 4.0f;
                            }
                        } else if (this.this$0.columnCount > 2) {
                            symbolSize = this.IMAGE_SIZE * 0.5f;
                        }
                        CardFaceSymbols.drawColorSet(g2, deckColor, x + (w - symbolSize), y + h2 / 8.0f, symbolSize, true);
                        if (!dp.isGeneratedDeck()) {
                            if (dp.getDeck().isEmpty()) {
                                g2.drawImage(Forge.hdbuttons ? FSkinImage.HDYIELD : FSkinImage.WARNING, x, y, symbolSize, symbolSize);
                            } else {
                                if (Forge.hdbuttons) {
                                    g2.drawImage(DeckPreferences.getPrefs(dp).getStarCount() > 0 ? FSkinImage.HDSTAR_FILLED : FSkinImage.HDSTAR_OUTLINE, x, y, symbolSize, symbolSize);
                                } else {
                                    g2.drawImage(DeckPreferences.getPrefs(dp).getStarCount() > 0 ? FSkinImage.STAR_FILLED : FSkinImage.STAR_OUTLINE, x, y, symbolSize, symbolSize);
                                }
                                g2.drawImage(dp.getAI().inMainDeck == 0 ? FSkinImage.AI_ACTIVE : FSkinImage.AI_INACTIVE, x, y + symbolSize, symbolSize, symbolSize);
                            }
                        }
                    }
                    String deckname = TextUtil.fastReplace(this.item.getName(), "] #", "]\n#");
                    g2.drawText(deckname, GROUP_HEADER_FONT, Color.BLACK, x + PADDING - 1.0f, y + h2 / 10.0f + PADDING + 1.0f, w - 2.0f * PADDING, h2 - 2.0f * PADDING, true, 1, true);
                    g2.drawText(deckname, GROUP_HEADER_FONT, Color.WHITE, x + PADDING, y + h2 / 10.0f + PADDING, w - 2.0f * PADDING, h2 - 2.0f * PADDING, true, 1, true);
                }
            } else {
                Texture img = ImageCache.getImage(this.item);
                if (img != null) {
                    g2.drawImage(img, x, y, w, h2);
                } else {
                    g2.fillRect(Color.BLACK, x, y, w, h2);
                    g2.drawText(this.item.getName(), GROUP_HEADER_FONT, Color.WHITE, x + PADDING, y + PADDING, w - 2.0f * PADDING, h2 - 2.0f * PADDING, true, 1, false);
                }
            }
        }
    }

    private class Pile
    extends FDisplayObject {
        private final List<ItemInfo> items = new ArrayList<ItemInfo>();

        private Pile() {
        }

        @Override
        public void draw(Graphics g2) {
            float visibleTop = ImageView.this.getScrollValue();
            float visibleBottom = visibleTop + ImageView.this.getScroller().getHeight();
            ItemInfo skippedItem = null;
            for (ItemInfo itemInfo : this.items) {
                if (itemInfo.getBottom() < visibleTop) continue;
                if (itemInfo.getTop() >= visibleBottom) break;
                if (itemInfo.selected) {
                    skippedItem = itemInfo;
                    continue;
                }
                itemInfo.draw(g2);
            }
            if (skippedItem != null) {
                CardRenderer.CardStackPosition backupPos = skippedItem.pos;
                skippedItem.pos = CardRenderer.CardStackPosition.Top;
                skippedItem.draw(g2);
                skippedItem.pos = backupPos;
            }
        }
    }

    private class Group
    extends FScrollPane {
        private final List<ItemInfo> items = new ArrayList<ItemInfo>();
        private final List<Pile> piles = new ArrayList<Pile>();
        private final String name;
        private boolean isCollapsed;
        private float scrollWidth;

        public Group(String name0) {
            this.name = name0;
        }

        public void add(ItemInfo item) {
            this.items.add(item);
        }

        public String toString() {
            return this.name;
        }

        @Override
        public void draw(Graphics g2) {
            if (this.items.isEmpty()) {
                return;
            }
            if (ImageView.this.groupBy != null) {
                float offset;
                float x = GROUP_HEADER_GLYPH_WIDTH + PADDING + 1.0f;
                float y = 0.0f;
                String caption = this.name + " (" + this.items.size() + ")";
                g2.drawText(caption, GROUP_HEADER_FONT, ImageView.getGroupHeaderForeColor(), x, y, this.getWidth(), GROUP_HEADER_HEIGHT, false, 8, true);
                g2.drawLine(GROUP_HEADER_LINE_THICKNESS, ImageView.getGroupHeaderLineColor(), x += GROUP_HEADER_FONT.getBounds((CharSequence)caption).width + PADDING, y += GROUP_HEADER_HEIGHT / 2.0f, this.getWidth(), y);
                x = offset = GROUP_HEADER_GLYPH_WIDTH / 2.0f + 1.0f;
                if (this.isCollapsed) {
                    g2.fillTriangle(ImageView.getGroupHeaderLineColor(), x, (y += GROUP_HEADER_LINE_THICKNESS) - offset, x + offset, y, x, y + offset);
                } else {
                    g2.fillTriangle(ImageView.getGroupHeaderLineColor(), x - offset + 2.0f, y + offset - 1.0f, x + offset, y + offset - 1.0f, x + offset, y - offset + 1.0f);
                }
                if (this.isCollapsed) {
                    return;
                }
                float visibleLeft = this.getScrollLeft();
                float visibleRight = visibleLeft + this.getWidth();
                for (Pile pile : this.piles) {
                    if (pile.getRight() < visibleLeft) continue;
                    if (pile.getLeft() >= visibleRight) break;
                    pile.draw(g2);
                }
                return;
            }
            float visibleTop = ImageView.this.getScrollValue();
            float visibleBottom = visibleTop + ImageView.this.getScroller().getHeight();
            for (ItemInfo itemInfo : this.items) {
                if (itemInfo.getBottom() < visibleTop) continue;
                if (itemInfo.getTop() >= visibleBottom) break;
                itemInfo.draw(g2);
            }
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            return new FScrollPane.ScrollBounds(this.scrollWidth, visibleHeight);
        }

        @Override
        public boolean tap(float x, float y, int count) {
            ItemInfo item = ImageView.this.getItemAtPoint(x + this.getLeft(), y + this.getTop());
            if (item != null && item.getKey() instanceof DeckProxy) {
                DeckProxy dp = (DeckProxy)item.getKey();
                if (count >= 2 && !dp.isGeneratedDeck()) {
                    if (DeckPreferences.getPrefs(dp).getStarCount() > 0) {
                        DeckPreferences.getPrefs(dp).setStarCount(0);
                    } else {
                        DeckPreferences.getPrefs(dp).setStarCount(1);
                    }
                    ImageView.this.updateLayout(false);
                }
            }
            if (ImageView.this.groupBy != null && !this.items.isEmpty() && y < GROUP_HEADER_HEIGHT) {
                this.isCollapsed = !this.isCollapsed;
                ImageView.this.btnExpandCollapseAll.updateIsAllCollapsed();
                ImageView.this.clearSelection();
                ImageView.this.updateLayout(false);
                return true;
            }
            return false;
        }

        @Override
        public boolean longPress(float x, float y) {
            ItemInfo item = ImageView.this.getItemAtPoint(x + this.getLeft(), y + this.getTop());
            if (item != null) {
                if (item.getKey() instanceof CardThemedDeckGenerator || item.getKey() instanceof CommanderDeckGenerator || item.getKey() instanceof ArchetypeDeckGenerator || item.getKey() instanceof DeckProxy) {
                    FDeckViewer.show(((DeckProxy)item.getKey()).getDeck());
                    return true;
                }
                CardZoom.show(ImageView.this.orderedItems, ImageView.this.orderedItems.indexOf(item), (CardZoom.ActivateHandler)ImageView.this.itemManager);
                return true;
            }
            return false;
        }

        @Override
        protected Vector2 getChildRelativePosition(FDisplayObject child, float offsetX, float offsetY) {
            return new Vector2(child.getLeft() - this.getScrollLeft() + offsetX - this.getLeft(), child.getTop() - ImageView.this.getScrollValue() + offsetY - this.getTop());
        }
    }

    private class ExpandCollapseButton
    extends FLabel {
        private boolean isAllCollapsed;

        private ExpandCollapseButton() {
            super(new FLabel.ButtonBuilder());
            this.setCommand((FEvent e) -> {
                if (ImageView.this.groupBy == null || ImageView.this.model.getItems().isEmpty()) {
                    return;
                }
                boolean collapsed = !this.isAllCollapsed;
                for (Group group : ImageView.this.groups) {
                    group.isCollapsed = collapsed;
                }
                this.updateIsAllCollapsed();
                ImageView.this.clearSelection();
                ImageView.this.updateLayout(false);
            });
        }

        private void updateIsAllCollapsed() {
            boolean isAllCollapsed0 = true;
            for (Group group : ImageView.this.groups) {
                if (group.isCollapsed) continue;
                isAllCollapsed0 = false;
                break;
            }
            this.isAllCollapsed = isAllCollapsed0;
        }

        @Override
        protected void drawContent(Graphics g2, float w, float h2, boolean pressed) {
            float lineThickness = Utils.scale(1.0f);
            float offset = 2.0f * lineThickness;
            float squareSize = Math.round(w / 2.0f - offset);
            if (squareSize % 2.0f == 1.0f) {
                squareSize += 1.0f;
            }
            float x = Math.round((w - squareSize) / 2.0f - offset);
            float y = Math.round((h2 - squareSize) / 2.0f - offset);
            if (pressed) {
                y += lineThickness;
            } else {
                x -= lineThickness;
            }
            for (int i = 0; i < 2; ++i) {
                g2.drawLine(lineThickness, ImageView.getGroupHeaderForeColor(), x, y, x + squareSize, y);
                g2.drawLine(lineThickness, ImageView.getGroupHeaderForeColor(), x + squareSize, y, x + squareSize, y + offset);
                g2.drawLine(lineThickness, ImageView.getGroupHeaderForeColor(), x, y, x, y + squareSize);
                g2.drawLine(lineThickness, ImageView.getGroupHeaderForeColor(), x, y + squareSize, x + offset, y + squareSize);
                x += offset;
                y += offset;
            }
            g2.drawLine(lineThickness, ImageView.getGroupHeaderForeColor(), x, y, x + squareSize, y);
            g2.drawLine(lineThickness, ImageView.getGroupHeaderForeColor(), x + squareSize, y, x + squareSize, y + squareSize);
            g2.drawLine(lineThickness, ImageView.getGroupHeaderForeColor(), x, y, x, y + squareSize);
            g2.drawLine(lineThickness, ImageView.getGroupHeaderForeColor(), x, y + squareSize, x + squareSize, y + squareSize);
            g2.drawLine(lineThickness, ImageView.getGroupHeaderForeColor(), x + offset + 1.0f, y + squareSize / 2.0f, x + squareSize - offset, y + squareSize / 2.0f);
            if (this.isAllCollapsed) {
                g2.drawLine(lineThickness, ImageView.getGroupHeaderForeColor(), x + squareSize / 2.0f, y + offset, x + squareSize / 2.0f, y + squareSize - offset - 1.0f);
            }
        }
    }
}

