/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.ListLabelFilter;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FSpinner;
import forge.util.ComparableOp;

public abstract class ValueRangeFilter<T extends InventoryItem>
extends ItemFilter<T> {
    private FLabel label;
    private FSpinner lowerBound;
    private FSpinner upperBound;

    protected ValueRangeFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
    }

    protected abstract String getCaption();

    protected int minValue() {
        return 0;
    }

    protected int maxValue() {
        return 20;
    }

    @Override
    public final boolean isEmpty() {
        return this.lowerBound.getValue() == this.minValue() && this.upperBound.getValue() == this.maxValue();
    }

    @Override
    public void reset() {
        this.lowerBound.setValue(this.minValue());
        this.upperBound.setValue(this.maxValue());
    }

    @Override
    public FDisplayObject getMainComponent() {
        return this.lowerBound;
    }

    @Override
    protected final void buildWidget(ItemFilter.Widget widget) {
        this.lowerBound = this.addSpinner(widget, true);
        String text = "<= " + this.getCaption() + " <=";
        this.label = new FLabel.Builder().text(text).align(1).font(ListLabelFilter.LABEL_FONT).build();
        widget.add(this.label);
        this.upperBound = this.addSpinner(widget, false);
        this.lowerBound.setChangedHandler(e -> {
            if (this.upperBound.getValue() < this.lowerBound.getValue()) {
                this.upperBound.setValue(this.lowerBound.getValue());
            }
            this.applyChange();
        });
        this.upperBound.setChangedHandler(e -> {
            if (this.lowerBound.getValue() > this.upperBound.getValue()) {
                this.lowerBound.setValue(this.upperBound.getValue());
            }
            this.applyChange();
        });
    }

    @Override
    protected void doWidgetLayout(float width, float height) {
        float x = 0.0f;
        float spinnerWidth = height * 1.5f;
        this.lowerBound.setBounds(x, 0.0f, spinnerWidth, height);
        this.label.setBounds(x += this.lowerBound.getWidth(), 0.0f, width - 2.0f * spinnerWidth, height);
        this.upperBound.setBounds(x += this.label.getWidth(), 0.0f, spinnerWidth, height);
    }

    private FSpinner addSpinner(ItemFilter.Widget widget, boolean lowerBound) {
        FSpinner spinner = new FSpinner(this.minValue(), this.maxValue(), lowerBound ? this.minValue() : this.maxValue());
        widget.add(spinner);
        return spinner;
    }

    protected Predicate<CardRules> getCardRulesFieldPredicate(CardRulesPredicates.LeafNumber.CardField field) {
        int lowerValue = this.lowerBound.getValue();
        int upperValue = this.upperBound.getValue();
        boolean hasMin = lowerValue != this.minValue();
        boolean hasMax = upperValue != this.maxValue();
        CardRulesPredicates.LeafNumber pLower = hasMin ? new CardRulesPredicates.LeafNumber(field, ComparableOp.GT_OR_EQUAL, lowerValue) : null;
        CardRulesPredicates.LeafNumber pUpper = hasMax ? new CardRulesPredicates.LeafNumber(field, ComparableOp.LT_OR_EQUAL, upperValue) : null;
        return SFilterUtil.optimizedAnd(pLower, pUpper);
    }
}

