/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.assets.FImage;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.ItemFilter;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import java.util.ArrayList;
import java.util.List;

public abstract class ToggleButtonsFilter<T extends InventoryItem>
extends ItemFilter<T> {
    protected boolean lockFiltering;
    private final List<FLabel> buttons = new ArrayList<FLabel>();

    protected ToggleButtonsFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
    }

    protected ToggleButton addToggleButton(ItemFilter.Widget widget, FImage icon) {
        ToggleButton button = new ToggleButton(icon);
        this.buttons.add(button);
        widget.add(button);
        return button;
    }

    @Override
    public float getPreferredWidth(float maxWidth, float height) {
        return Math.min((height - FLabel.BORDER_THICKNESS) * (float)this.buttons.size() + FLabel.BORDER_THICKNESS, maxWidth);
    }

    @Override
    protected void doWidgetLayout(float width, float height) {
        float buttonWidth = (width + FLabel.BORDER_THICKNESS * (float)(this.buttons.size() - 1)) / (float)this.buttons.size();
        float buttonHeight = height;
        float x = 0.0f;
        for (FLabel btn : this.buttons) {
            btn.setBounds(x, 0.0f, buttonWidth, buttonHeight);
            x += buttonWidth - FLabel.BORDER_THICKNESS;
        }
    }

    @Override
    public final boolean isEmpty() {
        for (FLabel button : this.buttons) {
            if (button.isSelected()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        for (FLabel button : this.buttons) {
            button.setSelected(true);
        }
    }

    public class ToggleButton
    extends FLabel {
        private FEvent.FEventHandler longPressHandler;

        private ToggleButton(FImage icon) {
            super(new FLabel.Builder().icon(icon).iconScaleFactor(1.0f).align(1).selectable(true).selected(true));
            this.setCommand(() -> {
                if (ToggleButtonsFilter.this.lockFiltering) {
                    return;
                }
                ToggleButtonsFilter.this.applyChange();
            });
        }

        public void setLongPressHandler(FEvent.FEventHandler longPressHandler0) {
            this.longPressHandler = longPressHandler0;
        }

        @Override
        public boolean longPress(float x, float y) {
            if (this.longPressHandler != null) {
                this.longPressHandler.handleEvent(new FEvent(this, FEvent.FEventType.LONG_PRESS));
                return true;
            }
            return false;
        }
    }
}

