/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinFont;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.filters.ItemFilter;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FTextField;

public class TextSearchFilter<T extends InventoryItem>
extends ItemFilter<T> {
    private static final FSkinFont FONT = FSkinFont.get(12);
    protected SearchField txtSearch;

    public TextSearchFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
    }

    @Override
    public ItemFilter<T> createCopy() {
        TextSearchFilter<T> copy = new TextSearchFilter<T>(this.itemManager);
        copy.getWidget();
        copy.txtSearch.setText(this.txtSearch.getText());
        return copy;
    }

    @Override
    public boolean isEmpty() {
        return this.txtSearch.isEmpty();
    }

    @Override
    public void reset() {
        this.txtSearch.setText("");
    }

    @Override
    public FDisplayObject getMainComponent() {
        return this.txtSearch;
    }

    @Override
    protected void buildWidget(ItemFilter.Widget widget) {
        this.txtSearch = new SearchField();
        widget.add(this.txtSearch);
        this.txtSearch.setChangedHandler(e -> this.applyChange());
    }

    @Override
    protected void doWidgetLayout(float width, float height) {
        this.txtSearch.setSize(width, height);
    }

    @Override
    protected Predicate<T> buildPredicate() {
        String text = this.txtSearch.getText();
        if (text.trim().isEmpty()) {
            return Predicates.alwaysTrue();
        }
        return SFilterUtil.buildItemTextFilter(text);
    }

    public void setRatio(String ratio0) {
        this.txtSearch.ratio = ratio0;
    }

    public String getCaption() {
        return this.txtSearch.getGhostText().substring((Forge.getLocalizer().getMessage("lblSearch", new Object[0]) + " ").length());
    }

    public void setCaption(String caption0) {
        this.txtSearch.setGhostText(Forge.getLocalizer().getMessage("lblSearch", new Object[0]) + " " + caption0);
    }

    protected class SearchField
    extends FTextField {
        private String ratio = "(0 / 0)";

        private SearchField() {
            this.setFont(FONT);
            this.setGhostText(Forge.getLocalizer().getMessage("lblSearch", new Object[0]));
            this.setHeight(SearchField.getDefaultHeight(ItemFilter.DEFAULT_FONT));
        }

        @Override
        protected float getRightPadding() {
            return this.renderedFont.getBounds((CharSequence)this.ratio).width + 2.0f * PADDING;
        }

        @Override
        public void draw(Graphics g2) {
            super.draw(g2);
            g2.drawText(this.ratio, this.renderedFont, SearchField.getGhostTextColor(), 0.0f, 0.0f, this.getWidth() - PADDING, this.getHeight(), false, 16, true);
        }
    }
}

