/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import forge.assets.FSkinFont;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.util.Utils;

public abstract class ItemFilter<T extends InventoryItem> {
    public static final float PADDING = Utils.scale(3.0f);
    public static final FSkinFont DEFAULT_FONT = FSkinFont.get(11);
    protected final ItemManager<? super T> itemManager;
    private Widget widget;

    protected ItemFilter(ItemManager<? super T> itemManager0) {
        this.itemManager = itemManager0;
    }

    public Widget getWidget() {
        if (this.widget == null) {
            this.widget = new Widget();
            this.buildWidget(this.widget);
        }
        return this.widget;
    }

    public void refreshWidget() {
        if (this.widget == null) {
            return;
        }
        this.widget.clear();
        this.buildWidget(this.widget);
    }

    public FDisplayObject getMainComponent() {
        return this.getWidget();
    }

    protected void applyChange() {
        this.itemManager.applyFilters();
    }

    public final <U extends InventoryItem> Predicate<U> buildPredicate(Class<U> genericType) {
        Predicate<T> predicate = this.buildPredicate();
        return item -> {
            try {
                return predicate.apply(item);
            }
            catch (Exception ex) {
                return this.showUnsupportedItem(item);
            }
        };
    }

    protected <U extends InventoryItem> boolean showUnsupportedItem(U item) {
        return false;
    }

    public abstract ItemFilter<T> createCopy();

    public abstract boolean isEmpty();

    public abstract void reset();

    public float getPreferredWidth(float maxWidth, float height) {
        return maxWidth;
    }

    protected abstract void buildWidget(Widget var1);

    protected abstract void doWidgetLayout(float var1, float var2);

    protected abstract Predicate<T> buildPredicate();

    public class Widget
    extends FContainer {
        private Widget() {
        }

        @Override
        protected void doLayout(float width, float height) {
            ItemFilter.this.doWidgetLayout(width, height);
        }
    }
}

