/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.card.CardEdition;
import forge.game.GameFormat;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.ArchivedFormatSelect;
import forge.itemmanager.filters.ItemFilter;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.settings.SettingsScreen;
import forge.toolbox.FCheckBox;
import forge.toolbox.FComboBox;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FGroupList;
import forge.toolbox.FList;
import forge.util.Callback;
import forge.util.TextUtil;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class FormatFilter<T extends InventoryItem>
extends ItemFilter<T> {
    protected GameFormat format;
    private String selectedFormat;
    private boolean preventHandling = false;
    private FComboBox<Object> cbxFormats = new FComboBox();

    public FormatFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
        this.cbxFormats.setFont(FSkinFont.get(12));
        this.cbxFormats.addItem(Forge.getLocalizer().getMessage("lblAllSetsFormats", new Object[0]));
        for (GameFormat format : FModel.getFormats().getFilterList()) {
            this.cbxFormats.addItem(format);
        }
        this.cbxFormats.addItem(Forge.getLocalizer().getMessage("lblOtherFormats", new Object[0]));
        this.cbxFormats.addItem(Forge.getLocalizer().getMessage("lblChooseSets", new Object[0]));
        this.cbxFormats.setEnabled(!Forge.isMobileAdventureMode);
        this.selectedFormat = this.cbxFormats.getText();
        this.cbxFormats.setChangedHandler(e -> {
            if (this.preventHandling) {
                return;
            }
            int index = this.cbxFormats.getSelectedIndex();
            if (index != -1) {
                if (index == 0) {
                    this.format = null;
                    this.applyChange();
                } else if (index == this.cbxFormats.getItemCount() - 2) {
                    this.preventHandling = true;
                    this.cbxFormats.setText(this.selectedFormat);
                    this.preventHandling = false;
                    ArchivedFormatSelect archivedFormatSelect = new ArchivedFormatSelect();
                    archivedFormatSelect.setOnCloseCallBack(() -> {
                        this.format = archivedFormatSelect.getSelectedFormat();
                        this.cbxFormats.setText(this.format.getName());
                        this.applyChange();
                    });
                    Forge.openScreen(archivedFormatSelect);
                } else if (index == this.cbxFormats.getItemCount() - 1) {
                    this.preventHandling = true;
                    this.cbxFormats.setText(this.selectedFormat);
                    this.preventHandling = false;
                    Forge.openScreen(new MultiSetSelect());
                } else {
                    this.format = (GameFormat)this.cbxFormats.getSelectedItem();
                    this.applyChange();
                }
            }
        });
    }

    @Override
    protected void applyChange() {
        this.selectedFormat = this.cbxFormats.getText();
        super.applyChange();
    }

    @Override
    public void reset() {
        this.preventHandling = true;
        this.cbxFormats.setSelectedIndex(0);
        this.preventHandling = false;
        this.format = null;
    }

    @Override
    public FDisplayObject getMainComponent() {
        return this.cbxFormats;
    }

    @Override
    public boolean isEmpty() {
        return this.format == null;
    }

    @Override
    protected void buildWidget(ItemFilter.Widget widget) {
        widget.add(this.cbxFormats);
    }

    @Override
    protected void doWidgetLayout(float width, float height) {
        this.cbxFormats.setSize(width, height);
    }

    private class MultiSetSelect
    extends FScreen {
        private final Set<CardEdition> selectedSets;
        private final FGroupList<CardEdition> lstSets;

        private MultiSetSelect() {
            super("Choose Sets");
            this.selectedSets = new HashSet<CardEdition>();
            this.lstSets = this.add(new FGroupList());
            this.lstSets.addGroup("Core Sets");
            this.lstSets.addGroup("Expansions");
            this.lstSets.addGroup("Starter Sets");
            this.lstSets.addGroup("Reprint Sets");
            this.lstSets.addGroup("Boxed Sets");
            this.lstSets.addGroup("Collector's Edition");
            this.lstSets.addGroup("Duel Decks");
            this.lstSets.addGroup("Promo Sets");
            this.lstSets.addGroup("Digital Sets");
            this.lstSets.addGroup("Draft Innovation Sets");
            this.lstSets.addGroup("Commander Sets");
            this.lstSets.addGroup("Multiplayer Sets");
            this.lstSets.addGroup("Other Supplemental Sets");
            this.lstSets.addGroup("Funny Sets");
            this.lstSets.addGroup("Custom Sets");
            List<CardEdition> sets = FModel.getMagicDb().getSortedEditions();
            block16: for (CardEdition set : sets) {
                switch (set.getType()) {
                    case CORE: {
                        this.lstSets.addItem(set, 0);
                        continue block16;
                    }
                    case EXPANSION: {
                        this.lstSets.addItem(set, 1);
                        continue block16;
                    }
                    case STARTER: {
                        this.lstSets.addItem(set, 2);
                        continue block16;
                    }
                    case REPRINT: {
                        this.lstSets.addItem(set, 3);
                        continue block16;
                    }
                    case BOXED_SET: {
                        this.lstSets.addItem(set, 4);
                        continue block16;
                    }
                    case COLLECTOR_EDITION: {
                        this.lstSets.addItem(set, 5);
                        continue block16;
                    }
                    case DUEL_DECK: {
                        this.lstSets.addItem(set, 6);
                        continue block16;
                    }
                    case PROMO: {
                        this.lstSets.addItem(set, 7);
                        continue block16;
                    }
                    case ONLINE: {
                        this.lstSets.addItem(set, 8);
                        continue block16;
                    }
                    case DRAFT: {
                        this.lstSets.addItem(set, 9);
                        continue block16;
                    }
                    case COMMANDER: {
                        this.lstSets.addItem(set, 10);
                        continue block16;
                    }
                    case MULTIPLAYER: {
                        this.lstSets.addItem(set, 11);
                        continue block16;
                    }
                    case OTHER: {
                        this.lstSets.addItem(set, 12);
                        continue block16;
                    }
                    case FUNNY: {
                        this.lstSets.addItem(set, 13);
                        continue block16;
                    }
                }
                this.lstSets.addItem(set, 14);
            }
            this.lstSets.setListItemRenderer(new SetRenderer());
        }

        @Override
        public void onClose(Callback<Boolean> canCloseCallback) {
            if (this.selectedSets.size() > 0) {
                ArrayList<String> setCodes = new ArrayList<String>();
                ArrayList<CardEdition> sortedSets = new ArrayList<CardEdition>(this.selectedSets);
                Collections.sort(sortedSets);
                for (CardEdition set : sortedSets) {
                    setCodes.add(set.getCode());
                }
                FormatFilter.this.format = new GameFormat(null, setCodes, null);
                FormatFilter.this.cbxFormats.setText(sortedSets.size() > 1 ? TextUtil.join(setCodes, ", ") : ((CardEdition)sortedSets.get(0)).toString());
                FormatFilter.this.applyChange();
            }
            super.onClose(canCloseCallback);
        }

        @Override
        protected void doLayout(float startY, float width, float height) {
            this.lstSets.setBounds(0.0f, startY, width, height - startY);
        }

        private class SetRenderer
        extends FList.ListItemRenderer<CardEdition> {
            private SetRenderer() {
            }

            @Override
            public float getItemHeight() {
                return Utils.AVG_FINGER_HEIGHT;
            }

            @Override
            public boolean tap(Integer index, CardEdition value, float x, float y, int count) {
                if (MultiSetSelect.this.selectedSets.contains(value)) {
                    if (count == 2) {
                        Forge.back();
                    } else {
                        MultiSetSelect.this.selectedSets.remove(value);
                    }
                } else {
                    MultiSetSelect.this.selectedSets.add(value);
                    if (count == 2) {
                        Forge.back();
                    }
                }
                return true;
            }

            @Override
            public void drawValue(Graphics g2, Integer index, CardEdition value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                float offset = SettingsScreen.getInsets(w) - FList.PADDING;
                float textHeight = h2 -= 2.0f * offset;
                g2.drawText(value.toString(), font, foreColor, x += offset, y += offset, (w -= 2.0f * offset) - (h2 *= 0.66f) - FList.PADDING, textHeight, false, 8, true);
                FCheckBox.drawCheckBox(g2, SettingsScreen.DESC_COLOR, foreColor, MultiSetSelect.this.selectedSets.contains(value), x += w - h2, y += (textHeight - h2) / 2.0f, h2, h2);
            }
        }
    }
}

