/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.google.common.base.Predicate;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.deck.DeckProxy;
import forge.gui.GuiBase;
import forge.gui.interfaces.IComboBox;
import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.GroupDef;
import forge.itemmanager.IItemManager;
import forge.localinstance.skin.FSkinProp;
import forge.localinstance.skin.IHasSkinProp;
import forge.util.ComparableOp;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;

public final class SItemManagerUtil {
    private static final GroupDef[] CARD_GROUPBY_OPTIONS = new GroupDef[]{GroupDef.DEFAULT, GroupDef.CARD_TYPE, GroupDef.COLOR, GroupDef.COLOR_IDENTITY, GroupDef.SET, GroupDef.CARD_RARITY, GroupDef.PW_DECK_SORT};
    private static final GroupDef[] DECK_GROUPBY_OPTIONS = new GroupDef[]{GroupDef.COLOR, GroupDef.COLOR_IDENTITY, GroupDef.SET};
    private static final ColumnDef[] CARD_PILEBY_OPTIONS = new ColumnDef[]{ColumnDef.CMC, ColumnDef.COLOR, ColumnDef.NAME, ColumnDef.COST, ColumnDef.TYPE, ColumnDef.RARITY, ColumnDef.SET, ColumnDef.COLLECTOR_ORDER, ColumnDef.FORMAT};
    private static final ColumnDef[] DECK_PILEBY_OPTIONS = new ColumnDef[]{ColumnDef.DECK_COLOR, ColumnDef.DECK_FOLDER, ColumnDef.NAME, ColumnDef.DECK_FORMAT, ColumnDef.DECK_EDITION, ColumnDef.DECK_AI};

    public static String getItemDisplayString(InventoryItem item, int qty, boolean forTitle) {
        ArrayList<InventoryItem> items = new ArrayList<InventoryItem>();
        items.add(item);
        return SItemManagerUtil.getItemDisplayString(items, qty, forTitle);
    }

    public static String getItemDisplayString(Iterable<? extends InventoryItem> items, int qty, boolean forTitle) {
        String result;
        Localizer localizer = Localizer.getInstance();
        int itemCount = 0;
        String sharedType = null;
        boolean checkForSharedType = true;
        for (InventoryItem inventoryItem : items) {
            if (checkForSharedType) {
                if (sharedType == null) {
                    sharedType = inventoryItem.getItemType();
                } else if (!inventoryItem.getItemType().equals(sharedType)) {
                    sharedType = null;
                    checkForSharedType = false;
                }
            }
            ++itemCount;
        }
        if (sharedType == null) {
            sharedType = "Item";
        }
        if (forTitle) {
            result = sharedType;
            if (itemCount != 1 || qty != 1) {
                result = result + "s";
            }
        } else {
            result = sharedType.toLowerCase();
            if (itemCount != 1) {
                result = itemCount + " " + result + "s";
            }
            if (qty < 0) {
                result = localizer.getMessage("lblXcopiesof", new Object[0]) + " " + result;
            } else if (qty != 1) {
                result = qty + " " + localizer.getMessage("lblcopiesof", new Object[0]) + " " + result;
            }
        }
        return result;
    }

    public static String buildDisplayList(Iterable<Map.Entry<InventoryItem, Integer>> items) {
        ArrayList<Map.Entry> sorted = new ArrayList<Map.Entry>();
        for (Map.Entry<InventoryItem, Integer> itemEntry : items) {
            sorted.add(itemEntry);
        }
        sorted.sort(Comparator.comparing(x -> ((InventoryItem)x.getKey()).toString()));
        StringBuilder builder = new StringBuilder();
        for (Map.Entry itemEntry : sorted) {
            builder.append("\n").append(itemEntry.getValue()).append(" * ").append(((InventoryItem)itemEntry.getKey()).toString());
        }
        return builder.toString();
    }

    public static void populateImageViewOptions(IItemManager<?> itemManager, IComboBox<Object> cbGroupByOptions, IComboBox<Object> cbPileByOptions) {
        boolean isDeckManager = itemManager.getGenericType().equals(DeckProxy.class);
        GroupDef[] groupByOptions = isDeckManager ? DECK_GROUPBY_OPTIONS : CARD_GROUPBY_OPTIONS;
        ColumnDef[] pileByOptions = isDeckManager ? DECK_PILEBY_OPTIONS : CARD_PILEBY_OPTIONS;
        Localizer localizer = Localizer.getInstance();
        cbGroupByOptions.addItem("(" + localizer.getMessage("lblNone", new Object[0]) + ")");
        cbPileByOptions.addItem("(" + localizer.getMessage("lblNone", new Object[0]) + ")");
        for (GroupDef groupDef : groupByOptions) {
            cbGroupByOptions.addItem((Object)groupDef);
        }
        for (Enum enum_ : pileByOptions) {
            cbPileByOptions.addItem(enum_);
        }
        cbGroupByOptions.setSelectedIndex(0);
        cbPileByOptions.setSelectedIndex(0);
    }

    public static enum StatTypes implements IHasSkinProp
    {
        WHITE(FSkinProp.IMG_MANA_W, CardRulesPredicates.Presets.IS_WHITE, "lblWhitecards"),
        BLUE(FSkinProp.IMG_MANA_U, CardRulesPredicates.Presets.IS_BLUE, "lblBluecards"),
        BLACK(FSkinProp.IMG_MANA_B, CardRulesPredicates.Presets.IS_BLACK, "lblBlackcards"),
        RED(FSkinProp.IMG_MANA_R, CardRulesPredicates.Presets.IS_RED, "lblRedcards"),
        GREEN(FSkinProp.IMG_MANA_G, CardRulesPredicates.Presets.IS_GREEN, "lblGreencards"),
        COLORLESS(FSkinProp.IMG_MANA_COLORLESS, CardRulesPredicates.Presets.IS_COLORLESS, "lblColorlesscards"),
        MULTICOLOR(GuiBase.getInterface().isLibgdxPort() ? FSkinProp.IMG_HDMULTI : FSkinProp.IMG_MULTI, CardRulesPredicates.Presets.IS_MULTICOLOR, "lblMulticolorcards"),
        PACK_OR_DECK(FSkinProp.IMG_PACK, null, "lblPackordeck"),
        LAND(FSkinProp.IMG_LAND, CardRulesPredicates.Presets.IS_LAND, "lblLands"),
        ARTIFACT(FSkinProp.IMG_ARTIFACT, CardRulesPredicates.Presets.IS_ARTIFACT, "lblArtifacts"),
        CREATURE(FSkinProp.IMG_CREATURE, CardRulesPredicates.Presets.IS_CREATURE, "lblCreatures"),
        ENCHANTMENT(FSkinProp.IMG_ENCHANTMENT, CardRulesPredicates.Presets.IS_ENCHANTMENT, "lblEnchantments"),
        PLANESWALKER(FSkinProp.IMG_PLANESWALKER, CardRulesPredicates.Presets.IS_PLANESWALKER, "lblPlaneswalkers"),
        INSTANT(FSkinProp.IMG_INSTANT, CardRulesPredicates.Presets.IS_INSTANT, "lblInstants"),
        SORCERY(FSkinProp.IMG_SORCERY, CardRulesPredicates.Presets.IS_SORCERY, "lblSorceries"),
        BATTLE(FSkinProp.IMG_BATTLE, CardRulesPredicates.Presets.IS_BATTLE, "lblBattles"),
        CMC_0(FSkinProp.IMG_MANA_0, new CardRulesPredicates.LeafNumber(CardRulesPredicates.LeafNumber.CardField.CMC, ComparableOp.EQUALS, 0), "lblCCMC0"),
        CMC_1(FSkinProp.IMG_MANA_1, new CardRulesPredicates.LeafNumber(CardRulesPredicates.LeafNumber.CardField.CMC, ComparableOp.EQUALS, 1), "lblCCMC1"),
        CMC_2(FSkinProp.IMG_MANA_2, new CardRulesPredicates.LeafNumber(CardRulesPredicates.LeafNumber.CardField.CMC, ComparableOp.EQUALS, 2), "lblCCMC2"),
        CMC_3(FSkinProp.IMG_MANA_3, new CardRulesPredicates.LeafNumber(CardRulesPredicates.LeafNumber.CardField.CMC, ComparableOp.EQUALS, 3), "lblCCMC3"),
        CMC_4(FSkinProp.IMG_MANA_4, new CardRulesPredicates.LeafNumber(CardRulesPredicates.LeafNumber.CardField.CMC, ComparableOp.EQUALS, 4), "lblCCMC4"),
        CMC_5(FSkinProp.IMG_MANA_5, new CardRulesPredicates.LeafNumber(CardRulesPredicates.LeafNumber.CardField.CMC, ComparableOp.EQUALS, 5), "lblCCMC5"),
        CMC_6(FSkinProp.IMG_MANA_6, new CardRulesPredicates.LeafNumber(CardRulesPredicates.LeafNumber.CardField.CMC, ComparableOp.GT_OR_EQUAL, 6), "lblCCMC6orMore"),
        DECK_WHITE(FSkinProp.IMG_MANA_W, null, "lblWhitedecks"),
        DECK_BLUE(FSkinProp.IMG_MANA_U, null, "lblBluedecks"),
        DECK_BLACK(FSkinProp.IMG_MANA_B, null, "lblBlackdecks"),
        DECK_RED(FSkinProp.IMG_MANA_R, null, "lblReddecks"),
        DECK_GREEN(FSkinProp.IMG_MANA_G, null, "lblGreendecks"),
        DECK_COLORLESS(FSkinProp.IMG_MANA_COLORLESS, null, "lblColorlessdecks"),
        DECK_MULTICOLOR(GuiBase.getInterface().isLibgdxPort() ? FSkinProp.IMG_HDMULTI : FSkinProp.IMG_MULTI, null, "lblMulticolordecks"),
        FOIL_OLD(FSkinProp.FOIL_11, null, "lblOldstyleFoilcards"),
        FOIL_NEW(FSkinProp.FOIL_01, null, "lblNewstyleFoilcards"),
        FOIL_NONE(FSkinProp.ICO_CLOSE, null, "lblNon-Foilcards"),
        RATE_NONE(FSkinProp.IMG_FAVNONE, null, "lblUnratedcards"),
        RATE_1(FSkinProp.IMG_FAV1, null, "lbl1starcards"),
        RATE_2(FSkinProp.IMG_FAV2, null, "lbl2starcards"),
        RATE_3(FSkinProp.IMG_FAV3, null, "lbl3starcards"),
        RATE_4(FSkinProp.IMG_FAV4, null, "lbl4starcards"),
        RATE_5(FSkinProp.IMG_FAV5, null, "lbl5starcards");

        public final FSkinProp skinProp;
        public final Predicate<CardRules> predicate;
        public final String label;

        private StatTypes(FSkinProp skinProp0, Predicate<CardRules> predicate0, String label0) {
            this.skinProp = skinProp0;
            this.predicate = predicate0;
            Localizer localizer = Localizer.getInstance();
            this.label = localizer.getMessage(label0, new Object[0]);
        }

        @Override
        public FSkinProp getSkinProp() {
            return this.skinProp;
        }
    }
}

