/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumnConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class SColumnUtil {
    public static Map<ColumnDef, ItemColumnConfig> getColumns(Iterable<ColumnDef> colDefs) {
        int i = 0;
        HashMap<ColumnDef, ItemColumnConfig> columns = new HashMap<ColumnDef, ItemColumnConfig>();
        for (ColumnDef colDef : colDefs) {
            ItemColumnConfig column = new ItemColumnConfig(colDef);
            column.setIndex(i++);
            columns.put(colDef, column);
        }
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getStringColumn() {
        HashMap<ColumnDef, ItemColumnConfig> columns = new HashMap<ColumnDef, ItemColumnConfig>();
        ItemColumnConfig column = new ItemColumnConfig(ColumnDef.STRING);
        column.setSortPriority(1);
        columns.put(ColumnDef.STRING, column);
        return columns;
    }

    private static Map<ColumnDef, ItemColumnConfig> getCardColumns(ColumnDef quantityColDef, boolean includeFavorite) {
        return SColumnUtil.getCardColumns(quantityColDef, includeFavorite, false, false, false, false);
    }

    private static Map<ColumnDef, ItemColumnConfig> getCardColumns(ColumnDef quantityColDef, boolean includeFavorite, boolean includeOwned, boolean includePrice, boolean includeNew, boolean includeDecks) {
        ArrayList<ColumnDef> colDefs = new ArrayList<ColumnDef>();
        if (includeFavorite) {
            colDefs.add(ColumnDef.FAVORITE);
        }
        if (quantityColDef != null) {
            colDefs.add(quantityColDef);
        }
        if (includeOwned) {
            colDefs.add(ColumnDef.OWNED);
        }
        colDefs.add(ColumnDef.NAME);
        if (includePrice) {
            colDefs.add(ColumnDef.PRICE);
        }
        if (includeNew) {
            colDefs.add(ColumnDef.NEW);
        }
        if (includeDecks) {
            colDefs.add(ColumnDef.DECKS);
        }
        colDefs.add(ColumnDef.COST);
        colDefs.add(ColumnDef.COLOR);
        colDefs.add(ColumnDef.TYPE);
        colDefs.add(ColumnDef.POWER);
        colDefs.add(ColumnDef.TOUGHNESS);
        colDefs.add(ColumnDef.CMC);
        colDefs.add(ColumnDef.RARITY);
        colDefs.add(ColumnDef.SET);
        colDefs.add(ColumnDef.FORMAT);
        colDefs.add(ColumnDef.AI);
        colDefs.add(ColumnDef.RANKING);
        colDefs.add(ColumnDef.COLLECTOR_ORDER);
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getColumns(colDefs);
        columns.get((Object)ColumnDef.AI).setVisible(false);
        columns.get((Object)ColumnDef.FORMAT).setVisible(false);
        columns.get((Object)ColumnDef.RANKING).setVisible(false);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getCatalogDefaultColumns(boolean isInfinite) {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(isInfinite ? null : ColumnDef.QUANTITY, true);
        columns.get((Object)ColumnDef.FAVORITE).setSortPriority(1);
        columns.get((Object)ColumnDef.NAME).setSortPriority(2);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getDeckEditorDefaultColumns() {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(ColumnDef.DECK_QUANTITY, false);
        columns.get((Object)ColumnDef.CMC).setSortPriority(1);
        columns.get((Object)ColumnDef.TYPE).setSortPriority(2);
        columns.get((Object)ColumnDef.NAME).setSortPriority(3);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getDeckViewerDefaultColumns() {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(ColumnDef.QUANTITY, false);
        columns.get((Object)ColumnDef.CMC).setSortPriority(1);
        columns.get((Object)ColumnDef.TYPE).setSortPriority(2);
        columns.get((Object)ColumnDef.NAME).setSortPriority(3);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getDraftPackDefaultColumns() {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(ColumnDef.QUANTITY, false);
        columns.get((Object)ColumnDef.RARITY).setSortPriority(1);
        columns.get((Object)ColumnDef.RARITY).setSortState(ItemColumnConfig.SortState.DESC);
        columns.get((Object)ColumnDef.COLOR).setSortPriority(2);
        columns.get((Object)ColumnDef.NAME).setSortPriority(3);
        columns.get((Object)ColumnDef.RANKING).setVisible(true);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getSpecialCardPoolDefaultColumns() {
        ArrayList<ColumnDef> colDefs = new ArrayList<ColumnDef>();
        colDefs.add(ColumnDef.FAVORITE);
        colDefs.add(ColumnDef.NAME);
        colDefs.add(ColumnDef.TYPE);
        colDefs.add(ColumnDef.RARITY);
        colDefs.add(ColumnDef.SET);
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getColumns(colDefs);
        columns.get((Object)ColumnDef.FAVORITE).setSortPriority(1);
        columns.get((Object)ColumnDef.NAME).setSortPriority(2);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getAttractionPoolDefaultColumns() {
        ArrayList<ColumnDef> colDefs = new ArrayList<ColumnDef>();
        colDefs.add(ColumnDef.FAVORITE);
        colDefs.add(ColumnDef.NAME);
        colDefs.add(ColumnDef.ATTRACTION_LIGHTS);
        colDefs.add(ColumnDef.RARITY);
        colDefs.add(ColumnDef.SET);
        colDefs.add(ColumnDef.COLLECTOR_ORDER);
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getColumns(colDefs);
        columns.get((Object)ColumnDef.FAVORITE).setSortPriority(1);
        columns.get((Object)ColumnDef.NAME).setSortPriority(2);
        columns.get((Object)ColumnDef.COLLECTOR_ORDER).setSortPriority(3);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getSpellShopDefaultColumns() {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(ColumnDef.QUANTITY, false, true, true, false, false);
        columns.get((Object)ColumnDef.OWNED).setSortPriority(1);
        columns.get((Object)ColumnDef.PRICE).setSortPriority(2);
        columns.get((Object)ColumnDef.NAME).setSortPriority(3);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getQuestInventoryDefaultColumns() {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(ColumnDef.QUANTITY, false, false, true, true, true);
        columns.get((Object)ColumnDef.NEW).setSortPriority(1);
        columns.get((Object)ColumnDef.PRICE).setSortPriority(2);
        columns.get((Object)ColumnDef.NAME).setSortPriority(3);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getQuestEditorPoolDefaultColumns() {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(ColumnDef.QUANTITY, false, false, false, true, false);
        columns.get((Object)ColumnDef.NEW).setSortPriority(1);
        columns.get((Object)ColumnDef.NAME).setSortPriority(2);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getQuestDeckEditorDefaultColumns() {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(ColumnDef.DECK_QUANTITY, false, false, false, true, true);
        columns.get((Object)ColumnDef.CMC).setSortPriority(1);
        columns.get((Object)ColumnDef.TYPE).setSortPriority(2);
        columns.get((Object)ColumnDef.NAME).setSortPriority(3);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getConquestAEtherDefaultColumns() {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(null, false, false, false, false, false);
        columns.get((Object)ColumnDef.NAME).setSortPriority(1);
        columns.get((Object)ColumnDef.COLOR).setSortPriority(2);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getConquestCollectionDefaultColumns() {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(null, false, false, false, true, false);
        columns.get((Object)ColumnDef.NEW).setSortPriority(1);
        columns.get((Object)ColumnDef.NAME).setSortPriority(2);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getConquestDeckEditorDefaultColumns() {
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getCardColumns(ColumnDef.DECK_QUANTITY, false, false, false, true, false);
        columns.get((Object)ColumnDef.CMC).setSortPriority(1);
        columns.get((Object)ColumnDef.TYPE).setSortPriority(2);
        columns.get((Object)ColumnDef.NAME).setSortPriority(3);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getConquestCommandersDefaultColumns() {
        ArrayList<ColumnDef> colDefs = new ArrayList<ColumnDef>();
        colDefs.add(ColumnDef.NAME);
        colDefs.add(ColumnDef.COLOR);
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getColumns(colDefs);
        columns.get((Object)ColumnDef.NAME).setSortPriority(1);
        columns.get((Object)ColumnDef.COLOR).setSortPriority(2);
        return columns;
    }

    public static Map<ColumnDef, ItemColumnConfig> getDecksDefaultColumns(boolean allowEdit, boolean includeFolder) {
        ArrayList<ColumnDef> colDefs = new ArrayList<ColumnDef>();
        colDefs.add(ColumnDef.DECK_FAVORITE);
        if (allowEdit) {
            colDefs.add(ColumnDef.DECK_ACTIONS);
        }
        if (includeFolder) {
            colDefs.add(ColumnDef.DECK_FOLDER);
        }
        colDefs.add(ColumnDef.NAME);
        colDefs.add(ColumnDef.DECK_COLOR);
        colDefs.add(ColumnDef.DECK_FORMAT);
        colDefs.add(ColumnDef.DECK_EDITION);
        colDefs.add(ColumnDef.DECK_MAIN);
        colDefs.add(ColumnDef.DECK_SIDE);
        colDefs.add(ColumnDef.DECK_AI);
        Map<ColumnDef, ItemColumnConfig> columns = SColumnUtil.getColumns(colDefs);
        columns.get((Object)ColumnDef.DECK_FAVORITE).setSortPriority(1);
        if (includeFolder) {
            columns.get((Object)ColumnDef.DECK_FOLDER).setSortPriority(2);
            columns.get((Object)ColumnDef.NAME).setSortPriority(3);
        } else {
            columns.get((Object)ColumnDef.NAME).setSortPriority(2);
        }
        return columns;
    }
}

