/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.google.common.base.Function;
import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumnConfig;
import forge.itemmanager.ItemManagerConfig;
import java.util.Map;

public class ItemColumn {
    private final ItemColumnConfig config;
    private final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnSort;
    private final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnDisplay;

    public ItemColumn(ItemColumnConfig config0) {
        this(config0, config0.getFnSort(), config0.getFnDisplay());
    }

    public ItemColumn(ItemColumnConfig config0, Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnSort0, Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnDisplay0) {
        if (fnSort0 == null) {
            throw new NullPointerException("A sort function hasn't been set for column " + config0.getLongName());
        }
        if (fnDisplay0 == null) {
            throw new NullPointerException("A display function hasn't been set for column " + config0.getLongName());
        }
        this.config = config0;
        this.fnSort = fnSort0;
        this.fnDisplay = fnDisplay0;
    }

    public ItemColumnConfig getConfig() {
        return this.config;
    }

    public String getShortName() {
        return this.config.getShortName();
    }

    public String getLongName() {
        return this.config.getLongName();
    }

    public int getIndex() {
        return this.config.getIndex();
    }

    public void setIndex(int index0) {
        this.config.setIndex(index0);
    }

    public int getSortPriority() {
        return this.config.getSortPriority();
    }

    public void setSortPriority(int sortPriority0) {
        this.config.setSortPriority(sortPriority0);
    }

    public ItemColumnConfig.SortState getSortState() {
        return this.config.getSortState();
    }

    public void setSortState(ItemColumnConfig.SortState state0) {
        this.config.setSortState(state0);
    }

    public ItemColumnConfig.SortState getDefaultSortState() {
        return this.config.getDefaultSortState();
    }

    public boolean isVisible() {
        return this.config.isVisible();
    }

    public void setVisible(boolean visible0) {
        this.config.setVisible(visible0);
    }

    public Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> getFnSort() {
        return this.fnSort;
    }

    public Function<Map.Entry<? extends InventoryItem, Integer>, Object> getFnDisplay() {
        return this.fnDisplay;
    }

    public String toString() {
        return this.config.getLongName();
    }

    public static void addColOverride(ItemManagerConfig config, Map<ColumnDef, ItemColumn> colOverrides, ColumnDef colDef) {
        ItemColumnConfig colConfig = config.getCols().get((Object)colDef);
        ItemColumn.addColOverride(config, colOverrides, colDef, colConfig.getFnSort(), colConfig.getFnDisplay());
    }

    public static void addColOverride(ItemManagerConfig config, Map<ColumnDef, ItemColumn> colOverrides, ColumnDef colDef, Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnSort0, Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnDisplay0) {
        colOverrides.put(colDef, new ItemColumn(config.getCols().get((Object)colDef), fnSort0, fnDisplay0));
    }
}

