/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import forge.card.CardAiHints;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.ICardFace;
import forge.card.mana.ManaCost;
import forge.deck.DeckProxy;
import forge.deck.io.DeckPreferences;
import forge.game.GameFormat;
import forge.gamemodes.limited.CardRanker;
import forge.gui.card.CardPreferences;
import forge.item.IPaperCard;
import forge.item.InventoryItem;
import forge.item.InventoryItemFromSet;
import forge.item.PaperCard;
import forge.itemmanager.ItemColumnConfig;
import forge.model.FModel;
import forge.util.CardTranslation;
import forge.util.ITranslatable;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum ColumnDef {
    STRING("", "", 0, false, ItemColumnConfig.SortState.ASC, from -> from.getKey() instanceof Comparable ? (Comparable)from.getKey() : ((InventoryItem)from.getKey()).getName(), from -> ((InventoryItem)from.getKey()).toString()),
    NAME("lblName", "lblName", 180, false, ItemColumnConfig.SortState.ASC, from -> {
        if (from.getKey() instanceof PaperCard) {
            String sortableName = ((PaperCard)from.getKey()).getSortableName();
            return sortableName == null ? TextUtil.toSortableName(((InventoryItem)from.getKey()).getName()) : sortableName;
        }
        return TextUtil.toSortableName(((InventoryItem)from.getKey()).getName());
    }, from -> {
        if (from.getKey() instanceof PaperCard) {
            return ((InventoryItem)from.getKey()).toString();
        }
        return ((InventoryItem)from.getKey()).getName();
    }),
    COLLECTOR_ORDER("lblCN", "ttCN", 20, false, ItemColumnConfig.SortState.ASC, from -> ColumnDef.toCollectorPrefix((InventoryItem)from.getKey()), from -> {
        InventoryItem item = (InventoryItem)from.getKey();
        return item instanceof PaperCard ? ((PaperCard)item).getCollectorNumber() : "N.A.";
    }),
    TYPE("lblType", "ttType", 100, false, ItemColumnConfig.SortState.ASC, from -> CardTranslation.getTranslatedType((ITranslatable)from.getKey()), from -> CardTranslation.getTranslatedType((ITranslatable)from.getKey())),
    COST("lblCost", "ttCost", 70, true, ItemColumnConfig.SortState.ASC, from -> ColumnDef.toManaCost((InventoryItem)from.getKey()), from -> ColumnDef.toCardRules((InventoryItem)from.getKey())),
    COLOR("lblColor", "ttColor", 46, true, ItemColumnConfig.SortState.ASC, from -> ColumnDef.toColor((InventoryItem)from.getKey()), from -> ColumnDef.toColor((InventoryItem)from.getKey())),
    POWER("lblPower", "ttPower", 20, true, ItemColumnConfig.SortState.DESC, from -> ColumnDef.toPower((InventoryItem)from.getKey()), from -> ColumnDef.toPower((InventoryItem)from.getKey())),
    TOUGHNESS("lblToughness", "ttToughness", 20, true, ItemColumnConfig.SortState.DESC, from -> ColumnDef.toToughness((InventoryItem)from.getKey()), from -> ColumnDef.toToughness((InventoryItem)from.getKey())),
    CMC("lblCMC", "ttCMC", 20, true, ItemColumnConfig.SortState.ASC, from -> ColumnDef.toCMC((InventoryItem)from.getKey()), from -> ColumnDef.toCMC((InventoryItem)from.getKey())),
    ATTRACTION_LIGHTS("lblLights", "lblLights", 94, true, ItemColumnConfig.SortState.NONE, from -> ColumnDef.toAttractionLightSort((InventoryItem)from.getKey()), from -> ColumnDef.toAttractionLights((InventoryItem)from.getKey())),
    RARITY("lblRarity", "lblRarity", 20, true, ItemColumnConfig.SortState.DESC, from -> ColumnDef.toRarity((InventoryItem)from.getKey()), from -> ColumnDef.toRarity((InventoryItem)from.getKey())),
    SET("lblSet", "lblSet", 38, true, ItemColumnConfig.SortState.DESC, from -> {
        InventoryItem i = (InventoryItem)from.getKey();
        if (!(i instanceof InventoryItemFromSet)) {
            return CardEdition.UNKNOWN;
        }
        String editionCode = ((InventoryItemFromSet)i).getEdition();
        return FModel.getMagicDb().getCardEdition(editionCode);
    }, from -> {
        InventoryItem i = (InventoryItem)from.getKey();
        return i instanceof InventoryItemFromSet ? ((InventoryItemFromSet)i).getEdition() : "n/a";
    }),
    AI("lblAI", "lblAIStatus", 30, true, ItemColumnConfig.SortState.ASC, from -> {
        InventoryItem i = (InventoryItem)from.getKey();
        return i instanceof PaperCard ? ((IPaperCard)i).getRules().getAiHints().getAiStatusComparable() : Integer.valueOf(-1);
    }, from -> {
        InventoryItem i = (InventoryItem)from.getKey();
        if (!(i instanceof PaperCard)) {
            return "n/a";
        }
        IPaperCard cp = (IPaperCard)i;
        CardAiHints ai = cp.getRules().getAiHints();
        return ai.getRemAIDecks() ? (ai.getRemRandomDecks() ? "X?" : "X") : (ai.getRemRandomDecks() ? "?" : "");
    }),
    FORMAT("lblFormat", "ttFormats", 60, false, ItemColumnConfig.SortState.DESC, from -> {
        PaperCard card = ColumnDef.toPaperCard((InventoryItem)from.getKey());
        if (card == null) {
            return Integer.valueOf(-1);
        }
        Set<GameFormat> formats = FModel.getFormats().getAllFormatsOfCard(card);
        int acc = 0;
        for (GameFormat gf : formats) {
            int ix;
            if (!gf.getFormatType().equals((Object)GameFormat.FormatType.SANCTIONED) || (ix = gf.getIndex()) >= 30 || ix <= 0) continue;
            acc |= 0x40000000 >> ix - 1;
        }
        return Integer.valueOf(acc);
    }, from -> {
        PaperCard card = ColumnDef.toPaperCard((InventoryItem)from.getKey());
        if (card == null) {
            return -1;
        }
        Set<GameFormat> formats = FModel.getFormats().getAllFormatsOfCard(card);
        HashSet<GameFormat> sanctioned = new HashSet<GameFormat>();
        for (GameFormat gf : formats) {
            if (!gf.getFormatType().equals((Object)GameFormat.FormatType.SANCTIONED)) continue;
            sanctioned.add(gf);
        }
        return StringUtils.join(Iterables.transform(sanctioned, GameFormat::getName), ", ");
    }),
    RANKING("lblRanking", "lblDraftRanking", 50, true, ItemColumnConfig.SortState.ASC, from -> ColumnDef.toRanking((InventoryItem)from.getKey(), false), from -> ColumnDef.toRanking((InventoryItem)from.getKey(), true)),
    QUANTITY("lblQty", "lblQuantity", 25, true, ItemColumnConfig.SortState.ASC, Map.Entry::getValue, Map.Entry::getValue),
    DECK_QUANTITY("lblQuantity", "lblQuantity", 50, true, ItemColumnConfig.SortState.ASC, Map.Entry::getValue, Map.Entry::getValue),
    NEW("lblNew", "lblNew", 30, true, ItemColumnConfig.SortState.DESC, null, null),
    PRICE("lblPrice", "ttPrice", 35, true, ItemColumnConfig.SortState.DESC, null, null),
    OWNED("lblOwned", "lblOwned", 20, true, ItemColumnConfig.SortState.ASC, null, null),
    DECKS("lblDecks", "lblDecks", 20, true, ItemColumnConfig.SortState.ASC, null, null),
    FAVORITE("", "ttFavorite", 18, true, ItemColumnConfig.SortState.DESC, from -> {
        IPaperCard card = ColumnDef.toCard((InventoryItem)from.getKey());
        if (card == null) {
            return Integer.valueOf(-1);
        }
        return Integer.valueOf(CardPreferences.getPrefs(card).getStarCount());
    }, from -> ColumnDef.toCard((InventoryItem)from.getKey())),
    DECK_FAVORITE("", "ttFavorite", 18, true, ItemColumnConfig.SortState.DESC, from -> {
        DeckProxy deck = ColumnDef.toDeck((InventoryItem)from.getKey());
        if (deck == null) {
            return Integer.valueOf(-1);
        }
        return Integer.valueOf(DeckPreferences.getPrefs(deck).getStarCount());
    }, from -> ColumnDef.toDeck((InventoryItem)from.getKey())),
    DECK_ACTIONS("", "lblDeleteEdit", 40, true, ItemColumnConfig.SortState.DESC, from -> Integer.valueOf(0), from -> ColumnDef.toDeck((InventoryItem)from.getKey())),
    DECK_FOLDER("lblFolder", "lblFolder", 80, false, ItemColumnConfig.SortState.ASC, from -> ColumnDef.toDeckFolder((InventoryItem)from.getKey()), from -> ColumnDef.toDeckFolder((InventoryItem)from.getKey())),
    DECK_COLOR("lblColor", "ttColor", 70, true, ItemColumnConfig.SortState.ASC, from -> ColumnDef.toDeckColor((InventoryItem)from.getKey()), from -> ColumnDef.toDeckColor((InventoryItem)from.getKey())),
    DECK_FORMAT("lblFormat", "ttFormats", 60, false, ItemColumnConfig.SortState.DESC, from -> {
        DeckProxy deck = ColumnDef.toDeck((InventoryItem)from.getKey());
        if (deck == null) {
            return Integer.valueOf(-1);
        }
        Set<GameFormat> all = deck.getExhaustiveFormats();
        int acc = 0;
        for (GameFormat gf : all) {
            int ix = gf.getIndex();
            if (ix >= 30 || ix <= 0) continue;
            acc |= 0x40000000 >> ix - 1;
        }
        return Integer.valueOf(acc);
    }, from -> {
        DeckProxy deck = ColumnDef.toDeck((InventoryItem)from.getKey());
        if (deck == null) {
            return null;
        }
        return deck.getFormatsString();
    }),
    DECK_EDITION("lblSet", "lblSet", 38, true, ItemColumnConfig.SortState.DESC, from -> ColumnDef.toDeck((InventoryItem)from.getKey()).getEdition(), from -> {
        CardEdition deckEdition = ColumnDef.toDeck((InventoryItem)from.getKey()).getEdition();
        if (deckEdition != null) {
            return deckEdition.getCode();
        }
        return null;
    }),
    DECK_AI("lblAI", "lblAIStatus", 38, true, ItemColumnConfig.SortState.DESC, from -> Integer.valueOf(ColumnDef.toDeck((InventoryItem)((InventoryItem)from.getKey())).getAI().inMainDeck), from -> ColumnDef.toDeck((InventoryItem)from.getKey()).getAI()),
    DECK_MAIN("lblMain", "ttMain", 30, true, ItemColumnConfig.SortState.ASC, from -> Integer.valueOf(ColumnDef.toDeck((InventoryItem)from.getKey()).getMainSize()), from -> ColumnDef.toDeck((InventoryItem)from.getKey()).getMainSize()),
    DECK_SIDE("lblSide", "lblSideboard", 30, true, ItemColumnConfig.SortState.ASC, from -> Integer.valueOf(ColumnDef.toDeck((InventoryItem)from.getKey()).getSideSize()), from -> ColumnDef.toDeck((InventoryItem)from.getKey()).getSideSize());

    public final String shortName;
    public final String longName;
    public final int preferredWidth;
    public final boolean isWidthFixed;
    public final ItemColumnConfig.SortState sortState;
    public final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnSort;
    public final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnDisplay;

    private ColumnDef(String shortName0, String longName0, int preferredWidth0, boolean isWidthFixed0, ItemColumnConfig.SortState sortState0, Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnSort0, Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnDisplay0) {
        Localizer localizer = Localizer.getInstance();
        this.shortName = shortName0 != null && !shortName0.isEmpty() ? localizer.getMessage(shortName0, new Object[0]) : shortName0;
        this.longName = longName0 != null && !longName0.isEmpty() ? localizer.getMessage(longName0, new Object[0]) : longName0;
        this.preferredWidth = preferredWidth0;
        this.isWidthFixed = isWidthFixed0;
        this.sortState = sortState0;
        this.fnSort = fnSort0;
        this.fnDisplay = fnDisplay0;
    }

    public String toString() {
        return this.longName;
    }

    private static IPaperCard toCard(InventoryItem i) {
        return i instanceof IPaperCard ? (IPaperCard)i : null;
    }

    private static PaperCard toPaperCard(InventoryItem i) {
        return i instanceof PaperCard ? (PaperCard)i : null;
    }

    private static ManaCost toManaCost(InventoryItem i) {
        return i instanceof IPaperCard ? ((IPaperCard)i).getRules().getManaCost() : ManaCost.NO_COST;
    }

    private static CardRules toCardRules(InventoryItem i) {
        return i instanceof IPaperCard ? ((IPaperCard)i).getRules() : null;
    }

    private static ColorSet toColor(InventoryItem i) {
        return i instanceof IPaperCard ? ((IPaperCard)i).getRules().getColor() : ColorSet.getNullColor();
    }

    private static Integer toPower(InventoryItem i) {
        ICardFace face;
        int result = Integer.MAX_VALUE;
        if (i instanceof PaperCard && (result = (face = ((IPaperCard)i).getMainFace()).getIntPower()) == Integer.MAX_VALUE && face.getType().isPlaneswalker()) {
            String loy = face.getInitialLoyalty();
            result = StringUtils.isNumeric(loy) ? Integer.parseInt(loy) : 0;
        }
        return result;
    }

    private static Integer toToughness(InventoryItem i) {
        return i instanceof PaperCard ? ((IPaperCard)i).getMainFace().getIntToughness() : Integer.MAX_VALUE;
    }

    private static Integer toCMC(InventoryItem i) {
        return i instanceof PaperCard ? ((IPaperCard)i).getRules().getManaCost().getCMC() : -1;
    }

    private static CardRarity toRarity(InventoryItem i) {
        return i instanceof PaperCard ? ((IPaperCard)i).getRarity() : CardRarity.Unknown;
    }

    private static Double toRanking(InventoryItem i, boolean truncate) {
        if (i instanceof PaperCard) {
            PaperCard cp = (PaperCard)i;
            double ranking = CardRanker.getRawScore(cp);
            if (truncate) {
                return new BigDecimal(ranking).setScale(4, RoundingMode.HALF_UP).doubleValue();
            }
            return ranking;
        }
        return 500.0;
    }

    private static DeckProxy toDeck(InventoryItem i) {
        return i instanceof DeckProxy ? (DeckProxy)i : null;
    }

    private static ColorSet toDeckColor(InventoryItem i) {
        return i instanceof DeckProxy ? ((DeckProxy)i).getColor() : null;
    }

    private static String toDeckFolder(InventoryItem i) {
        return i instanceof DeckProxy ? ((DeckProxy)i).getPath() + "/" : null;
    }

    private static String toCollectorPrefix(InventoryItem i) {
        String collectorNumber = i instanceof PaperCard ? ((PaperCard)i).getCollectorNumberSortingKey() : "N.A.";
        return collectorNumber;
    }

    private static String toLandsLast(InventoryItem i) {
        return !((IPaperCard)i).getRules().getType().isLand() ? "0" + ColumnDef.toArtifactsWithColorlessCostsLast(i) : "1";
    }

    private static String toArtifactsWithColorlessCostsLast(InventoryItem i) {
        ManaCost manaCost = ((IPaperCard)i).getRules().getManaCost();
        return !((IPaperCard)i).getRules().getType().isArtifact() || !ColumnDef.toColor(i).isColorless() && (!manaCost.canBePaidWithAvailable((byte)1) || !manaCost.canBePaidWithAvailable((byte)2) || !manaCost.canBePaidWithAvailable((byte)4)) ? "0" + ColumnDef.toSplitLast(i) : "1";
    }

    private static String toSplitLast(InventoryItem i) {
        return ((IPaperCard)i).getRules().getSplitType() != CardSplitType.Split ? "0" + ColumnDef.toConspiracyFirst(i) : "1" + ColumnDef.toSplitCardSort(i);
    }

    private static String toConspiracyFirst(InventoryItem i) {
        return ((IPaperCard)i).getRules().getType().isConspiracy() ? "0" : "1" + ColumnDef.toColorlessFirst(i);
    }

    private static String toColorlessFirst(InventoryItem i) {
        return ColumnDef.toColor(i).isColorless() ? "0" : "1" + ColumnDef.toMonocolorFirst(i);
    }

    private static String toMonocolorFirst(InventoryItem i) {
        return ColumnDef.toColor(i).isMonoColor() ? "0" + ColumnDef.toWubrgOrder(i) : "1" + ColumnDef.toGoldFirst(i);
    }

    private static String toGoldFirst(InventoryItem i) {
        ManaCost manaCost = ((IPaperCard)i).getRules().getManaCost();
        return !(manaCost.canBePaidWithAvailable((byte)1) | manaCost.canBePaidWithAvailable((byte)2) | manaCost.canBePaidWithAvailable((byte)4) | manaCost.canBePaidWithAvailable((byte)8) | manaCost.canBePaidWithAvailable((byte)16)) ? "0" : "1";
    }

    private static String toSplitCardSort(InventoryItem i) {
        ICardFace mainPart = ((IPaperCard)i).getMainFace();
        ICardFace otherPart = ((IPaperCard)i).getOtherFace();
        return ColumnDef.toSplitSort(mainPart, otherPart);
    }

    private static String toSplitSort(ICardFace mainPart, ICardFace otherPart) {
        ColorSet otherPartColor;
        ColorSet mainPartColor = mainPart.getColor();
        return mainPartColor.isEqual((otherPartColor = otherPart.getColor()).getColor()) ? (mainPartColor.isEqual((byte)1) ? "01" : (mainPartColor.isEqual((byte)2) ? "02" : (mainPartColor.isEqual((byte)4) ? "03" : (mainPartColor.isEqual((byte)8) ? "04" : (mainPartColor.isEqual((byte)16) ? "05" : "00"))))) : (mainPartColor.isMulticolor() && otherPartColor.isMulticolor() ? "06" : (mainPartColor.isEqual((byte)1) && otherPartColor.isEqual((byte)2) ? "11" : (mainPartColor.isEqual((byte)2) && otherPartColor.isEqual((byte)4) ? "12" : (mainPartColor.isEqual((byte)4) && otherPartColor.isEqual((byte)8) ? "13" : (mainPartColor.isEqual((byte)8) && otherPartColor.isEqual((byte)16) ? "14" : (mainPartColor.isEqual((byte)16) && otherPartColor.isEqual((byte)1) ? "15" : (mainPartColor.isEqual((byte)1) && otherPartColor.isEqual((byte)4) ? "21" : (mainPartColor.isEqual((byte)2) && otherPartColor.isEqual((byte)8) ? "22" : (mainPartColor.isEqual((byte)4) && otherPartColor.isEqual((byte)16) ? "23" : (mainPartColor.isEqual((byte)8) && otherPartColor.isEqual((byte)1) ? "24" : (mainPartColor.isEqual((byte)16) && otherPartColor.isEqual((byte)2) ? "25" : (mainPartColor.isEqual((byte)1) && otherPartColor.isEqual((byte)8) ? "31" : (mainPartColor.isEqual((byte)2) && otherPartColor.isEqual((byte)16) ? "32" : (mainPartColor.isEqual((byte)4) && otherPartColor.isEqual((byte)1) ? "33" : (mainPartColor.isEqual((byte)8) && otherPartColor.isEqual((byte)2) ? "34" : (mainPartColor.isEqual((byte)16) && otherPartColor.isEqual((byte)4) ? "35" : (mainPartColor.isEqual((byte)1) && otherPartColor.isEqual((byte)16) ? "41" : (mainPartColor.isEqual((byte)2) && otherPartColor.isEqual((byte)1) ? "42" : (mainPartColor.isEqual((byte)4) && otherPartColor.isEqual((byte)2) ? "43" : (mainPartColor.isEqual((byte)8) && otherPartColor.isEqual((byte)4) ? "44" : (mainPartColor.isEqual((byte)16) && otherPartColor.isEqual((byte)8) ? "45" : "99")))))))))))))))))))));
    }

    private static String toWubrgOrder(InventoryItem i) {
        ColorSet color = ColumnDef.toColor(i);
        return color.hasWhite() ? "0" : (color.hasBlue() ? "1" : (color.hasBlack() ? "2" : (color.hasRed() ? "3" : "4")));
    }

    private static String toContraptionsLast(InventoryItem i) {
        return !((IPaperCard)i).getRules().getType().hasSubtype("Contraption") ? "0" + ColumnDef.toLandsLast(i) : "1";
    }

    private static String toBasicLandsLast(InventoryItem i) {
        return !((IPaperCard)i).getRules().getType().isBasicLand() ? "0" + ColumnDef.toContraptionsLast(i) : "1" + ColumnDef.toFullArtFirst(i);
    }

    private static String toFullArtFirst(InventoryItem i) {
        return ColumnDef.toBasicLandSort(i);
    }

    private static String toBasicLandSort(InventoryItem i) {
        CardType basicLandType = ((IPaperCard)i).getRules().getType();
        return basicLandType.hasStringType("Plains") ? "1" : (basicLandType.hasStringType("Island") ? "2" : (basicLandType.hasStringType("Swamp") ? "3" : (basicLandType.hasStringType("Mountain") ? "4" : (basicLandType.hasStringType("Forest") ? "5" : "0"))));
    }

    private static Set<Integer> toAttractionLights(InventoryItem i) {
        return i instanceof PaperCard ? ((PaperCard)i).getMainFace().getAttractionLights() : null;
    }

    private static String toAttractionLightSort(InventoryItem i) {
        if (!(i instanceof PaperCard)) {
            return "";
        }
        Set<Integer> lights = ((PaperCard)i).getRules().getAttractionLights();
        return (lights.contains(1) ? "0" : "1") + (lights.contains(2) ? "0" : "1") + (lights.contains(3) ? "0" : "1") + (lights.contains(4) ? "0" : "1") + (lights.contains(5) ? "0" : "1") + (lights.contains(6) ? "0" : "1");
    }
}

