/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.itemmanager.filters.CardColorFilter;
import forge.itemmanager.filters.CardFormatFilter;
import forge.itemmanager.filters.CardSearchFilter;
import forge.itemmanager.filters.CardTypeFilter;
import forge.itemmanager.filters.TextSearchFilter;
import forge.toolbox.FList;
import java.util.Map;

public class CardManager
extends ItemManager<PaperCard> {
    public CardManager(boolean wantUnique0) {
        super(PaperCard.class, wantUnique0);
    }

    @Override
    protected void addDefaultFilters() {
        CardManager.addDefaultFilters(this);
    }

    @Override
    protected TextSearchFilter<PaperCard> createSearchFilter() {
        return CardManager.createSearchFilter(this);
    }

    @Override
    protected AdvancedSearchFilter<PaperCard> createAdvancedSearchFilter() {
        return CardManager.createAdvancedSearchFilter(this);
    }

    protected void onCardLongPress(int index, Map.Entry<PaperCard, Integer> value, float x, float y) {
        CardZoom.show(this.model.getOrderedList(), index, (CardZoom.ActivateHandler)this);
    }

    public static void addDefaultFilters(ItemManager<? super PaperCard> itemManager) {
        itemManager.addFilter(new CardColorFilter(itemManager));
        itemManager.addFilter(new CardFormatFilter(itemManager));
        itemManager.addFilter(new CardTypeFilter(itemManager));
    }

    public static TextSearchFilter<PaperCard> createSearchFilter(ItemManager<? super PaperCard> itemManager) {
        return new CardSearchFilter(itemManager);
    }

    public static AdvancedSearchFilter<PaperCard> createAdvancedSearchFilter(ItemManager<? super PaperCard> itemManager) {
        return new AdvancedSearchFilter<PaperCard>(itemManager);
    }

    @Override
    public ItemManager.ItemRenderer getListItemRenderer(final FList.CompactModeHandler compactModeHandler) {
        return new ItemManager.ItemRenderer(){

            @Override
            public float getItemHeight() {
                return CardRenderer.getCardListItemHeight(compactModeHandler.isCompactMode());
            }

            public void drawValue(Graphics g2, Map.Entry<PaperCard, Integer> value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                CardRenderer.drawCardListItem(g2, font, foreColor, value.getKey(), CardManager.this.isInfinite() ? 0 : value.getValue(), CardManager.this.getItemSuffix(value), x, y, w, h2, compactModeHandler.isCompactMode());
            }

            public boolean tap(Integer index, Map.Entry<PaperCard, Integer> value, float x, float y, int count) {
                return CardRenderer.cardListItemTap(CardManager.this.model.getOrderedList(), index, CardManager.this, x, y, count, compactModeHandler.isCompactMode());
            }

            public boolean longPress(Integer index, Map.Entry<PaperCard, Integer> value, float x, float y) {
                if (CardRenderer.cardListItemTap(CardManager.this.model.getOrderedList(), index, CardManager.this, x, y, 1, compactModeHandler.isCompactMode())) {
                    return true;
                }
                CardManager.this.onCardLongPress(index, value, x, y);
                return true;
            }

            public boolean allowPressEffect(FList<Map.Entry<PaperCard, Integer>> list, float x, float y) {
                return x > CardRenderer.getCardListItemHeight(compactModeHandler.isCompactMode()) * 1.302f;
            }
        };
    }
}

