/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import forge.StaticData;
import forge.deck.Deck;
import forge.deck.io.DeckSerializer;
import forge.deck.io.DeckStorage;
import forge.item.InventoryItemFromSet;
import forge.util.FileSection;
import forge.util.FileUtil;
import forge.util.storage.StorageReaderFolder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Map;

public class PreconDeck
implements InventoryItemFromSet {
    private final Deck deck;
    private final String set;
    private final String description;
    private String imageFilename;

    @Override
    public String getName() {
        return this.deck.getName();
    }

    @Override
    public String getItemType() {
        return "Prebuilt Deck";
    }

    public String toString() {
        return this.deck.toString();
    }

    public PreconDeck(Deck d, String set, String description) {
        this.deck = d;
        this.set = set;
        this.description = description;
    }

    public final Deck getDeck() {
        return this.deck;
    }

    public final String getImageFilename() {
        return this.imageFilename;
    }

    @Override
    public String getEdition() {
        return this.set;
    }

    public final String getDescription() {
        return this.description;
    }

    @Override
    public String getImageKey(boolean altState) {
        return "p:" + this.imageFilename;
    }

    public static class Reader
    extends StorageReaderFolder<PreconDeck> {
        public Reader(File deckDir0) {
            super(deckDir0, PreconDeck::getName);
        }

        @Override
        protected PreconDeck read(File file) {
            return this.getPreconDeckFromSections(FileSection.parseSections(FileUtil.readFile(file)));
        }

        protected PreconDeck getPreconDeckFromSections(Map<String, List<String>> sections) {
            FileSection kv = FileSection.parse((Iterable<String>)sections.get("metadata"), FileSection.EQUALS_KV_SEPARATOR);
            String imageFilename = kv.get("Image");
            String description = kv.get("Description");
            String deckEdition = kv.get("set");
            String set = deckEdition == null || StaticData.instance().getEditions().get(deckEdition.toUpperCase()) == null ? "n/a" : deckEdition;
            PreconDeck result = new PreconDeck(DeckSerializer.fromSections(sections), set, description);
            result.imageFilename = imageFilename;
            return result;
        }

        @Override
        protected FilenameFilter getFileFilter() {
            return DeckStorage.DCK_FILE_FILTER;
        }
    }
}

