/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.ColorSet;
import forge.card.ICardFace;
import forge.item.IPaperCard;
import forge.item.InventoryItemFromSet;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class PaperToken
implements InventoryItemFromSet,
IPaperCard {
    private static final long serialVersionUID = 1L;
    private String name;
    private transient CardEdition edition;
    private ArrayList<String> imageFileName = new ArrayList();
    private transient CardRules cardRules;
    private int artIndex = 1;

    public static String makeTokenFileName(String in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == ' ' || c == '-' || c == '_') {
                out.append('_');
                continue;
            }
            if (!Character.isLetterOrDigit(c)) continue;
            out.append(c);
        }
        return out.toString().toLowerCase(Locale.ENGLISH);
    }

    public static String makeTokenFileName(String colors, String power, String toughness, String types) {
        return PaperToken.makeTokenFileName(null, colors, power, toughness, types);
    }

    public static String makeTokenFileName(String name, String colors, String power, String toughness, String types) {
        ArrayList<String> build = new ArrayList<String>();
        if (name != null) {
            build.add(name);
        }
        build.add(colors);
        if (power != null && toughness != null) {
            build.add(power);
            build.add(toughness);
        }
        build.add(types);
        String fileName = StringUtils.join(build, "_");
        return PaperToken.makeTokenFileName(fileName);
    }

    public static String makeTokenFileName(CardRules rules, CardEdition edition) {
        ArrayList<String> build = new ArrayList<String>();
        String subtypes = StringUtils.join(rules.getType().getSubtypes(), " ");
        if (!rules.getName().equals(subtypes)) {
            return PaperToken.makeTokenFileName(rules.getName());
        }
        ColorSet colors = rules.getColor();
        if (colors.isColorless()) {
            build.add("C");
        } else {
            String color = "";
            if (colors.hasWhite()) {
                color = color + "W";
            }
            if (colors.hasBlue()) {
                color = color + "U";
            }
            if (colors.hasBlack()) {
                color = color + "B";
            }
            if (colors.hasRed()) {
                color = color + "R";
            }
            if (colors.hasGreen()) {
                color = color + "G";
            }
            build.add(color);
        }
        if (rules.getPower() != null && rules.getToughness() != null) {
            build.add(rules.getPower());
            build.add(rules.getToughness());
        }
        String cardTypes = "";
        if (rules.getType().isArtifact()) {
            cardTypes = cardTypes + "A";
        }
        if (rules.getType().isEnchantment()) {
            cardTypes = cardTypes + "E";
        }
        if (!cardTypes.isEmpty()) {
            build.add(cardTypes);
        }
        build.add(subtypes);
        for (String keyword : rules.getMainPart().getKeywords()) {
            build.add(keyword);
        }
        if (edition != null) {
            build.add(edition.getCode());
        }
        return StringUtils.join(build, "_").replace('*', 'x').toLowerCase();
    }

    public PaperToken(CardRules c, CardEdition edition0, String imageFileName) {
        this.cardRules = c;
        this.name = c.getName();
        this.edition = edition0;
        if (this.edition != null && this.edition.getTokens().containsKey(imageFileName)) {
            this.artIndex = this.edition.getTokens().get(imageFileName);
        }
        if (imageFileName == null) {
            this.imageFileName.add(PaperToken.makeTokenFileName(c, edition0));
        } else {
            String formatEdition = null == this.edition || CardEdition.UNKNOWN == this.edition ? "" : "_" + this.edition.getCode().toLowerCase();
            this.imageFileName.add(String.format("%s%s", imageFileName, formatEdition));
            for (int idx = 2; idx <= this.artIndex; ++idx) {
                this.imageFileName.add(String.format("%s%d%s", imageFileName, idx, formatEdition));
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getEdition() {
        return this.edition != null ? this.edition.getCode() : "???";
    }

    @Override
    public String getCollectorNumber() {
        return "N.A.";
    }

    @Override
    public String getFunctionalVariant() {
        return "";
    }

    @Override
    public int getArtIndex() {
        return this.artIndex;
    }

    @Override
    public boolean isFoil() {
        return false;
    }

    @Override
    public CardRules getRules() {
        return this.cardRules;
    }

    @Override
    public CardRarity getRarity() {
        return CardRarity.Token;
    }

    @Override
    public String getArtist() {
        return "";
    }

    public String getImageFilename() {
        return this.getImageFilename(1);
    }

    public String getImageFilename(int idx) {
        return this.imageFileName.get(idx - 1);
    }

    @Override
    public String getItemType() {
        return "Token";
    }

    @Override
    public boolean hasBackFace() {
        if (this.cardRules == null) {
            return false;
        }
        CardSplitType cst = this.cardRules.getSplitType();
        return cst == CardSplitType.Transform;
    }

    @Override
    public ICardFace getMainFace() {
        return this.getRules().getMainPart();
    }

    @Override
    public ICardFace getOtherFace() {
        return this.getRules().getOtherPart();
    }

    @Override
    public boolean isToken() {
        return true;
    }

    @Override
    public String getCardImageKey() {
        return this.getImageKey(false);
    }

    @Override
    public String getCardAltImageKey() {
        return this.getImageKey(true);
    }

    @Override
    public String getCardWSpecImageKey() {
        return this.getImageKey(false);
    }

    @Override
    public String getCardUSpecImageKey() {
        return this.getImageKey(false);
    }

    @Override
    public String getCardBSpecImageKey() {
        return this.getImageKey(false);
    }

    @Override
    public String getCardRSpecImageKey() {
        return this.getImageKey(false);
    }

    @Override
    public String getCardGSpecImageKey() {
        return this.getImageKey(false);
    }

    @Override
    public String getImageKey(boolean altState) {
        if (this.hasBackFace()) {
            String edCode;
            String string = edCode = this.edition != null ? "_" + this.edition.getCode().toLowerCase() : "";
            if (altState) {
                String name = "t:" + this.cardRules.getOtherPart().getName().toLowerCase().replace(" token", "");
                name.replace(" ", "_");
                return name + edCode;
            }
            String name = "t:" + this.cardRules.getMainPart().getName().toLowerCase().replace(" token", "");
            name.replace(" ", "_");
            return name + edCode;
        }
        int idx = MyRandom.getRandom().nextInt(this.artIndex);
        return this.getImageKey(idx);
    }

    public String getImageKey(int artIndex) {
        return "t:" + this.imageFileName.get(artIndex).replace(" ", "_");
    }

    @Override
    public boolean isRebalanced() {
        return false;
    }
}

