/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import java.util.List;
import java.util.TreeMap;

public class BoosterSlot {
    private final String slotName;
    private String baseRarity;
    private float startRange = 0.0f;
    private final TreeMap<Float, String> slotPercentages = new TreeMap();

    public BoosterSlot(String slotName, List<String> contents) {
        this.slotName = slotName;
        this.baseRarity = null;
        this.parseContents(contents);
    }

    public final String getSlotName() {
        return this.slotName;
    }

    public static BoosterSlot parseSlot(String slotName, List<String> contents) {
        return new BoosterSlot(slotName, contents);
    }

    private void parseContents(List<String> contents) {
        for (String content : contents) {
            if (content.startsWith("#")) continue;
            String[] parts = content.split("=", 2);
            String key = parts[0];
            String value = parts[1];
            if (key.equalsIgnoreCase("Base")) {
                this.baseRarity = value;
                continue;
            }
            if (!key.equalsIgnoreCase("Replace")) continue;
            String[] replaceParts = value.split(" ", 2);
            float pct = Float.parseFloat(replaceParts[0]);
            this.startRange += pct;
            this.slotPercentages.put(Float.valueOf(this.startRange), replaceParts[1]);
        }
    }

    public String replaceSlot() {
        float rand = (float)Math.random();
        for (Float key : this.slotPercentages.keySet()) {
            if (!(rand < key.floatValue())) continue;
            System.out.println("Replaced a base slot! " + this.slotName + " -> " + this.slotPercentages.get(key));
            return this.slotPercentages.get(key);
        }
        return this.baseRarity;
    }
}

