/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.control;

public enum PlaybackSpeed {
    SLOW(3.0),
    NORMAL(1.0),
    FAST(0.1);

    private double modifier = 1.0;

    private PlaybackSpeed(double modifier) {
        this.modifier = modifier;
    }

    public long applyModifier(long milliseconds) {
        return (long)(this.modifier * (double)milliseconds);
    }

    public String nextSpeedText() {
        switch (this) {
            case NORMAL: {
                return "10x speed";
            }
            case FAST: {
                return "1/3x speed";
            }
        }
        return "1x speed";
    }

    public PlaybackSpeed nextSpeed() {
        switch (this) {
            case NORMAL: {
                return FAST;
            }
            case FAST: {
                return SLOW;
            }
        }
        return NORMAL;
    }
}

