/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardView;
import forge.game.event.GameEvent;
import forge.game.event.GameEventAnteCardsSelected;
import forge.game.event.GameEventAttackersDeclared;
import forge.game.event.GameEventBlockersDeclared;
import forge.game.event.GameEventCardAttachment;
import forge.game.event.GameEventCardChangeZone;
import forge.game.event.GameEventCardCounters;
import forge.game.event.GameEventCardDamaged;
import forge.game.event.GameEventCardForetold;
import forge.game.event.GameEventCardPhased;
import forge.game.event.GameEventCardRegenerated;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.event.GameEventCardTapped;
import forge.game.event.GameEventCombatChanged;
import forge.game.event.GameEventCombatEnded;
import forge.game.event.GameEventCombatUpdate;
import forge.game.event.GameEventDayTimeChanged;
import forge.game.event.GameEventGameFinished;
import forge.game.event.GameEventGameOutcome;
import forge.game.event.GameEventLandPlayed;
import forge.game.event.GameEventManaBurn;
import forge.game.event.GameEventManaPool;
import forge.game.event.GameEventPlayerControl;
import forge.game.event.GameEventPlayerCounters;
import forge.game.event.GameEventPlayerDamaged;
import forge.game.event.GameEventPlayerLivesChanged;
import forge.game.event.GameEventPlayerPoisoned;
import forge.game.event.GameEventPlayerPriority;
import forge.game.event.GameEventPlayerRadiation;
import forge.game.event.GameEventPlayerShardsChanged;
import forge.game.event.GameEventPlayerStatsChanged;
import forge.game.event.GameEventShuffle;
import forge.game.event.GameEventSpellAbilityCast;
import forge.game.event.GameEventSpellRemovedFromStack;
import forge.game.event.GameEventSpellResolved;
import forge.game.event.GameEventSubgameEnd;
import forge.game.event.GameEventTokenStateUpdate;
import forge.game.event.GameEventTurnBegan;
import forge.game.event.GameEventTurnPhase;
import forge.game.event.GameEventZone;
import forge.game.event.IGameEventVisitor;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.gui.GuiBase;
import forge.gui.interfaces.IGuiGame;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.PlayerControllerHuman;
import forge.player.PlayerZoneUpdate;
import forge.player.PlayerZoneUpdates;
import forge.util.Lang;
import forge.util.maps.MapOfLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FControlGameEventHandler
extends IGameEventVisitor.Base<Void> {
    private final PlayerControllerHuman humanController;
    private final IGuiGame matchController;
    private final Set<CardView> cardsUpdate = new HashSet<CardView>();
    private final Set<CardView> cardsRefreshDetails = new HashSet<CardView>();
    private final Set<PlayerView> livesUpdate = new HashSet<PlayerView>();
    private final Set<PlayerView> shardsUpdate = new HashSet<PlayerView>();
    private final Set<PlayerView> manaPoolUpdate = new HashSet<PlayerView>();
    private final PlayerZoneUpdates zonesUpdate = new PlayerZoneUpdates();
    private final Map<PlayerView, Object> playersWithValidTargets = Maps.newHashMap();
    private boolean processEventsQueued;
    private boolean needPhaseUpdate;
    private boolean needCombatUpdate;
    private boolean needStackUpdate;
    private boolean needPlayerControlUpdate;
    private boolean refreshFieldUpdate;
    private boolean showExileUpdate;
    private boolean gameOver;
    private boolean gameFinished;
    private boolean needSaveState = false;
    private PlayerView turnUpdate;
    private PlayerView activatingPlayer;
    private final Runnable processEvents = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FControlGameEventHandler.this.processEventsQueued = false;
            Iterable iterable = FControlGameEventHandler.this.cardsUpdate;
            synchronized (iterable) {
                if (!FControlGameEventHandler.this.cardsUpdate.isEmpty()) {
                    FControlGameEventHandler.this.matchController.updateCards(FControlGameEventHandler.this.cardsUpdate);
                    FControlGameEventHandler.this.cardsUpdate.clear();
                }
            }
            iterable = FControlGameEventHandler.this.cardsRefreshDetails;
            synchronized (iterable) {
                if (!FControlGameEventHandler.this.cardsRefreshDetails.isEmpty()) {
                    FControlGameEventHandler.this.matchController.refreshCardDetails(FControlGameEventHandler.this.cardsRefreshDetails);
                    FControlGameEventHandler.this.cardsRefreshDetails.clear();
                }
            }
            iterable = FControlGameEventHandler.this.livesUpdate;
            synchronized (iterable) {
                if (!FControlGameEventHandler.this.livesUpdate.isEmpty()) {
                    FControlGameEventHandler.this.matchController.updateLives(FControlGameEventHandler.this.livesUpdate);
                    FControlGameEventHandler.this.livesUpdate.clear();
                }
            }
            iterable = FControlGameEventHandler.this.shardsUpdate;
            synchronized (iterable) {
                if (!FControlGameEventHandler.this.shardsUpdate.isEmpty()) {
                    FControlGameEventHandler.this.matchController.updateShards(FControlGameEventHandler.this.shardsUpdate);
                    FControlGameEventHandler.this.shardsUpdate.clear();
                }
            }
            iterable = FControlGameEventHandler.this.manaPoolUpdate;
            synchronized (iterable) {
                if (!FControlGameEventHandler.this.manaPoolUpdate.isEmpty()) {
                    FControlGameEventHandler.this.matchController.updateManaPool(FControlGameEventHandler.this.manaPoolUpdate);
                    FControlGameEventHandler.this.manaPoolUpdate.clear();
                }
            }
            if (FControlGameEventHandler.this.turnUpdate != null) {
                FControlGameEventHandler.this.matchController.updateTurn(FControlGameEventHandler.this.turnUpdate);
                FControlGameEventHandler.this.turnUpdate = null;
            }
            if (FControlGameEventHandler.this.needPhaseUpdate) {
                FControlGameEventHandler.this.needPhaseUpdate = false;
                if (FControlGameEventHandler.this.needSaveState) {
                    FControlGameEventHandler.this.needSaveState = false;
                    FControlGameEventHandler.this.matchController.updatePhase(true);
                } else {
                    FControlGameEventHandler.this.matchController.updatePhase(false);
                }
            }
            if (FControlGameEventHandler.this.needCombatUpdate) {
                FControlGameEventHandler.this.needCombatUpdate = false;
                FControlGameEventHandler.this.matchController.showCombat();
            }
            if (FControlGameEventHandler.this.needStackUpdate) {
                FControlGameEventHandler.this.needStackUpdate = false;
                FControlGameEventHandler.this.matchController.updateStack();
            }
            if (FControlGameEventHandler.this.needPlayerControlUpdate) {
                FControlGameEventHandler.this.needPlayerControlUpdate = false;
                FControlGameEventHandler.this.matchController.updatePlayerControl();
            }
            iterable = FControlGameEventHandler.this.zonesUpdate;
            synchronized (iterable) {
                if (!FControlGameEventHandler.this.zonesUpdate.isEmpty()) {
                    FControlGameEventHandler.this.matchController.updateZones(new PlayerZoneUpdates(FControlGameEventHandler.this.zonesUpdate));
                    FControlGameEventHandler.this.zonesUpdate.clear();
                }
            }
            if (FControlGameEventHandler.this.refreshFieldUpdate) {
                FControlGameEventHandler.this.refreshFieldUpdate = false;
                FControlGameEventHandler.this.matchController.refreshField();
            }
            if (FControlGameEventHandler.this.showExileUpdate) {
                FControlGameEventHandler.this.showExileUpdate = false;
                FControlGameEventHandler.this.matchController.openZones(FControlGameEventHandler.this.activatingPlayer, Collections.singleton(ZoneType.Exile), FControlGameEventHandler.this.playersWithValidTargets, false);
                FControlGameEventHandler.this.activatingPlayer = null;
                FControlGameEventHandler.this.playersWithValidTargets.clear();
            }
            if (FControlGameEventHandler.this.gameOver) {
                FControlGameEventHandler.this.gameOver = false;
                FControlGameEventHandler.this.humanController.getInputQueue().onGameOver(true);
            }
            if (FControlGameEventHandler.this.gameFinished) {
                FControlGameEventHandler.this.gameFinished = false;
                PlayerView localPlayer = FControlGameEventHandler.this.humanController.getLocalPlayerView();
                FControlGameEventHandler.this.humanController.cancelAwaitNextInput();
                FControlGameEventHandler.this.matchController.showPromptMessage(localPlayer, "");
                FControlGameEventHandler.this.matchController.updateButtons(localPlayer, "", "", false, false, false);
                FControlGameEventHandler.this.matchController.finishGame();
                FControlGameEventHandler.this.humanController.updateAchievements();
            }
        }
    };

    public FControlGameEventHandler(PlayerControllerHuman humanController0) {
        this.humanController = humanController0;
        this.matchController = this.humanController.getGui();
    }

    @Subscribe
    public void receiveGameEvent(GameEvent ev) {
        ev.visit(this);
    }

    private Void processEvent() {
        if (this.processEventsQueued) {
            return null;
        }
        this.processEventsQueued = true;
        GuiBase.getInterface().invokeInEdtLater(this.processEvents);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void processCard(Card card, Set<CardView> list) {
        Set<CardView> set = list;
        synchronized (set) {
            list.add(card.getView());
        }
        return this.processEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void processCards(Collection<Card> cards, Set<CardView> list) {
        if (cards.isEmpty()) {
            return null;
        }
        Set<CardView> set = list;
        synchronized (set) {
            for (Card c : cards) {
                list.add(c.getView());
            }
        }
        return this.processEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void processPlayer(Player player, Set<PlayerView> list) {
        Set<PlayerView> set = list;
        synchronized (set) {
            list.add(player.getView());
        }
        return this.processEvent();
    }

    private Void updateZone(Zone z) {
        if (z == null) {
            return null;
        }
        return this.updateZone(z.getPlayer(), z.getZoneType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void updateZone(Player p, ZoneType z) {
        if (p == null || z == null) {
            return null;
        }
        PlayerZoneUpdates playerZoneUpdates = this.zonesUpdate;
        synchronized (playerZoneUpdates) {
            this.zonesUpdate.add(new PlayerZoneUpdate(PlayerView.get(p), z));
        }
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventTurnPhase ev) {
        this.needPhaseUpdate = true;
        this.needSaveState = ev.phaseDesc != "dev";
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventPlayerPriority event) {
        this.needCombatUpdate = true;
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventTurnBegan event) {
        this.turnUpdate = event.turnOwner.getView();
        this.processPlayer(event.turnOwner, this.livesUpdate);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_STACK_CREATURES) && event.turnOwner != null) {
            this.updateZone(event.turnOwner, ZoneType.Battlefield);
        }
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventAnteCardsSelected ev) {
        ArrayList<CardView> options = Lists.newArrayList();
        for (Map.Entry<Player, Card> kv : ev.cards.entries()) {
            CardView fakeCard = new CardView(-1, null, "  -- From " + Lang.getInstance().getPossesive(kv.getKey().getName()) + " deck --");
            options.add(fakeCard);
            options.add(kv.getValue().getView());
        }
        this.humanController.getGui().reveal("These cards were chosen to ante", options);
        return null;
    }

    @Override
    public Void visit(GameEventPlayerControl ev) {
        if (ev.player.getGame().isGameOver()) {
            return null;
        }
        PlayerControllerHuman newController = ev.newController instanceof PlayerControllerHuman ? (PlayerControllerHuman)ev.newController : null;
        this.matchController.setGameController(PlayerView.get(ev.player), newController);
        this.needPlayerControlUpdate = true;
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventGameOutcome ev) {
        this.gameOver = true;
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventGameFinished ev) {
        this.gameFinished = true;
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventSpellAbilityCast event) {
        this.needStackUpdate = true;
        if (GuiBase.getInterface().isLibgdxPort()) {
            return this.processEvent();
        }
        this.processEvent();
        Runnable notifyStackAddition = () -> this.matchController.notifyStackAddition(event);
        GuiBase.getInterface().invokeInEdtLater(notifyStackAddition);
        return null;
    }

    @Override
    public Void visit(GameEventSpellResolved event) {
        this.needStackUpdate = true;
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventSpellRemovedFromStack event) {
        this.needStackUpdate = true;
        if (GuiBase.getInterface().isLibgdxPort()) {
            return this.processEvent();
        }
        this.processEvent();
        Runnable notifyStackAddition = () -> this.matchController.notifyStackRemoval(event);
        GuiBase.getInterface().invokeInEdtLater(notifyStackAddition);
        return null;
    }

    @Override
    public Void visit(GameEventSubgameEnd event) {
        if (event.maingame != null) {
            for (Player p : event.maingame.getPlayers()) {
                this.updateZone(p, ZoneType.Battlefield);
                this.updateZone(p, ZoneType.Hand);
                this.updateZone(p, ZoneType.Graveyard);
                this.updateZone(p, ZoneType.Exile);
                this.updateZone(p, ZoneType.Command);
            }
            if (event.maingame.isDay()) {
                this.matchController.updateDayTime("Day");
            } else if (event.maingame.isNight()) {
                this.matchController.updateDayTime("Night");
            }
            return this.processEvent();
        }
        return null;
    }

    @Override
    public Void visit(GameEventZone event) {
        if (event.player != null) {
            this.updateZone(event.player, event.zoneType);
            return this.processEvent();
        }
        return null;
    }

    @Override
    public Void visit(GameEventCardAttachment event) {
        Game game = event.equipment.getGame();
        Zone zEq = game.getZoneOf(event.equipment);
        if (event.oldEntiy instanceof Card) {
            this.updateZone(game.getZoneOf((Card)event.oldEntiy));
        }
        if (event.newTarget instanceof Card) {
            this.updateZone(game.getZoneOf((Card)event.newTarget));
        }
        this.updateZone(zEq);
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventCardTapped event) {
        this.refreshFieldUpdate = true;
        this.processCard(event.card, this.cardsUpdate);
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventCardPhased event) {
        this.processCard(event.card, this.cardsUpdate);
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventCardDamaged event) {
        this.processCard(event.card, this.cardsUpdate);
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventCardCounters event) {
        this.processCard(event.card, this.cardsUpdate);
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventBlockersDeclared event) {
        HashSet<Card> cards = new HashSet<Card>();
        for (MapOfLists<Card, Card> kv : event.blockers.values()) {
            for (Collection blockers : kv.values()) {
                cards.addAll(blockers);
            }
        }
        return this.processCards(cards, this.cardsUpdate);
    }

    @Override
    public Void visit(GameEventAttackersDeclared event) {
        return this.processCards(event.attackersMap.values(), this.cardsUpdate);
    }

    @Override
    public Void visit(GameEventCombatChanged event) {
        this.needCombatUpdate = true;
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventCombatEnded event) {
        this.needCombatUpdate = true;
        this.processCards(event.attackers, this.cardsUpdate);
        return this.processCards(event.blockers, this.cardsUpdate);
    }

    @Override
    public Void visit(GameEventCombatUpdate event) {
        if (!GuiBase.isNetworkplay()) {
            return null;
        }
        CardCollection cards = new CardCollection();
        cards.addAll(event.attackers);
        cards.addAll(event.blockers);
        this.refreshFieldUpdate = true;
        this.processCards(cards, this.cardsRefreshDetails);
        return this.processCards(cards, this.cardsUpdate);
    }

    @Override
    public Void visit(GameEventCardChangeZone event) {
        if (GuiBase.getInterface().isLibgdxPort()) {
            this.updateZone(event.from);
            return this.updateZone(event.to);
        }
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventCardStatsChanged event) {
        this.refreshFieldUpdate = true;
        this.processCards(event.cards, this.cardsRefreshDetails);
        return this.processCards(event.cards, this.cardsUpdate);
    }

    @Override
    public Void visit(GameEventCardForetold event) {
        this.showExileUpdate = true;
        this.activatingPlayer = event.activatingPlayer.getView();
        this.playersWithValidTargets.put(this.activatingPlayer, null);
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventPlayerStatsChanged event) {
        CardCollection cards = new CardCollection();
        for (Player p : event.players) {
            if (event.updateCards) {
                cards.addAll(p.getAllCards());
            }
            this.processPlayer(p, this.livesUpdate);
        }
        return this.processCards(cards, this.cardsRefreshDetails);
    }

    @Override
    public Void visit(GameEventLandPlayed event) {
        this.processPlayer(event.player, this.livesUpdate);
        this.matchController.handleLandPlayed(event.land);
        return this.processCard(event.land, this.cardsRefreshDetails);
    }

    @Override
    public Void visit(GameEventTokenStateUpdate event) {
        this.refreshFieldUpdate = true;
        this.processCards(event.cards, this.cardsRefreshDetails);
        return this.processCards(event.cards, this.cardsUpdate);
    }

    @Override
    public Void visit(GameEventCardRegenerated event) {
        this.refreshFieldUpdate = true;
        this.processCards(event.cards, this.cardsRefreshDetails);
        return this.processCards(event.cards, this.cardsUpdate);
    }

    @Override
    public Void visit(GameEventShuffle event) {
        if (GuiBase.getInterface().isLibgdxPort()) {
            return this.updateZone(event.player.getZone(ZoneType.Library));
        }
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventDayTimeChanged event) {
        this.matchController.updateDayTime(event.daytime ? "Day" : "Night");
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventManaPool event) {
        return this.processPlayer(event.player, this.manaPoolUpdate);
    }

    @Override
    public Void visit(GameEventPlayerLivesChanged event) {
        return this.processPlayer(event.player, this.livesUpdate);
    }

    @Override
    public Void visit(GameEventPlayerShardsChanged event) {
        return this.processPlayer(event.player, this.shardsUpdate);
    }

    @Override
    public Void visit(GameEventManaBurn event) {
        return this.processPlayer(event.player, this.livesUpdate);
    }

    @Override
    public Void visit(GameEventPlayerPoisoned event) {
        return this.processPlayer(event.receiver, this.livesUpdate);
    }

    @Override
    public Void visit(GameEventPlayerRadiation event) {
        return this.processPlayer(event.receiver, this.livesUpdate);
    }

    @Override
    public Void visit(GameEventPlayerDamaged event) {
        return this.processEvent();
    }

    @Override
    public Void visit(GameEventPlayerCounters event) {
        return this.processPlayer(event.receiver, this.livesUpdate);
    }
}

