/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.tournament;

import forge.deck.Deck;
import forge.deck.DeckType;
import forge.deck.DeckgenUtil;
import forge.game.GameFormat;
import forge.gamemodes.tournament.TournamentData;
import forge.gamemodes.tournament.TournamentIO;
import forge.model.FModel;
import forge.util.MyRandom;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TournamentUtil {
    public static TournamentData createQuickTournament(Deck userDeck, int numOpponents, List<DeckType> allowedDeckTypes) {
        TournamentData tournament = new TournamentData();
        TournamentUtil.setDefaultTournamentName(tournament, "Quick_");
        FModel.setTournamentData(tournament);
        ArrayList<String> eventNames = new ArrayList<String>();
        ArrayList<Deck> decks = new ArrayList<Deck>();
        block16: for (int i = 0; i < numOpponents; ++i) {
            Deck deck;
            int randType = (int)Math.floor(MyRandom.getRandom().nextDouble() * (double)allowedDeckTypes.size());
            switch (allowedDeckTypes.get(randType)) {
                case COLOR_DECK: {
                    deck = DeckgenUtil.getRandomColorDeck(true);
                    eventNames.add("Random colors deck");
                    break;
                }
                case STANDARD_COLOR_DECK: {
                    deck = DeckgenUtil.getRandomColorDeck(FModel.getFormats().getStandard().getFilterPrinted(), true);
                    break;
                }
                case STANDARD_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildCardGenDeck(FModel.getFormats().getStandard(), true);
                    break;
                }
                case PIONEER_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildCardGenDeck(FModel.getFormats().getPioneer(), true);
                    break;
                }
                case HISTORIC_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildCardGenDeck(FModel.getFormats().getHistoric(), true);
                    break;
                }
                case MODERN_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildCardGenDeck(FModel.getFormats().getModern(), true);
                    break;
                }
                case LEGACY_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildLDACArchetypeDeck((GameFormat)FModel.getFormats().get("Legacy"), true);
                    break;
                }
                case VINTAGE_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildLDACArchetypeDeck((GameFormat)FModel.getFormats().get("Vintage"), true);
                    break;
                }
                case PAUPER_CARDGEN_DECK: {
                    deck = DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getPauper(), true);
                    break;
                }
                case MODERN_COLOR_DECK: {
                    deck = DeckgenUtil.getRandomColorDeck(FModel.getFormats().getModern().getFilterPrinted(), true);
                    break;
                }
                case CUSTOM_DECK: {
                    deck = DeckgenUtil.getRandomCustomDeck();
                    if (deck != null) {
                        eventNames.add(deck.getName());
                        break;
                    }
                }
                case PRECONSTRUCTED_DECK: {
                    deck = DeckgenUtil.getRandomPreconDeck();
                    eventNames.add(deck.getName());
                    break;
                }
                case QUEST_OPPONENT_DECK: {
                    deck = DeckgenUtil.getRandomQuestDeck();
                    eventNames.add(deck.getName());
                    break;
                }
                case THEME_DECK: {
                    deck = DeckgenUtil.getRandomThemeDeck();
                    eventNames.add(deck.getName());
                    break;
                }
                default: {
                    continue block16;
                }
            }
            decks.add(deck);
        }
        tournament.setDecks(decks);
        tournament.setEventNames(eventNames);
        tournament.setUserDeck(userDeck);
        tournament.reset();
        return tournament;
    }

    public static void setDefaultTournamentName(TournamentData tournament, String prefix) {
        File[] arrFiles = TournamentIO.getTournamentFilesUnlocked(prefix);
        HashSet<String> setNames = new HashSet<String>();
        for (File f : arrFiles) {
            setNames.add(f.getName());
        }
        int num = 1;
        while (setNames.contains(prefix + num + ".dat")) {
            ++num;
        }
        tournament.setName(prefix + num);
    }
}

