/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.tournament;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import forge.deck.CardPool;
import forge.gamemodes.tournament.TournamentData;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.IgnoringXStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;

public class TournamentIO {
    public static final String TXF_PROMPT = "[New Tournament]";
    public static final String SUFFIX_DATA = ".dat";
    public static final String PREFIX_QUICK = "Quick_";
    public static final String PREFIX_CUSTOM = "Custom_";
    public static final String PREFIX_LOCKED = "LOCKED_";

    protected static XStream getSerializer(boolean isIgnoring) {
        XStream xStream = isIgnoring ? new IgnoringXStream() : new XStream();
        xStream.addPermission(NoTypePermission.NONE);
        xStream.addPermission(NullPermission.NULL);
        xStream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xStream.allowTypeHierarchy(String.class);
        xStream.ignoreUnknownElements();
        xStream.setMode(1001);
        xStream.allowTypesByWildcard(new String[]{TournamentIO.class.getPackage().getName() + ".*"});
        xStream.registerConverter(new DeckSectionToXml());
        xStream.autodetectAnnotations(true);
        xStream.aliasPackage("forge.tournament", TournamentIO.class.getPackage().getName());
        return xStream;
    }

    public static File getTournamentFile(String name) {
        return new File(ForgeConstants.TOURNAMENT_DIR.userPrefLoc, name + SUFFIX_DATA);
    }

    public static File getTournamentFile(TournamentData gd) {
        return TournamentIO.getTournamentFile(gd.getName());
    }

    public static File[] getTournamentFilesUnlocked(String prefix) {
        FilenameFilter filter = (dir, name) -> (prefix == null || name.startsWith(prefix)) && name.endsWith(SUFFIX_DATA);
        File folder = new File(ForgeConstants.TOURNAMENT_DIR.userPrefLoc);
        return folder.listFiles(filter);
    }

    public static File[] getTournamentFilesLocked() {
        FilenameFilter filter = (dir, name) -> name.startsWith(PREFIX_LOCKED) && name.endsWith(SUFFIX_DATA);
        File folder = new File(ForgeConstants.TOURNAMENT_DIR.defaultLoc);
        return folder.listFiles(filter);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static TournamentData loadTournament(File xmlSaveFile) {
        boolean isCorrupt = false;
        try (GZIPInputStream zin = new GZIPInputStream(Files.newInputStream(xmlSaveFile.toPath(), new OpenOption[0]));){
            TournamentData tournamentData;
            try (InputStreamReader reader = new InputStreamReader(zin);){
                TournamentData data = (TournamentData)TournamentIO.getSerializer(true).fromXML(reader);
                String filename = xmlSaveFile.getName();
                data.setName(filename.substring(0, filename.length() - SUFFIX_DATA.length()));
                tournamentData = data;
            }
            return tournamentData;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            isCorrupt = true;
        }
        if (isCorrupt) {
            try {
                xmlSaveFile.delete();
            }
            catch (Exception e) {
                System.out.println("error delete corrupt tournament file: " + e);
            }
        }
        return null;
    }

    public static void saveTournament(TournamentData gd0) {
        try {
            XStream xStream = TournamentIO.getSerializer(false);
            TournamentIO.savePacked(xStream, gd0);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void savePacked(XStream xStream0, TournamentData gd0) throws IOException {
        try (BufferedOutputStream bout = new BufferedOutputStream(Files.newOutputStream(TournamentIO.getTournamentFile(gd0).toPath(), new OpenOption[0]));
             GZIPOutputStream zout = new GZIPOutputStream(bout);){
            xStream0.toXML((Object)gd0, zout);
            zout.flush();
        }
    }

    private static class DeckSectionToXml
    implements Converter {
        private DeckSectionToXml() {
        }

        @Override
        public boolean canConvert(Class clasz) {
            return clasz.equals(CardPool.class);
        }

        @Override
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            for (Map.Entry e : (CardPool)source) {
                DeckSectionToXml.writeCardPrinted((PaperCard)e.getKey(), e.getValue(), writer);
            }
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            CardPool result = new CardPool();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String sCnt = reader.getAttribute("n");
                int cnt = StringUtils.isNumeric(sCnt) ? Integer.parseInt(sCnt) : 1;
                String nodename = reader.getNodeName();
                if ("string".equals(nodename)) {
                    result.add(FModel.getMagicDb().getCommonCards().getCard(reader.getValue()));
                } else if ("card".equals(nodename)) {
                    result.add(DeckSectionToXml.readCardPrinted(reader), cnt);
                }
                reader.moveUp();
            }
            return result;
        }

        private static void writeCardPrinted(PaperCard cref, Integer count, HierarchicalStreamWriter writer) {
            writer.startNode("card");
            writer.addAttribute("c", cref.getName());
            writer.addAttribute("s", cref.getEdition());
            if (cref.isFoil()) {
                writer.addAttribute("foil", "1");
            }
            writer.addAttribute("i", Integer.toString(cref.getArtIndex()));
            writer.addAttribute("n", count.toString());
            writer.endNode();
        }

        private static PaperCard readCardPrinted(HierarchicalStreamReader reader) {
            String name = reader.getAttribute("c");
            String set = reader.getAttribute("s");
            String sIndex = reader.getAttribute("i");
            short index = StringUtils.isNumeric(sIndex) ? Short.parseShort(sIndex) : (short)0;
            boolean foil = "1".equals(reader.getAttribute("foil"));
            PaperCard card = FModel.getMagicDb().getOrLoadCommonCard(name, set, index, foil);
            if (null == card && (card = FModel.getMagicDb().getCommonCards().getCard(name)) == null) {
                System.err.println("Warning: Unsupported card found in quest save: " + name + " from edition " + set + ". It will be removed from the quest save.");
            }
            return card;
        }
    }
}

