/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.io;

import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.io.DeckSerializer;
import forge.deck.io.DeckStorage;
import forge.gamemodes.quest.QuestEvent;
import forge.gamemodes.quest.QuestEventDifficulty;
import forge.gamemodes.quest.QuestEventDuel;
import forge.util.FileSection;
import forge.util.FileUtil;
import forge.util.TextUtil;
import forge.util.storage.StorageReaderFolder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class MainWorldDuelReader
extends StorageReaderFolder<QuestEventDuel> {
    private static final String WILD_DEFAULT_ICON_NAME = "Wild.jpg";
    private static final String WILD_DIR_NAME = "wild";

    public MainWorldDuelReader(File deckDir0) {
        super(deckDir0, QuestEvent::getName);
    }

    @Override
    public Map<String, QuestEventDuel> readAll() {
        final TreeMap<String, QuestEventDuel> result = new TreeMap<String, QuestEventDuel>();
        try {
            Files.walkFileTree(this.directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    File actualFile = new File(path.toString());
                    try {
                        QuestEventDuel newDeck = MainWorldDuelReader.this.read(actualFile);
                        if (null == newDeck) {
                            String msg = "An object stored in " + actualFile.getPath() + " failed to load.\nPlease submit this as a bug with the mentioned file/directory attached.";
                            throw new RuntimeException(msg);
                        }
                        String newKey = (String)MainWorldDuelReader.this.keySelector.apply(newDeck);
                        if (result.containsKey(newKey)) {
                            System.err.println("StorageReaderFolder: an object with key " + newKey + " is already present - skipping new entry");
                        } else {
                            result.put(newKey, newDeck);
                        }
                    }
                    catch (NoSuchElementException ex) {
                        String message = TextUtil.concatWithSpace(actualFile.getName(), "failed to load because ----", ex.getMessage());
                        MainWorldDuelReader.this.objectsThatFailedToLoad.add(message);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Iterable<DeckProxy> constructedDecks = DeckProxy.getAllConstructedDecks();
        for (DeckProxy constructedDeck : constructedDecks) {
            Deck currDeck = constructedDeck.getDeck();
            QuestEventDuel newDeck = this.read(currDeck);
            String newKey = (String)this.keySelector.apply(newDeck);
            if (result.containsKey(newKey)) {
                System.err.println("StorageReaderFolder: an object with key " + newKey + " is already present - skipping new entry");
                continue;
            }
            result.put(newKey, newDeck);
        }
        return result;
    }

    @Override
    protected QuestEventDuel read(File file) {
        boolean difficultySpecified;
        Map<String, List<String>> contents = FileSection.parseSections(FileUtil.readFile(file));
        QuestEventDuel qc = new QuestEventDuel();
        FileSection sectionMeta = FileSection.parse((Iterable<String>)contents.get("metadata"), FileSection.EQUALS_KV_SEPARATOR);
        qc.setName(sectionMeta.get("Name"));
        boolean bl = difficultySpecified = !StringUtils.isEmpty(sectionMeta.get("Difficulty"));
        if (difficultySpecified) {
            qc.setTitle(sectionMeta.get("Title"));
            qc.setDifficulty(QuestEventDifficulty.fromString(sectionMeta.get("Difficulty")));
            qc.setDescription(sectionMeta.get("Description", "").replace("\\n", "\n"));
            qc.setCardReward(sectionMeta.get("Card Reward"));
            qc.setIconImageKey("i:" + sectionMeta.get("Icon"));
            if (sectionMeta.contains("Profile")) {
                qc.setProfile(sectionMeta.get("Profile"));
            }
        } else {
            qc.setDifficulty(QuestEventDifficulty.WILD);
            qc.setTitle(sectionMeta.get("Title") != null ? sectionMeta.get("Title") : qc.getName());
            qc.setDescription(sectionMeta.get("Description") != null ? sectionMeta.get("Description") : "Wild opponent");
            qc.setIconImageKey("i:" + (sectionMeta.get("Icon") != null ? sectionMeta.get("Icon") : WILD_DEFAULT_ICON_NAME));
        }
        qc.setEventDeck(DeckSerializer.fromSections(contents));
        return qc;
    }

    protected QuestEventDuel read(Deck deck) {
        QuestEventDuel qc = new QuestEventDuel();
        qc.setName(deck.getName());
        qc.setTitle(deck.getName());
        qc.setDifficulty(QuestEventDifficulty.WILD);
        qc.setDescription("Wild opponent");
        qc.setIconImageKey("i:Wild.jpg");
        qc.setEventDeck(deck);
        return qc;
    }

    @Override
    protected FilenameFilter getFileFilter() {
        return DeckStorage.DCK_FILE_FILTER;
    }
}

