/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.data;

import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.PreferencesStore;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.io.Serializable;

public class QuestPreferences
extends PreferencesStore<QPref>
implements Serializable {
    public QuestPreferences() {
        super(ForgeConstants.QUEST_PREFS_FILE, QPref.class);
    }

    protected QPref[] getEnumValues() {
        return QPref.values();
    }

    @Override
    protected QPref valueOf(String name) {
        try {
            return QPref.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected String getPrefDefault(QPref key) {
        return key.getDefault();
    }

    public String getPref(DifficultyPrefs pref, int difficultyIndex) {
        String newQPref = pref.toString();
        switch (difficultyIndex) {
            case 0: {
                newQPref = newQPref + "_EASY";
                break;
            }
            case 1: {
                newQPref = newQPref + "_MEDIUM";
                break;
            }
            case 2: {
                newQPref = newQPref + "_HARD";
                break;
            }
            case 3: {
                newQPref = newQPref + "_EXPERT";
                break;
            }
            default: {
                throw new IllegalArgumentException(TextUtil.concatNoSpace("Difficulty index ", String.valueOf(difficultyIndex), " out of bounds, preference ", newQPref));
            }
        }
        return this.getPref(QPref.valueOf(newQPref));
    }

    public int getPrefInt(DifficultyPrefs pref, int difficultyIndex) {
        return Integer.parseInt(this.getPref(pref, difficultyIndex));
    }

    public String validatePreference(QPref qpref, int val) {
        switch (qpref) {
            case STARTING_POOL_COLOR_BIAS: {
                if (val < 1) {
                    return "Bias value too small (minimum 1).";
                }
                if (val <= 100) break;
                return "Bias value too large (maximum 100).";
            }
            case WORLD_RULES_CONFORMANCE: 
            case DRAFT_ROTATION: 
            case SPECIAL_BOOSTERS: 
            case FOIL_FILTER_DEFAULT: 
            case RATING_FILTER_DEFAULT: 
            case ITEM_LEVEL_RESTRICTION: 
            case EXCLUDE_PROMOS_FROM_POOL: {
                if (val == 0 || val == 1) break;
                return "Only values 0 or 1 are acceptable; 1 for enabled, 0 for disabled.";
            }
            case SHOP_MAX_PACKS: 
            case SHOP_MAX_SELLING_PRICE: 
            case SHOP_SELLING_PERCENTAGE_BASE: 
            case SHOP_SELLING_PERCENTAGE_MAX: 
            case SHOP_WINS_FOR_ADDITIONAL_PACK: 
            case PLAYSET_SIZE: 
            case PLAYSET_ANY_NUMBER_SIZE: 
            case WINS_NEW_CHALLENGE: 
            case WINS_NEW_DRAFT: 
            case WINS_ROTATE_DRAFT: 
            case WINS_UNLOCK_SET: 
            case UNLOCK_DISTANCE_MULTIPLIER: {
                if (val >= 1) break;
                return "Value too small (minimum 1).";
            }
            case WILD_OPPONENTS_NUMBER: {
                if (val >= 0 && val <= 3) break;
                return Localizer.getInstance().getMessage("lblWildOpponentNumberError", new Object[0]);
            }
            default: {
                if (val >= 0) break;
                return "Value too small (minimum 0).";
            }
        }
        return null;
    }

    public static enum DifficultyPrefs {
        STARTING_COMMONS,
        STARTING_UNCOMMONS,
        STARTING_RARES,
        STARTING_CREDITS,
        WINS_BOOSTER,
        WINS_RANKUP,
        WINS_MEDIUMAI,
        WINS_HARDAI,
        WINS_EXPERTAI;

    }

    public static enum QPref {
        WORLD_RULES_CONFORMANCE("0"),
        BOOSTER_COMMONS("11"),
        BOOSTER_UNCOMMONS("3"),
        BOOSTER_RARES("1"),
        BOOSTER_FORMAT("Standard"),
        SPECIAL_BOOSTERS("1"),
        PENALTY_LOSS("15"),
        CURRENT_QUEST("DEFAULT"),
        CURRENT_DECK("DEFAULT"),
        REWARDS_BASE("25"),
        REWARDS_UNDEFEATED("25"),
        REWARDS_WINS_MULTIPLIER("0.3"),
        REWARDS_WINS_MULTIPLIER_MAX("300"),
        REWARDS_POISON("50"),
        REWARDS_MILLED("40"),
        REWARDS_ALTERNATIVE("100"),
        REWARDS_HEALTH_DIFF_MAX("750"),
        REWARDS_MULLIGAN0("500"),
        REWARDS_TURN15("5"),
        REWARDS_TURN10("50"),
        REWARDS_TURN5("250"),
        REWARDS_TURN1("1500"),
        STARTING_SNOW_LANDS("5"),
        STARTING_POOL_COLOR_BIAS("75"),
        STARTING_COMMONS_EASY("82"),
        STARTING_COMMONS_MEDIUM("80"),
        STARTING_COMMONS_HARD("78"),
        STARTING_COMMONS_EXPERT("76"),
        STARTING_UNCOMMONS_EASY("40"),
        STARTING_UNCOMMONS_MEDIUM("36"),
        STARTING_UNCOMMONS_HARD("32"),
        STARTING_UNCOMMONS_EXPERT("28"),
        STARTING_RARES_EASY("20"),
        STARTING_RARES_MEDIUM("18"),
        STARTING_RARES_HARD("16"),
        STARTING_RARES_EXPERT("15"),
        STARTING_CREDITS_EASY("250"),
        STARTING_CREDITS_MEDIUM("200"),
        STARTING_CREDITS_HARD("150"),
        STARTING_CREDITS_EXPERT("100"),
        WINS_NEW_CHALLENGE("10"),
        WINS_NEW_DRAFT("5"),
        WINS_ROTATE_DRAFT("15"),
        WINS_BOOSTER_EASY("1"),
        WINS_BOOSTER_MEDIUM("1"),
        WINS_BOOSTER_HARD("2"),
        WINS_BOOSTER_EXPERT("2"),
        WINS_RANKUP_EASY("3"),
        WINS_RANKUP_MEDIUM("4"),
        WINS_RANKUP_HARD("5"),
        WINS_RANKUP_EXPERT("6"),
        WINS_MEDIUMAI_EASY("20"),
        WINS_MEDIUMAI_MEDIUM("15"),
        WINS_MEDIUMAI_HARD("12"),
        WINS_MEDIUMAI_EXPERT("10"),
        WINS_HARDAI_EASY("40"),
        WINS_HARDAI_MEDIUM("30"),
        WINS_HARDAI_HARD("25"),
        WINS_HARDAI_EXPERT("20"),
        WINS_EXPERTAI_EASY("80"),
        WINS_EXPERTAI_MEDIUM("60"),
        WINS_EXPERTAI_HARD("50"),
        WINS_EXPERTAI_EXPERT("40"),
        WINS_UNLOCK_SET("20"),
        UNLIMITED_UNLOCKING("0"),
        UNLOCK_DISTANCE_MULTIPLIER("1.25"),
        SHOP_MAX_PACKS("7"),
        SHOP_MIN_PACKS("3"),
        SHOP_SINGLES_COMMON("7"),
        SHOP_SINGLES_UNCOMMON("3"),
        SHOP_SINGLES_RARE("1"),
        SHOP_WINS_FOR_ADDITIONAL_PACK("10"),
        SHOP_STARTING_PACKS("5"),
        SHOP_SELLING_PERCENTAGE_BASE("20"),
        SHOP_SELLING_PERCENTAGE_MAX("60"),
        SHOP_MAX_SELLING_PRICE("1000"),
        SHOP_WINS_FOR_NO_SELL_LIMIT("50"),
        MORE_DUEL_CHOICES("0"),
        WILD_OPPONENTS_MULTIPLIER("2.0"),
        WILD_OPPONENTS_NUMBER("0"),
        PLAYSET_SIZE("4"),
        PLAYSET_ANY_NUMBER_SIZE("500"),
        PLAYSET_BASIC_LAND_SIZE("50"),
        ITEM_LEVEL_RESTRICTION("1"),
        SIMULATE_AI_VS_AI_RESULTS("0"),
        DRAFT_ROTATION("0"),
        FOIL_FILTER_DEFAULT("0"),
        RATING_FILTER_DEFAULT("1"),
        EXCLUDE_PROMOS_FROM_POOL("1");

        private final String strDefaultVal;

        private QPref(String s0) {
            this.strDefaultVal = s0;
        }

        public String getDefault() {
            return this.strDefaultVal;
        }
    }
}

