/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.data;

import forge.game.GameFormat;
import forge.gamemodes.quest.QuestMode;
import forge.gamemodes.quest.data.DeckConstructionRules;
import forge.gamemodes.quest.data.GameFormatQuest;
import forge.gamemodes.quest.data.QuestAchievements;
import forge.gamemodes.quest.data.QuestAssets;
import forge.gamemodes.quest.data.StarRating;
import forge.gamemodes.quest.io.QuestDataIO;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class QuestData {
    public static final int CURRENT_VERSION_NUMBER = 13;
    private int versionNumber = 13;
    private GameFormatQuest format;
    private String name;
    private QuestMode mode;
    private String worldId;
    private QuestAssets assets;
    private QuestAchievements achievements;
    private final Map<Integer, String> petSlots = new HashMap<Integer, String>();
    private int matchLength = 3;
    public HashSet<StarRating> Ratings = new HashSet();
    public String currentDeck = "DEFAULT";
    public DeckConstructionRules deckConstructionRules = DeckConstructionRules.Default;

    public QuestData() {
    }

    public QuestData(String name0, int diff, QuestMode mode0, GameFormat userFormat, boolean allowSetUnlocks, String startingWorld, DeckConstructionRules dcr) {
        this.name = name0;
        if (userFormat != null) {
            this.format = new GameFormatQuest(userFormat, allowSetUnlocks, null);
        }
        this.mode = mode0;
        this.achievements = new QuestAchievements(diff);
        this.assets = new QuestAssets(this.format);
        this.worldId = startingWorld;
        this.deckConstructionRules = dcr;
    }

    public QuestMode getMode() {
        return this.mode;
    }

    public GameFormatQuest getFormat() {
        return this.format;
    }

    public Object readResolve() {
        return this;
    }

    public void saveData() {
        QuestDataIO.saveData(this);
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int versionNumber0) {
        this.versionNumber = versionNumber0;
    }

    public String getName() {
        return this.name;
    }

    public void rename(String newName) {
        File newpath = new File(ForgeConstants.QUEST_SAVE_DIR, newName + ".dat");
        File oldpath = new File(ForgeConstants.QUEST_SAVE_DIR, this.name + ".dat");
        oldpath.renameTo(newpath);
        newpath = new File(ForgeConstants.QUEST_SAVE_DIR, newName + ".dat.bak");
        oldpath = new File(ForgeConstants.QUEST_SAVE_DIR, this.name + ".dat.bak");
        oldpath.renameTo(newpath);
        this.name = newName;
        QuestDataIO.saveData(this);
    }

    public QuestAssets getAssets() {
        return this.assets;
    }

    public Map<Integer, String> getPetSlots() {
        return this.petSlots;
    }

    public QuestAchievements getAchievements() {
        return this.achievements;
    }

    public String getWorldId() {
        return this.worldId;
    }

    public void setWorldId(String newId) {
        if (newId != null && FModel.getWorlds().get(newId) == null) {
            throw new RuntimeException("Tried to set illegal (unknown) world id: " + newId);
        }
        this.worldId = newId;
    }

    public void setMatchLength(int len) {
        this.matchLength = len;
    }

    public int getMatchLength() {
        return this.matchLength;
    }
}

