/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.bazaar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.bazaar.IQuestBazaarItem;
import forge.gamemodes.quest.bazaar.QuestPetStats;
import forge.gamemodes.quest.data.QuestAssets;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gui.GuiBase;
import forge.item.PaperToken;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.FSkinProp;
import forge.localinstance.skin.ISkinImage;
import forge.model.FModel;
import java.util.ArrayList;
import java.util.List;

public class QuestPetController
implements IQuestBazaarItem {
    @XStreamAsAttribute
    private final int maxLevel;
    private final List<QuestPetStats> levels = new ArrayList<QuestPetStats>();
    @XStreamAsAttribute
    private final String name;
    @XStreamAlias(value="desc")
    private final String description;
    @XStreamAsAttribute
    private final String saveFileKey;
    @XStreamAsAttribute
    private int slot;

    protected int getPetLevel(QuestAssets qA) {
        int level = qA.getPetLevel(this.saveFileKey);
        return level < 0 ? 0 : (level > this.maxLevel ? this.maxLevel : level);
    }

    public PaperToken getPetCard(QuestAssets qA) {
        return this.levels.get(this.getPetLevel(qA)).getCard();
    }

    @Override
    public final int getBuyingPrice(QuestAssets qA) {
        int level = this.getPetLevel(qA);
        return level >= this.maxLevel ? -1 : this.levels.get(level + 1).getCost();
    }

    @Override
    public final int getSellingPrice(QuestAssets qA) {
        return 0;
    }

    public final String getUpgradeDescription(QuestAssets qA) {
        return this.levels.get(this.getPetLevel(qA)).getNextLevel();
    }

    @Override
    public final ISkinImage getIcon(QuestAssets qA) {
        String path = ForgeConstants.CACHE_TOKEN_PICS_DIR;
        int level = this.getPetLevel(qA);
        try {
            return GuiBase.getInterface().getUnskinnedIcon(path + this.levels.get(level < this.maxLevel ? level + 1 : level).getPicture() + ".jpg");
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                return GuiBase.getInterface().getUnskinnedIcon(ForgeConstants.NO_CARD_FILE);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return GuiBase.getInterface().getSkinIcon(FSkinProp.ICO_UNKNOWN);
            }
        }
    }

    public final String getStats(QuestAssets qA) {
        return this.levels.get(this.getPetLevel(qA)).getStats();
    }

    public final String getUpgradedStats(QuestAssets qA) {
        int level = this.getPetLevel(qA);
        return level >= this.maxLevel ? "N/A" : this.levels.get(level + 1).getStats();
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    private QuestPetController() {
        this.description = null;
        this.name = null;
        this.maxLevel = 0;
        this.saveFileKey = null;
    }

    @Override
    public final String getPurchaseDescription(QuestAssets qA) {
        return this.getDescription() + "\n\nCurrent stats: " + this.getStats(qA) + "\nUpgraded stats: " + this.getUpgradedStats(qA);
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }

    @Override
    public final int compareTo(Object o) {
        return this.name.compareTo(o.toString());
    }

    @Override
    public final String getPurchaseName() {
        return this.name;
    }

    @Override
    public boolean isAvailableForPurchase(QuestAssets qA, QuestController qCtrl) {
        return this.getPetLevel(qA) < this.getMaxLevel() && (qCtrl == null || qCtrl.getLevel() >= this.getPetLevel(qA) || FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.ITEM_LEVEL_RESTRICTION) == 0);
    }

    @Override
    public void onPurchase(QuestAssets qA) {
        qA.setPetLevel(this.saveFileKey, this.getPetLevel(qA) + 1);
    }

    public String getSaveFileKey() {
        return this.saveFileKey;
    }

    public int getSlot() {
        return this.slot;
    }
}

