/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.bazaar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import forge.gamemodes.quest.bazaar.QuestItemBasic;
import forge.gamemodes.quest.bazaar.QuestItemCharmOfVigor;
import forge.gamemodes.quest.bazaar.QuestItemCharmOfVim;
import forge.gamemodes.quest.bazaar.QuestItemElixir;
import forge.gamemodes.quest.bazaar.QuestItemEstates;
import forge.gamemodes.quest.bazaar.QuestItemMembership;
import forge.gamemodes.quest.bazaar.QuestItemPoundFlesh;
import forge.gamemodes.quest.bazaar.QuestItemZeppelin;
import forge.gamemodes.quest.data.QuestItemCondition;

@XStreamAlias(value="forge.gamemodes.quest.data.item.QuestItemType")
public enum QuestItemType {
    SLEIGHT("Sleight", QuestItemBasic.class, QuestItemCondition.class),
    ESTATES("Estates", QuestItemEstates.class, QuestItemCondition.class),
    LUCKY_COIN("Lucky Coin", QuestItemBasic.class, QuestItemCondition.class),
    MAP("Map", QuestItemBasic.class, QuestItemCondition.class),
    ZEPPELIN("Zeppelin", QuestItemZeppelin.class, QuestItemCondition.class),
    ELIXIR_OF_LIFE("Elixir of Life", QuestItemElixir.class, QuestItemCondition.class),
    POUND_FLESH("Pound of Flesh", QuestItemPoundFlesh.class, QuestItemCondition.class),
    CHARM("Charm of Vigor", QuestItemCharmOfVigor.class, QuestItemCondition.class),
    CHARM_VIM("Charm of Vim", QuestItemCharmOfVim.class, QuestItemCondition.class),
    CASH_STAKES("Cash Stakes", QuestItemBasic.class, QuestItemCondition.class),
    MEMBERSHIP_TOKEN("Bank Membership", QuestItemMembership.class, QuestItemCondition.class);

    private final String saveFileKey;
    private final Class<? extends QuestItemBasic> bazaarControllerClass;
    private final Class<? extends QuestItemCondition> modelClass;

    private QuestItemType(String key, Class<? extends QuestItemBasic> controllerClass0, Class<? extends QuestItemCondition> modelClass0) {
        this.saveFileKey = key;
        this.bazaarControllerClass = controllerClass0;
        this.modelClass = modelClass0;
    }

    public String getKey() {
        return this.saveFileKey;
    }

    public Class<? extends QuestItemBasic> getBazaarControllerClass() {
        return this.bazaarControllerClass;
    }

    public Class<? extends QuestItemCondition> getModelClass() {
        return this.modelClass;
    }

    public static QuestItemType smartValueOf(String value) {
        if (value == null) {
            return null;
        }
        if ("All".equals(value)) {
            return null;
        }
        String valToCompate = value.trim();
        for (QuestItemType v : QuestItemType.values()) {
            if (v.name().compareToIgnoreCase(valToCompate) != 0) continue;
            return v;
        }
        throw new IllegalArgumentException("No element named " + value + " in enum QuestItemType");
    }

    public static QuestItemType valueFromSaveKey(String name) {
        if (name == null) {
            return null;
        }
        String valToCompate = name.trim();
        for (QuestItemType v : QuestItemType.values()) {
            if (v.getKey().compareToIgnoreCase(valToCompate) != 0) continue;
            return v;
        }
        throw new IllegalArgumentException("No element keyed " + name + " in enum QuestItemType");
    }
}

