/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest.bazaar;

import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.bazaar.IQuestBazaarItem;
import forge.gamemodes.quest.bazaar.QuestItemBasic;
import forge.gamemodes.quest.bazaar.QuestItemType;
import forge.gamemodes.quest.bazaar.QuestPetController;
import forge.gamemodes.quest.bazaar.QuestStallDefinition;
import forge.gamemodes.quest.data.QuestAssets;
import forge.model.FModel;
import forge.util.IgnoringXStream;
import forge.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QuestBazaarManager {
    private final File xmlFile;
    private final Map<String, QuestStallDefinition> stalls = new TreeMap<String, QuestStallDefinition>();
    private final Map<String, SortedSet<IQuestBazaarItem>> itemsOnStalls = new TreeMap<String, SortedSet<IQuestBazaarItem>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, IQuestBazaarItem> items = new TreeMap<String, IQuestBazaarItem>();

    public QuestBazaarManager(File xmlFile0) {
        this.xmlFile = xmlFile0;
    }

    public void load() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(this.xmlFile);
            IgnoringXStream xs = new IgnoringXStream();
            xs.addPermission(NoTypePermission.NONE);
            xs.addPermission(NullPermission.NULL);
            xs.addPermission(PrimitiveTypePermission.PRIMITIVES);
            xs.allowTypeHierarchy(String.class);
            xs.allowTypesByWildcard(new String[]{QuestBazaarManager.class.getPackage().getName() + ".*"});
            xs.autodetectAnnotations(true);
            NodeList xmlStalls = document.getElementsByTagName("stalls").item(0).getChildNodes();
            for (int iN = 0; iN < xmlStalls.getLength(); ++iN) {
                Node n = xmlStalls.item(iN);
                if (n.getNodeType() != 1) continue;
                Attr att = document.createAttribute("resolves-to");
                att.setValue(QuestStallDefinition.class.getCanonicalName());
                n.getAttributes().setNamedItem(att);
                QuestStallDefinition stall = (QuestStallDefinition)xs.fromXML(XmlUtil.nodeToString(n));
                this.stalls.put(stall.getName(), stall);
            }
            NodeList xmlQuestItems = document.getElementsByTagName("questItems").item(0).getChildNodes();
            for (int iN = 0; iN < xmlQuestItems.getLength(); ++iN) {
                Node n = xmlQuestItems.item(iN);
                if (n.getNodeType() != 1) continue;
                NamedNodeMap attrs = n.getAttributes();
                String sType = attrs.getNamedItem("itemType").getTextContent();
                String name = attrs.getNamedItem("name").getTextContent();
                QuestItemType qType = QuestItemType.smartValueOf(sType);
                Attr att = document.createAttribute("resolves-to");
                att.setValue(qType.getBazaarControllerClass().getCanonicalName());
                attrs.setNamedItem(att);
                QuestItemBasic ctrl = (QuestItemBasic)xs.fromXML(XmlUtil.nodeToString(n));
                this.items.put(name, ctrl);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    public QuestStallDefinition getStall(String stallName) {
        if (this.stalls.isEmpty()) {
            this.load();
        }
        return this.stalls.get(stallName);
    }

    public void buildItems(QuestController qCtrl) {
        HashMap<String, IQuestBazaarItem> itemSet = new HashMap<String, IQuestBazaarItem>();
        for (int iSlot = 0; iSlot < 2; ++iSlot) {
            for (QuestPetController pet : qCtrl.getPetsStorage().getAllPets(iSlot)) {
                itemSet.put(pet.getName(), pet);
            }
        }
        itemSet.putAll(this.items);
        this.itemsOnStalls.clear();
        for (QuestStallDefinition thisStall : this.stalls.values()) {
            TreeSet<IQuestBazaarItem> set = new TreeSet<IQuestBazaarItem>();
            for (String itemName : thisStall.getItems()) {
                IQuestBazaarItem item = (IQuestBazaarItem)itemSet.get(itemName);
                set.add(item);
            }
            this.itemsOnStalls.put(thisStall.getName(), set);
        }
    }

    public List<IQuestBazaarItem> getItems(QuestController qCtrl, String stallName) {
        this.buildItems(qCtrl);
        ArrayList<IQuestBazaarItem> ret = new ArrayList<IQuestBazaarItem>();
        QuestAssets qA = FModel.getQuest().getAssets();
        for (IQuestBazaarItem purchasable : this.itemsOnStalls.get(stallName)) {
            if (!purchasable.isAvailableForPurchase(qA, qCtrl)) continue;
            ret.add(purchasable);
        }
        return ret;
    }

    public Set<String> getStallNames() {
        if (this.stalls.isEmpty()) {
            this.load();
        }
        return this.stalls.keySet();
    }
}

