/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import forge.card.CardEdition;
import forge.deck.Deck;
import forge.game.GameFormat;
import forge.gamemodes.quest.data.GameFormatQuest;
import forge.gamemodes.quest.setrotation.QueueRandomRotation;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.storage.StorageReaderFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QuestWorld
implements Comparable<QuestWorld> {
    private final String name;
    private final String dir;
    private final GameFormatQuest format;
    public static final String STANDARDWORLDNAME = "Random Standard";
    public static final String PIONEERWORLDNAME = "Random Pioneer";
    public static final String MODERNWORLDNAME = "Random Modern";
    public static final String RANDOMCOMMANDERWORLDNAME = "Random Commander";
    public static final String MAINWORLDNAME = "Main world";
    public static final String EVOLVINGWILDSWORLDNAME = "Evolving Wilds";
    private boolean isCustom;

    public QuestWorld(String useName, String useDir, GameFormatQuest useFormat) {
        this.name = useName;
        this.dir = useDir;
        this.format = useFormat;
        this.isCustom = false;
    }

    public QuestWorld(String useName, String useDir, GameFormatQuest useFormat, boolean isCustom0) {
        this.name = useName;
        this.dir = useDir;
        this.format = useFormat;
        this.isCustom = isCustom0;
    }

    public String getName() {
        return this.name;
    }

    public String getDuelsDir() {
        return this.dir == null ? null : this.dir + "/duels";
    }

    public String getChallengesDir() {
        return this.dir == null ? null : this.dir + "/challenges";
    }

    public GameFormatQuest getFormat() {
        return this.format;
    }

    public Collection<PaperCard> getAllCards() {
        GameFormatQuest format0 = this.format;
        if (format0 == null) {
            format0 = FModel.getQuest().getMainFormat();
        }
        if (format0 != null) {
            return format0.getAllCards();
        }
        return FModel.getMagicDb().getCommonCards().getAllCards();
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(QuestWorld other) {
        if (null == other) {
            return 1;
        }
        if (this.name == null) {
            return -1;
        }
        return this.name.compareTo(other.name);
    }

    public static Set<QuestWorld> getAllQuestWorldsOfCard(PaperCard card) {
        HashSet<QuestWorld> result = new HashSet<QuestWorld>();
        for (QuestWorld qw : FModel.getWorlds()) {
            GameFormatQuest format = qw.getFormat();
            if (format == null) {
                format = FModel.getQuest().getMainFormat();
            }
            if (format != null && !((GameFormat)format).getFilterRules().apply(card)) continue;
            result.add(qw);
        }
        return result;
    }

    public static Set<QuestWorld> getAllQuestWorldsOfDeck(Deck deck) {
        HashSet<QuestWorld> result = new HashSet<QuestWorld>();
        for (QuestWorld qw : FModel.getWorlds()) {
            GameFormatQuest format = qw.getFormat();
            if (format == null) {
                format = FModel.getQuest().getMainFormat();
            }
            if (format != null && !format.isDeckLegal(deck)) continue;
            result.add(qw);
        }
        return result;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public void setCustom(boolean custom) {
        this.isCustom = custom;
    }

    public static class Reader
    extends StorageReaderFile<QuestWorld> {
        public Reader(String file0) {
            super(file0, QuestWorld::getName);
        }

        @Override
        protected QuestWorld read(String line, int i) {
            String[] pieces;
            String useName = null;
            String useDir = null;
            GameFormatQuest useFormat = null;
            ArrayList<String> sets = new ArrayList<String>();
            ArrayList<String> bannedCards = new ArrayList<String>();
            block12: for (String piece : pieces = line.split("\\|")) {
                String value;
                String key;
                int idx = piece.indexOf(58);
                if (idx != -1) {
                    key = piece.substring(0, idx).trim().toLowerCase();
                    value = piece.substring(idx + 1).trim();
                } else {
                    this.alertInvalidLine(line, "Invalid plane definition.");
                    key = piece.trim().toLowerCase();
                    value = "";
                }
                switch (key) {
                    case "name": {
                        useName = value;
                        continue block12;
                    }
                    case "dir": {
                        useDir = value;
                        continue block12;
                    }
                    case "sets": {
                        sets.addAll(Arrays.asList(value.split(", ")));
                        continue block12;
                    }
                    case "banned": {
                        bannedCards.addAll(Arrays.asList(value.split("; ")));
                        continue block12;
                    }
                    default: {
                        this.alertInvalidLine(line, "Invalid quest world definition.");
                    }
                }
            }
            if (useName == null) {
                this.alertInvalidLine(line, "Quest world must have a name.");
                return null;
            }
            if (!sets.isEmpty() || !bannedCards.isEmpty()) {
                useFormat = new GameFormatQuest(useName, (List<String>)sets, (List<String>)bannedCards);
            }
            if (useName.equalsIgnoreCase(QuestWorld.STANDARDWORLDNAME)) {
                useFormat = new GameFormatQuest(QuestWorld.STANDARDWORLDNAME, FModel.getFormats().getStandard().getAllowedSetCodes(), FModel.getFormats().getStandard().getBannedCardNames(), false);
            }
            if (useName.equalsIgnoreCase(QuestWorld.PIONEERWORLDNAME)) {
                useFormat = new GameFormatQuest(QuestWorld.PIONEERWORLDNAME, FModel.getFormats().getPioneer().getAllowedSetCodes(), FModel.getFormats().getPioneer().getBannedCardNames(), false);
            }
            if (useName.equalsIgnoreCase(QuestWorld.MODERNWORLDNAME)) {
                useFormat = new GameFormatQuest(QuestWorld.MODERNWORLDNAME, FModel.getFormats().getModern().getAllowedSetCodes(), FModel.getFormats().getModern().getBannedCardNames(), false);
            }
            if (useName.equalsIgnoreCase(QuestWorld.RANDOMCOMMANDERWORLDNAME)) {
                useFormat = new GameFormatQuest(QuestWorld.RANDOMCOMMANDERWORLDNAME, FModel.getFormats().getFormat("Commander").getAllowedSetCodes(), FModel.getFormats().getFormat("Commander").getBannedCardNames(), false);
            }
            if (useName.equalsIgnoreCase(QuestWorld.EVOLVINGWILDSWORLDNAME)) {
                QueueRandomRotation rot = new QueueRandomRotation(6, 5, 1);
                ArrayList<String> allowedCodes = new ArrayList<String>();
                for (CardEdition edition : FModel.getMagicDb().getEditionsTypeMap().get((Object)CardEdition.Type.CORE)) {
                    allowedCodes.add(edition.getCode());
                }
                for (CardEdition edition : FModel.getMagicDb().getEditionsTypeMap().get((Object)CardEdition.Type.EXPANSION)) {
                    allowedCodes.add(edition.getCode());
                }
                useFormat = new GameFormatQuest(QuestWorld.EVOLVINGWILDSWORLDNAME, allowedCodes, FModel.getFormats().getVintage().getBannedCardNames(), false, rot);
            }
            return new QuestWorld(useName, useDir, useFormat);
        }
    }
}

