/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.card.CardEdition;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.quest.io.ReadPriceList;
import forge.gui.GuiBase;
import forge.gui.util.SGuiChoose;
import forge.gui.util.SOptionPane;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.item.generation.UnOpenedProduct;
import forge.model.FModel;
import forge.util.TextUtil;
import forge.util.storage.IStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class QuestUtilUnlockSets {
    private static int UNLOCK_COST = 4000;
    private static final List<CardEdition> emptyEditions = ImmutableList.of();
    private static final EnumSet<CardEdition.Type> unlockableSetTypes = EnumSet.of(CardEdition.Type.CORE, CardEdition.Type.EXPANSION, CardEdition.Type.REPRINT, CardEdition.Type.STARTER);

    public static ImmutablePair<CardEdition, Integer> chooseSetToUnlock(QuestController qData, boolean freeUnlock, List<CardEdition> presetChoices) {
        if (qData.getFormat() == null || !qData.getFormat().canUnlockSets()) {
            return null;
        }
        ReadPriceList prices = new ReadPriceList();
        Map<String, Integer> mapPrices = prices.getPriceList();
        ArrayList<ImmutablePair<CardEdition, Integer>> setPrices = new ArrayList<ImmutablePair<CardEdition, Integer>>();
        double multiplier = 1.0;
        int j = 0;
        for (CardEdition ed : QuestUtilUnlockSets.getUnlockableEditions(qData)) {
            if (++j > 5 && (multiplier *= Double.parseDouble(FModel.getQuestPreferences().getPref(QuestPreferences.QPref.UNLOCK_DISTANCE_MULTIPLIER))) >= 500.0) {
                multiplier = 500.0;
            }
            int price = UNLOCK_COST;
            if (mapPrices.containsKey(TextUtil.concatNoSpace(ed.getName(), " Booster Pack"))) {
                price = Math.max(Double.valueOf(30.0 * Math.pow(Math.sqrt(mapPrices.get(TextUtil.concatNoSpace(ed.getName(), " Booster Pack")).intValue()), 1.7)).intValue(), UNLOCK_COST);
            }
            price = (int)((double)price * multiplier);
            setPrices.add(ImmutablePair.of(ed, price));
        }
        String setPrompt = "You have " + qData.getAssets().getCredits() + " credits. Unlock:";
        ArrayList<String> options = new ArrayList<String>();
        for (ImmutablePair immutablePair : setPrices) {
            options.add(TextUtil.concatNoSpace(((CardEdition)immutablePair.left).getName(), " [PRICE: ", String.valueOf(immutablePair.right), " credits]"));
        }
        int index = options.indexOf(SGuiChoose.oneOrNone(setPrompt, options));
        if (index < 0 || index >= options.size()) {
            return null;
        }
        ImmutablePair immutablePair = (ImmutablePair)setPrices.get(index);
        int price = (Integer)immutablePair.right;
        CardEdition choosenEdition = (CardEdition)immutablePair.left;
        if (qData.getAssets().getCredits() < (long)price) {
            SOptionPane.showMessageDialog("Unfortunately, you cannot afford that set yet.\nTo unlock " + choosenEdition.getName() + ", you need " + price + " credits.\nYou have only " + qData.getAssets().getCredits() + " credits.", "Failed to unlock " + choosenEdition.getName(), null);
            return null;
        }
        if (!SOptionPane.showConfirmDialog("Unlocking " + choosenEdition.getName() + " will cost you " + price + " credits.\nYou have " + qData.getAssets().getCredits() + " credits.\n\nAre you sure you want to unlock " + choosenEdition.getName() + "?", "Confirm Unlocking " + choosenEdition.getName())) {
            return null;
        }
        return immutablePair;
    }

    private static List<CardEdition> getUnlockableEditions(QuestController qData) {
        if (qData.getFormat() == null || !qData.getFormat().canUnlockSets()) {
            return emptyEditions;
        }
        if (qData.getUnlocksTokens() < 1) {
            throw new RuntimeException("BUG? Could not find unlockable sets even though we should.");
        }
        ArrayList<CardEdition> options = new ArrayList<CardEdition>();
        ArrayList<CardEdition> allowedSets = Lists.newArrayList(Iterables.transform(qData.getFormat().getAllowedSetCodes(), FModel.getMagicDb().getEditions()::get));
        Collections.sort(allowedSets);
        ArrayList<CardEdition> excludedSets = Lists.newArrayList(Iterables.transform(qData.getFormat().getLockedSets(), FModel.getMagicDb().getEditions()::get));
        Collections.sort(excludedSets);
        ArrayList<ImmutablePair<CardEdition, Long>> excludedWithDistances = new ArrayList<ImmutablePair<CardEdition, Long>>();
        for (CardEdition cardEdition : excludedSets) {
            if (!unlockableSetTypes.contains((Object)cardEdition.getType())) continue;
            long distance = Long.MAX_VALUE;
            for (CardEdition in : allowedSets) {
                long d = Math.abs(cardEdition.getDate().getTime() - in.getDate().getTime());
                if (d >= distance) continue;
                distance = d;
            }
            excludedWithDistances.add(ImmutablePair.of(cardEdition, distance));
        }
        excludedWithDistances.sort((o1, o2) -> {
            long delta = (Long)o2.right - (Long)o1.right;
            return delta < 0L ? -1 : (delta == 0L ? 0 : 1);
        });
        for (ImmutablePair immutablePair : excludedWithDistances) {
            options.add((CardEdition)immutablePair.left);
        }
        Collections.reverse(options);
        if (FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.UNLIMITED_UNLOCKING) == 0) {
            return options.subList(0, Math.min(options.size(), Math.min(8, 2 + qData.getAchievements().getWin() / 50)));
        }
        return options.subList(0, options.size());
    }

    public static void doUnlock(QuestController qData, CardEdition unlockedSet) {
        IStorage<SealedTemplate> starters = FModel.getMagicDb().getTournamentPacks();
        IStorage<SealedTemplate> boosters = FModel.getMagicDb().getBoosters();
        qData.getFormat().unlockSet(unlockedSet.getCode());
        String additionalSet = unlockedSet.getAdditionalUnlockSet();
        if (!additionalSet.isEmpty()) {
            qData.getFormat().unlockSet(additionalSet);
        }
        ArrayList<PaperCard> cardsWon = new ArrayList<PaperCard>();
        if (starters.contains(unlockedSet.getCode())) {
            UnOpenedProduct starter = new UnOpenedProduct(starters.get(unlockedSet.getCode()));
            cardsWon.addAll((Collection<PaperCard>)starter.get());
        } else if (boosters.contains(unlockedSet.getCode())) {
            UnOpenedProduct booster = new UnOpenedProduct(boosters.get(unlockedSet.getCode()));
            cardsWon.addAll((Collection<PaperCard>)booster.get());
            cardsWon.addAll((Collection<PaperCard>)booster.get());
            cardsWon.addAll((Collection<PaperCard>)booster.get());
        }
        if (!cardsWon.isEmpty()) {
            qData.getCards().addAllCards(cardsWon);
            GuiBase.getInterface().showCardList(unlockedSet.getName(), "You get the following bonus cards:", cardsWon);
        }
        qData.save();
    }
}

