/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.card.CardDb;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.MagicColor;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.GameFormat;
import forge.gamemodes.quest.BoosterUtils;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestMode;
import forge.gamemodes.quest.StartingPoolPreferences;
import forge.gamemodes.quest.bazaar.QuestItemType;
import forge.gamemodes.quest.data.GameFormatQuest;
import forge.gamemodes.quest.data.QuestAssets;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.item.BoosterBox;
import forge.item.BoosterPack;
import forge.item.FatPack;
import forge.item.IPaperCard;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.item.PreconDeck;
import forge.item.SealedProduct;
import forge.item.SealedTemplate;
import forge.item.TournamentPack;
import forge.item.generation.UnOpenedProduct;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.Aggregates;
import forge.util.ItemPool;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public final class QuestUtilCards {
    private static final Predicate<PaperCard> COMMON_PREDICATE = IPaperCard.Predicates.Presets.IS_COMMON;
    private static final Predicate<PaperCard> UNCOMMON_PREDICATE = IPaperCard.Predicates.Presets.IS_UNCOMMON;
    private static final Predicate<PaperCard> RARE_PREDICATE = IPaperCard.Predicates.Presets.IS_RARE_OR_MYTHIC;
    private static final Predicate<PaperCard> ONLY_RARE_PREDICATE = IPaperCard.Predicates.Presets.IS_RARE;
    private static final Predicate<PaperCard> MYTHIC_PREDICATE = IPaperCard.Predicates.Presets.IS_MYTHIC_RARE;
    private final QuestController questController;
    private final QuestPreferences questPreferences;
    private final QuestAssets questAssets;
    private final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnNewCompare = from -> this.isNew((InventoryItem)from.getKey()) ? Integer.valueOf(1) : Integer.valueOf(0);
    private final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnNewGet = from -> this.isNew((InventoryItem)from.getKey()) ? "NEW" : "";
    private final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnOwnedCompare = new Function<Map.Entry<InventoryItem, Integer>, Comparable<?>>(){

        @Override
        public Comparable<?> apply(Map.Entry<InventoryItem, Integer> from) {
            InventoryItem i = from.getKey();
            if (i instanceof PaperCard) {
                return QuestUtilCards.this.questAssets.getCardPool().count((PaperCard)i);
            }
            if (i instanceof PreconDeck) {
                PreconDeck pDeck = (PreconDeck)i;
                return FModel.getQuest().getMyDecks().contains(pDeck.getName()) ? -1 : -2;
            }
            if (i instanceof SealedProduct) {
                SealedProduct oPack = (SealedProduct)i;
                return QuestUtilCards.this.getCompletionPercent(oPack.getEdition()) - 103;
            }
            return null;
        }
    };
    private final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnOwnedGet = new Function<Map.Entry<? extends InventoryItem, Integer>, Object>(){

        @Override
        public Object apply(Map.Entry<? extends InventoryItem, Integer> from) {
            InventoryItem i = from.getKey();
            if (i instanceof PaperCard) {
                return QuestUtilCards.this.questAssets.getCardPool().count((PaperCard)i);
            }
            if (i instanceof PreconDeck) {
                PreconDeck pDeck = (PreconDeck)i;
                return FModel.getQuest().getMyDecks().contains(pDeck.getName()) ? "YES" : "NO";
            }
            if (i instanceof SealedProduct) {
                SealedProduct oPack = (SealedProduct)i;
                return String.format("%d%%", QuestUtilCards.this.getCompletionPercent(oPack.getEdition()));
            }
            return null;
        }
    };

    public QuestUtilCards(QuestController questController) {
        this.questController = questController;
        this.questAssets = questController.getAssets();
        this.questPreferences = FModel.getQuestPreferences();
    }

    public static ItemPool<PaperCard> generateBasicLands(int nBasic, int nSnow, GameFormatQuest usedFormat) {
        CardDb db = FModel.getMagicDb().getCommonCards();
        ItemPool<PaperCard> pool = new ItemPool<PaperCard>(PaperCard.class);
        ArrayList<String> landCodes = new ArrayList<String>();
        ArrayList<String> snowLandCodes = new ArrayList<String>();
        ArrayList<String> wastesCodes = new ArrayList<String>();
        if (usedFormat != null) {
            List<String> availableEditions = usedFormat.getAllowedSetCodes();
            for (String edCode : availableEditions) {
                CardEdition ed = FModel.getMagicDb().getEditions().get(edCode);
                if (!CardEdition.Predicates.hasBasicLands.apply(ed)) continue;
                landCodes.add(edCode);
            }
            if (usedFormat.isSetLegal("ICE")) {
                snowLandCodes.add("ICE");
            }
            if (usedFormat.isSetLegal("CSP")) {
                snowLandCodes.add("CSP");
            }
            if (usedFormat.isSetLegal("KHM")) {
                snowLandCodes.add("KHM");
            }
            if (usedFormat.isSetLegal("OGW")) {
                wastesCodes.add("OGW");
            }
        } else {
            CardEdition.Collection allEditions = FModel.getMagicDb().getEditions();
            for (CardEdition edition : Iterables.filter(allEditions, CardEdition.Predicates.hasBasicLands)) {
                landCodes.add(edition.getCode());
            }
            snowLandCodes.add("ICE");
            snowLandCodes.add("CSP");
            snowLandCodes.add("KHM");
            wastesCodes.add("OGW");
        }
        String landCode = (String)Aggregates.random(landCodes);
        if (null == landCode) {
            landCode = "M10";
        }
        boolean isZendikarSet = landCode.equals("ZEN");
        boolean zendikarSetMode = MyRandom.getRandom().nextBoolean();
        for (String landName : MagicColor.Constant.BASIC_LANDS) {
            int artCount = db.getArtCount(landName, landCode);
            if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_RANDOM_ART_IN_POOLS)) {
                int[] artGroups = MyRandom.splitIntoRandomGroups(nBasic, isZendikarSet ? 4 : artCount);
                for (int i = 1; i <= artGroups.length; ++i) {
                    pool.add(db.getCard(landName, landCode, isZendikarSet ? (zendikarSetMode ? i : i + 4) : i), artGroups[i - 1]);
                }
                continue;
            }
            pool.add(db.getCard(landName, landCode, artCount > 1 ? MyRandom.getRandom().nextInt(artCount) + 1 : 1), nBasic);
        }
        if (!snowLandCodes.isEmpty()) {
            String snowLandCode = (String)Aggregates.random(snowLandCodes);
            for (String landName : MagicColor.Constant.SNOW_LANDS) {
                pool.add(db.getCard(landName, snowLandCode), nSnow);
            }
        }
        if (!wastesCodes.isEmpty()) {
            String wasteCode = (String)Aggregates.random(wastesCodes);
            pool.add(db.getCard("Wastes", wasteCode), 5);
        }
        return pool;
    }

    public List<PaperCard> generateQuestBooster(Predicate<PaperCard> fSets) {
        return new UnOpenedProduct(this.getBoosterTemplate(), fSets).get();
    }

    public void addAllCards(Iterable<PaperCard> newCards) {
        for (PaperCard card : newCards) {
            this.addSingleCard(card, 1);
        }
    }

    public void addSingleCard(PaperCard card, int qty) {
        this.questAssets.getCardPool().add(card, qty);
        this.questAssets.getNewCardList().add(card, qty);
    }

    public Predicate<PaperCard> applyFormatFilter(Predicate<PaperCard> source) {
        return this.questController.getFormat() == null ? source : Predicates.and(source, this.questController.getFormat().getFilterPrinted());
    }

    public PaperCard addRandomRare() {
        boolean usePromos = this.questPreferences.getPrefInt(QuestPreferences.QPref.EXCLUDE_PROMOS_FROM_POOL) == 0;
        Collection<PaperCard> pool = usePromos ? FModel.getMagicDb().getCommonCards().getAllCards() : FModel.getMagicDb().getCommonCards().getAllNonPromoCards();
        Predicate<PaperCard> myFilter = this.applyFormatFilter(RARE_PREDICATE);
        PaperCard card = Aggregates.random(Iterables.filter(pool, myFilter));
        this.addSingleCard(card, 1);
        return card;
    }

    public List<PaperCard> addRandomCommon(int n) {
        boolean usePromos = this.questPreferences.getPrefInt(QuestPreferences.QPref.EXCLUDE_PROMOS_FROM_POOL) == 0;
        Collection<PaperCard> pool = usePromos ? FModel.getMagicDb().getCommonCards().getAllCards() : FModel.getMagicDb().getCommonCards().getAllNonPromoCards();
        Predicate<PaperCard> myFilter = this.applyFormatFilter(COMMON_PREDICATE);
        List<PaperCard> newCards = Aggregates.random(Iterables.filter(pool, myFilter), n);
        this.addAllCards(newCards);
        return newCards;
    }

    public List<PaperCard> addRandomUncommon(int n) {
        boolean usePromos = this.questPreferences.getPrefInt(QuestPreferences.QPref.EXCLUDE_PROMOS_FROM_POOL) == 0;
        Collection<PaperCard> pool = usePromos ? FModel.getMagicDb().getCommonCards().getAllCards() : FModel.getMagicDb().getCommonCards().getAllNonPromoCards();
        Predicate<PaperCard> myFilter = this.applyFormatFilter(UNCOMMON_PREDICATE);
        List<PaperCard> newCards = Aggregates.random(Iterables.filter(pool, myFilter), n);
        this.addAllCards(newCards);
        return newCards;
    }

    public List<PaperCard> addRandomRare(int n) {
        boolean usePromos = this.questPreferences.getPrefInt(QuestPreferences.QPref.EXCLUDE_PROMOS_FROM_POOL) == 0;
        Collection<PaperCard> pool = usePromos ? FModel.getMagicDb().getCommonCards().getAllCards() : FModel.getMagicDb().getCommonCards().getAllNonPromoCards();
        Predicate<PaperCard> myFilter = this.applyFormatFilter(RARE_PREDICATE);
        List<PaperCard> newCards = Aggregates.random(Iterables.filter(pool, myFilter), n);
        this.addAllCards(newCards);
        return newCards;
    }

    public List<PaperCard> addRandomRareNotMythic(int n) {
        boolean usePromos = this.questPreferences.getPrefInt(QuestPreferences.QPref.EXCLUDE_PROMOS_FROM_POOL) == 0;
        Collection<PaperCard> pool = usePromos ? FModel.getMagicDb().getCommonCards().getAllCards() : FModel.getMagicDb().getCommonCards().getAllNonPromoCards();
        Predicate<PaperCard> myFilter = this.applyFormatFilter(ONLY_RARE_PREDICATE);
        List<PaperCard> newCards = Aggregates.random(Iterables.filter(pool, myFilter), n);
        this.addAllCards(newCards);
        return newCards;
    }

    public List<PaperCard> addRandomMythicRare(int n) {
        Predicate<PaperCard> myFilter;
        boolean usePromos = this.questPreferences.getPrefInt(QuestPreferences.QPref.EXCLUDE_PROMOS_FROM_POOL) == 0;
        Collection<PaperCard> pool = usePromos ? FModel.getMagicDb().getCommonCards().getAllCards() : FModel.getMagicDb().getCommonCards().getAllNonPromoCards();
        Iterable<PaperCard> cardPool = Iterables.filter(pool, myFilter = this.applyFormatFilter(MYTHIC_PREDICATE));
        if (!cardPool.iterator().hasNext()) {
            return null;
        }
        List<PaperCard> newCards = Aggregates.random(cardPool, n);
        this.addAllCards(newCards);
        return newCards;
    }

    public void setupNewGameCardPool(GameFormat formatStartingPool, int idxDifficulty, StartingPoolPreferences userPrefs) {
        double variantModifier = 1.0;
        switch (FModel.getQuest().getDeckConstructionRules()) {
            case Default: {
                break;
            }
            case Commander: {
                variantModifier = 2.0;
            }
        }
        int nC = (int)((double)this.questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.STARTING_COMMONS, idxDifficulty) * variantModifier);
        int nU = (int)((double)this.questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.STARTING_UNCOMMONS, idxDifficulty) * variantModifier);
        int nR = (int)((double)this.questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.STARTING_RARES, idxDifficulty) * variantModifier);
        this.addAllCards(BoosterUtils.getQuestStarterDeck(formatStartingPool, nC, nU, nR, userPrefs));
    }

    public void buyCard(PaperCard card, int qty, int value) {
        int totalCost = qty * value;
        if (this.questAssets.getCredits() >= (long)totalCost) {
            this.questAssets.setCredits(this.questAssets.getCredits() - (long)totalCost);
            this.addSingleCard(card, qty);
        }
    }

    public void buyPack(SealedProduct booster, int value) {
        if (this.questAssets.getCredits() >= (long)value) {
            this.questAssets.setCredits(this.questAssets.getCredits() - (long)value);
            this.addAllCards(booster.getCards());
        }
    }

    public void buyPreconDeck(PreconDeck precon, int value) {
        if (this.questAssets.getCredits() >= (long)value) {
            this.questAssets.subtractCredits(value);
            this.addDeck(precon.getDeck());
        }
    }

    void addDeck(Deck fromDeck) {
        if (fromDeck == null) {
            return;
        }
        this.questController.getMyDecks().add(fromDeck);
        this.addAllCards(fromDeck.getAllCardsInASinglePool().toFlatList());
    }

    public void loseCards(List<PaperCard> cards) {
        for (PaperCard card : cards) {
            this.removeCard(card, 1);
            if (this.questAssets.getItemLevel(QuestItemType.CASH_STAKES) <= 0) continue;
            this.addCardToShop(card);
        }
    }

    public void addCardToShop(PaperCard card) {
        this.questAssets.getShopList().add(card);
    }

    public void removeCard(PaperCard card, int qty) {
        this.questAssets.getCardPool().remove(card, qty);
        int leftInPool = this.questAssets.getCardPool().count(card);
        if (!card.isFoil() && card.isVeryBasicLand()) {
            return;
        }
        for (Deck deck : this.questController.getMyDecks()) {
            int cntInSb;
            int cntInMain = deck.getMain().count(card);
            int nToRemoveFromThisDeck = cntInMain + (cntInSb = deck.has(DeckSection.Sideboard) ? deck.get(DeckSection.Sideboard).count(card) : 0) - leftInPool;
            if (nToRemoveFromThisDeck <= 0) continue;
            int nToRemoveFromSb = Math.min(cntInSb, nToRemoveFromThisDeck);
            if (nToRemoveFromSb > 0) {
                deck.get(DeckSection.Sideboard).remove(card, nToRemoveFromSb);
                if ((nToRemoveFromThisDeck -= nToRemoveFromSb) <= 0) continue;
            }
            deck.getMain().remove(card, nToRemoveFromThisDeck);
        }
    }

    public void clearShopList() {
        if (this.questAssets.getShopList() != null) {
            this.questAssets.getShopList().clear();
        }
    }

    public double getSellMultiplier() {
        double baseMultiplier = Double.parseDouble(this.questPreferences.getPref(QuestPreferences.QPref.SHOP_SELLING_PERCENTAGE_BASE)) / 100.0;
        double maxMultiplier = Double.parseDouble(this.questPreferences.getPref(QuestPreferences.QPref.SHOP_SELLING_PERCENTAGE_MAX)) / 100.0;
        double multi = baseMultiplier + 0.001 * (double)this.questController.getAchievements().getWin();
        if (maxMultiplier > 0.0 && multi > maxMultiplier) {
            multi = maxMultiplier;
        }
        int lvlEstates = this.questController.getMode() == QuestMode.Fantasy ? this.questAssets.getItemLevel(QuestItemType.ESTATES) : 0;
        switch (lvlEstates) {
            case 1: {
                multi += 0.01;
                break;
            }
            case 2: {
                multi += 0.0175;
                break;
            }
            case 3: {
                multi += 0.025;
                break;
            }
        }
        return multi;
    }

    public int getSellPriceLimit() {
        int winsNoLimit = this.questPreferences.getPrefInt(QuestPreferences.QPref.SHOP_WINS_FOR_NO_SELL_LIMIT);
        int maxPrice = this.questPreferences.getPrefInt(QuestPreferences.QPref.SHOP_MAX_SELLING_PRICE);
        return this.questController.getAchievements().getWin() < winsNoLimit ? maxPrice : Integer.MAX_VALUE;
    }

    public static Predicate<CardEdition> isLegalInQuestFormat(GameFormatQuest qFormat) {
        return GameFormatQuest.QPredicates.isLegalInFormatQuest(qFormat);
    }

    private List<InventoryItem> generateRandomSpecialBoosterPacks(int quantity) {
        ArrayList<InventoryItem> output = new ArrayList<InventoryItem>();
        for (int i = 0; i < quantity; ++i) {
            String color = SealedProduct.specialSets.get(MyRandom.getRandom().nextInt(SealedProduct.specialSets.size()));
            output.add(new BoosterPack(color, QuestUtilCards.getColoredBoosterTemplate(color)));
        }
        return output;
    }

    private void generateBoostersInShop(int quantity) {
        this.questAssets.getShopList().addAllFlat(BoosterUtils.generateRandomBoosterPacks(quantity, this.questController));
        if (this.questPreferences.getPrefInt(QuestPreferences.QPref.SPECIAL_BOOSTERS) == 1) {
            this.questAssets.getShopList().addAllFlat(this.generateRandomSpecialBoosterPacks(quantity));
        }
    }

    private void generateSinglesInShop(int quantity) {
        SealedTemplate boosterTemplate = this.getShopBoosterTemplate();
        if (this.questController.getFormat() == null) {
            for (int i = 0; i < quantity; ++i) {
                this.questAssets.getShopList().addAllOfTypeFlat(new UnOpenedProduct(boosterTemplate).get());
            }
            return;
        }
        for (int i = 0; i < quantity; ++i) {
            this.questAssets.getShopList().addAllOfTypeFlat(new UnOpenedProduct(boosterTemplate, this.questController.getFormat().getFilterPrinted()).get());
        }
    }

    private static int getRandomCardFromBooster(List<PaperCard> cards, Predicate<PaperCard> predicate, List<PaperCard> toAddTo, int amount) {
        if (amount <= 0) {
            return 0;
        }
        ArrayList<PaperCard> temp = new ArrayList<PaperCard>();
        for (PaperCard card : cards) {
            if (!predicate.apply(card)) continue;
            temp.add(card);
        }
        if (!temp.isEmpty()) {
            toAddTo.add((PaperCard)temp.get((int)(MyRandom.getRandom().nextDouble() * (double)temp.size())));
            return amount - 1;
        }
        return amount;
    }

    private void generateTournamentsInShop(int count) {
        Predicate<CardEdition> formatFilter = CardEdition.Predicates.HAS_TOURNAMENT_PACK;
        if (this.questController.getFormat() != null) {
            formatFilter = Predicates.and(formatFilter, QuestUtilCards.isLegalInQuestFormat(this.questController.getFormat()));
        }
        Iterable<CardEdition> rightEditions = Iterables.filter(FModel.getMagicDb().getEditions(), formatFilter);
        this.questAssets.getShopList().addAllOfTypeFlat(Aggregates.random(Iterables.transform(rightEditions, TournamentPack::fromSet), count));
    }

    private void generateFatPacksInShop(int count) {
        Predicate<CardEdition> formatFilter = CardEdition.Predicates.HAS_FAT_PACK;
        if (this.questController.getFormat() != null) {
            formatFilter = Predicates.and(formatFilter, QuestUtilCards.isLegalInQuestFormat(this.questController.getFormat()));
        }
        Iterable<CardEdition> rightEditions = Iterables.filter(FModel.getMagicDb().getEditions(), formatFilter);
        this.questAssets.getShopList().addAllOfTypeFlat(Aggregates.random(Iterables.transform(rightEditions, FatPack::fromSet), count));
    }

    private void generateBoosterBoxesInShop(int count) {
        if (count == 0) {
            return;
        }
        Predicate<CardEdition> formatFilter = CardEdition.Predicates.HAS_BOOSTER_BOX;
        if (this.questController.getFormat() != null) {
            formatFilter = Predicates.and(formatFilter, QuestUtilCards.isLegalInQuestFormat(this.questController.getFormat()));
        }
        Iterable<CardEdition> rightEditions = Iterables.filter(FModel.getMagicDb().getEditions(), formatFilter);
        List editions = new ArrayList<CardEdition>();
        for (CardEdition e : rightEditions) {
            editions.add(e);
        }
        Collections.shuffle(editions);
        int numberOfBoxes = Math.min(Math.max(count / 2, 1), editions.size());
        if (numberOfBoxes == 0) {
            return;
        }
        editions = editions.subList(0, numberOfBoxes);
        ArrayList<BoosterBox> output = new ArrayList<BoosterBox>();
        for (CardEdition e : editions) {
            output.add(BoosterBox.fromSet(e));
        }
        this.questAssets.getShopList().addAllOfTypeFlat(output);
    }

    private void generatePreconsInShop(int count) {
        ArrayList<PreconDeck> meetRequirements = new ArrayList<PreconDeck>();
        for (PreconDeck deck : QuestController.getPrecons()) {
            if (!QuestController.getPreconDeals(deck).meetsRequiremnts(this.questController.getAchievements()) || null != this.questController.getFormat() && !this.questController.getFormat().isSetLegal(deck.getEdition())) continue;
            meetRequirements.add(deck);
        }
        this.questAssets.getShopList().addAllOfTypeFlat(Aggregates.random(meetRequirements, count));
    }

    private SealedTemplate getShopBoosterTemplate() {
        return new SealedTemplate(Lists.newArrayList(Pair.of("Common", this.questPreferences.getPrefInt(QuestPreferences.QPref.SHOP_SINGLES_COMMON)), Pair.of("Uncommon", this.questPreferences.getPrefInt(QuestPreferences.QPref.SHOP_SINGLES_UNCOMMON)), Pair.of("RareMythic", this.questPreferences.getPrefInt(QuestPreferences.QPref.SHOP_SINGLES_RARE))));
    }

    private SealedTemplate getBoosterTemplate() {
        return new SealedTemplate(ImmutableList.of(Pair.of("Common", this.questPreferences.getPrefInt(QuestPreferences.QPref.BOOSTER_COMMONS)), Pair.of("Uncommon", this.questPreferences.getPrefInt(QuestPreferences.QPref.BOOSTER_UNCOMMONS)), Pair.of("RareMythic", this.questPreferences.getPrefInt(QuestPreferences.QPref.BOOSTER_RARES))));
    }

    public static SealedTemplate getColoredBoosterTemplate(String color) {
        if (FModel.getQuest().getFormat() == null) {
            return new SealedTemplate("?", ImmutableList.of(Pair.of("Common:color(\"" + color + "\"):!" + "Land", 11), Pair.of("Uncommon:color(\"" + color + "\"):!" + "Land", 3), Pair.of("RareMythic:color(\"" + color + "\"):!" + "Land", 1), Pair.of("Land:color(\"" + color + "\")", 1)));
        }
        StringBuilder restrictions = new StringBuilder();
        List<String> allowedSetCodes = FModel.getQuest().getFormat().getAllowedSetCodes();
        if (allowedSetCodes.isEmpty()) {
            for (String restrictedCard : FModel.getQuest().getFormat().getRestrictedCards()) {
                restrictions.append(":!name(\"").append(restrictedCard).append("\")");
            }
        } else {
            restrictions.append(":fromSets(\"");
            for (String set : allowedSetCodes) {
                restrictions.append(set).append(",");
            }
            restrictions.append(")");
        }
        return new SealedTemplate("?", ImmutableList.of(Pair.of("Common:color(\"" + color + "\"):!" + "Land" + restrictions, 11), Pair.of("Uncommon:color(\"" + color + "\"):!" + "Land" + restrictions, 3), Pair.of("RareMythic:color(\"" + color + "\"):!" + "Land" + restrictions, 1), Pair.of("Land:color(\"" + color + "\")" + restrictions, 1)));
    }

    private void generateCardsInShop() {
        int startPacks = this.questPreferences.getPrefInt(QuestPreferences.QPref.SHOP_STARTING_PACKS);
        int winsForPack = this.questPreferences.getPrefInt(QuestPreferences.QPref.SHOP_WINS_FOR_ADDITIONAL_PACK);
        int maxPacks = this.questPreferences.getPrefInt(QuestPreferences.QPref.SHOP_MAX_PACKS);
        int minPacks = this.questPreferences.getPrefInt(QuestPreferences.QPref.SHOP_MIN_PACKS);
        int level = this.questController.getAchievements().getLevel();
        int levelPacks = level > 0 ? startPacks / level : startPacks;
        int winPacks = this.questController.getAchievements().getWin() / winsForPack;
        int totalPacks = Math.min(Math.max(levelPacks + winPacks, minPacks), maxPacks);
        this.generateSinglesInShop(totalPacks);
        this.generateBoostersInShop(totalPacks);
        this.generatePreconsInShop(totalPacks);
        this.generateTournamentsInShop(totalPacks);
        this.generateFatPacksInShop(totalPacks);
        this.generateBoosterBoxesInShop(totalPacks);
        if (this.questController.getFormat() == null || this.questController.getFormat().hasSnowLands()) {
            this.questAssets.getShopList().addAllOfType(QuestUtilCards.generateBasicLands(0, 5, this.questController.getFormat()));
        }
    }

    public ItemPool<PaperCard> getCardpool() {
        return this.questAssets.getCardPool();
    }

    public ItemPool<InventoryItem> getShopList() {
        if (this.questAssets.getShopList().isEmpty()) {
            this.generateCardsInShop();
        }
        return this.questAssets.getShopList();
    }

    public ItemPool<InventoryItem> getNewCards() {
        return this.questAssets.getNewCardList();
    }

    public void resetNewList() {
        this.questAssets.getNewCardList().clear();
    }

    public Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> getFnNewCompare() {
        return this.fnNewCompare;
    }

    public Function<Map.Entry<? extends InventoryItem, Integer>, Object> getFnNewGet() {
        return this.fnNewGet;
    }

    public boolean isNew(InventoryItem item) {
        return this.questAssets.getNewCardList().contains(item);
    }

    public Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> getFnOwnedCompare() {
        return this.fnOwnedCompare;
    }

    public Function<Map.Entry<? extends InventoryItem, Integer>, Object> getFnOwnedGet() {
        return this.fnOwnedGet;
    }

    public int getCompletionPercent(String edition) {
        for (String color : SealedProduct.specialSets) {
            if (!color.equals(edition)) continue;
            return 0;
        }
        if (edition.equals("?")) {
            return 0;
        }
        Predicate<PaperCard> filter = IPaperCard.Predicates.printedInSet(edition);
        Iterable<PaperCard> editionCards = Iterables.filter(FModel.getMagicDb().getCommonCards().getAllCards(), filter);
        ItemPool<PaperCard> ownedCards = this.questAssets.getCardPool();
        int completeCards = 0;
        int numOwnedCards = 0;
        for (PaperCard card : editionCards) {
            int target = CardRarity.BasicLand == card.getRarity() ? 1 : 4;
            completeCards += target;
            numOwnedCards += Math.min(target, ownedCards.count(card));
        }
        return numOwnedCards * 100 / completeCards;
    }
}

