/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.collect.ImmutableMap;
import forge.LobbyPlayer;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.deck.Deck;
import forge.game.GameRules;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.match.HostedMatch;
import forge.gamemodes.quest.IVQuestStats;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEvent;
import forge.gamemodes.quest.QuestEventChallenge;
import forge.gamemodes.quest.QuestEventDraft;
import forge.gamemodes.quest.QuestMode;
import forge.gamemodes.quest.QuestUtilUnlockSets;
import forge.gamemodes.quest.QuestWorld;
import forge.gamemodes.quest.bazaar.IQuestBazaarItem;
import forge.gamemodes.quest.bazaar.QuestItemType;
import forge.gamemodes.quest.bazaar.QuestPetController;
import forge.gamemodes.quest.data.DeckConstructionRules;
import forge.gamemodes.quest.data.QuestAchievements;
import forge.gamemodes.quest.data.QuestAssets;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.interfaces.IButton;
import forge.gui.interfaces.IGuiGame;
import forge.gui.util.SGuiChoose;
import forge.gui.util.SOptionPane;
import forge.item.IPaperCard;
import forge.item.PaperToken;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.Localizer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class QuestUtil {
    private static final DecimalFormat CREDITS_FORMATTER = new DecimalFormat("#,###");
    private static QuestEvent event;
    private static QuestEventDraft draftEvent;

    public static String formatCredits(long credits) {
        return CREDITS_FORMATTER.format(credits);
    }

    public static List<IPaperCard> getComputerStartingCards(QuestEvent qe) {
        ArrayList<IPaperCard> list = new ArrayList<IPaperCard>();
        for (String s2 : qe.getAiExtraCards()) {
            list.add(QuestUtil.readExtraCard(s2));
        }
        return list;
    }

    public static List<IPaperCard> getHumanStartingCards(QuestController qc) {
        ArrayList<IPaperCard> list = new ArrayList<IPaperCard>();
        for (int iSlot = 0; iSlot < 2; ++iSlot) {
            PaperToken c;
            String petName = qc.getSelectedPet(iSlot);
            QuestPetController pet = qc.getPetsStorage().getPet(petName);
            if (pet == null || (c = pet.getPetCard(qc.getAssets())) == null) continue;
            list.add(c);
        }
        return list;
    }

    public static List<IPaperCard> getHumanStartingCards(QuestController qc, QuestEvent qe) {
        List<IPaperCard> list = QuestUtil.getHumanStartingCards(qc);
        for (String s2 : qe.getHumanExtraCards()) {
            list.add(QuestUtil.readExtraCard(s2));
        }
        return list;
    }

    public static PaperToken createToken(String s2) {
        String[] properties = s2.split(";", 6);
        ArrayList<String> script = new ArrayList<String>();
        script.add("Name:" + properties[4]);
        script.add("Colors:" + properties[1]);
        script.add("PT:" + properties[2] + "/" + properties[3]);
        script.add("Types:" + properties[5].replace(';', ' '));
        script.add("Oracle:");
        String fileName = PaperToken.makeTokenFileName(properties[1], properties[2], properties[3], properties[4]);
        return new PaperToken(CardRules.fromScript(script), CardEdition.UNKNOWN, fileName);
    }

    public static IPaperCard readExtraCard(String name) {
        if (name.startsWith("TOKEN")) {
            PaperToken tempcard = QuestUtil.createToken(name);
            return tempcard;
        }
        return FModel.getMagicDb().getCommonCards().getCardFromEditions(name);
    }

    public static void travelWorld() {
        Localizer localizer = Localizer.getInstance();
        if (!QuestUtil.checkActiveQuest(localizer.getMessage("lblTravelBetweenWorlds", new Object[0]))) {
            return;
        }
        ArrayList<QuestWorld> worlds = new ArrayList<QuestWorld>();
        QuestController qCtrl = FModel.getQuest();
        for (QuestWorld qw : FModel.getWorlds()) {
            if (qCtrl.getWorld() == qw) continue;
            worlds.add(qw);
        }
        if (worlds.size() < 1) {
            SOptionPane.showErrorDialog("There are currently no worlds you can travel to\nin this version of Forge.", "No Worlds");
            return;
        }
        String setPrompt = localizer.getMessage("lblWhereDoYouWishToTravel", new Object[0]);
        QuestWorld newWorld = (QuestWorld)SGuiChoose.oneOrNone(setPrompt, worlds);
        if (worlds.indexOf(newWorld) < 0) {
            return;
        }
        if (qCtrl.getWorld() != newWorld) {
            boolean needRemove = false;
            if (QuestUtil.nextChallengeInWins() < 1 && !qCtrl.getAchievements().getCurrentChallenges().isEmpty()) {
                needRemove = true;
                if (!SOptionPane.showConfirmDialog(localizer.getMessage("lblUncompleteChallengesDesc", new Object[0]), localizer.getMessage("lblUncompleteChallengesWarning", new Object[0]))) {
                    return;
                }
            }
            if (needRemove) {
                while (QuestUtil.nextChallengeInWins() == 0) {
                    qCtrl.getAchievements().addChallengesPlayed();
                }
                qCtrl.getAchievements().getCurrentChallenges().clear();
            }
            qCtrl.setWorld(newWorld);
            qCtrl.resetDuelsManager();
            qCtrl.resetChallengesManager();
            qCtrl.getDuelsManager().randomizeOpponents();
            qCtrl.getCards().clearShopList();
            qCtrl.save();
        }
    }

    public static int nextChallengeInWins() {
        int turnsToUnlock;
        QuestController qData = FModel.getQuest();
        int challengesPlayed = qData.getAchievements().getChallengesPlayed();
        int wins = qData.getAchievements().getWin();
        int delta = wins < 2 * (turnsToUnlock = FModel.getQuest().getTurnsToUnlockChallenge()) ? 2 * turnsToUnlock - wins : (wins / turnsToUnlock > challengesPlayed ? 0 : (wins < challengesPlayed * turnsToUnlock ? challengesPlayed * turnsToUnlock - wins + turnsToUnlock : turnsToUnlock - wins % turnsToUnlock));
        return delta > 0 ? delta : 0;
    }

    private static void updatePlantAndPetForView(IVQuestStats view, QuestController qCtrl) {
        Localizer localizer = Localizer.getInstance();
        for (int iSlot = 0; iSlot < 2; ++iSlot) {
            List<QuestPetController> petList = qCtrl.getPetsStorage().getAvaliablePets(iSlot, qCtrl.getAssets());
            String currentPetName = qCtrl.getSelectedPet(iSlot);
            if (iSlot == 0) {
                if (petList.isEmpty()) {
                    view.getCbPlant().setVisible(false);
                } else {
                    view.getCbPlant().setVisible(true);
                    view.getCbPlant().setSelected(currentPetName != null);
                }
            }
            if (iSlot != 1) continue;
            view.getCbxPet().removeAllItems();
            if (!petList.isEmpty()) {
                view.getCbxPet().setVisible(true);
                view.getCbxPet().addItem(localizer.getMessage("lblDontSummonAPet", new Object[0]));
                for (QuestPetController pet : petList) {
                    String name = localizer.getMessage("lblSummon", new Object[0]).replace("%n", "\"" + pet.getName() + "\"");
                    view.getCbxPet().addItem(name);
                    if (!pet.getName().equals(currentPetName)) continue;
                    view.getCbxPet().setSelectedItem(name);
                }
                continue;
            }
            view.getCbxPet().setVisible(false);
        }
        view.getCbxMatchLength().removeAllItems();
        boolean activeCharms = false;
        StringBuilder matchLength = new StringBuilder();
        matchLength.append(localizer.getMessage("lblMatchBestof", new Object[0])).append(" ").append(qCtrl.getMatchLength());
        if (qCtrl.getAssets().hasItem(QuestItemType.CHARM_VIM)) {
            view.getCbxMatchLength().addItem(localizer.getMessage("lblMatchBestOf1", new Object[0]));
            activeCharms = true;
        }
        view.getCbxMatchLength().addItem(localizer.getMessage("lblMatchBestOf3", new Object[0]));
        if (qCtrl.getAssets().hasItem(QuestItemType.CHARM)) {
            view.getCbxMatchLength().addItem(localizer.getMessage("lblMatchBestOf5", new Object[0]));
            activeCharms = true;
        }
        view.getCbxMatchLength().setSelectedItem(matchLength.toString());
        view.getCbxMatchLength().setVisible(activeCharms);
        if (view.isChallengesView()) {
            view.getLblZep().setVisible(qCtrl.getAssets().hasItem(QuestItemType.ZEPPELIN));
            if (qCtrl.getAssets().getItemLevel(QuestItemType.ZEPPELIN) == 2) {
                view.getLblZep().setEnabled(false);
                view.getLblZep().setTextColor(128, 128, 128);
            } else {
                view.getLblZep().setEnabled(true);
                view.getLblZep().setImage(FSkinProp.CLR_TEXT);
            }
        } else {
            view.getLblZep().setVisible(false);
        }
    }

    public static void updateQuestView(IVQuestStats view0) {
        QuestController qCtrl = FModel.getQuest();
        QuestAchievements qA = qCtrl.getAchievements();
        QuestAssets qS = qCtrl.getAssets();
        if (qA == null) {
            return;
        }
        view0.getLblNextChallengeInWins().setVisible(true);
        view0.getBtnBazaar().setVisible(true);
        view0.getLblLife().setVisible(true);
        Localizer localizer = Localizer.getInstance();
        view0.getLblCredits().setText(localizer.getMessage("lblCredits", new Object[0]) + ": " + QuestUtil.formatCredits(qS.getCredits()));
        view0.getLblLife().setText(localizer.getMessage("lblLife", new Object[0]) + ": " + qS.getLife(qCtrl.getMode()));
        view0.getLblWins().setText(localizer.getMessage("lblWins", new Object[0]) + ": " + qA.getWin());
        view0.getLblLosses().setText(localizer.getMessage("lblLosses", new Object[0]) + ": " + qA.getLost());
        view0.getLblWorld().setText(localizer.getMessage("lblWorld", new Object[0]) + ": " + (qCtrl.getWorld() == null ? " (" + localizer.getMessage("lblNone", new Object[0]) + ")" : qCtrl.getWorld()));
        view0.getBtnUnlock().setVisible(qCtrl.getUnlocksTokens() > 0 && qCtrl.getWorldFormat() == null);
        int num = QuestUtil.nextChallengeInWins();
        String str = num == 0 ? localizer.getMessage("lblnextChallengeInWins0", new Object[0]) : (num == 1 ? localizer.getMessage("lblnextChallengeInWins1", new Object[0]) : localizer.getMessage("lblnextChallengeInWins2", new Object[0]).replace("%n", "\"" + num + "\""));
        view0.getLblNextChallengeInWins().setText(str);
        if (view0.allowHtml()) {
            view0.getLblWinStreak().setText("<html>" + localizer.getMessage("lblWinStreak", new Object[0]) + ": " + qA.getWinStreakCurrent() + "<br>&nbsp; (" + localizer.getMessage("lblBest", new Object[0]) + ": " + qA.getWinStreakBest() + ")</html>");
        } else {
            view0.getLblWinStreak().setText(localizer.getMessage("lblWinStreak", new Object[0]) + ": " + qA.getWinStreakCurrent() + " (" + localizer.getMessage("lblBest", new Object[0]) + ": " + qA.getWinStreakBest() + ")");
        }
        IButton lblCurrentDeck = view0.getLblCurrentDeck();
        if (QuestUtil.getCurrentDeck() == null) {
            lblCurrentDeck.setTextColor(204, 0, 0);
            lblCurrentDeck.setText(localizer.getMessage("lblBuildAndSelectaDeck", new Object[0]));
        } else {
            lblCurrentDeck.setImage(FSkinProp.CLR_TEXT);
            lblCurrentDeck.setText(localizer.getMessage("lblCurrentDeck", new Object[0]).replace("%n", "\"" + QuestUtil.getCurrentDeck().getName() + "\"."));
        }
        if (qCtrl.getMode() == QuestMode.Fantasy) {
            QuestUtil.updatePlantAndPetForView(view0, qCtrl);
        } else {
            view0.getCbxPet().setVisible(false);
            view0.getCbPlant().setVisible(false);
            view0.getCbxMatchLength().setVisible(false);
            view0.getLblZep().setVisible(false);
            view0.getLblNextChallengeInWins().setVisible(false);
            view0.getBtnBazaar().setVisible(false);
            view0.getLblLife().setVisible(false);
        }
    }

    public static Deck getCurrentDeck() {
        Deck d = null;
        if (FModel.getQuest().getAssets() != null) {
            d = FModel.getQuest().getMyDecks().get(FModel.getQuest().getCurrentDeck());
        }
        return d;
    }

    public static void setEvent(QuestEvent event0) {
        event = event0;
    }

    public static void setDraftEvent(QuestEventDraft event0) {
        draftEvent = event0;
    }

    public static QuestEventDraft getDraftEvent() {
        return draftEvent;
    }

    public static boolean checkActiveQuest(String location) {
        Localizer localizer = Localizer.getInstance();
        QuestController qc = FModel.getQuest();
        if (qc == null || qc.getAssets() == null) {
            String msg = localizer.getMessage("PleaseCreateAQuestBefore", new Object[0]).replace("%n", location);
            SOptionPane.showErrorDialog(msg, localizer.getMessage("lblNoQuest", new Object[0]));
            System.out.println(msg);
            return false;
        }
        return true;
    }

    public static void showSpellShop() {
        Localizer localizer = Localizer.getInstance();
        if (!QuestUtil.checkActiveQuest(localizer.getMessage("lblVisitTheSpellShop", new Object[0]))) {
            return;
        }
        GuiBase.getInterface().showSpellShop();
    }

    public static void showBazaar() {
        Localizer localizer = Localizer.getInstance();
        if (!QuestUtil.checkActiveQuest(localizer.getMessage("lblVisitTheBazaar", new Object[0]))) {
            return;
        }
        GuiBase.getInterface().showBazaar();
    }

    public static void chooseAndUnlockEdition() {
        Localizer localizer = Localizer.getInstance();
        if (!QuestUtil.checkActiveQuest(localizer.getMessage("lblUnlockEditions", new Object[0]))) {
            return;
        }
        QuestController qData = FModel.getQuest();
        ImmutablePair<CardEdition, Integer> toUnlock = QuestUtilUnlockSets.chooseSetToUnlock(qData, false, null);
        if (toUnlock == null) {
            return;
        }
        CardEdition unlocked = (CardEdition)toUnlock.left;
        qData.getAssets().subtractCredits(((Integer)toUnlock.right).intValue());
        SOptionPane.showMessageDialog(localizer.getMessage("lblUnlocked", new Object[0]).replace("%n", unlocked.getName()), localizer.getMessage("titleUnlocked", new Object[0]).replace("%n", unlocked.getName()), null);
        QuestUtilUnlockSets.doUnlock(qData, unlocked);
    }

    public static void startGame() {
        if (QuestUtil.canStartGame()) {
            QuestUtil.finishStartingGame();
        }
    }

    public static void finishStartingGame() {
        QuestController qData = FModel.getQuest();
        FThreads.invokeInBackgroundThread(() -> {
            qData.getDuelsManager().randomizeOpponents();
            qData.setCurrentEvent(event);
            qData.save();
        });
        int extraLifeHuman = 0;
        Integer lifeHuman = null;
        boolean useBazaar = true;
        Boolean forceAnte = null;
        int variantLifeModifier = 0;
        switch (FModel.getQuest().getDeckConstructionRules()) {
            case Default: {
                break;
            }
            case Commander: {
                variantLifeModifier = 20;
            }
        }
        int lifeAI = 20 + variantLifeModifier;
        if (event instanceof QuestEventChallenge) {
            QuestEventChallenge qc = (QuestEventChallenge)event;
            lifeAI = qc.getAILife();
            lifeHuman = qc.getHumanLife();
            if (qData.getAssets().hasItem(QuestItemType.ZEPPELIN)) {
                extraLifeHuman = 3;
            }
            useBazaar = qc.isUseBazaar();
            forceAnte = qc.isForceAnte();
        }
        RegisteredPlayer humanStart = QuestUtil.getRegisteredPlayerByVariant(QuestUtil.getDeckForNewGame());
        RegisteredPlayer aiStart = QuestUtil.getRegisteredPlayerByVariant(event.getEventDeck());
        if (lifeHuman != null) {
            humanStart.setStartingLife(lifeHuman);
        } else {
            humanStart.setStartingLife(qData.getAssets().getLife(qData.getMode()) + extraLifeHuman);
        }
        if (useBazaar) {
            humanStart.setCardsOnBattlefield(QuestUtil.getHumanStartingCards(qData, event));
            aiStart.setStartingLife(lifeAI);
            aiStart.setCardsOnBattlefield(QuestUtil.getComputerStartingCards(event));
        }
        ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
        starter.add(humanStart.setPlayer(GamePlayerUtil.getQuestPlayer()));
        LobbyPlayer aiPlayer = GamePlayerUtil.createAiPlayer(event.getOpponentName() == null ? event.getTitle() : event.getOpponentName(), event.getProfile());
        starter.add(aiStart.setPlayer(aiPlayer));
        boolean useRandomFoil = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_RANDOM_FOIL);
        for (RegisteredPlayer rp : starter) {
            rp.setRandomFoil(useRandomFoil);
        }
        boolean useAnte = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ANTE);
        boolean matchAnteRarity = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ANTE_MATCH_RARITY);
        if (forceAnte != null) {
            useAnte = forceAnte;
        }
        GameRules rules = new GameRules(GameType.Quest);
        rules.setPlayForAnte(useAnte);
        rules.setMatchAnteRarity(matchAnteRarity);
        rules.setGamesPerMatch(qData.getMatchLength());
        rules.setManaBurn(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_MANABURN));
        rules.setUseGrayText(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_GRAY_INACTIVE_TEXT));
        TreeSet<GameType> variant = new TreeSet<GameType>();
        if (FModel.getQuest().getDeckConstructionRules() == DeckConstructionRules.Commander) {
            variant.add(GameType.Commander);
        }
        HostedMatch hostedMatch = GuiBase.getInterface().hostMatch();
        IGuiGame gui = GuiBase.getInterface().getNewGuiGame();
        gui.setPlayerAvatar(aiPlayer, event);
        FThreads.invokeInEdtNowOrLater(() -> hostedMatch.startMatch(rules, (Set<GameType>)variant, (List<RegisteredPlayer>)starter, ImmutableMap.of(humanStart, gui), null));
    }

    private static RegisteredPlayer getRegisteredPlayerByVariant(Deck deck) {
        switch (FModel.getQuest().getDeckConstructionRules()) {
            case Default: {
                return new RegisteredPlayer(deck);
            }
            case Commander: {
                return RegisteredPlayer.forCommander(deck);
            }
        }
        return null;
    }

    private static Deck getDeckForNewGame() {
        Deck deck = null;
        if (event instanceof QuestEventChallenge) {
            deck = ((QuestEventChallenge)event).getHumanDeck();
        }
        if (deck == null) {
            deck = QuestUtil.getCurrentDeck();
        }
        return deck;
    }

    public static boolean canStartGame() {
        String errorMessage;
        Localizer localizer = Localizer.getInstance();
        if (!QuestUtil.checkActiveQuest(localizer.getMessage("lblStartADuel", new Object[0])) || null == event) {
            return false;
        }
        Deck deck = QuestUtil.getDeckForNewGame();
        if (deck == null) {
            String msg = localizer.getMessage("lblSelectAQuestDeck", new Object[0]);
            SOptionPane.showErrorDialog(msg, localizer.getMessage("lblNoDeck", new Object[0]));
            System.out.println(msg);
            return false;
        }
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY) && null != (errorMessage = QuestUtil.getDeckConformanceProblemsBeforeGame(deck))) {
            SOptionPane.showErrorDialog(localizer.getMessage("lblInvalidDeckDesc", new Object[0]).replace("%n", errorMessage), "Invalid Deck");
            return false;
        }
        return true;
    }

    public static String getDeckConformanceProblemsBeforeGame(Deck deck) {
        if (event instanceof QuestEventChallenge && ((QuestEventChallenge)event).getHumanDeck() != null) {
            return null;
        }
        String errorMessage = GameType.Quest.getDeckFormat().getDeckConformanceProblem(deck);
        if (errorMessage != null) {
            return errorMessage;
        }
        switch (FModel.getQuest().getDeckConstructionRules()) {
            case Commander: {
                errorMessage = GameType.Commander.getDeckFormat().getDeckConformanceProblem(deck);
            }
        }
        if (errorMessage != null) {
            return errorMessage;
        }
        if (FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.WORLD_RULES_CONFORMANCE) == 1 && FModel.getQuest().getFormat() != null) {
            errorMessage = FModel.getQuest().getFormat().getDeckConformanceProblem(deck);
        }
        return errorMessage;
    }

    public static String cleanString(String in) {
        char[] c;
        StringBuilder out = new StringBuilder();
        for (char aC : c = in.toCharArray()) {
            if (!Character.isLetterOrDigit(aC) && aC != '-' && aC != '_' && aC != ' ') continue;
            out.append(aC);
        }
        return out.toString();
    }

    public static void buyQuestItem(IQuestBazaarItem item) {
        QuestAssets qA = FModel.getQuest().getAssets();
        int cost = item.getBuyingPrice(qA);
        if (cost >= 0 && qA.getCredits() - (long)cost >= 0L) {
            qA.subtractCredits(cost);
            qA.addCredits(item.getSellingPrice(qA));
            item.onPurchase(qA);
            FModel.getQuest().save();
        }
    }
}

