/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.deck.DeckGroup;
import forge.game.GameType;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.quest.IQuestTournamentView;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestDraftUtils;
import forge.gamemodes.quest.QuestEventDraft;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.data.QuestAchievements;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.tournament.system.TournamentBracket;
import forge.gamemodes.tournament.system.TournamentPairing;
import forge.gamemodes.tournament.system.TournamentPlayer;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.interfaces.IGuiGame;
import forge.gui.util.SGuiChoose;
import forge.gui.util.SOptionPane;
import forge.item.BoosterPack;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.util.ThreadUtil;
import forge.util.storage.IStorage;
import java.util.ArrayList;
import java.util.List;

public class QuestTournamentController {
    private final IQuestTournamentView view;
    private final Localizer localizer = Localizer.getInstance();
    private boolean drafting = false;
    private IGuiGame gui = null;

    public QuestTournamentController(IQuestTournamentView view0) {
        this.view = view0;
        QuestAchievements achievements = FModel.getQuest().getAchievements();
        IStorage<DeckGroup> decks = FModel.getQuest().getDraftDecks();
        if (achievements == null) {
            this.view.setMode(QuestDraftUtils.Mode.EMPTY);
        } else if (achievements.getDraftEvents() == null || achievements.getDraftEvents().isEmpty()) {
            achievements.generateDrafts();
            if (achievements.getDraftEvents().isEmpty()) {
                this.view.setMode(QuestDraftUtils.Mode.EMPTY);
            } else {
                this.view.setMode(QuestDraftUtils.Mode.SELECT_TOURNAMENT);
            }
        } else if (decks == null || !decks.contains("Tournament Deck")) {
            achievements.generateDrafts();
            this.view.setMode(QuestDraftUtils.Mode.SELECT_TOURNAMENT);
        } else if (!achievements.getCurrentDraft().isStarted()) {
            this.view.setMode(QuestDraftUtils.Mode.PREPARE_DECK);
        } else {
            this.view.setMode(QuestDraftUtils.Mode.TOURNAMENT_ACTIVE);
        }
    }

    public void endTournamentAndAwardPrizes() {
        boolean saveDraft;
        QuestEventDraft draft = FModel.getQuest().getAchievements().getCurrentDraft();
        if (!draft.isStarted()) {
            boolean shouldQuit;
            boolean bl = shouldQuit = SOptionPane.showOptionDialog(this.localizer.getMessage("lblLeaveTournamentDraftWarning1", new Object[0]), this.localizer.getMessage("lblReallyQuit", new Object[0]), SOptionPane.WARNING_ICON, ImmutableList.of(this.localizer.getMessage("lblYes", new Object[0]), this.localizer.getMessage("lblNo", new Object[0])), 1) == 0;
            if (!shouldQuit) {
                return;
            }
        } else {
            if (draft.playerHasMatchesLeft()) {
                boolean shouldQuit;
                boolean bl = shouldQuit = SOptionPane.showOptionDialog(this.localizer.getMessage("lblLeaveTournamentDraftWarning2", new Object[0]), this.localizer.getMessage("lblReallyQuit", new Object[0]), SOptionPane.WARNING_ICON, ImmutableList.of(this.localizer.getMessage("lblYes", new Object[0]), this.localizer.getMessage("lblNo", new Object[0])), 1) == 0;
                if (!shouldQuit) {
                    return;
                }
            }
            String placement = draft.getPlacementString();
            QuestEventDraft.QuestDraftPrizes prizes = draft.collectPrizes();
            if (prizes.hasCredits()) {
                SOptionPane.showMessageDialog(this.localizer.getMessage("lblForPlacing", new Object[0]) + placement + this.localizer.getMessage("lblHaveBeAward", new Object[0]) + QuestUtil.formatCredits(prizes.credits) + " " + this.localizer.getMessage("lblCredits", new Object[0]) + "!", this.localizer.getMessage("lblCreditsAwarded", new Object[0]), FSkinProp.ICO_QUEST_GOLD);
            }
            if (prizes.hasIndividualCards()) {
                GuiBase.getInterface().showCardList(this.localizer.getMessage("lblTournamentReward", new Object[0]), this.localizer.getMessage("lblParticipateingTournamentReward", new Object[0]), prizes.individualCards);
            }
            if (prizes.hasBoosterPacks()) {
                String packPlural = prizes.boosterPacks.size() == 1 ? "" : "s";
                SOptionPane.showMessageDialog(this.localizer.getMessage("lblForPlacing", new Object[0]) + placement + this.localizer.getMessage("lblHaveBeAward", new Object[0]) + prizes.boosterPacks.size() + " " + this.localizer.getMessage("lblBoosterPack", new Object[0]) + packPlural + "!", this.localizer.getMessage("lblBoosterPack", new Object[0]) + packPlural + " " + this.localizer.getMessage("lblAwarded", new Object[0]), FSkinProp.ICO_QUEST_BOX);
                if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_OPEN_PACKS_INDIV) && prizes.boosterPacks.size() > 1) {
                    boolean skipTheRest = false;
                    ArrayList<PaperCard> remainingCards = new ArrayList<PaperCard>();
                    int totalPacks = prizes.boosterPacks.size();
                    int currentPack = 0;
                    while (!prizes.boosterPacks.isEmpty()) {
                        BoosterPack pack = prizes.boosterPacks.remove(0);
                        ++currentPack;
                        if (skipTheRest) {
                            remainingCards.addAll(pack.getCards());
                            continue;
                        }
                        skipTheRest = GuiBase.getInterface().showBoxedProduct(pack.getName(), this.localizer.getMessage("lblFoundCards", new Object[0]) + " (" + this.localizer.getMessage("lblBoosterPack", new Object[0]) + " " + currentPack + " / " + totalPacks + "):", pack.getCards());
                    }
                    if (skipTheRest && !remainingCards.isEmpty()) {
                        GuiBase.getInterface().showCardList(this.localizer.getMessage("lblTournamentReward", new Object[0]), this.localizer.getMessage("lblFoundCards", new Object[0]) + ":", remainingCards);
                    }
                } else {
                    ArrayList<PaperCard> cards = new ArrayList<PaperCard>();
                    while (!prizes.boosterPacks.isEmpty()) {
                        BoosterPack pack = prizes.boosterPacks.remove(0);
                        cards.addAll(pack.getCards());
                    }
                    GuiBase.getInterface().showCardList(this.localizer.getMessage("lblTournamentReward", new Object[0]), this.localizer.getMessage("lblFoundCards", new Object[0]) + ":", cards);
                }
            }
            if (prizes.selectRareFromSets()) {
                SOptionPane.showMessageDialog(this.localizer.getMessage("lblForPlacing", new Object[0]) + placement + this.localizer.getMessage("lblSelectRareAwarded", new Object[0]), this.localizer.getMessage("lblRareAwarded", new Object[0]), FSkinProp.ICO_QUEST_STAKES);
                PaperCard card = GuiBase.getInterface().chooseCard(this.localizer.getMessage("lblSelectACard", new Object[0]), this.localizer.getMessage("lblSelectKeepCard", new Object[0]), prizes.selectRareCards);
                prizes.addSelectedCard(card);
                SOptionPane.showMessageDialog("'" + card.getName() + "' " + this.localizer.getMessage("lblAddToCollection", new Object[0]), this.localizer.getMessage("lblCardAdded", new Object[0]), FSkinProp.ICO_QUEST_STAKES);
            }
            if (draft.getPlayerPlacement() == 1) {
                SOptionPane.showMessageDialog(this.localizer.getMessage("lblForPlacing", new Object[0]) + placement + this.localizer.getMessage("lblHaveBeAwardToken", new Object[0]), this.localizer.getMessage("lblBonusToken", new Object[0]), FSkinProp.ICO_QUEST_NOTES);
                FModel.getQuest().getAchievements().addDraftToken();
            }
        }
        boolean bl = saveDraft = SOptionPane.showOptionDialog(this.localizer.getMessage("lblWouldLikeSaveDraft", new Object[0]), this.localizer.getMessage("lblSaveDraft", new Object[0]) + "?", SOptionPane.QUESTION_ICON, ImmutableList.of(this.localizer.getMessage("lblYes", new Object[0]), this.localizer.getMessage("lblNo", new Object[0])), 0) == 0;
        if (saveDraft) {
            draft.saveToRegularDraft();
        }
        draft.addToQuestDecks();
        this.update();
        this.view.populate();
    }

    public void spendToken() {
        QuestAchievements achievements = FModel.getQuest().getAchievements();
        if (achievements != null) {
            List<QuestEventDraft.QuestDraftFormat> formats = QuestEventDraft.getAvailableFormats(FModel.getQuest());
            if (formats.isEmpty()) {
                SOptionPane.showErrorDialog(this.localizer.getMessage("lblNoAvailableDraftsMessage", new Object[0]), this.localizer.getMessage("lblNoAvailableDrafts", new Object[0]));
                return;
            }
            QuestEventDraft.QuestDraftFormat format = SGuiChoose.oneOrNone(this.localizer.getMessage("lblChooseDraftFormat", new Object[0]), formats);
            if (format != null) {
                QuestEventDraft evt = QuestEventDraft.getDraftOrNull(FModel.getQuest(), format);
                if (evt != null) {
                    String fee = TextUtil.concatNoSpace(this.localizer.getMessage("lblEntryFeeOfDraftTournament", new Object[0]), String.valueOf(evt.getEntryFee()), this.localizer.getMessage("lblWouldLikeCreateTournament", new Object[0]));
                    if (SOptionPane.showConfirmDialog(fee, this.localizer.getMessage("lblCreatingDraftTournament", new Object[0]))) {
                        achievements.spendDraftToken(format);
                        this.update();
                        this.view.populate();
                    }
                } else {
                    SOptionPane.showErrorDialog(this.localizer.getMessage("lblUnexpectedCreatingDraftTournament", new Object[0]) + format.getName() + this.localizer.getMessage("lblPleaseReportBug", new Object[0]));
                    System.err.println("Error creating booster draft tournament (QuestEventDraft object was null): " + format.getName());
                }
            }
        }
    }

    public void update() {
        if (FModel.getQuest().getAchievements() == null) {
            this.view.setMode(QuestDraftUtils.Mode.EMPTY);
            return;
        }
        QuestAchievements achievements = FModel.getQuest().getAchievements();
        achievements.generateDrafts();
        if (FModel.getQuest().getAchievements().getDraftEvents().isEmpty()) {
            this.view.setMode(QuestDraftUtils.Mode.EMPTY);
            this.updatePlacementLabelsText();
            return;
        }
        if (FModel.getQuest().getDraftDecks() == null || !FModel.getQuest().getDraftDecks().contains("Tournament Deck") || FModel.getQuest().getAchievements().getCurrentDraftIndex() == -1) {
            this.view.setMode(QuestDraftUtils.Mode.SELECT_TOURNAMENT);
        } else if (!FModel.getQuest().getAchievements().getCurrentDraft().isStarted()) {
            this.view.setMode(QuestDraftUtils.Mode.PREPARE_DECK);
        } else {
            this.view.setMode(QuestDraftUtils.Mode.TOURNAMENT_ACTIVE);
        }
        QuestDraftUtils.update(this.gui);
        switch (this.view.getMode()) {
            case SELECT_TOURNAMENT: {
                this.updateSelectTournament();
                break;
            }
            case PREPARE_DECK: {
                this.updatePrepareDeck();
                break;
            }
            case TOURNAMENT_ACTIVE: {
                this.updateTournamentActive();
                break;
            }
        }
    }

    private void updateSelectTournament() {
        this.view.getLblCredits().setText(this.localizer.getMessage("lblCredits", new Object[0]) + ": " + QuestUtil.formatCredits(FModel.getQuest().getAssets().getCredits()));
        QuestAchievements achievements = FModel.getQuest().getAchievements();
        achievements.generateDrafts();
        this.view.updateEventList(achievements.getDraftEvents());
        this.updatePlacementLabelsText();
    }

    private void updatePlacementLabelsText() {
        QuestAchievements achievements = FModel.getQuest().getAchievements();
        if (this.view.getMode() == QuestDraftUtils.Mode.EMPTY) {
            this.view.updateEventList(null);
        }
        this.view.getLblFirst().setText(this.localizer.getMessage("lbl1stPlace", new Object[0]) + achievements.getWinsForPlace(1) + this.localizer.getMessage("lblTime", new Object[0]) + (achievements.getWinsForPlace(1) == 1 ? "" : "s"));
        this.view.getLblSecond().setText(this.localizer.getMessage("lbl2ndPlace", new Object[0]) + achievements.getWinsForPlace(2) + this.localizer.getMessage("lblTime", new Object[0]) + (achievements.getWinsForPlace(2) == 1 ? "" : "s"));
        this.view.getLblThird().setText(this.localizer.getMessage("lbl3rdPlace", new Object[0]) + achievements.getWinsForPlace(3) + this.localizer.getMessage("lblTime", new Object[0]) + (achievements.getWinsForPlace(3) == 1 ? "" : "s"));
        this.view.getLblFourth().setText(this.localizer.getMessage("lbl4thPlace", new Object[0]) + achievements.getWinsForPlace(4) + this.localizer.getMessage("lblTime", new Object[0]) + (achievements.getWinsForPlace(4) == 1 ? "" : "s"));
        this.view.getBtnSpendToken().setText(this.localizer.getMessage("btnSpendToken", new Object[0]) + " (" + achievements.getDraftTokens() + ")");
        this.view.getBtnSpendToken().setEnabled(achievements.getDraftTokens() > 0);
    }

    private void updatePrepareDeck() {
    }

    private void updateTournamentActive() {
        if (FModel.getQuest().getAchievements().getCurrentDraft() == null) {
            return;
        }
        if (QuestDraftUtils.TOURNAMENT_TOGGLE) {
            this.updateTournamentActiveForBracket();
            return;
        }
        for (int i = 0; i < 15; ++i) {
            String playerID = FModel.getQuest().getAchievements().getCurrentDraft().getStandings()[i];
            int iconID = 0;
            switch (playerID) {
                case "quest_draft_human_place": {
                    playerID = FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME);
                    if (FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",").length <= 0) break;
                    iconID = Integer.parseInt(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",")[0]);
                    break;
                }
                case "quest_draft_undetermined_place": {
                    playerID = "Undetermined";
                    iconID = GuiBase.getInterface().getAvatarCount() - 1;
                    break;
                }
                default: {
                    iconID = FModel.getQuest().getAchievements().getCurrentDraft().getAIIcons()[Integer.parseInt(playerID) - 1];
                    playerID = FModel.getQuest().getAchievements().getCurrentDraft().getAINames()[Integer.parseInt(playerID) - 1];
                }
            }
            boolean first = i % 2 == 0;
            int box = i / 2;
            this.view.updateTournamentBoxLabel(playerID, iconID, box, first);
        }
        if (FModel.getQuest().getAchievements().getCurrentDraft().playerHasMatchesLeft()) {
            this.view.getBtnLeaveTournament().setText(this.localizer.getMessage("btnLeaveTournament", new Object[0]));
        } else {
            this.view.getBtnLeaveTournament().setText(this.localizer.getMessage("lblCollectPrizes", new Object[0]));
        }
    }

    private void updateTournamentActiveForBracket() {
        QuestEventDraft draft = FModel.getQuest().getAchievements().getCurrentDraft();
        TournamentBracket bracket = draft.getBracket();
        if (bracket == null) {
            return;
        }
        ArrayList<TournamentPairing> allPairings = Lists.newArrayList();
        allPairings.addAll(bracket.getCompletedPairings());
        allPairings.addAll(bracket.getActivePairings());
        int count = 0;
        int playerCount = 0;
        int lastWinner = 0;
        for (TournamentPairing tp : allPairings) {
            boolean first = true;
            String playerID = "Undetermined";
            int iconID = 0;
            for (TournamentPlayer player : tp.getPairedPlayers()) {
                if (player.getIndex() == -1) {
                    playerID = FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME);
                    if (FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",").length > 0) {
                        iconID = Integer.parseInt(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",")[0]);
                    }
                } else {
                    playerID = player.getPlayer().getName();
                    iconID = player.getIndex();
                }
                this.view.updateTournamentBoxLabel(playerID, iconID, count, first);
                if (tp.getWinner() != null && tp.getWinner().equals(player)) {
                    lastWinner = playerCount;
                    this.view.updateTournamentBoxLabel(player.getPlayer().getName(), player.getIndex(), playerCount / 4 + 4, count % 2 == 0);
                }
                first = false;
                ++playerCount;
            }
            ++count;
        }
        if (!bracket.isTournamentOver()) {
            for (int i = lastWinner / 2 + 9; i < 15; ++i) {
                String playerID = "Undetermined";
                int iconID = GuiBase.getInterface().getAvatarCount() - 1;
                this.view.updateTournamentBoxLabel(playerID, iconID, i / 2, i % 2 == 0);
            }
        }
        if (draft.playerHasMatchesLeft()) {
            this.view.getBtnLeaveTournament().setText(this.localizer.getMessage("btnLeaveTournament", new Object[0]));
        } else {
            this.view.getBtnLeaveTournament().setText(this.localizer.getMessage("lblCollectPrizes", new Object[0]));
        }
    }

    public void setCompletedDraft(DeckGroup finishedDraft) {
        QuestDraftUtils.completeDraft(finishedDraft);
        this.view.editDeck(false);
        this.drafting = false;
        this.view.setMode(QuestDraftUtils.Mode.PREPARE_DECK);
        this.view.populate();
    }

    public void startDraft() {
        ThreadUtil.invokeInGameThread(() -> {
            boolean okayToEnter;
            if (this.drafting) {
                SOptionPane.showErrorDialog(this.localizer.getMessage("lblCurrentlyInDraft", new Object[0]));
                return;
            }
            QuestEventDraft draftEvent = QuestUtil.getDraftEvent();
            long creditsAvailable = FModel.getQuest().getAssets().getCredits();
            if (draftEvent.canEnter()) {
                SOptionPane.showMessageDialog(this.localizer.getMessage("lblYouNeed", new Object[0]) + QuestUtil.formatCredits((long)draftEvent.getEntryFee() - creditsAvailable) + " " + this.localizer.getMessage("lblMoreCredits", new Object[0]), this.localizer.getMessage("lblNotEnoughCredits", new Object[0]), SOptionPane.WARNING_ICON);
                return;
            }
            boolean bl = okayToEnter = SOptionPane.showOptionDialog(this.localizer.getMessage("lblTournamentCosts", new Object[0]) + QuestUtil.formatCredits(draftEvent.getEntryFee()) + this.localizer.getMessage("lblSureEnterTournament", new Object[0]), this.localizer.getMessage("lblEnterDraftTournament", new Object[0]), FSkinProp.ICO_QUEST_GOLD, ImmutableList.of(this.localizer.getMessage("lblYes", new Object[0]), this.localizer.getMessage("lblNo", new Object[0])), 1) == 0;
            if (!okayToEnter) {
                return;
            }
            this.drafting = true;
            BoosterDraft draft = draftEvent.enter();
            FThreads.invokeInEdtLater(() -> this.view.startDraft(draft));
        });
    }

    public boolean cancelDraft() {
        if (SOptionPane.showConfirmDialog(this.localizer.getMessage("lblLeaveDraftConfirm", new Object[0]), this.localizer.getMessage("lblLeaveDraft", new Object[0]) + "?", this.localizer.getMessage("lblLeave", new Object[0]), this.localizer.getMessage("lblCancel", new Object[0]), false)) {
            this.drafting = false;
            QuestController quest = FModel.getQuest();
            QuestEventDraft draft = quest.getAchievements().getCurrentDraft();
            quest.getAssets().addCredits(draft.getEntryFee());
            quest.getAchievements().deleteDraft(draft);
            quest.save();
            return true;
        }
        return false;
    }

    public void startTournament() {
        FModel.getQuest().save();
        String message = GameType.QuestDraft.getDeckFormat().getDeckConformanceProblem(((DeckGroup)FModel.getQuest().getAssets().getDraftDeckStorage().get("Tournament Deck")).getHumanDeck());
        if (message != null && FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) {
            SOptionPane.showMessageDialog(this.localizer.getMessage("lblDeck", new Object[0]) + " " + message, this.localizer.getMessage("lblDeckInvalid", new Object[0]));
            return;
        }
        FModel.getQuest().getAchievements().getCurrentDraft().start();
        this.view.setMode(QuestDraftUtils.Mode.TOURNAMENT_ACTIVE);
        this.view.populate();
        this.update();
    }

    public void startNextMatch() {
        String message = QuestDraftUtils.getDeckLegality();
        if (message != null) {
            SOptionPane.showMessageDialog(message, this.localizer.getMessage("lblDeckInvalid", new Object[0]));
            return;
        }
        if (QuestDraftUtils.matchInProgress) {
            SOptionPane.showErrorDialog(this.localizer.getMessage("lblAlreadyMatchPleaseWait", new Object[0]));
            return;
        }
        if (FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.SIMULATE_AI_VS_AI_RESULTS) == 1 || GuiBase.getInterface().isLibgdxPort()) {
            if (!QuestDraftUtils.injectRandomMatchOutcome(false)) {
                this.gui = GuiBase.getInterface().getNewGuiGame();
                QuestDraftUtils.startNextMatch(this.gui);
            } else {
                this.view.populate();
                this.update();
            }
        } else {
            this.gui = GuiBase.getInterface().getNewGuiGame();
            QuestDraftUtils.startNextMatch(this.gui);
        }
    }
}

