/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import forge.gamemodes.quest.IQuestRewardCard;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.ItemPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class QuestRewardCardDuplicate
implements IQuestRewardCard {
    private final String description;

    public QuestRewardCardDuplicate() {
        this.description = "a duplicate card";
    }

    @Override
    public String getName() {
        return this.description;
    }

    @Override
    public String getItemType() {
        return "duplicate card";
    }

    public String toString() {
        return this.description;
    }

    @Override
    public final List<PaperCard> getChoices() {
        ItemPool<PaperCard> playerCards = FModel.getQuest().getAssets().getCardPool();
        if (!playerCards.isEmpty()) {
            ArrayList<PaperCard> cardChoices = new ArrayList<PaperCard>();
            for (Map.Entry<PaperCard, Integer> entry : playerCards) {
                cardChoices.add(entry.getKey());
            }
            Collections.sort(cardChoices);
            return Collections.unmodifiableList(cardChoices);
        }
        return null;
    }

    @Override
    public String getImageKey(boolean altState) {
        return null;
    }
}

