/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.card.CardRules;
import forge.gamemodes.quest.BoosterUtils;
import forge.gamemodes.quest.IQuestRewardCard;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.model.FModel;
import java.util.ArrayList;

public abstract class QuestRewardCard
implements IQuestRewardCard {
    protected String buildDescription(String[] input) {
        String defaultDescription = "a card";
        if (input == null || input.length < 1) {
            return "a card";
        }
        StringBuilder buildDesc = null;
        for (String s2 : input) {
            if (s2.startsWith("desc:") || s2.startsWith("Desc:")) {
                String[] tmp = s2.split(":");
                if (tmp.length > 1) {
                    buildDesc = new StringBuilder(tmp[1]);
                    continue;
                }
                buildDesc = new StringBuilder();
                continue;
            }
            if (buildDesc == null) continue;
            if (s2.contains(":")) {
                return buildDesc.toString();
            }
            buildDesc.append(" ").append(s2);
        }
        if (buildDesc != null) {
            return buildDesc.toString();
        }
        return "a card";
    }

    protected Predicate<PaperCard> buildPredicates(String[] input) {
        if (input == null || input.length < 1) {
            return null;
        }
        Predicate<PaperCard> filters = FModel.getQuest().getFormat().getFilterPrinted();
        Predicate<CardRules> filterRules = null;
        Predicate<PaperCard> filterRarity = null;
        for (String s2 : input) {
            String[] rarityCodes;
            String[] tmp;
            if (s2.startsWith("sets:") || s2.startsWith("Sets:")) {
                String[] setcodes;
                tmp = s2.split(":");
                if (tmp.length <= 1 || (setcodes = tmp[1].split(",")).length <= 0) continue;
                ArrayList<String> sets = new ArrayList<String>();
                String[] stringArray = setcodes;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String code = stringArray[i];
                    if (!FModel.getMagicDb().getEditions().contains(code)) continue;
                    sets.add(code);
                }
                if (sets.size() <= 0) continue;
                filters = IPaperCard.Predicates.printedInSets(sets, true);
                continue;
            }
            if (s2.startsWith("rules:") || s2.startsWith("Rules:")) {
                String[] ruleCodes;
                tmp = s2.split(":");
                if (tmp.length <= 1 || (ruleCodes = tmp[1].split(",")).length <= 0) continue;
                for (String rule : ruleCodes) {
                    Predicate<CardRules> newRule = BoosterUtils.parseRulesLimitation(rule);
                    if (newRule == null) continue;
                    filterRules = filterRules == null ? newRule : Predicates.and(filterRules, newRule);
                }
                continue;
            }
            if (!s2.startsWith("rarity:") && !s2.startsWith("Rarity:") || (tmp = s2.split(":")).length <= 1 || (rarityCodes = tmp[1].split(",")).length <= 0) continue;
            for (String rarity : rarityCodes) {
                if (rarity.startsWith("C") || rarity.startsWith("c")) {
                    filterRarity = filterRarity == null ? IPaperCard.Predicates.Presets.IS_COMMON : Predicates.or(filterRarity, IPaperCard.Predicates.Presets.IS_COMMON);
                    continue;
                }
                if (rarity.startsWith("U") || rarity.startsWith("u")) {
                    filterRarity = filterRarity == null ? IPaperCard.Predicates.Presets.IS_UNCOMMON : Predicates.or(filterRarity, IPaperCard.Predicates.Presets.IS_UNCOMMON);
                    continue;
                }
                if (rarity.startsWith("R") || rarity.startsWith("r")) {
                    filterRarity = filterRarity == null ? IPaperCard.Predicates.Presets.IS_RARE : Predicates.or(filterRarity, IPaperCard.Predicates.Presets.IS_RARE);
                    continue;
                }
                if (!rarity.startsWith("M") && !rarity.startsWith("m")) continue;
                filterRarity = filterRarity == null ? IPaperCard.Predicates.Presets.IS_MYTHIC_RARE : Predicates.or(filterRarity, IPaperCard.Predicates.Presets.IS_MYTHIC_RARE);
            }
        }
        if (filterRules != null) {
            Predicate rulesPrinted = Predicates.compose(filterRules, PaperCard::getRules);
            filters = Predicates.and(filters, rulesPrinted);
        }
        if (filterRarity != null) {
            filters = Predicates.and(filters, filterRarity);
        }
        return filters;
    }

    @Override
    public String getImageKey(boolean altState) {
        return null;
    }
}

