/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import forge.deck.CardArchetypeLDAGenerator;
import forge.deck.io.Archetype;
import forge.game.GameFormat;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEventDifficulty;
import forge.gamemodes.quest.QuestEventDuel;
import forge.gamemodes.quest.QuestEventDuelManagerInterface;
import forge.gamemodes.quest.QuestEventLDADuel;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.model.FModel;
import forge.util.CollectionSuppliers;
import forge.util.MyRandom;
import forge.util.maps.EnumMapOfLists;
import forge.util.maps.MapOfLists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class QuestEventLDADuelManager
implements QuestEventDuelManagerInterface {
    private List<Archetype> archetypes;
    private final MapOfLists<QuestEventDifficulty, QuestEventDuel> sortedDuels = new EnumMapOfLists(QuestEventDifficulty.class, CollectionSuppliers.arrayLists());
    private GameFormat baseFormat;
    private static List<QuestEventDifficulty> easyOrder = Arrays.asList(QuestEventDifficulty.EASY, QuestEventDifficulty.MEDIUM, QuestEventDifficulty.HARD, QuestEventDifficulty.EXPERT);
    private static List<QuestEventDifficulty> mediumOrder = Arrays.asList(QuestEventDifficulty.MEDIUM, QuestEventDifficulty.HARD, QuestEventDifficulty.EASY, QuestEventDifficulty.EXPERT);
    private static List<QuestEventDifficulty> hardOrder = Arrays.asList(QuestEventDifficulty.HARD, QuestEventDifficulty.MEDIUM, QuestEventDifficulty.EASY, QuestEventDifficulty.EXPERT);
    private static List<QuestEventDifficulty> expertOrder = Arrays.asList(QuestEventDifficulty.EXPERT, QuestEventDifficulty.HARD, QuestEventDifficulty.MEDIUM, QuestEventDifficulty.EASY);

    public QuestEventLDADuelManager(GameFormat baseFormat) {
        this.baseFormat = baseFormat;
        this.archetypes = CardArchetypeLDAGenerator.ldaArchetypes.get(baseFormat.getName());
        this.assembleDuelDifficultyLists();
    }

    private void assembleDuelDifficultyLists() {
        this.sortedDuels.clear();
        this.sortedDuels.put(QuestEventDifficulty.EASY, (QuestEventDuel)((Object)new ArrayList()));
        this.sortedDuels.put(QuestEventDifficulty.MEDIUM, (QuestEventDuel)((Object)new ArrayList()));
        this.sortedDuels.put(QuestEventDifficulty.HARD, (QuestEventDuel)((Object)new ArrayList()));
        this.sortedDuels.put(QuestEventDifficulty.EXPERT, (QuestEventDuel)((Object)new ArrayList()));
        int i = 0;
        for (Archetype archetype : this.archetypes) {
            QuestEventLDADuel duel = new QuestEventLDADuel(archetype, this.baseFormat);
            duel.setDescription("Randomly generated " + archetype.getName() + " archetype deck.");
            duel.setName(archetype.getName());
            duel.setTitle(archetype.getName());
            duel.setOpponentName(archetype.getName());
            QuestEventDifficulty diff = QuestEventDifficulty.EASY;
            if ((double)i <= (double)this.archetypes.size() * 0.1) {
                diff = QuestEventDifficulty.EXPERT;
            } else if ((double)i <= (double)this.archetypes.size() * 0.4) {
                diff = QuestEventDifficulty.HARD;
            } else if ((double)i <= (double)this.archetypes.size() * 0.7) {
                diff = QuestEventDifficulty.MEDIUM;
            }
            duel.setDifficulty(diff);
            this.sortedDuels.add(diff, duel);
            ++i;
        }
    }

    private void addRandomDuel(List<QuestEventDuel> listOfDuels, QuestEventDifficulty difficulty) {
        QuestEventDifficulty diff;
        QuestEventDuel duel = new QuestEventDuel();
        List<QuestEventDifficulty> difficultyOrder = this.getOrderForDifficulty(difficulty);
        ArrayList possibleDuels = new ArrayList();
        Iterator<QuestEventDifficulty> iterator = difficultyOrder.iterator();
        while (iterator.hasNext() && (possibleDuels = new ArrayList((Collection)this.sortedDuels.get((Object)(diff = iterator.next())))).isEmpty()) {
        }
        QuestEventDuel randomOpponent = (QuestEventDuel)possibleDuels.get((int)((double)possibleDuels.size() * MyRandom.getRandom().nextDouble()));
        duel.setTitle("Random Opponent");
        duel.setIconImageKey(randomOpponent.getIconImageKey());
        duel.setOpponentName(randomOpponent.getTitle());
        duel.setDifficulty(difficulty);
        duel.setProfile(randomOpponent.getProfile());
        duel.setShowDifficulty(false);
        duel.setDescription("Fight a random opponent");
        duel.setEventDeck(randomOpponent.getEventDeck());
        listOfDuels.add(duel);
    }

    @Override
    public final List<QuestEventDuel> generateDuels() {
        boolean moreDuelChoices;
        QuestPreferences questPreferences = FModel.getQuestPreferences();
        boolean bl = moreDuelChoices = questPreferences.getPrefInt(QuestPreferences.QPref.MORE_DUEL_CHOICES) > 0;
        if (FModel.getQuest().getAchievements() == null) {
            return null;
        }
        QuestController qCtrl = FModel.getQuest();
        int numberOfWins = qCtrl.getAchievements().getWin();
        int index = qCtrl.getAchievements().getDifficulty();
        ArrayList<QuestEventDuel> duelOpponents = new ArrayList<QuestEventDuel>();
        QuestEventDifficulty randomDuelDifficulty = QuestEventDifficulty.EASY;
        if (numberOfWins < questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_MEDIUMAI, index)) {
            this.addDuel(duelOpponents, QuestEventDifficulty.EASY, 3);
            randomDuelDifficulty = QuestEventDifficulty.EASY;
        } else if (numberOfWins == questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_MEDIUMAI, index)) {
            this.addDuel(duelOpponents, QuestEventDifficulty.EASY, 1);
            this.addDuel(duelOpponents, QuestEventDifficulty.MEDIUM, 2);
            randomDuelDifficulty = QuestEventDifficulty.MEDIUM;
        } else if (numberOfWins < questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_HARDAI, index)) {
            this.addDuel(duelOpponents, QuestEventDifficulty.MEDIUM, 3);
            randomDuelDifficulty = QuestEventDifficulty.MEDIUM;
        } else if (numberOfWins == questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_HARDAI, index)) {
            this.addDuel(duelOpponents, QuestEventDifficulty.MEDIUM, 1);
            this.addDuel(duelOpponents, QuestEventDifficulty.HARD, 2);
            randomDuelDifficulty = QuestEventDifficulty.HARD;
        } else if (numberOfWins < questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_EXPERTAI, index)) {
            this.addDuel(duelOpponents, QuestEventDifficulty.HARD, 3);
            randomDuelDifficulty = QuestEventDifficulty.HARD;
        } else {
            this.addDuel(duelOpponents, QuestEventDifficulty.HARD, 2);
            this.addDuel(duelOpponents, QuestEventDifficulty.EXPERT, 1);
            randomDuelDifficulty = MyRandom.getRandom().nextDouble() * 3.0 < 2.0 ? QuestEventDifficulty.HARD : QuestEventDifficulty.EXPERT;
        }
        if (moreDuelChoices) {
            if (numberOfWins == questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_MEDIUMAI, index)) {
                this.addDuel(duelOpponents, QuestEventDifficulty.EASY, 1);
            } else if (numberOfWins < questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_HARDAI, index)) {
                this.addDuel(duelOpponents, QuestEventDifficulty.EASY, 1);
            } else if (numberOfWins == questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_HARDAI, index)) {
                this.addDuel(duelOpponents, QuestEventDifficulty.MEDIUM, 1);
            } else {
                this.addDuel(duelOpponents, QuestEventDifficulty.MEDIUM, 1);
                this.addDuel(duelOpponents, QuestEventDifficulty.EASY, 1);
            }
        }
        this.addRandomDuel(duelOpponents, randomDuelDifficulty);
        return duelOpponents;
    }

    private void addDuel(List<QuestEventDuel> outList, QuestEventDifficulty targetDifficulty, int toAdd) {
        List<QuestEventDifficulty> difficultyOrder = this.getOrderForDifficulty(targetDifficulty);
        for (QuestEventDifficulty d : difficultyOrder) {
            for (QuestEventDuel duel : (Collection)this.sortedDuels.get((Object)d)) {
                if (toAdd <= 0) {
                    return;
                }
                if (outList.contains(duel)) continue;
                outList.add(duel);
                --toAdd;
            }
        }
    }

    private List<QuestEventDifficulty> getOrderForDifficulty(QuestEventDifficulty d) {
        List<QuestEventDifficulty> difficultyOrder;
        switch (d) {
            case EASY: {
                difficultyOrder = easyOrder;
                break;
            }
            case MEDIUM: {
                difficultyOrder = mediumOrder;
                break;
            }
            case HARD: {
                difficultyOrder = hardOrder;
                break;
            }
            case EXPERT: {
                difficultyOrder = expertOrder;
                break;
            }
            default: {
                throw new RuntimeException("unhandled difficulty: " + (Object)((Object)d));
            }
        }
        return difficultyOrder;
    }

    @Override
    public Iterable<QuestEventDuel> getAllDuels() {
        return new ArrayList<QuestEventDuel>();
    }

    @Override
    public Iterable<QuestEventDuel> getDuels(QuestEventDifficulty difficulty) {
        return (Iterable)this.sortedDuels.get((Object)difficulty);
    }

    @Override
    public void randomizeOpponents() {
        for (QuestEventDifficulty qd : this.sortedDuels.keySet()) {
            List list = (List)this.sortedDuels.get((Object)qd);
            Collections.shuffle(list, MyRandom.getRandom());
        }
    }
}

