/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import forge.gamemodes.quest.data.QuestPreferences;
import forge.model.FModel;
import org.apache.commons.lang3.StringUtils;

public enum QuestEventDifficulty {
    EASY("easy", 1.0),
    MEDIUM("medium", 1.5),
    HARD("hard", 2.0),
    EXPERT("very hard", 3.0),
    WILD("wild", FModel.getQuestPreferences().getPrefDouble(QuestPreferences.QPref.WILD_OPPONENTS_MULTIPLIER));

    private final String inFile;
    private final double multiplier;

    private QuestEventDifficulty(String storedInFile, double multiplier) {
        this.inFile = storedInFile;
        this.multiplier = multiplier;
    }

    public final String getTitle() {
        return this.inFile;
    }

    public final double getMultiplier() {
        return this.multiplier;
    }

    public static QuestEventDifficulty fromString(String src) {
        if (StringUtils.isBlank(src)) {
            return MEDIUM;
        }
        for (QuestEventDifficulty qd : QuestEventDifficulty.values()) {
            if (!src.equalsIgnoreCase(qd.inFile) && !src.equalsIgnoreCase(qd.name())) continue;
            return qd;
        }
        return null;
    }
}

