/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.collect.Lists;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckSection;
import forge.game.Game;
import forge.game.GameRules;
import forge.game.GameType;
import forge.game.Match;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.limited.LimitedDeckEvaluator;
import forge.gamemodes.match.HostedMatch;
import forge.gamemodes.quest.QuestEventDraft;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.tournament.system.TournamentBracket;
import forge.gamemodes.tournament.system.TournamentPairing;
import forge.gamemodes.tournament.system.TournamentPlayer;
import forge.gui.GuiBase;
import forge.gui.interfaces.IGuiGame;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.MyRandom;
import forge.util.storage.IStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QuestDraftUtils {
    public static boolean TOURNAMENT_TOGGLE = false;
    public static boolean AI_BACKGROUND = false;
    public static boolean matchInProgress = false;
    private static boolean waitForUserInput = false;
    private static final List<DraftMatchup> matchups = new ArrayList<DraftMatchup>();

    public static void completeDraft(DeckGroup finishedDraft) {
        ArrayList<Deck> aiDecks = new ArrayList<Deck>(finishedDraft.getAiDecks());
        finishedDraft.getAiDecks().clear();
        for (int i = 0; i < aiDecks.size(); ++i) {
            Deck oldDeck = (Deck)aiDecks.get(i);
            Deck namedDeck = new Deck("AI Deck " + i);
            namedDeck.putSection(DeckSection.Main, oldDeck.get(DeckSection.Main));
            namedDeck.putSection(DeckSection.Sideboard, oldDeck.get(DeckSection.Sideboard));
            finishedDraft.getAiDecks().add(namedDeck);
        }
        IStorage<DeckGroup> draft = FModel.getQuest().getDraftDecks();
        draft.add(finishedDraft);
        FModel.getQuest().save();
    }

    public static String getDeckLegality() {
        if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) {
            return null;
        }
        return GameType.QuestDraft.getDeckFormat().getDeckConformanceProblem(((DeckGroup)FModel.getQuest().getAssets().getDraftDeckStorage().get("Tournament Deck")).getHumanDeck());
    }

    private static int getPreviousMatchup(int position) {
        switch (position) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return 4;
            }
            case 6: 
            case 7: {
                return 6;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 6;
            }
            case 12: {
                return 8;
            }
            case 13: {
                return 10;
            }
            case 14: {
                return 12;
            }
        }
        return -1;
    }

    public static void startNextMatchInTournament(IGuiGame gui) {
        QuestEventDraft draft = FModel.getQuest().getAchievements().getCurrentDraft();
        TournamentBracket bracket = draft.getBracket();
        TournamentPairing pairing = bracket.getNextPairing();
        if (pairing == null && !bracket.isTournamentOver()) {
            bracket.generateActivePairings();
            pairing = bracket.getNextPairing();
        }
        QuestDraftUtils.updateFromTournament(gui);
    }

    public static void startNextMatch(IGuiGame gui) {
        int latestSet;
        if (TOURNAMENT_TOGGLE) {
            QuestDraftUtils.startNextMatchInTournament(gui);
            return;
        }
        if (!matchups.isEmpty()) {
            return;
        }
        matchups.clear();
        QuestEventDraft draft = FModel.getQuest().getAchievements().getCurrentDraft();
        String[] currentStandings = draft.getStandings();
        int currentSet = -1;
        for (int i = currentStandings.length - 1; i >= 0; --i) {
            if (currentStandings[i].equals("quest_draft_undetermined_place")) continue;
            currentSet = i;
            break;
        }
        if ((latestSet = currentSet) % 2 == 1) {
            --latestSet;
        }
        if (latestSet == currentStandings.length - 1) {
            return;
        }
        boolean foundMatchups = false;
        for (int i = 0; i <= latestSet && i <= 14; i += 2) {
            int previousMatchup;
            if (currentStandings[i].equals("quest_draft_undetermined_place") && !currentStandings[i + 1].equals("quest_draft_undetermined_place")) {
                previousMatchup = QuestDraftUtils.getPreviousMatchup(i);
                QuestDraftUtils.addMatchup(previousMatchup, previousMatchup + 1, draft);
                foundMatchups = true;
                continue;
            }
            if (!currentStandings[i].equals("quest_draft_undetermined_place") && currentStandings[i + 1].equals("quest_draft_undetermined_place")) {
                previousMatchup = QuestDraftUtils.getPreviousMatchup(i + 1);
                QuestDraftUtils.addMatchup(previousMatchup, previousMatchup + 1, draft);
                foundMatchups = true;
                continue;
            }
            if (!currentStandings[i].equals("quest_draft_undetermined_place") || !currentStandings[i + 1].equals("quest_draft_undetermined_place")) continue;
            previousMatchup = QuestDraftUtils.getPreviousMatchup(i);
            QuestDraftUtils.addMatchup(previousMatchup, previousMatchup + 1, draft);
            if (i >= 8) {
                previousMatchup = QuestDraftUtils.getPreviousMatchup(i + 1);
                QuestDraftUtils.addMatchup(previousMatchup, previousMatchup + 1, draft);
            }
            foundMatchups = true;
        }
        if (!foundMatchups) {
            switch (currentSet) {
                case 7: {
                    QuestDraftUtils.addMatchup(0, 1, draft);
                }
                case 8: {
                    QuestDraftUtils.addMatchup(2, 3, draft);
                }
                case 9: {
                    QuestDraftUtils.addMatchup(4, 5, draft);
                }
                case 10: {
                    QuestDraftUtils.addMatchup(6, 7, draft);
                    break;
                }
                case 11: {
                    QuestDraftUtils.addMatchup(8, 9, draft);
                }
                case 12: {
                    QuestDraftUtils.addMatchup(10, 11, draft);
                    break;
                }
                case 13: {
                    QuestDraftUtils.addMatchup(12, 13, draft);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        QuestDraftUtils.update(gui);
    }

    private static void addMatchup(int player1, int player2, QuestEventDraft draft) {
        DraftMatchup matchup = new DraftMatchup();
        DeckGroup decks = (DeckGroup)FModel.getQuest().getAssets().getDraftDeckStorage().get("Tournament Deck");
        int humanIndex = -1;
        int aiIndex = -1;
        if (draft.getStandings()[player1].equals("quest_draft_human_place")) {
            humanIndex = player1;
            aiIndex = player2;
        } else if (draft.getStandings()[player2].equals("quest_draft_human_place")) {
            humanIndex = player2;
            aiIndex = player1;
        }
        if (humanIndex > -1) {
            matchup.setHumanPlayer(new RegisteredPlayer(decks.getHumanDeck()).setPlayer(GamePlayerUtil.getGuiPlayer()));
            int aiName = Integer.parseInt(draft.getStandings()[aiIndex]) - 1;
            int aiDeckIndex = Integer.parseInt(draft.getStandings()[aiIndex]) - 1;
            matchup.matchStarter.add(new RegisteredPlayer(decks.getAiDecks().get(aiDeckIndex)).setPlayer(GamePlayerUtil.createAiPlayer(draft.getAINames()[aiName], draft.getAIIcons()[aiName])));
        } else {
            int aiName1 = Integer.parseInt(draft.getStandings()[player1]) - 1;
            int aiName2 = Integer.parseInt(draft.getStandings()[player2]) - 1;
            int aiDeckIndex = Integer.parseInt(draft.getStandings()[player1]) - 1;
            matchup.matchStarter.add(new RegisteredPlayer(decks.getAiDecks().get(aiDeckIndex)).setPlayer(GamePlayerUtil.createAiPlayer(draft.getAINames()[aiName1], draft.getAIIcons()[aiName1])));
            aiDeckIndex = Integer.parseInt(draft.getStandings()[player2]) - 1;
            matchup.matchStarter.add(new RegisteredPlayer(decks.getAiDecks().get(aiDeckIndex)).setPlayer(GamePlayerUtil.createAiPlayer(draft.getAINames()[aiName2], draft.getAIIcons()[aiName2])));
        }
        matchups.add(matchup);
    }

    private static GameRules createQuestDraftRuleset() {
        GameRules rules = new GameRules(GameType.QuestDraft);
        rules.setPlayForAnte(false);
        rules.setMatchAnteRarity(false);
        rules.setGamesPerMatch(3);
        rules.setManaBurn(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_MANABURN));
        rules.setUseGrayText(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_GRAY_INACTIVE_TEXT));
        return rules;
    }

    public static void update(IGuiGame gui) {
        if (TOURNAMENT_TOGGLE) {
            QuestDraftUtils.updateFromTournament(gui);
            return;
        }
        if (matchups.isEmpty()) {
            return;
        }
        if (waitForUserInput || matchInProgress) {
            return;
        }
        gui.enableOverlay();
        DraftMatchup nextMatch = matchups.remove(0);
        if (nextMatch.hasHumanPlayer()) {
            waitForUserInput = true;
        } else {
            if (FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.SIMULATE_AI_VS_AI_RESULTS) == 1 || GuiBase.getInterface().isLibgdxPort()) {
                return;
            }
            gui.disableOverlay();
            waitForUserInput = false;
        }
        matchInProgress = true;
        GameRules rules = QuestDraftUtils.createQuestDraftRuleset();
        HostedMatch newMatch = GuiBase.getInterface().hostMatch();
        newMatch.startMatch(rules, null, (List<RegisteredPlayer>)nextMatch.matchStarter, nextMatch.humanPlayer, GuiBase.getInterface().getNewGuiGame());
    }

    private static List<RegisteredPlayer> registerTournamentPlayers(TournamentPairing pairing, QuestEventDraft draft, DeckGroup decks) {
        ArrayList<RegisteredPlayer> registered = Lists.newArrayList();
        for (TournamentPlayer pl : pairing.getPairedPlayers()) {
            if (pl.getIndex() == -1) {
                registered.add(new RegisteredPlayer(decks.getHumanDeck()).setPlayer(pl.getPlayer()));
                continue;
            }
            registered.add(new RegisteredPlayer(decks.getAiDecks().get(pl.getIndex())).setPlayer(pl.getPlayer()));
        }
        return registered;
    }

    private static void updateFromTournament(IGuiGame gui) {
        if (waitForUserInput || matchInProgress || gui == null) {
            return;
        }
        gui.enableOverlay();
        QuestEventDraft draft = FModel.getQuest().getAchievements().getCurrentDraft();
        if (draft == null) {
            return;
        }
        TournamentBracket bracket = draft.getBracket();
        TournamentPairing pairing = bracket.getNextPairing();
        if (pairing == null) {
            gui.disableOverlay();
            return;
        }
        matchInProgress = true;
        DeckGroup decks = (DeckGroup)FModel.getQuest().getAssets().getDraftDeckStorage().get("Tournament Deck");
        boolean waitForUserInput = pairing.hasPlayer(GamePlayerUtil.getGuiPlayer());
        GameRules rules = QuestDraftUtils.createQuestDraftRuleset();
        List<RegisteredPlayer> registered = TournamentBracket.registerTournamentPlayers(pairing, decks);
        RegisteredPlayer registeredHuman = null;
        if (waitForUserInput) {
            HostedMatch newMatch = GuiBase.getInterface().hostMatch();
            for (RegisteredPlayer rp : registered) {
                if (!rp.getPlayer().equals(GamePlayerUtil.getGuiPlayer())) continue;
                registeredHuman = rp;
            }
            newMatch.startMatch(rules, null, registered, registeredHuman, GuiBase.getInterface().getNewGuiGame());
        } else {
            gui.disableOverlay();
            if (AI_BACKGROUND) {
                System.out.println("Spawning a thread to simulate the match");
                Match mc = new Match(rules, registered, "Simulated Match");
                Object winner = null;
                while (!mc.isMatchOver()) {
                    Game gm = mc.createGame();
                    mc.startGame(gm);
                }
                RegisteredPlayer regPlayer = mc.getWinner();
                gui.finishGame();
            } else {
                HostedMatch newMatch = GuiBase.getInterface().hostMatch();
                newMatch.startMatch(rules, null, registered, registeredHuman, GuiBase.getInterface().getNewGuiGame());
            }
        }
    }

    public static void continueMatches(IGuiGame gui) {
        waitForUserInput = false;
        QuestDraftUtils.update(gui);
    }

    public static void cancelFurtherMatches() {
        matchInProgress = false;
        waitForUserInput = false;
        matchups.clear();
        if (TOURNAMENT_TOGGLE) {
            QuestEventDraft draft = FModel.getQuest().getAchievements().getCurrentDraft();
            TournamentBracket bracket = draft.getBracket();
            bracket.endTournament();
        }
    }

    private static double rankDraftDeckValue(String sid) {
        DeckGroup draftDecks = FModel.getQuest().getDraftDecks().get("Tournament Deck");
        Deck d = sid.equals("quest_draft_human_place") ? draftDecks.getHumanDeck() : draftDecks.getAiDecks().get(Integer.parseInt(sid) - 1);
        return LimitedDeckEvaluator.getDeckDraftValue(d);
    }

    public static boolean isNextMatchAIvsAI() {
        QuestEventDraft qd = FModel.getQuest().getAchievements().getCurrentDraft();
        int pos = Arrays.asList(qd.getStandings()).indexOf("quest_draft_undetermined_place");
        if (pos == -1) {
            return false;
        }
        int offset = (pos - 8) * 2;
        String sid1 = qd.getStandings()[offset];
        String sid2 = qd.getStandings()[offset + 1];
        return !sid1.equals("quest_draft_human_place") && !sid2.equals("quest_draft_human_place");
    }

    public static boolean injectRandomMatchOutcome(boolean simHumanMatches) {
        matchInProgress = true;
        QuestEventDraft qd = FModel.getQuest().getAchievements().getCurrentDraft();
        int pos = Arrays.asList(qd.getStandings()).indexOf("quest_draft_undetermined_place");
        if (pos == -1) {
            matchInProgress = false;
            return true;
        }
        int offset = (pos - 8) * 2;
        String sid1 = qd.getStandings()[offset];
        String sid2 = qd.getStandings()[offset + 1];
        if ((sid1.equals("quest_draft_human_place") || sid2.equals("quest_draft_human_place")) && !simHumanMatches) {
            matchInProgress = false;
            return false;
        }
        double deck1Value = QuestDraftUtils.rankDraftDeckValue(sid1);
        double deck2Value = QuestDraftUtils.rankDraftDeckValue(sid2);
        boolean strongerDeckWon = MyRandom.getRandom().nextInt(100) < 75;
        qd.getStandings()[pos] = strongerDeckWon ? (deck1Value > deck2Value ? sid1 : sid2) : (deck1Value > deck2Value ? sid2 : sid1);
        FModel.getQuest().save();
        matchInProgress = false;
        return true;
    }

    private static final class DraftMatchup {
        private final List<RegisteredPlayer> matchStarter = new ArrayList<RegisteredPlayer>();
        private RegisteredPlayer humanPlayer = null;

        private DraftMatchup() {
        }

        private void setHumanPlayer(RegisteredPlayer humanPlayer) {
            this.matchStarter.add(humanPlayer);
            this.humanPlayer = humanPlayer;
        }

        private boolean hasHumanPlayer() {
            return this.humanPlayer != null;
        }
    }

    public static enum Mode {
        EMPTY,
        SELECT_TOURNAMENT,
        PREPARE_DECK,
        TOURNAMENT_ACTIVE;

    }
}

