/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEventDifficulty;
import forge.gamemodes.quest.QuestEventDuel;
import forge.gamemodes.quest.QuestEventDuelManagerInterface;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.quest.io.MainWorldDuelReader;
import forge.model.FModel;
import forge.util.CollectionSuppliers;
import forge.util.MyRandom;
import forge.util.maps.EnumMapOfLists;
import forge.util.maps.MapOfLists;
import forge.util.storage.IStorage;
import forge.util.storage.StorageBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MainWorldEventDuelManager
implements QuestEventDuelManagerInterface {
    protected final MapOfLists<QuestEventDifficulty, QuestEventDuel> sortedDuels = new EnumMapOfLists(QuestEventDifficulty.class, CollectionSuppliers.arrayLists());
    protected final IStorage<QuestEventDuel> allDuels;
    private static List<QuestEventDifficulty> easyOrder = Arrays.asList(QuestEventDifficulty.EASY, QuestEventDifficulty.MEDIUM, QuestEventDifficulty.HARD, QuestEventDifficulty.EXPERT);
    private static List<QuestEventDifficulty> mediumOrder = Arrays.asList(QuestEventDifficulty.MEDIUM, QuestEventDifficulty.HARD, QuestEventDifficulty.EASY, QuestEventDifficulty.EXPERT);
    private static List<QuestEventDifficulty> hardOrder = Arrays.asList(QuestEventDifficulty.HARD, QuestEventDifficulty.MEDIUM, QuestEventDifficulty.EASY, QuestEventDifficulty.EXPERT);
    private static List<QuestEventDifficulty> expertOrder = Arrays.asList(QuestEventDifficulty.EXPERT, QuestEventDifficulty.HARD, QuestEventDifficulty.MEDIUM, QuestEventDifficulty.EASY);
    private static List<QuestEventDifficulty> wildOrder = Arrays.asList(QuestEventDifficulty.WILD);

    public MainWorldEventDuelManager(File dir) {
        this.allDuels = new StorageBase<QuestEventDuel>("Quest duels", new MainWorldDuelReader(dir));
        this.assembleDuelDifficultyLists();
    }

    @Override
    public Iterable<QuestEventDuel> getAllDuels() {
        return this.allDuels;
    }

    @Override
    public Iterable<QuestEventDuel> getDuels(QuestEventDifficulty difficulty) {
        return (Iterable)this.sortedDuels.get((Object)difficulty);
    }

    private List<QuestEventDifficulty> getOrderForDifficulty(QuestEventDifficulty d) {
        List<QuestEventDifficulty> difficultyOrder;
        switch (d) {
            case EASY: {
                difficultyOrder = easyOrder;
                break;
            }
            case MEDIUM: {
                difficultyOrder = mediumOrder;
                break;
            }
            case HARD: {
                difficultyOrder = hardOrder;
                break;
            }
            case EXPERT: {
                difficultyOrder = expertOrder;
                break;
            }
            case WILD: {
                difficultyOrder = wildOrder;
                break;
            }
            default: {
                throw new RuntimeException("unhandled difficulty: " + (Object)((Object)d));
            }
        }
        return difficultyOrder;
    }

    private void addDuel(List<QuestEventDuel> outList, QuestEventDifficulty targetDifficulty, int toAdd) {
        if (this.allDuels.size() <= toAdd) {
            return;
        }
        List<QuestEventDifficulty> difficultyOrder = this.getOrderForDifficulty(targetDifficulty);
        for (QuestEventDifficulty d : difficultyOrder) {
            for (QuestEventDuel duel : (Collection)this.sortedDuels.get((Object)d)) {
                if (toAdd <= 0) {
                    return;
                }
                if (outList.contains(duel)) continue;
                outList.add(duel);
                --toAdd;
            }
        }
    }

    private void addRandomDuel(List<QuestEventDuel> listOfDuels, QuestEventDifficulty difficulty) {
        QuestEventDifficulty diff;
        QuestEventDuel duel = new QuestEventDuel();
        List<QuestEventDifficulty> difficultyOrder = this.getOrderForDifficulty(difficulty);
        ArrayList possibleDuels = new ArrayList();
        Iterator<QuestEventDifficulty> iterator = difficultyOrder.iterator();
        while (iterator.hasNext() && (possibleDuels = new ArrayList((Collection)this.sortedDuels.get((Object)(diff = iterator.next())))).isEmpty()) {
        }
        QuestEventDuel randomOpponent = (QuestEventDuel)possibleDuels.get((int)((double)possibleDuels.size() * MyRandom.getRandom().nextDouble()));
        duel.setTitle("Random Opponent");
        duel.setIconImageKey(randomOpponent.getIconImageKey());
        duel.setOpponentName(randomOpponent.getTitle());
        duel.setDifficulty(difficulty);
        duel.setProfile(randomOpponent.getProfile());
        duel.setShowDifficulty(false);
        duel.setDescription("Fight a random opponent");
        duel.setEventDeck(randomOpponent.getEventDeck());
        listOfDuels.add(duel);
    }

    @Override
    public final List<QuestEventDuel> generateDuels() {
        boolean moreDuelChoices;
        QuestPreferences questPreferences = FModel.getQuestPreferences();
        boolean bl = moreDuelChoices = questPreferences.getPrefInt(QuestPreferences.QPref.MORE_DUEL_CHOICES) > 0;
        if (FModel.getQuest().getAchievements() == null) {
            return null;
        }
        QuestController qCtrl = FModel.getQuest();
        int numberOfWins = qCtrl.getAchievements().getWin();
        int index = qCtrl.getAchievements().getDifficulty();
        ArrayList<QuestEventDuel> duelOpponents = new ArrayList<QuestEventDuel>();
        QuestEventDifficulty randomDuelDifficulty = QuestEventDifficulty.EASY;
        double randomDouble = MyRandom.getRandom().nextDouble();
        if (numberOfWins < questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_MEDIUMAI, index)) {
            this.addDuel(duelOpponents, QuestEventDifficulty.EASY, 3);
            randomDuelDifficulty = this.areWildDecksWanted() && this.isWildDeckAvailable() && randomDouble * 2.0 < 1.0 ? QuestEventDifficulty.WILD : QuestEventDifficulty.EASY;
        } else if (numberOfWins == questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_MEDIUMAI, index)) {
            this.addDuel(duelOpponents, QuestEventDifficulty.EASY, 1);
            this.addDuel(duelOpponents, QuestEventDifficulty.MEDIUM, 2);
            randomDuelDifficulty = this.areWildDecksWanted() && this.isWildDeckAvailable() && randomDouble * 2.0 < 1.0 ? QuestEventDifficulty.WILD : QuestEventDifficulty.MEDIUM;
        } else if (numberOfWins < questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_HARDAI, index)) {
            this.addDuel(duelOpponents, QuestEventDifficulty.MEDIUM, 3);
            randomDuelDifficulty = QuestEventDifficulty.MEDIUM;
        } else if (numberOfWins == questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_HARDAI, index)) {
            this.addDuel(duelOpponents, QuestEventDifficulty.MEDIUM, 1);
            this.addDuel(duelOpponents, QuestEventDifficulty.HARD, 2);
            randomDuelDifficulty = this.areWildDecksWanted() && this.isWildDeckAvailable() && randomDouble * 2.0 < 1.0 ? QuestEventDifficulty.WILD : QuestEventDifficulty.HARD;
        } else if (numberOfWins < questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_EXPERTAI, index)) {
            this.addDuel(duelOpponents, QuestEventDifficulty.HARD, 3);
            randomDuelDifficulty = this.areWildDecksWanted() && this.isWildDeckAvailable() && randomDouble * 2.0 < 1.0 ? QuestEventDifficulty.WILD : QuestEventDifficulty.HARD;
        } else {
            this.addDuel(duelOpponents, QuestEventDifficulty.HARD, 2);
            this.addDuel(duelOpponents, QuestEventDifficulty.EXPERT, 1);
            randomDuelDifficulty = this.areWildDecksWanted() && this.isWildDeckAvailable() ? (randomDouble * 2.0 < 1.0 ? QuestEventDifficulty.WILD : (randomDouble * 6.0 < 5.0 ? QuestEventDifficulty.HARD : QuestEventDifficulty.EXPERT)) : (randomDouble * 3.0 < 2.0 ? QuestEventDifficulty.HARD : QuestEventDifficulty.EXPERT);
        }
        if (moreDuelChoices) {
            if (numberOfWins == questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_MEDIUMAI, index)) {
                this.addDuel(duelOpponents, QuestEventDifficulty.EASY, 1);
            } else if (numberOfWins < questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_HARDAI, index)) {
                this.addDuel(duelOpponents, QuestEventDifficulty.EASY, 1);
            } else if (numberOfWins == questPreferences.getPrefInt(QuestPreferences.DifficultyPrefs.WINS_HARDAI, index)) {
                this.addDuel(duelOpponents, QuestEventDifficulty.MEDIUM, 1);
            } else {
                this.addDuel(duelOpponents, QuestEventDifficulty.MEDIUM, 1);
                this.addDuel(duelOpponents, QuestEventDifficulty.EASY, 1);
            }
        }
        this.addDuel(duelOpponents, QuestEventDifficulty.WILD, FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.WILD_OPPONENTS_NUMBER));
        this.addRandomDuel(duelOpponents, randomDuelDifficulty);
        return duelOpponents;
    }

    private boolean areWildDecksWanted() {
        int wildOpponentsPreference = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.WILD_OPPONENTS_NUMBER);
        return wildOpponentsPreference > 0;
    }

    private boolean isWildDeckAvailable() {
        List wildList = (List)this.sortedDuels.get((Object)QuestEventDifficulty.WILD);
        return !wildList.isEmpty();
    }

    protected void assembleDuelDifficultyLists() {
        this.sortedDuels.clear();
        this.sortedDuels.put(QuestEventDifficulty.EASY, (QuestEventDuel)((Object)new ArrayList()));
        this.sortedDuels.put(QuestEventDifficulty.MEDIUM, (QuestEventDuel)((Object)new ArrayList()));
        this.sortedDuels.put(QuestEventDifficulty.HARD, (QuestEventDuel)((Object)new ArrayList()));
        this.sortedDuels.put(QuestEventDifficulty.EXPERT, (QuestEventDuel)((Object)new ArrayList()));
        this.sortedDuels.put(QuestEventDifficulty.WILD, (QuestEventDuel)((Object)new ArrayList()));
        for (QuestEventDuel qd : this.allDuels) {
            this.sortedDuels.add(qd.getDifficulty(), qd);
        }
    }

    @Override
    public void randomizeOpponents() {
        for (QuestEventDifficulty qd : this.sortedDuels.keySet()) {
            List list = (List)this.sortedDuels.get((Object)qd);
            Collections.shuffle(list, MyRandom.getRandom());
        }
    }
}

