/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.quest;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.card.PrintSheet;
import forge.game.GameFormat;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestRewardCardDuplicate;
import forge.gamemodes.quest.QuestRewardCardFiltered;
import forge.gamemodes.quest.QuestUtilCards;
import forge.gamemodes.quest.StartingPoolPreferences;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.item.BoosterPack;
import forge.item.IPaperCard;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.item.TournamentPack;
import forge.model.FModel;
import forge.util.Aggregates;
import forge.util.MyRandom;
import forge.util.PredicateString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class BoosterUtils {
    private static final List<Byte> possibleColors = new ArrayList<Byte>();
    private static final int RARES_PER_MYTHIC = 8;
    private static final int MAX_BIAS = 100;
    private static final int[] COLOR_COUNT_PROBABILITIES = new int[]{1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 6};
    private static final GameFormat.Collection formats = FModel.getFormats();
    private static final Predicate<CardEdition> filterPioneer = BoosterUtils.formats.getPioneer().editionLegalPredicate;
    private static final Predicate<CardEdition> filterModern = BoosterUtils.formats.getModern().editionLegalPredicate;
    private static final Predicate<CardEdition> filterStandard = Predicates.and(CardEdition.Predicates.CAN_MAKE_BOOSTER, BoosterUtils.formats.getStandard().editionLegalPredicate);
    private static final Predicate<CardEdition> filterPioneerNotStandard = Predicates.and(CardEdition.Predicates.CAN_MAKE_BOOSTER, Predicates.and(filterPioneer, Predicates.not(BoosterUtils.formats.getStandard().editionLegalPredicate)));
    private static final Predicate<CardEdition> filterModernNotPioneer = Predicates.and(CardEdition.Predicates.CAN_MAKE_BOOSTER, Predicates.and(filterModern, Predicates.not(filterPioneer)));
    private static final Predicate<CardEdition> filterNotModern = Predicates.and(CardEdition.Predicates.CAN_MAKE_BOOSTER, Predicates.not(filterModern));

    public static List<PaperCard> getQuestStarterDeck(GameFormat formatStartingPool, int numCommons, int numUncommons, int numRares, StartingPoolPreferences userPrefs) {
        if (possibleColors.isEmpty()) {
            possibleColors.add((byte)4);
            possibleColors.add((byte)2);
            possibleColors.add((byte)16);
            possibleColors.add((byte)8);
            possibleColors.add((byte)1);
            possibleColors.add((byte)0);
        }
        ArrayList<PaperCard> cards = new ArrayList<PaperCard>();
        if (userPrefs != null && userPrefs.getPoolType() == StartingPoolPreferences.PoolType.BOOSTERS) {
            for (InventoryItem inventoryItem : BoosterUtils.generateRandomBoosterPacks(userPrefs.getNumberOfBoosters(), formatStartingPool.editionLegalPredicate)) {
                cards.addAll(((BoosterPack)inventoryItem).getCards());
            }
            return cards;
        }
        Predicate<Object> filter = Predicates.alwaysTrue();
        if (formatStartingPool != null) {
            filter = formatStartingPool.getFilterPrinted();
        }
        ArrayList<PaperCard> cardPool = Lists.newArrayList(Iterables.filter(FModel.getMagicDb().getCommonCards().getAllNonPromoCards(), filter));
        if (userPrefs != null && userPrefs.grantCompleteSet()) {
            for (PaperCard card : cardPool) {
                cards.add(card);
                cards.add(card);
                cards.add(card);
                cards.add(card);
            }
            return cards;
        }
        boolean allowDuplicates = userPrefs != null && userPrefs.allowDuplicates();
        boolean mythicsAvailable = Iterables.any(cardPool, IPaperCard.Predicates.Presets.IS_MYTHIC_RARE);
        int numMythics = mythicsAvailable ? numRares / 8 : 0;
        int adjustedRares = numRares - numMythics;
        List<Predicate<CardRules>> colorFilters = BoosterUtils.getColorFilters(userPrefs, cardPool);
        cards.addAll(BoosterUtils.generateCards(cardPool, IPaperCard.Predicates.Presets.IS_COMMON, numCommons, colorFilters, allowDuplicates));
        cards.addAll(BoosterUtils.generateCards(cardPool, IPaperCard.Predicates.Presets.IS_UNCOMMON, numUncommons, colorFilters, allowDuplicates));
        cards.addAll(BoosterUtils.generateCards(cardPool, IPaperCard.Predicates.Presets.IS_RARE, adjustedRares, colorFilters, allowDuplicates));
        if (numMythics > 0) {
            cards.addAll(BoosterUtils.generateCards(cardPool, IPaperCard.Predicates.Presets.IS_MYTHIC_RARE, numMythics, colorFilters, allowDuplicates));
        }
        return cards;
    }

    public static List<InventoryItem> generateRandomBoosterPacks(int quantity, QuestController questController) {
        if (questController.getFormat() != null) {
            return BoosterUtils.generateRandomBoosterPacks(quantity, QuestUtilCards.isLegalInQuestFormat(questController.getFormat()));
        }
        int rollD100 = MyRandom.getRandom().nextInt(100);
        Predicate<CardEdition> rolledFilter = rollD100 < 30 ? filterStandard : (rollD100 < 50 ? filterPioneerNotStandard : (rollD100 < 70 ? filterModernNotPioneer : filterNotModern));
        return BoosterUtils.generateRandomBoosterPacks(quantity, rolledFilter);
    }

    public static List<InventoryItem> generateRandomBoosterPacks(int quantity, Predicate<CardEdition> editionFilter) {
        ArrayList<InventoryItem> output = new ArrayList<InventoryItem>();
        Predicate<CardEdition> filter = Predicates.and(CardEdition.Predicates.CAN_MAKE_BOOSTER, editionFilter);
        Iterable<CardEdition> possibleEditions = Iterables.filter(FModel.getMagicDb().getEditions(), filter);
        if (!possibleEditions.iterator().hasNext()) {
            System.err.println("No sets found in starting pool that can create boosters.");
            return output;
        }
        for (int i = 0; i < quantity; ++i) {
            CardEdition edition = Aggregates.random(possibleEditions);
            BoosterPack pack = BoosterPack.fromSet(edition);
            if (pack != null) {
                output.add(pack);
                continue;
            }
            System.err.println("Could not create booster of edition: " + edition);
        }
        return output;
    }

    private static List<Predicate<CardRules>> getColorFilters(StartingPoolPreferences userPrefs, List<PaperCard> cardPool) {
        ArrayList<Predicate<CardRules>> colorFilters = new ArrayList<Predicate<CardRules>>();
        if (userPrefs != null) {
            boolean includeArtifacts = userPrefs.includeArtifacts();
            List<Byte> preferredColors = userPrefs.getPreferredColors();
            switch (userPrefs.getPoolType()) {
                case RANDOM_BALANCED: {
                    preferredColors.clear();
                    int numberOfColors = COLOR_COUNT_PROBABILITIES[(int)(MyRandom.getRandom().nextDouble() * (double)COLOR_COUNT_PROBABILITIES.length)];
                    if (numberOfColors < 6) {
                        Collections.shuffle(possibleColors);
                        for (int i = 0; i < numberOfColors; ++i) {
                            preferredColors.add(possibleColors.get(i));
                        }
                    } else {
                        preferredColors.addAll(possibleColors);
                    }
                    includeArtifacts = MyRandom.getRandom().nextDouble() < 0.5;
                }
                case BALANCED: {
                    BoosterUtils.populateBalancedFilters(colorFilters, preferredColors, cardPool, includeArtifacts);
                    break;
                }
                case RANDOM: {
                    BoosterUtils.populateRandomFilters(colorFilters);
                    break;
                }
            }
        }
        return colorFilters;
    }

    private static void populateRandomFilters(List<Predicate<CardRules>> colorFilters) {
        for (int i = 0; i < 100; ++i) {
            byte color = possibleColors.get((int)(MyRandom.getRandom().nextDouble() * 6.0));
            Predicate<CardRules> predicate = MyRandom.getRandom().nextDouble() < 0.6 ? CardRulesPredicates.isMonoColor(color) : CardRulesPredicates.hasColor(color);
            if (MyRandom.getRandom().nextDouble() < 0.1) {
                predicate = Predicates.and(predicate, CardRulesPredicates.Presets.IS_MULTICOLOR);
            }
            colorFilters.add(predicate);
        }
    }

    private static void populateBalancedFilters(List<Predicate<CardRules>> colorFilters, List<Byte> preferredColors, List<PaperCard> cardPool, boolean includeArtifacts) {
        ArrayList<Byte> otherColors = new ArrayList<Byte>(possibleColors);
        otherColors.removeAll(preferredColors);
        int colorBias = FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.STARTING_POOL_COLOR_BIAS);
        double preferredBias = 0.0;
        if (preferredColors.isEmpty()) {
            colorBias = 0;
        } else {
            preferredBias = (double)colorBias / (double)preferredColors.size();
        }
        int usedMulticolor = 0;
        int usedPhyrexian = 0;
        for (int i = 0; i < 100; ++i) {
            if (i < colorBias) {
                int index = (int)((double)i / preferredBias);
                for (Byte ignored : otherColors) {
                    if (i % 8 == 0 && !preferredColors.contains((byte)0) && includeArtifacts) {
                        colorFilters.add(CardRulesPredicates.Presets.IS_ARTIFACT);
                        continue;
                    }
                    if (i % 5 == 0) {
                        Predicate predicateCard;
                        Predicate<CardRules> predicateRules;
                        if (preferredColors.contains((byte)0) && preferredColors.size() == 1) {
                            predicateRules = CardRulesPredicates.cost(PredicateString.StringOp.CONTAINS_IC, "p/");
                            predicateCard = Predicates.compose(predicateRules, PaperCard::getRules);
                            int size = Iterables.size(Iterables.filter(cardPool, predicateCard));
                            int totalSize = cardPool.size();
                            double phyrexianAmount = (double)size / (double)totalSize;
                            if ((double)usedPhyrexian < Math.min(1.0, phyrexianAmount *= 125.0)) {
                                colorFilters.add(predicateRules);
                                ++usedPhyrexian;
                                continue;
                            }
                        }
                        if (usedMulticolor / 8 < Iterables.size(Iterables.filter(cardPool, predicateCard = Predicates.compose(predicateRules = Predicates.and(CardRulesPredicates.isColor(preferredColors.get(index)), CardRulesPredicates.Presets.IS_MULTICOLOR), PaperCard::getRules)))) {
                            colorFilters.add(predicateRules);
                            ++usedMulticolor;
                            continue;
                        }
                        colorFilters.add(CardRulesPredicates.isColor(preferredColors.get(index)));
                        continue;
                    }
                    colorFilters.add(CardRulesPredicates.isMonoColor(preferredColors.get(index)));
                }
                continue;
            }
            for (Byte color : otherColors) {
                if (i % 6 == 0) {
                    colorFilters.add(Predicates.and(CardRulesPredicates.isColor(color), CardRulesPredicates.Presets.IS_MULTICOLOR));
                    continue;
                }
                colorFilters.add(CardRulesPredicates.isMonoColor(color));
            }
        }
    }

    private static List<PaperCard> generateCards(Iterable<PaperCard> source, Predicate<PaperCard> filter, int cntNeeded, List<Predicate<CardRules>> allowedColors, boolean allowDuplicates) {
        int size;
        ArrayList<PaperCard> result = new ArrayList<PaperCard>();
        int n = size = allowedColors == null ? 0 : allowedColors.size();
        if (allowedColors != null) {
            Collections.shuffle(allowedColors);
        }
        int cntMade = 0;
        int iAttempt = 0;
        int allowedMisses = (size + 4) * cntNeeded;
        int nullMisses = 0;
        while (cntMade < cntNeeded && allowedMisses > 0) {
            PaperCard card = null;
            if (size > 0) {
                Predicate<CardRules> color2 = allowedColors.get(iAttempt % size);
                int colorMisses = 0;
                do {
                    if (color2 == null) continue;
                    Predicate color2c = Predicates.compose(color2, PaperCard::getRules);
                    card = Aggregates.random(Iterables.filter(source, Predicates.and(filter, color2c)));
                } while (card == null && colorMisses++ < 10);
            }
            if (card == null) {
                if (nullMisses++ < 10) {
                    ++iAttempt;
                    continue;
                }
                nullMisses = 0;
            }
            if (card != null && (allowDuplicates || !result.contains(card))) {
                result.add(card);
                ++cntMade;
            } else {
                --allowedMisses;
            }
            ++iAttempt;
        }
        return result;
    }

    public static Predicate<CardRules> parseRulesLimitation(String input) {
        if (null == input || "random".equalsIgnoreCase(input)) {
            return Predicates.alwaysTrue();
        }
        if (input.equalsIgnoreCase("black")) {
            return CardRulesPredicates.Presets.IS_BLACK;
        }
        if (input.equalsIgnoreCase("blue")) {
            return CardRulesPredicates.Presets.IS_BLUE;
        }
        if (input.equalsIgnoreCase("green")) {
            return CardRulesPredicates.Presets.IS_GREEN;
        }
        if (input.equalsIgnoreCase("red")) {
            return CardRulesPredicates.Presets.IS_RED;
        }
        if (input.equalsIgnoreCase("white")) {
            return CardRulesPredicates.Presets.IS_WHITE;
        }
        if (input.equalsIgnoreCase("colorless")) {
            return CardRulesPredicates.Presets.IS_COLORLESS;
        }
        if (input.equalsIgnoreCase("multicolor")) {
            return CardRulesPredicates.Presets.IS_MULTICOLOR;
        }
        if (input.equalsIgnoreCase("land")) {
            return CardRulesPredicates.Presets.IS_LAND;
        }
        if (input.equalsIgnoreCase("creature")) {
            return CardRulesPredicates.Presets.IS_CREATURE;
        }
        if (input.equalsIgnoreCase("artifact")) {
            return CardRulesPredicates.Presets.IS_ARTIFACT;
        }
        if (input.equalsIgnoreCase("planeswalker")) {
            return CardRulesPredicates.Presets.IS_PLANESWALKER;
        }
        if (input.equalsIgnoreCase("instant")) {
            return CardRulesPredicates.Presets.IS_INSTANT;
        }
        if (input.equalsIgnoreCase("sorcery")) {
            return CardRulesPredicates.Presets.IS_SORCERY;
        }
        if (input.equalsIgnoreCase("enchantment")) {
            return CardRulesPredicates.Presets.IS_ENCHANTMENT;
        }
        throw new IllegalArgumentException("No CardRules limitations could be parsed from: " + input);
    }

    private static List<InventoryItem> parseReward(String s2) {
        PaperCard specific;
        String[] temp = s2.split(" ");
        ArrayList<InventoryItem> rewards = new ArrayList<InventoryItem>();
        if (temp.length > 1 && temp[temp.length - 1].regionMatches(true, 0, "rare", 0, 4)) {
            int qty = Integer.parseInt(temp[0]);
            ArrayList<Predicate<PaperCard>> preds = new ArrayList<Predicate<PaperCard>>();
            preds.add(IPaperCard.Predicates.Presets.IS_RARE_OR_MYTHIC);
            if (temp.length > 2) {
                Predicate<CardRules> cr = BoosterUtils.parseRulesLimitation(temp[1]);
                if (Predicates.alwaysTrue() != cr) {
                    preds.add(Predicates.compose(cr, PaperCard::getRules));
                }
            }
            if (FModel.getQuest().getFormat() != null) {
                preds.add(FModel.getQuest().getFormat().getFilterPrinted());
            }
            PrintSheet ps = new PrintSheet("Quest rewards");
            Predicate predicate = preds.size() == 1 ? (Predicate)preds.get(0) : Predicates.and(preds);
            ps.addAll(Iterables.filter(FModel.getMagicDb().getCommonCards().getAllNonPromoCards(), predicate));
            rewards.addAll(ps.random(qty, true));
        } else if (temp.length == 2 && temp[0].equalsIgnoreCase("duplicate") && temp[1].equalsIgnoreCase("card")) {
            rewards.add(new QuestRewardCardDuplicate());
        } else if (temp.length >= 2 && temp[0].equalsIgnoreCase("chosen") && temp[1].equalsIgnoreCase("card")) {
            rewards.add(new QuestRewardCardFiltered(temp));
        } else if (temp.length >= 3 && temp[0].equalsIgnoreCase("booster") && temp[1].equalsIgnoreCase("pack")) {
            CardEdition edition = FModel.getMagicDb().getEditions().get(temp[2]);
            rewards.add(BoosterPack.fromSet(edition));
        } else if (temp.length >= 3 && temp[0].equalsIgnoreCase("tournament") && temp[1].equalsIgnoreCase("pack")) {
            CardEdition edition = FModel.getMagicDb().getEditions().get(temp[2]);
            rewards.add(TournamentPack.fromSet(edition));
        } else if (temp.length > 0 && (specific = FModel.getMagicDb().getCommonCards().getCard(s2)) != null) {
            rewards.add(specific);
        }
        return rewards;
    }

    public static List<InventoryItem> generateCardRewardList(String s2) {
        if (StringUtils.isBlank(s2)) {
            return null;
        }
        String[] items = s2.split(";");
        ArrayList<InventoryItem> rewards = new ArrayList<InventoryItem>();
        for (String item : items) {
            List<InventoryItem> reward;
            String input = null;
            if (item.contains("%")) {
                String[] tmp = item.split("%");
                int chance = Integer.parseInt(tmp[0].trim());
                if (chance > 0 && tmp.length > 1 && MyRandom.percentTrue(chance)) {
                    input = tmp[1].trim();
                }
            } else {
                input = item;
            }
            if (input == null || (reward = BoosterUtils.parseReward(input)) == null) continue;
            rewards.addAll(reward);
        }
        return rewards;
    }

    public static void sort(List<PaperCard> cards) {
        cards.sort(Comparator.comparing(PaperCard::getName));
        cards.sort(Comparator.comparing(c -> c.getRules().getColor()));
        cards.sort(Comparator.comparing(PaperCard::getRarity).reversed());
    }
}

