/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.card.CardRulesPredicates;
import forge.card.ColorSet;
import forge.deck.generation.DeckGenPool;
import forge.game.card.Card;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gui.GuiBase;
import forge.item.PaperCard;
import forge.localinstance.skin.ISkinImage;
import forge.model.FModel;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionReader;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConquestRegion {
    private final ConquestPlane plane;
    private final String name;
    private final String artCardName;
    private final ColorSet colorSet;
    private final Predicate<PaperCard> pred;
    private final DeckGenPool cardPool = new DeckGenPool();
    private ISkinImage art;

    private ConquestRegion(ConquestPlane plane0, String name0, String artCardName0, ColorSet colorSet0, Predicate<PaperCard> pred0) {
        this.plane = plane0;
        this.name = name0;
        this.artCardName = artCardName0;
        this.pred = pred0;
        this.colorSet = colorSet0;
    }

    public ConquestPlane getPlane() {
        return this.plane;
    }

    public String getName() {
        return this.name;
    }

    public void clearArt() {
        this.art = null;
    }

    public ISkinImage getArt() {
        this.clearArt();
        if (this.art == null) {
            PaperCard pc = this.cardPool.getCard(this.artCardName);
            this.art = pc == null ? (!(pc = FModel.getMagicDb().getCommonCards().getUniqueByName(this.artCardName)).getName().equals(this.artCardName) && Card.fromPaperCard(pc, null).hasAlternateState() ? GuiBase.getInterface().getCardArt(pc, true) : GuiBase.getInterface().getCardArt(pc)) : GuiBase.getInterface().getCardArt(pc);
        }
        return this.art;
    }

    public ColorSet getColorSet() {
        return this.colorSet;
    }

    public DeckGenPool getCardPool() {
        return this.cardPool;
    }

    public FCollectionView<PaperCard> getCommanders() {
        FCollection<PaperCard> commanders = new FCollection<PaperCard>();
        for (PaperCard commander : this.plane.getCommanders()) {
            if (!this.cardPool.contains(commander)) continue;
            commanders.add(commander);
        }
        if (commanders.isEmpty()) {
            return this.plane.getCommanders();
        }
        return commanders;
    }

    public String toString() {
        return this.plane.getName().replace("_", " ") + " - " + this.name;
    }

    static void addCard(PaperCard pc, Iterable<ConquestRegion> regions) {
        boolean foundRegion = false;
        for (ConquestRegion region : regions) {
            if (!region.pred.apply(pc)) continue;
            region.cardPool.add(pc);
            foundRegion = true;
        }
        if (foundRegion) {
            return;
        }
        for (ConquestRegion region : regions) {
            region.cardPool.add(pc);
        }
    }

    public static Set<ConquestRegion> getAllRegionsOfCard(PaperCard card) {
        HashSet<ConquestRegion> regions = new HashSet<ConquestRegion>();
        for (ConquestPlane plane : FModel.getPlanes()) {
            if (!plane.getCardPool().contains(card)) continue;
            for (ConquestRegion region : plane.getRegions()) {
                if (!region.getCardPool().contains(card)) continue;
                regions.add(region);
            }
        }
        return regions;
    }

    public static List<ConquestRegion> getAllRegions() {
        ArrayList<ConquestRegion> regions = new ArrayList<ConquestRegion>();
        for (ConquestPlane plane : FModel.getPlanes()) {
            for (ConquestRegion region : plane.getRegions()) {
                regions.add(region);
            }
        }
        return regions;
    }

    public static class Reader
    extends FCollectionReader<ConquestRegion> {
        private final ConquestPlane plane;

        public Reader(ConquestPlane plane0) {
            super(plane0.getDirectory() + "regions.txt");
            this.plane = plane0;
        }

        @Override
        protected ConquestRegion read(String line) {
            String[] pieces;
            String name = null;
            String artCardName = null;
            ColorSet colorSet = ColorSet.ALL_COLORS;
            Predicate pred = Predicates.alwaysTrue();
            block12: for (String piece : pieces = line.split("\\|")) {
                String value;
                String key;
                int idx = piece.indexOf(58);
                if (idx != -1) {
                    key = piece.substring(0, idx).trim().toLowerCase();
                    value = piece.substring(idx + 1).trim();
                } else {
                    this.alertInvalidLine(line, "Invalid region definition.");
                    key = piece.trim().toLowerCase();
                    value = "";
                }
                switch (key) {
                    case "name": {
                        name = value;
                        continue block12;
                    }
                    case "art": {
                        artCardName = value;
                        continue block12;
                    }
                    case "colors": {
                        colorSet = ColorSet.fromNames(value.toCharArray());
                        pred = Predicates.compose(CardRulesPredicates.hasColorIdentity(colorSet.getColor()), PaperCard::getRules);
                        continue block12;
                    }
                    case "sets": {
                        String[] sets = value.split(",");
                        for (int i = 0; i < sets.length; ++i) {
                            sets[i] = sets[i].trim();
                        }
                        pred = pc -> {
                            for (String set : sets) {
                                if (!pc.getEdition().equals(set)) continue;
                                return true;
                            }
                            return false;
                        };
                        continue block12;
                    }
                    default: {
                        this.alertInvalidLine(line, "Invalid region definition.");
                    }
                }
            }
            return new ConquestRegion(this.plane, name, artCardName, colorSet, pred);
        }
    }
}

