/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import com.google.common.base.Function;
import forge.card.CardDb;
import forge.gamemodes.planarconquest.ConquestBattle;
import forge.gamemodes.planarconquest.ConquestCommander;
import forge.gamemodes.planarconquest.ConquestLocation;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestPlaneData;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.gamemodes.planarconquest.ConquestRecord;
import forge.gamemodes.planarconquest.IVConquestStats;
import forge.gui.util.SOptionPane;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemManagerConfig;
import forge.localinstance.achievements.PlaneswalkerAchievements;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.ISkinImage;
import forge.model.FModel;
import forge.util.CardTranslation;
import forge.util.FileUtil;
import forge.util.Localizer;
import forge.util.XmlReader;
import forge.util.XmlWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class ConquestData {
    private static final String XML_FILE = "data.xml";
    private File directory;
    private String name;
    private String xmlFilename;
    private PaperCard planeswalker;
    private ISkinImage planeswalkerToken;
    private ConquestLocation currentLocation;
    private int selectedCommanderIndex;
    private int aetherShards;
    private int planeswalkEmblems;
    private final ConquestRecord chaosBattleRecord;
    private final Map<String, ConquestPlaneData> planeDataMap = new HashMap<String, ConquestPlaneData>();
    private final HashSet<PaperCard> unlockedCards = new HashSet();
    private final List<ConquestCommander> commanders = new ArrayList<ConquestCommander>();
    private final HashSet<PaperCard> newCards = new HashSet();
    private final HashSet<PaperCard> exiledCards = new HashSet();
    private static final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnNewCompare = from -> FModel.getConquest().getModel().newCards.contains(from.getKey()) ? Integer.valueOf(1) : Integer.valueOf(0);
    private static final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnNewGet = from -> FModel.getConquest().getModel().newCards.contains(from.getKey()) ? "NEW" : "";

    public ConquestData(String name0, ConquestPlane startingPlane0, PaperCard startingPlaneswalker0, PaperCard startingCommander0) {
        this.name = name0;
        this.directory = new File(ForgeConstants.CONQUEST_SAVE_DIR, this.name.replace(' ', '_'));
        this.xmlFilename = this.directory.getPath() + ForgeConstants.PATH_SEPARATOR + XML_FILE;
        this.aetherShards = FModel.getConquestPreferences().getPrefInt(ConquestPreferences.CQPref.AETHER_START_SHARDS);
        this.currentLocation = new ConquestLocation(startingPlane0, 0, 0, 0);
        this.unlockPlane(startingPlane0);
        this.setPlaneswalker(startingPlaneswalker0);
        this.unlockCard(startingCommander0);
        this.unlockCard(startingPlaneswalker0);
        ConquestCommander commander = this.getSelectedCommander();
        for (Map.Entry entry : commander.getDeck().getMain()) {
            PaperCard card = (PaperCard)entry.getKey();
            if (card.getRules().getType().isBasicLand()) continue;
            this.unlockCard(card);
        }
        this.chaosBattleRecord = new ConquestRecord();
    }

    public ConquestData(File directory0) {
        this.name = directory0.getName().replace('_', ' ');
        this.directory = directory0;
        this.xmlFilename = this.directory.getPath() + ForgeConstants.PATH_SEPARATOR + XML_FILE;
        ConquestRecord chaosBattleRecord0 = null;
        try {
            XmlReader xml = new XmlReader(this.xmlFilename);
            CardDb cardDb = FModel.getMagicDb().getCommonCards();
            this.setPlaneswalker(xml.read("planeswalker", cardDb));
            this.aetherShards = xml.read("aetherShards", this.aetherShards);
            this.planeswalkEmblems = xml.read("planeswalkEmblems", this.planeswalkEmblems);
            this.currentLocation = xml.read("currentLocation", ConquestLocation.class);
            this.selectedCommanderIndex = xml.read("selectedCommanderIndex", this.selectedCommanderIndex);
            chaosBattleRecord0 = xml.read("chaosBattleRecord", ConquestRecord.class);
            xml.read("unlockedCards", this.unlockedCards, cardDb);
            xml.read("newCards", this.newCards, cardDb);
            xml.read("exiledCards", this.exiledCards, cardDb);
            xml.read("commanders", this.commanders, ConquestCommander.class);
            xml.read("planeDataMap", this.planeDataMap, ConquestPlaneData.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (chaosBattleRecord0 == null) {
            chaosBattleRecord0 = new ConquestRecord();
        }
        this.chaosBattleRecord = chaosBattleRecord0;
    }

    public void saveData() {
        FileUtil.ensureDirectoryExists(this.directory);
        try {
            XmlWriter xml = new XmlWriter(this.xmlFilename, "data");
            xml.write("planeswalker", this.planeswalker);
            xml.write("aetherShards", this.aetherShards);
            xml.write("planeswalkEmblems", this.planeswalkEmblems);
            xml.write("currentLocation", this.currentLocation);
            xml.write("selectedCommanderIndex", this.selectedCommanderIndex);
            xml.write("chaosBattleRecord", this.chaosBattleRecord);
            xml.write("unlockedCards", this.unlockedCards);
            xml.write("newCards", this.newCards);
            xml.write("exiledCards", this.exiledCards);
            xml.write("commanders", this.commanders);
            xml.write("planeDataMap", this.planeDataMap);
            xml.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public File getDirectory() {
        return this.directory;
    }

    public PaperCard getPlaneswalker() {
        return this.planeswalker;
    }

    public void setPlaneswalker(PaperCard planeswalker0) {
        this.planeswalker = planeswalker0;
        this.planeswalkerToken = PlaneswalkerAchievements.getTrophyImage(this.planeswalker.getName(), this.planeswalker);
    }

    public ISkinImage getPlaneswalkerToken() {
        return this.planeswalkerToken;
    }

    public Iterable<PaperCard> getSortedPlaneswalkers() {
        ArrayList<PaperCard> planeswalkers = new ArrayList<PaperCard>();
        for (PaperCard card : this.unlockedCards) {
            if (!card.getRules().getType().isPlaneswalker() || this.isInExile(card)) continue;
            planeswalkers.add(card);
        }
        Collections.sort(planeswalkers);
        return planeswalkers;
    }

    public ConquestPlane getCurrentPlane() {
        return this.currentLocation.getPlane();
    }

    public ConquestLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public void setCurrentLocation(ConquestLocation currentLocation0) {
        this.currentLocation = currentLocation0;
        this.getCurrentPlaneData().setLocation(currentLocation0);
    }

    private ConquestPlaneData getPlaneData(ConquestPlane plane) {
        return this.planeDataMap.get(plane.getName());
    }

    public ConquestPlaneData getCurrentPlaneData() {
        return this.getPlaneData(this.getCurrentPlane());
    }

    public boolean isPlaneUnlocked(ConquestPlane plane) {
        return this.planeDataMap.containsKey(plane.getName());
    }

    public int getUnlockedPlaneCount() {
        return this.planeDataMap.size();
    }

    public int getAccessiblePlaneCount() {
        int i = 0;
        for (ConquestPlane plane : FModel.getPlanes()) {
            if (plane.isUnreachable()) continue;
            ++i;
        }
        return i;
    }

    public void unlockPlane(ConquestPlane plane) {
        if (this.isPlaneUnlocked(plane)) {
            return;
        }
        this.planeDataMap.put(plane.getName(), new ConquestPlaneData(plane));
    }

    public void planeswalkTo(ConquestPlane plane) {
        ConquestPlaneData planeData = this.getPlaneData(plane);
        if (planeData == null) {
            return;
        }
        this.setCurrentLocation(planeData.getLocation());
    }

    public ConquestCommander getSelectedCommander() {
        return this.commanders.get(this.selectedCommanderIndex);
    }

    public void setSelectedCommander(ConquestCommander commander) {
        this.selectedCommanderIndex = this.commanders.indexOf(commander);
    }

    public Iterable<PaperCard> getUnlockedCards() {
        return this.unlockedCards;
    }

    public boolean hasUnlockedCard(PaperCard card) {
        return this.unlockedCards.contains(card);
    }

    public void unlockCard(PaperCard card) {
        if (this.unlockedCards.add(card)) {
            this.newCards.add(card);
            if (card.getRules().canBeCommander()) {
                ConquestCommander commander;
                if (this.commanders.isEmpty()) {
                    commander = new ConquestCommander(card, this.getCurrentPlane());
                    this.selectedCommanderIndex = 0;
                } else {
                    commander = new ConquestCommander(card);
                }
                this.commanders.add(commander);
            }
        }
    }

    public void unlockCards(Iterable<PaperCard> cards) {
        for (PaperCard card : cards) {
            this.unlockCard(card);
        }
    }

    public boolean isInExile(PaperCard card) {
        return this.exiledCards.contains(card);
    }

    public Iterable<PaperCard> getExiledCards() {
        return this.exiledCards;
    }

    public boolean exileCards(Collection<PaperCard> cards, int value) {
        int count = cards.size();
        if (count == 0) {
            return false;
        }
        String title = count == 1 ? Localizer.getInstance().getMessage("lblExileCard", new Object[0]) : Localizer.getInstance().getMessage("lblExileNCard", String.valueOf(count));
        String cardStr = count == 1 ? Localizer.getInstance().getMessage("lblCard", new Object[0]) : Localizer.getInstance().getMessage("lblCards", new Object[0]);
        ArrayList<ConquestCommander> commandersBeingExiled = null;
        StringBuilder message = new StringBuilder(Localizer.getInstance().getMessage("lblExileFollowCardsToReceiveNAE", cardStr, "{AE}", String.valueOf(value)));
        for (PaperCard card : cards) {
            if (this.planeswalker == card) {
                SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblCurrentPlaneswalkerCannotBeExiled", new Object[0]), title, SOptionPane.INFORMATION_ICON);
                return false;
            }
            StringBuilder commandersUsingCard = new StringBuilder();
            for (ConquestCommander commander : this.commanders) {
                if (commander.getCard() == card) {
                    if (!commander.getDeck().getMain().isEmpty()) {
                        SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblCannotCommanderWithDefinedDeck", new Object[0]), title, SOptionPane.INFORMATION_ICON);
                        return false;
                    }
                    if (commandersBeingExiled == null) {
                        commandersBeingExiled = new ArrayList<ConquestCommander>();
                    }
                    commandersBeingExiled.add(commander);
                }
                if (!commander.getDeck().getMain().contains(card)) continue;
                commandersUsingCard.append("\n").append(CardTranslation.getTranslatedName(commander.getName()));
            }
            if (commandersUsingCard.length() > 0) {
                SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblCommandersCardCannotBeExiledByCard", CardTranslation.getTranslatedName(card.getName()), commandersUsingCard), title, SOptionPane.INFORMATION_ICON);
                return false;
            }
            message.append("\n").append(CardTranslation.getTranslatedName(card.getName()));
        }
        if (SOptionPane.showConfirmDialog(message.toString(), title, Localizer.getInstance().getMessage("lblOK", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0])) && this.exiledCards.addAll(cards)) {
            if (commandersBeingExiled != null) {
                this.commanders.removeAll(commandersBeingExiled);
            }
            this.rewardAEtherShards(value);
            this.saveData();
            return true;
        }
        return false;
    }

    public boolean retrieveCardsFromExile(Collection<PaperCard> cards, int cost) {
        String cardStr;
        int count = cards.size();
        if (count == 0) {
            return false;
        }
        String title = count == 1 ? Localizer.getInstance().getMessage("lblRetrieveCard", new Object[0]) : Localizer.getInstance().getMessage("lblRetrieveNCard", String.valueOf(count));
        String string = cardStr = count == 1 ? Localizer.getInstance().getMessage("lblCard", new Object[0]) : Localizer.getInstance().getMessage("lblCards", new Object[0]);
        if (this.aetherShards < cost) {
            SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblNotEnoughShardsToRetrieveCards", cardStr), title, SOptionPane.INFORMATION_ICON);
            return false;
        }
        StringBuilder message = new StringBuilder(Localizer.getInstance().getMessage("lblSpendAECostToRetrieveCardsFromExile", "{AE}", String.valueOf(cost), cardStr));
        for (PaperCard card : cards) {
            message.append("\n").append(card.getName());
        }
        if (SOptionPane.showConfirmDialog(message.toString(), title, Localizer.getInstance().getMessage("lblOK", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0])) && this.exiledCards.removeAll(cards)) {
            for (PaperCard card : cards) {
                if (!card.getRules().canBeCommander()) continue;
                this.commanders.add(new ConquestCommander(card));
            }
            this.spendAEtherShards(cost);
            this.saveData();
            return true;
        }
        return false;
    }

    public int getUnlockedCardCount() {
        return this.unlockedCards.size();
    }

    public Iterable<ConquestCommander> getCommanders() {
        return this.commanders;
    }

    public void addWin(ConquestBattle event) {
        ConquestPlaneData planeData = this.getPlaneData(event.getLocation().getPlane());
        if (planeData == null) {
            return;
        }
        planeData.addWin(event);
        this.getSelectedCommander().getRecord().addWin();
        event.setConquered(true);
    }

    public void addLoss(ConquestBattle event) {
        ConquestPlaneData planeData = this.getPlaneData(event.getLocation().getPlane());
        if (planeData == null) {
            return;
        }
        planeData.addLoss(event);
        this.getSelectedCommander().getRecord().addLoss();
    }

    public int getAEtherShards() {
        return this.aetherShards;
    }

    public void rewardAEtherShards(int shards) {
        this.aetherShards += shards;
    }

    public boolean spendAEtherShards(int shards) {
        if (this.aetherShards >= shards) {
            this.aetherShards -= shards;
            return true;
        }
        return false;
    }

    public int getPlaneswalkEmblems() {
        return this.planeswalkEmblems;
    }

    public void rewardPlaneswalkEmblems(int emblems) {
        this.planeswalkEmblems += emblems;
    }

    public boolean spendPlaneswalkEmblems(int emblems) {
        if (this.planeswalkEmblems >= emblems) {
            this.planeswalkEmblems -= emblems;
            return true;
        }
        return false;
    }

    public String getProgress() {
        int conquered = 0;
        int total = 0;
        for (ConquestPlane plane : FModel.getPlanes()) {
            ConquestPlaneData planeData = this.planeDataMap.get(plane.getName());
            if (planeData != null) {
                conquered += planeData.getConqueredCount();
            }
            total += plane.getEventCount();
        }
        return Math.round(100.0f * (float)conquered / (float)total) + "%";
    }

    public ConquestRecord getChaosBattleRecord() {
        return this.chaosBattleRecord;
    }

    public void updateStatLabels(IVConquestStats view, ConquestPlane plane) {
        int wins = 0;
        int losses = 0;
        int conqueredCount = 0;
        int totalEventCount = 0;
        int unlockedCardCount = 0;
        int totalCardCount = 0;
        int commanderCount = 0;
        int totalCommanderCount = 0;
        int planeswalkerCount = 0;
        int totalPlaneswalkerCount = 0;
        if (plane != null) {
            ConquestPlaneData planeData = this.planeDataMap.get(plane.getName());
            if (planeData != null) {
                wins = planeData.getTotalWins();
                losses = planeData.getTotalLosses();
                conqueredCount = planeData.getConqueredCount();
            }
            for (ConquestCommander commander : this.commanders) {
                if (!plane.getCommanders().contains(commander.getCard())) continue;
                ++commanderCount;
            }
            totalEventCount = plane.getEventCount();
            totalCardCount = plane.getCardPool().size();
            totalCommanderCount = plane.getCommanders().size();
            for (PaperCard card : plane.getCardPool().getAllCards()) {
                boolean unlocked = this.hasUnlockedCard(card);
                if (unlocked) {
                    ++unlockedCardCount;
                }
                if (!card.getRules().getType().isPlaneswalker()) continue;
                if (unlocked) {
                    ++planeswalkerCount;
                }
                ++totalPlaneswalkerCount;
            }
        } else {
            for (ConquestPlane p : FModel.getPlanes()) {
                if (p.isUnreachable()) continue;
                ConquestPlaneData planeData = this.planeDataMap.get(p.getName());
                if (planeData != null) {
                    wins += planeData.getTotalWins();
                    losses += planeData.getTotalLosses();
                    conqueredCount += planeData.getConqueredCount();
                }
                totalEventCount += p.getEventCount();
                totalCardCount += p.getCardPool().size();
                totalCommanderCount += p.getCommanders().size();
                for (PaperCard card : p.getCardPool().getAllCards()) {
                    boolean unlocked = this.hasUnlockedCard(card);
                    if (unlocked) {
                        ++unlockedCardCount;
                    }
                    if (!card.getRules().getType().isPlaneswalker()) continue;
                    if (unlocked) {
                        ++planeswalkerCount;
                    }
                    ++totalPlaneswalkerCount;
                }
            }
            commanderCount = this.commanders.size();
        }
        view.getLblAEtherShards().setText(Localizer.getInstance().getMessage("lblAetherShards", new Object[0]) + ": " + this.aetherShards);
        view.getLblPlaneswalkEmblems().setText(Localizer.getInstance().getMessage("lblPlaneswalkEmblems", new Object[0]) + ": " + this.planeswalkEmblems);
        view.getLblTotalWins().setText(Localizer.getInstance().getMessage("lblTotalWins", new Object[0]) + ": " + wins);
        view.getLblTotalLosses().setText(Localizer.getInstance().getMessage("lblTotalLosses", new Object[0]) + ": " + losses);
        view.getLblConqueredEvents().setText(Localizer.getInstance().getMessage("lblConqueredEvents", new Object[0]) + ": " + this.formatRatio(conqueredCount, totalEventCount));
        view.getLblUnlockedCards().setText(Localizer.getInstance().getMessage("lblUnlockedCards", new Object[0]) + ": " + this.formatRatio(unlockedCardCount, totalCardCount));
        view.getLblCommanders().setText(Localizer.getInstance().getMessage("lblCommanders", new Object[0]) + ": " + this.formatRatio(commanderCount, totalCommanderCount));
        view.getLblPlaneswalkers().setText(Localizer.getInstance().getMessage("lblPlaneswalkers", new Object[0]) + ": " + this.formatRatio(planeswalkerCount, totalPlaneswalkerCount));
    }

    private String formatRatio(int numerator, int denominator) {
        if (denominator == 0) {
            return "0 / 0 (0%)";
        }
        return numerator + " / " + denominator + " (" + Math.round(100.0f * (float)numerator / (float)denominator) + "%)";
    }

    public void rename(String newName) {
        this.name = newName;
        File directory0 = new File(ForgeConstants.CONQUEST_SAVE_DIR, this.name.replace(' ', '_'));
        this.directory.renameTo(directory0);
        this.directory = directory0;
        this.xmlFilename = this.directory.getPath() + ForgeConstants.PATH_SEPARATOR + XML_FILE;
    }

    public void resetNewCards() {
        this.newCards.clear();
    }

    public static Map<ColumnDef, ItemColumn> getColOverrides(ItemManagerConfig config) {
        HashMap<ColumnDef, ItemColumn> colOverrides = new HashMap<ColumnDef, ItemColumn>();
        ItemColumn.addColOverride(config, colOverrides, ColumnDef.NEW, fnNewCompare, fnNewGet);
        return colOverrides;
    }

    public List<ConquestLocation> getPath(ConquestLocation destLoc) {
        PathFinder pathFinder = new PathFinder();
        return pathFinder.findPath(destLoc);
    }

    private class PathFinder {
        private final HashSet<Node> closedSet = new HashSet();
        private final HashSet<Node> openSet = new HashSet();
        private final Node[][] map;

        private PathFinder() {
            ConquestPlane plane = ConquestData.this.getCurrentPlane();
            int xMax = plane.getCols();
            int yMax = plane.getRegions().size() * plane.getRowsPerRegion();
            this.map = new Node[xMax][yMax];
            for (int x = 0; x < xMax; ++x) {
                for (int y = 0; y < yMax; ++y) {
                    this.map[x][y] = new Node(plane, x, y);
                }
            }
        }

        public List<ConquestLocation> findPath(ConquestLocation destLoc) {
            Node goal = this.getNode(destLoc);
            if (goal.isBlocked()) {
                return null;
            }
            Node start = this.getNode(ConquestData.this.getCurrentLocation());
            this.openSet.add(start);
            start.g_score = 0;
            start.f_score = start.g_score + this.distance(start, goal);
            while (!this.openSet.isEmpty()) {
                Node current = null;
                for (Node node : this.openSet) {
                    if (current != null && node.f_score >= current.f_score) continue;
                    current = node;
                }
                if (current == goal) {
                    ArrayList<ConquestLocation> path = new ArrayList<ConquestLocation>();
                    while (current != null) {
                        path.add(current.loc);
                        current = current.came_from;
                    }
                    Collections.reverse(path);
                    return path;
                }
                this.openSet.remove(current);
                this.closedSet.add(current);
                this.checkNeighbor(current, goal, current.x - 1, current.y);
                this.checkNeighbor(current, goal, current.x + 1, current.y);
                this.checkNeighbor(current, goal, current.x, current.y - 1);
                this.checkNeighbor(current, goal, current.x, current.y + 1);
            }
            return null;
        }

        private void checkNeighbor(Node current, Node goal, int x, int y) {
            if (x < 0 || x >= this.map.length) {
                return;
            }
            Node[] column = this.map[x];
            if (y < 0 || y >= column.length) {
                return;
            }
            Node neighbor = column[y];
            if (neighbor.isBlocked()) {
                return;
            }
            if (this.closedSet.contains(neighbor)) {
                return;
            }
            int g_score = current.g_score + 1;
            if (!this.openSet.contains(neighbor)) {
                this.openSet.add(neighbor);
            } else if (g_score >= neighbor.g_score) {
                return;
            }
            neighbor.came_from = current;
            neighbor.g_score = g_score;
            neighbor.f_score = neighbor.g_score + this.distance(neighbor, goal);
        }

        private int distance(Node from, Node to) {
            return Math.abs(from.x - to.x) + Math.abs(from.y - to.y);
        }

        private Node getNode(ConquestLocation loc) {
            int x = loc.getCol();
            int y = loc.getRegionIndex() * loc.getPlane().getRowsPerRegion() + loc.getRow();
            return this.map[x][y];
        }

        private class Node {
            private final int x;
            private final int y;
            private final ConquestLocation loc;
            private int g_score = Integer.MAX_VALUE;
            private int f_score = Integer.MAX_VALUE;
            private Node came_from;
            private Boolean blocked = null;

            public Node(ConquestPlane plane, int x0, int y0) {
                this.x = x0;
                this.y = y0;
                int regionIndex = this.y / plane.getRowsPerRegion();
                int col = this.x;
                int row = this.y % plane.getRowsPerRegion();
                this.loc = new ConquestLocation(plane, regionIndex, row, col);
            }

            public boolean isBlocked() {
                if (this.blocked == null) {
                    ConquestPlaneData planeData = ConquestData.this.getCurrentPlaneData();
                    if (planeData.hasConquered(this.loc)) {
                        this.blocked = false;
                    } else {
                        this.blocked = true;
                        for (ConquestLocation neighbor : this.loc.getNeighbors()) {
                            if (!planeData.hasConquered(neighbor)) continue;
                            this.blocked = false;
                            break;
                        }
                    }
                }
                return this.blocked;
            }
        }
    }
}

