/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.planarconquest;

import forge.LobbyPlayer;
import forge.deck.Deck;
import forge.game.GameType;
import forge.game.GameView;
import forge.gamemodes.planarconquest.ConquestAwardPool;
import forge.gamemodes.planarconquest.ConquestBattle;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.gamemodes.quest.QuestEventDifficulty;
import forge.gamemodes.quest.QuestEventDuel;
import forge.gamemodes.quest.QuestEventDuelManager;
import forge.gamemodes.quest.QuestWorld;
import forge.gui.interfaces.IButton;
import forge.gui.interfaces.IGuiGame;
import forge.gui.interfaces.IWinLoseView;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.Aggregates;
import forge.util.Localizer;
import java.io.File;
import java.util.EnumSet;
import java.util.Set;

public class ConquestChaosBattle
extends ConquestBattle {
    private final QuestWorld world;
    private final QuestEventDuel duel;
    private ConquestAwardPool awardPool;

    public ConquestChaosBattle() {
        super(null, 0);
        ConquestPreferences prefs = FModel.getConquestPreferences();
        int chaosBattleWins = FModel.getConquest().getModel().getChaosBattleRecord().getWins();
        QuestEventDifficulty prefferedDifficulty = chaosBattleWins < prefs.getPrefInt(ConquestPreferences.CQPref.CHAOS_BATTLE_WINS_MEDIUMAI) ? QuestEventDifficulty.EASY : (chaosBattleWins < prefs.getPrefInt(ConquestPreferences.CQPref.CHAOS_BATTLE_WINS_HARDAI) ? QuestEventDifficulty.MEDIUM : (chaosBattleWins < prefs.getPrefInt(ConquestPreferences.CQPref.CHAOS_BATTLE_WINS_EXPERTAI) ? QuestEventDifficulty.HARD : QuestEventDifficulty.EXPERT));
        QuestWorld world0 = null;
        QuestEventDuel duel0 = null;
        do {
            String worldDir = (world0 = Aggregates.random(FModel.getWorlds())) != null && world0.isCustom() ? ForgeConstants.USER_QUEST_WORLD_DIR : ForgeConstants.QUEST_WORLD_DIR;
            String path = world0 == null || world0.getDuelsDir() == null ? ForgeConstants.DEFAULT_DUELS_DIR : worldDir + world0.getDuelsDir();
            QuestEventDuelManager duelManager = new QuestEventDuelManager(new File(path));
            QuestEventDifficulty difficulty = prefferedDifficulty;
            duel0 = Aggregates.random(duelManager.getDuels(difficulty));
            block6: while (duel0 == null && difficulty != QuestEventDifficulty.EASY) {
                switch (difficulty) {
                    case EXPERT: {
                        difficulty = QuestEventDifficulty.HARD;
                        break;
                    }
                    case HARD: {
                        difficulty = QuestEventDifficulty.MEDIUM;
                        break;
                    }
                    case MEDIUM: {
                        difficulty = QuestEventDifficulty.EASY;
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                duel0 = Aggregates.random(duelManager.getDuels(difficulty));
            }
        } while (duel0 == null);
        this.world = world0;
        this.duel = duel0;
    }

    @Override
    protected Deck buildOpponentDeck() {
        return this.duel.getEventDeck();
    }

    @Override
    public String getEventName() {
        return this.duel.getTitle();
    }

    @Override
    public String getOpponentName() {
        return this.duel.getName();
    }

    @Override
    public PaperCard getPlaneswalker() {
        return null;
    }

    @Override
    public void setOpponentAvatar(LobbyPlayer aiPlayer, IGuiGame gui) {
        gui.setPlayerAvatar(aiPlayer, this.duel);
    }

    @Override
    public Set<GameType> getVariants() {
        return EnumSet.noneOf(GameType.class);
    }

    @Override
    public int gamesPerMatch() {
        return 3;
    }

    @Override
    public void showGameOutcome(ConquestData model, GameView game, LobbyPlayer humanPlayer, IWinLoseView<? extends IButton> view) {
        if (game.isMatchOver()) {
            view.getBtnContinue().setVisible(false);
            if (game.isMatchWonBy(humanPlayer)) {
                view.getBtnQuit().setText(Localizer.getInstance().getMessage("lblGreat", new Object[0]) + "!");
                model.getChaosBattleRecord().addWin();
                this.setConquered(true);
            } else {
                view.getBtnQuit().setText(Localizer.getInstance().getMessage("lblOK", new Object[0]));
                model.getChaosBattleRecord().addLoss();
            }
            model.saveData();
        } else {
            view.getBtnContinue().setVisible(true);
            view.getBtnContinue().setText(Localizer.getInstance().getMessage("btnContinue", new Object[0]));
            view.getBtnQuit().setText(Localizer.getInstance().getMessage("btnQuit", new Object[0]));
        }
    }

    @Override
    public void onFinished(ConquestData model, IWinLoseView<? extends IButton> view) {
        if (view.getBtnContinue().isVisible()) {
            model.getChaosBattleRecord().addLoss();
            model.saveData();
        }
        super.onFinished(model, view);
    }

    public ConquestAwardPool getAwardPool() {
        if (this.awardPool == null) {
            this.awardPool = new ConquestAwardPool(this.world.getAllCards());
        }
        return this.awardPool;
    }
}

