/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net.server;

import forge.gamemodes.match.GameLobby;
import forge.gamemodes.match.LobbySlot;
import forge.gamemodes.match.LobbySlotType;
import forge.gamemodes.net.server.FServerManager;
import forge.gui.interfaces.IGuiGame;
import java.util.Collections;

public final class ServerGameLobby
extends GameLobby {
    public ServerGameLobby() {
        super(true);
        this.addSlot(new LobbySlot(LobbySlotType.LOCAL, ServerGameLobby.localName(), ServerGameLobby.localAvatarIndices()[0], ServerGameLobby.localSleeveIndices()[0], 0, true, false, Collections.emptySet()));
        this.addSlot(new LobbySlot(LobbySlotType.OPEN, null, -1, -1, 1, false, false, Collections.emptySet()));
    }

    public int connectPlayer(String name, int avatarIndex, int sleeveIndex) {
        int nSlots = this.getNumberOfSlots();
        for (int index = 0; index < nSlots; ++index) {
            LobbySlot slot = this.getSlot(index);
            if (slot.getType() != LobbySlotType.OPEN) continue;
            this.connectPlayer(name, avatarIndex, sleeveIndex, slot);
            return index;
        }
        return -1;
    }

    private void connectPlayer(String name, int avatarIndex, int sleeveIndex, LobbySlot slot) {
        slot.setType(LobbySlotType.REMOTE);
        slot.setName(name);
        slot.setAvatarIndex(avatarIndex);
        slot.setSleeveIndex(sleeveIndex);
        this.updateView(false);
    }

    public void disconnectPlayer(int index) {
        LobbySlot slot = this.getSlot(index);
        slot.setType(LobbySlotType.OPEN);
        slot.setName("");
        slot.setIsReady(false);
        this.updateView(false);
    }

    @Override
    public boolean hasControl() {
        return true;
    }

    @Override
    public boolean mayEdit(int index) {
        LobbySlotType type = this.getSlot(index).getType();
        return type != LobbySlotType.REMOTE && type != LobbySlotType.OPEN;
    }

    @Override
    public boolean mayControl(int index) {
        return this.getSlot(index).getType() != LobbySlotType.REMOTE;
    }

    @Override
    public boolean mayRemove(int index) {
        return index >= 2;
    }

    @Override
    protected IGuiGame getGui(int index) {
        return FServerManager.getInstance().getGui(index);
    }

    @Override
    protected void onGameStarted() {
    }
}

