/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net.server;

import com.google.common.base.Function;
import forge.LobbyPlayer;
import forge.ai.GameState;
import forge.deck.CardPool;
import forge.game.GameEntityView;
import forge.game.GameView;
import forge.game.card.CardView;
import forge.game.phase.PhaseType;
import forge.game.player.DelayedReveal;
import forge.game.player.IHasIcon;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbilityView;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.AbstractGuiGame;
import forge.gamemodes.net.GameProtocolSender;
import forge.gamemodes.net.ProtocolMethod;
import forge.gamemodes.net.server.IToClient;
import forge.item.PaperCard;
import forge.localinstance.skin.FSkinProp;
import forge.player.PlayerZoneUpdate;
import forge.player.PlayerZoneUpdates;
import forge.trackable.TrackableCollection;
import forge.util.ITriggerEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NetGuiGame
extends AbstractGuiGame {
    private final GameProtocolSender sender;

    public NetGuiGame(IToClient client) {
        this.sender = new GameProtocolSender(client);
    }

    private void send(ProtocolMethod method, Object ... args) {
        this.sender.send(method, args);
    }

    private <T> T sendAndWait(ProtocolMethod method, Object ... args) {
        return this.sender.sendAndWait(method, args);
    }

    public void updateGameView() {
        this.send(ProtocolMethod.setGameView, this.getGameView());
    }

    @Override
    public void setGameView(GameView gameView) {
        super.setGameView(gameView);
        this.updateGameView();
    }

    @Override
    public void openView(TrackableCollection<PlayerView> myPlayers) {
        this.send(ProtocolMethod.openView, myPlayers);
        this.updateGameView();
    }

    @Override
    public void afterGameEnd() {
        this.send(ProtocolMethod.afterGameEnd, new Object[0]);
    }

    @Override
    public void showCombat() {
        this.send(ProtocolMethod.showCombat, new Object[0]);
    }

    @Override
    public void showPromptMessage(PlayerView playerView, String message) {
        this.updateGameView();
        this.send(ProtocolMethod.showPromptMessage, playerView, message);
    }

    @Override
    public void showCardPromptMessage(PlayerView playerView, String message, CardView card) {
        this.updateGameView();
        this.send(ProtocolMethod.showCardPromptMessage, playerView, message, card);
    }

    @Override
    public void updateButtons(PlayerView owner, String label1, String label2, boolean enable1, boolean enable2, boolean focus1) {
        this.send(ProtocolMethod.updateButtons, owner, label1, label2, enable1, enable2, focus1);
    }

    @Override
    public void flashIncorrectAction() {
        this.send(ProtocolMethod.flashIncorrectAction, new Object[0]);
    }

    @Override
    public void alertUser() {
        this.send(ProtocolMethod.alertUser, new Object[0]);
    }

    @Override
    public void updatePhase(boolean saveState) {
        this.updateGameView();
        this.send(ProtocolMethod.updatePhase, saveState);
    }

    @Override
    public void updateTurn(PlayerView player) {
        this.updateGameView();
        this.send(ProtocolMethod.updateTurn, player);
    }

    @Override
    public void updatePlayerControl() {
        this.updateGameView();
        this.send(ProtocolMethod.updatePlayerControl, new Object[0]);
    }

    @Override
    public void enableOverlay() {
        this.send(ProtocolMethod.enableOverlay, new Object[0]);
    }

    @Override
    public void disableOverlay() {
        this.send(ProtocolMethod.disableOverlay, new Object[0]);
    }

    @Override
    public void finishGame() {
        this.send(ProtocolMethod.finishGame, new Object[0]);
    }

    @Override
    public void showManaPool(PlayerView player) {
        this.send(ProtocolMethod.showManaPool, player);
    }

    @Override
    public void hideManaPool(PlayerView player) {
        this.send(ProtocolMethod.hideManaPool, player);
    }

    @Override
    public void updateStack() {
        this.updateGameView();
        this.send(ProtocolMethod.updateStack, new Object[0]);
    }

    @Override
    public void updateZones(Iterable<PlayerZoneUpdate> zonesToUpdate) {
        this.updateGameView();
        this.send(ProtocolMethod.updateZones, zonesToUpdate);
    }

    @Override
    public Iterable<PlayerZoneUpdate> tempShowZones(PlayerView controller, Iterable<PlayerZoneUpdate> zonesToUpdate) {
        this.updateGameView();
        return (Iterable)this.sendAndWait(ProtocolMethod.tempShowZones, controller, zonesToUpdate);
    }

    @Override
    public void hideZones(PlayerView controller, Iterable<PlayerZoneUpdate> zonesToUpdate) {
        this.updateGameView();
        this.send(ProtocolMethod.hideZones, controller, zonesToUpdate);
    }

    @Override
    public void updateCards(Iterable<CardView> cards) {
        this.updateGameView();
        this.send(ProtocolMethod.updateCards, cards);
    }

    @Override
    public void updateManaPool(Iterable<PlayerView> manaPoolUpdate) {
        this.updateGameView();
        this.send(ProtocolMethod.updateManaPool, manaPoolUpdate);
    }

    @Override
    public void updateLives(Iterable<PlayerView> livesUpdate) {
        this.updateGameView();
        this.send(ProtocolMethod.updateLives, livesUpdate);
    }

    @Override
    public void updateShards(Iterable<PlayerView> shardsUpdate) {
    }

    @Override
    public void setPanelSelection(CardView hostCard) {
        this.updateGameView();
        this.send(ProtocolMethod.setPanelSelection, hostCard);
    }

    @Override
    public void refreshField() {
        this.updateGameView();
        this.send(ProtocolMethod.refreshField, new Object[0]);
    }

    @Override
    public GameState getGamestate() {
        return null;
    }

    @Override
    public SpellAbilityView getAbilityToPlay(CardView hostCard, List<SpellAbilityView> abilities, ITriggerEvent triggerEvent) {
        return (SpellAbilityView)this.sendAndWait(ProtocolMethod.getAbilityToPlay, hostCard, abilities, null);
    }

    @Override
    public Map<CardView, Integer> assignCombatDamage(CardView attacker, List<CardView> blockers, int damage, GameEntityView defender, boolean overrideOrder, boolean maySkip) {
        return (Map)this.sendAndWait(ProtocolMethod.assignCombatDamage, attacker, blockers, damage, defender, overrideOrder, maySkip);
    }

    @Override
    public Map<Object, Integer> assignGenericAmount(CardView effectSource, Map<Object, Integer> targets, int amount, boolean atLeastOne, String amountLabel) {
        return (Map)this.sendAndWait(ProtocolMethod.assignGenericAmount, effectSource, targets, amount, atLeastOne, amountLabel);
    }

    @Override
    public void message(String message, String title) {
        this.send(ProtocolMethod.message, message, title);
    }

    @Override
    public void showErrorDialog(String message, String title) {
        this.send(ProtocolMethod.showErrorDialog, message, title);
    }

    @Override
    public boolean showConfirmDialog(String message, String title, String yesButtonText, String noButtonText, boolean defaultYes) {
        return (Boolean)this.sendAndWait(ProtocolMethod.showConfirmDialog, message, title, yesButtonText, noButtonText, defaultYes);
    }

    @Override
    public int showOptionDialog(String message, String title, FSkinProp icon, List<String> options, int defaultOption) {
        return (Integer)this.sendAndWait(ProtocolMethod.showOptionDialog, new Object[]{message, title, icon, options, defaultOption});
    }

    @Override
    public String showInputDialog(String message, String title, FSkinProp icon, String initialInput, List<String> inputOptions, boolean isNumeric) {
        return (String)this.sendAndWait(ProtocolMethod.showInputDialog, new Object[]{message, title, icon, initialInput, inputOptions, isNumeric});
    }

    @Override
    public boolean confirm(CardView c, String question, boolean defaultIsYes, List<String> options) {
        return (Boolean)this.sendAndWait(ProtocolMethod.confirm, c, question, defaultIsYes, options);
    }

    @Override
    public <T> List<T> getChoices(String message, int min2, int max, List<T> choices, T selected, Function<T, String> display) {
        return (List)this.sendAndWait(ProtocolMethod.getChoices, message, min2, max, choices, selected, display);
    }

    @Override
    public <T> List<T> order(String title, String top, int remainingObjectsMin, int remainingObjectsMax, List<T> sourceChoices, List<T> destChoices, CardView referenceCard, boolean sideboardingMode) {
        return (List)this.sendAndWait(ProtocolMethod.order, title, top, remainingObjectsMin, remainingObjectsMax, sourceChoices, destChoices, referenceCard, sideboardingMode);
    }

    @Override
    public List<PaperCard> sideboard(CardPool sideboard, CardPool main, String message) {
        return (List)this.sendAndWait(ProtocolMethod.sideboard, sideboard, main, message);
    }

    @Override
    public GameEntityView chooseSingleEntityForEffect(String title, List<? extends GameEntityView> optionList, DelayedReveal delayedReveal, boolean isOptional) {
        return (GameEntityView)this.sendAndWait(ProtocolMethod.chooseSingleEntityForEffect, title, optionList, delayedReveal, isOptional);
    }

    @Override
    public List<GameEntityView> chooseEntitiesForEffect(String title, List<? extends GameEntityView> optionList, int min2, int max, DelayedReveal delayedReveal) {
        return (List)this.sendAndWait(ProtocolMethod.chooseEntitiesForEffect, title, optionList, min2, max, delayedReveal);
    }

    @Override
    public List<CardView> manipulateCardList(String title, Iterable<CardView> cards, Iterable<CardView> manipulable, boolean toTop, boolean toBottom, boolean toAnywhere) {
        return (List)this.sendAndWait(ProtocolMethod.manipulateCardList, title, cards, manipulable, toTop, toBottom, toAnywhere);
    }

    @Override
    public void setCard(CardView card) {
        this.updateGameView();
        this.send(ProtocolMethod.setCard, card);
    }

    @Override
    public void setSelectables(Iterable<CardView> cards) {
        this.updateGameView();
        this.send(ProtocolMethod.setSelectables, cards);
    }

    @Override
    public void clearSelectables() {
        this.updateGameView();
        this.send(ProtocolMethod.clearSelectables, new Object[0]);
    }

    @Override
    public void setPlayerAvatar(LobbyPlayer player, IHasIcon ihi) {
    }

    @Override
    public PlayerZoneUpdates openZones(PlayerView controller, Collection<ZoneType> zones, Map<PlayerView, Object> players, boolean backupLastZones) {
        this.updateGameView();
        return (PlayerZoneUpdates)this.sendAndWait(ProtocolMethod.openZones, controller, zones, players, backupLastZones);
    }

    @Override
    public void restoreOldZones(PlayerView playerView, PlayerZoneUpdates playerZoneUpdates) {
        this.send(ProtocolMethod.restoreOldZones, playerView, playerZoneUpdates);
    }

    @Override
    public boolean isUiSetToSkipPhase(PlayerView playerTurn, PhaseType phase) {
        return (Boolean)this.sendAndWait(ProtocolMethod.isUiSetToSkipPhase, new Object[]{playerTurn, phase});
    }

    @Override
    protected void updateCurrentPlayer(PlayerView player) {
    }
}

