/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net.event;

import forge.ai.AIOption;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.gamemodes.match.LobbySlotType;
import forge.gamemodes.net.event.NetEvent;
import forge.gamemodes.net.server.RemoteClient;
import java.util.Collections;
import java.util.Set;

public final class UpdateLobbyPlayerEvent
implements NetEvent {
    private static final long serialVersionUID = -7354695008599789571L;
    private LobbySlotType type = null;
    private String name = null;
    private int avatarIndex = -1;
    private int sleeveIndex = -1;
    private int team = -1;
    private Boolean isArchenemy = null;
    private Boolean isReady = null;
    private Boolean isDevMode = null;
    private Deck deck = null;
    private DeckSection section = null;
    private CardPool cards = null;
    private Set<AIOption> aiOptions = null;
    private String AvatarVanguard = null;
    private String SchemeDeckName = null;
    private String PlanarDeckName = null;
    private String DeckName = null;

    public static UpdateLobbyPlayerEvent create(LobbySlotType type, String name, int avatarIndex, int sleeveIndex, int team, boolean isArchenemy, boolean isReady, Set<AIOption> aiOptions) {
        return new UpdateLobbyPlayerEvent(type, name, avatarIndex, sleeveIndex, team, isArchenemy, isReady, aiOptions);
    }

    public static UpdateLobbyPlayerEvent create(LobbySlotType type, String name, int avatarIndex, int sleeveIndex, int team, boolean isArchenemy, boolean isReady, boolean isDevMode, Set<AIOption> aiOptions) {
        return new UpdateLobbyPlayerEvent(type, name, avatarIndex, sleeveIndex, team, isArchenemy, isReady, isDevMode, aiOptions);
    }

    public static UpdateLobbyPlayerEvent deckUpdate(Deck deck) {
        return new UpdateLobbyPlayerEvent(deck);
    }

    public static UpdateLobbyPlayerEvent deckUpdate(DeckSection section, CardPool cards) {
        return new UpdateLobbyPlayerEvent(section, cards);
    }

    public static UpdateLobbyPlayerEvent nameUpdate(String name) {
        return new UpdateLobbyPlayerEvent(name);
    }

    private UpdateLobbyPlayerEvent(String name) {
        this.name = name;
    }

    public static UpdateLobbyPlayerEvent avatarUpdate(int index) {
        return new UpdateLobbyPlayerEvent(index, true);
    }

    public static UpdateLobbyPlayerEvent sleeveUpdate(int index) {
        return new UpdateLobbyPlayerEvent(index, false);
    }

    public static UpdateLobbyPlayerEvent isReadyUpdate(boolean isReady) {
        return new UpdateLobbyPlayerEvent(isReady);
    }

    public static UpdateLobbyPlayerEvent teamUpdate(int team) {
        return new UpdateLobbyPlayerEvent(team);
    }

    public static UpdateLobbyPlayerEvent setDeckSchemePlaneVanguard(String DeckName, String Scheme, String Plane2, String Vanguard) {
        return new UpdateLobbyPlayerEvent(DeckName, Scheme, Plane2, Vanguard);
    }

    private UpdateLobbyPlayerEvent(int index, boolean avatar) {
        if (avatar) {
            this.avatarIndex = index;
        } else {
            this.sleeveIndex = index;
        }
    }

    private UpdateLobbyPlayerEvent(int team) {
        this.team = team;
    }

    private UpdateLobbyPlayerEvent(String DeckName, String Scheme, String Plane2, String Vanguard) {
        this.SchemeDeckName = Scheme;
        this.PlanarDeckName = Plane2;
        this.AvatarVanguard = Vanguard;
        this.DeckName = DeckName;
    }

    private UpdateLobbyPlayerEvent(Deck deck) {
        this.deck = deck;
    }

    private UpdateLobbyPlayerEvent(boolean isReady) {
        this.isReady = isReady;
    }

    private UpdateLobbyPlayerEvent(DeckSection section, CardPool cards) {
        this.section = section;
        this.cards = cards;
    }

    private UpdateLobbyPlayerEvent(LobbySlotType type, String name, int avatarIndex, int sleeveIndex, int team, boolean isArchenemy, boolean isReady, Set<AIOption> aiOptions) {
        this.type = type;
        this.name = name;
        this.avatarIndex = avatarIndex;
        this.sleeveIndex = sleeveIndex;
        this.team = team;
        this.isArchenemy = isArchenemy;
        this.isReady = isReady;
        this.aiOptions = aiOptions;
    }

    private UpdateLobbyPlayerEvent(LobbySlotType type, String name, int avatarIndex, int sleeveIndex, int team, boolean isArchenemy, boolean isReady, boolean isDevMode, Set<AIOption> aiOptions) {
        this.type = type;
        this.name = name;
        this.avatarIndex = avatarIndex;
        this.sleeveIndex = sleeveIndex;
        this.team = team;
        this.isArchenemy = isArchenemy;
        this.isReady = isReady;
        this.isDevMode = isDevMode;
        this.aiOptions = aiOptions;
    }

    @Override
    public void updateForClient(RemoteClient client) {
    }

    public LobbySlotType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getAvatarIndex() {
        return this.avatarIndex;
    }

    public int getSleeveIndex() {
        return this.sleeveIndex;
    }

    public int getTeam() {
        return this.team;
    }

    public Boolean getArchenemy() {
        return this.isArchenemy;
    }

    public Boolean getReady() {
        return this.isReady;
    }

    public Boolean getDevMode() {
        return this.isDevMode;
    }

    public Deck getDeck() {
        return this.deck;
    }

    public DeckSection getSection() {
        return this.section;
    }

    public CardPool getCards() {
        return this.cards;
    }

    public Set<AIOption> getAiOptions() {
        return this.aiOptions == null ? null : Collections.unmodifiableSet(this.aiOptions);
    }

    public String getAvatarVanguard() {
        return this.AvatarVanguard;
    }

    public String getSchemeDeckName() {
        return this.SchemeDeckName;
    }

    public String getPlanarDeckName() {
        return this.PlanarDeckName;
    }

    public String getDeckName() {
        return this.DeckName;
    }
}

