/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net.client;

import com.google.common.collect.Lists;
import forge.game.player.PlayerView;
import forge.gamemodes.net.CompatibleObjectDecoder;
import forge.gamemodes.net.CompatibleObjectEncoder;
import forge.gamemodes.net.ReplyPool;
import forge.gamemodes.net.client.GameClientHandler;
import forge.gamemodes.net.client.IToServer;
import forge.gamemodes.net.client.NetGameController;
import forge.gamemodes.net.event.IdentifiableNetEvent;
import forge.gamemodes.net.event.LobbyUpdateEvent;
import forge.gamemodes.net.event.MessageEvent;
import forge.gamemodes.net.event.NetEvent;
import forge.gui.interfaces.IGuiGame;
import forge.interfaces.ILobbyListener;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.serialization.ClassResolvers;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class FGameClient
implements IToServer {
    private final IGuiGame clientGui;
    private final List<ILobbyListener> lobbyListeners = Lists.newArrayList();
    private final ReplyPool replies = new ReplyPool();
    private Channel channel;

    public FGameClient(String username, String roomKey, IGuiGame clientGui) {
        this.clientGui = clientGui;
    }

    final IGuiGame getGui() {
        return this.clientGui;
    }

    final ReplyPool getReplyPool() {
        return this.replies;
    }

    public void connect(String host, int port) {
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new CompatibleObjectEncoder(), new CompatibleObjectDecoder(0x989800, ClassResolvers.cacheDisabled(null)), new MessageHandler(), new LobbyUpdateHandler(), new GameClientHandler(FGameClient.this));
                }
            });
            this.channel = b.connect(host, port).sync().channel();
            ChannelFuture ch = this.channel.closeFuture();
            new Thread(() -> {
                try {
                    ch.sync();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    group.shutdownGracefully();
                }
            }).start();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Override
    public void send(NetEvent event) {
        System.out.println("Client sent " + event);
        this.channel.writeAndFlush(event);
    }

    @Override
    public Object sendAndWait(IdentifiableNetEvent event) throws TimeoutException {
        this.replies.initialize(event.getId());
        this.send(event);
        return this.replies.get(event.getId());
    }

    List<ILobbyListener> getLobbyListeners() {
        return this.lobbyListeners;
    }

    public void addLobbyListener(ILobbyListener listener) {
        this.lobbyListeners.add(listener);
    }

    void setGameControllers(Iterable<PlayerView> myPlayers) {
        for (PlayerView p : myPlayers) {
            this.clientGui.setOriginalGameController(p, new NetGameController(this));
        }
    }

    private class LobbyUpdateHandler
    extends ChannelInboundHandlerAdapter {
        private LobbyUpdateHandler() {
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof LobbyUpdateEvent) {
                for (ILobbyListener listener : FGameClient.this.lobbyListeners) {
                    LobbyUpdateEvent event = (LobbyUpdateEvent)msg;
                    listener.update(event.getState(), event.getSlot());
                }
            }
            super.channelRead(ctx, msg);
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            for (ILobbyListener listener : FGameClient.this.lobbyListeners) {
                listener.close();
            }
            super.channelInactive(ctx);
        }
    }

    private class MessageHandler
    extends ChannelInboundHandlerAdapter {
        private MessageHandler() {
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof MessageEvent) {
                MessageEvent event = (MessageEvent)msg;
                for (ILobbyListener listener : FGameClient.this.lobbyListeners) {
                    listener.message(event.getSource(), event.getMessage());
                }
            }
            super.channelRead(ctx, msg);
        }
    }
}

