/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net;

import forge.gamemodes.match.GameLobby;
import forge.gamemodes.match.LobbySlotType;
import forge.gamemodes.net.ChatMessage;
import forge.gamemodes.net.IOnlineChatInterface;
import forge.gamemodes.net.IOnlineLobby;
import forge.gamemodes.net.IRemote;
import forge.gamemodes.net.client.ClientGameLobby;
import forge.gamemodes.net.client.FGameClient;
import forge.gamemodes.net.event.IdentifiableNetEvent;
import forge.gamemodes.net.event.MessageEvent;
import forge.gamemodes.net.event.NetEvent;
import forge.gamemodes.net.server.FServerManager;
import forge.gamemodes.net.server.ServerGameLobby;
import forge.gui.GuiBase;
import forge.gui.interfaces.IGuiGame;
import forge.gui.interfaces.ILobbyView;
import forge.gui.util.SOptionPane;
import forge.interfaces.ILobbyListener;
import forge.interfaces.IUpdateable;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.properties.ForgeProfileProperties;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.Localizer;
import org.apache.commons.lang3.StringUtils;

public class NetConnectUtil {
    private NetConnectUtil() {
    }

    public static String getServerUrl() {
        String url = SOptionPane.showInputDialog(Localizer.getInstance().getMessage("lblOnlineMultiplayerDest", new Object[0]), Localizer.getInstance().getMessage("lblConnectToServer", new Object[0]));
        if (url == null) {
            return null;
        }
        if (StringUtils.isBlank(FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME))) {
            GamePlayerUtil.setPlayerName();
        }
        return url;
    }

    public static ChatMessage host(IOnlineLobby onlineLobby, final IOnlineChatInterface chatInterface) {
        int port = ForgeProfileProperties.getServerPort();
        final FServerManager server = FServerManager.getInstance();
        ServerGameLobby lobby = new ServerGameLobby();
        final ILobbyView view = onlineLobby.setLobby(lobby);
        server.startServer(port);
        server.setLobby(lobby);
        lobby.setListener(new IUpdateable(){

            @Override
            public void update(boolean fullUpdate) {
                view.update(fullUpdate);
                server.updateLobbyState();
            }

            @Override
            public void update(int slot, LobbySlotType type) {
            }
        });
        view.setPlayerChangeListener((index, event) -> {
            server.updateSlot(index, event);
            server.updateLobbyState();
        });
        server.setLobbyListener(new ILobbyListener(){

            @Override
            public void update(GameLobby.GameLobbyData state, int slot) {
            }

            @Override
            public void message(String source, String message) {
                chatInterface.addMessage(new ChatMessage(source, message));
            }

            @Override
            public void close() {
            }

            @Override
            public ClientGameLobby getLobby() {
                return null;
            }
        });
        chatInterface.setGameClient(new IRemote(){

            @Override
            public void send(NetEvent event) {
                if (event instanceof MessageEvent) {
                    MessageEvent message = (MessageEvent)event;
                    chatInterface.addMessage(new ChatMessage(message.getSource(), message.getMessage()));
                    server.broadcast(event);
                }
            }

            @Override
            public Object sendAndWait(IdentifiableNetEvent event) {
                this.send(event);
                return null;
            }
        });
        view.update(true);
        return new ChatMessage(null, Localizer.getInstance().getMessage("lblHostingPortOnN", String.valueOf(port)));
    }

    public static void copyHostedServerUrl() {
        String internalAddress = FServerManager.getInstance().getLocalAddress();
        FServerManager.getInstance();
        String externalAddress = FServerManager.getExternalAddress();
        String internalUrl = internalAddress + ":" + ForgeProfileProperties.getServerPort();
        String externalUrl = null;
        if (externalAddress != null) {
            externalUrl = externalAddress + ":" + ForgeProfileProperties.getServerPort();
            GuiBase.getInterface().copyToClipboard(externalUrl);
        } else {
            GuiBase.getInterface().copyToClipboard(internalAddress);
        }
        String message = "";
        message = externalUrl != null ? Localizer.getInstance().getMessage("lblShareURLToMakePlayerJoinServer", externalUrl, internalUrl) : Localizer.getInstance().getMessage("lblForgeUnableDetermineYourExternalIP", message + internalUrl);
        SOptionPane.showMessageDialog(message, Localizer.getInstance().getMessage("lblServerURL", new Object[0]), SOptionPane.INFORMATION_ICON);
    }

    public static ChatMessage join(final String url, final IOnlineLobby onlineLobby, final IOnlineChatInterface chatInterface) {
        IGuiGame gui = GuiBase.getInterface().getNewGuiGame();
        FGameClient client = new FGameClient(FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME), "0", gui);
        onlineLobby.setClient(client);
        chatInterface.setGameClient(client);
        final ClientGameLobby lobby = new ClientGameLobby();
        ILobbyView view = onlineLobby.setLobby(lobby);
        lobby.setListener(view);
        client.addLobbyListener(new ILobbyListener(){

            @Override
            public void message(String source, String message) {
                chatInterface.addMessage(new ChatMessage(source, message));
            }

            @Override
            public void update(GameLobby.GameLobbyData state, int slot) {
                lobby.setLocalPlayer(slot);
                lobby.setData(state);
            }

            @Override
            public void close() {
                GuiBase.setInterrupted(true);
                onlineLobby.closeConn(Localizer.getInstance().getMessage("lblYourConnectionToHostWasInterrupted", url));
            }

            @Override
            public ClientGameLobby getLobby() {
                return lobby;
            }
        });
        view.setPlayerChangeListener((index, event) -> client.send(event));
        String hostname = url;
        int port = ForgeProfileProperties.getServerPort();
        int index2 = url.indexOf(58);
        if (index2 >= 0) {
            hostname = url.substring(0, index2);
            String portStr = url.substring(index2 + 1);
            try {
                port = Integer.parseInt(portStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            client.connect(hostname, port);
        }
        catch (Exception ex) {
            return new ChatMessage(null, "<<_EM_ESOLC_<<");
        }
        return new ChatMessage(null, Localizer.getInstance().getMessage("lblConnectedIPPort", hostname, String.valueOf(port)));
    }
}

