/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.net;

import forge.gamemodes.net.IRemote;
import forge.gamemodes.net.ProtocolMethod;
import forge.gamemodes.net.ReplyPool;
import forge.gamemodes.net.event.GuiGameEvent;
import forge.gamemodes.net.event.ReplyEvent;
import forge.gui.FThreads;
import forge.gui.util.SOptionPane;
import forge.localinstance.skin.FSkinProp;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class GameProtocolHandler<T>
extends ChannelInboundHandlerAdapter {
    private final boolean runInEdt;

    protected GameProtocolHandler(boolean runInEdt) {
        this.runInEdt = runInEdt;
    }

    protected abstract ReplyPool getReplyPool(ChannelHandlerContext var1);

    protected abstract IRemote getRemote(ChannelHandlerContext var1);

    protected abstract T getToInvoke(ChannelHandlerContext var1);

    protected abstract void beforeCall(ProtocolMethod var1, Object[] var2);

    @Override
    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        String[] catchedError = new String[]{""};
        System.out.println("Received: " + msg);
        if (msg instanceof ReplyEvent) {
            ReplyEvent event = (ReplyEvent)msg;
            this.getReplyPool(ctx).complete(event.getIndex(), event.getReply());
        } else if (msg instanceof GuiGameEvent) {
            GuiGameEvent event = (GuiGameEvent)msg;
            ProtocolMethod protocolMethod = event.getMethod();
            String methodName = protocolMethod.name();
            Method method = protocolMethod.getMethod();
            if (method == null) {
                catchedError[0] = catchedError[0] + String.format("IllegalStateException: Method %s not found (GameProtocolHandler.java Line 43)\n", protocolMethod.name());
                System.err.printf("Method %s not found%n", protocolMethod.name());
            }
            Object[] args = event.getObjects();
            protocolMethod.checkArgs(args);
            T toInvoke = this.getToInvoke(ctx);
            this.beforeCall(protocolMethod, args);
            Class<?> returnType = protocolMethod.getReturnType();
            Runnable toRun = () -> {
                if (returnType.equals(Void.TYPE)) {
                    try {
                        method.invoke(toInvoke, args);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        System.err.printf("Unknown protocol method %s with %d args%n", methodName, args == null ? 0 : args.length);
                    }
                    catch (InvocationTargetException e) {
                        catchedError[0] = catchedError[0] + String.format("RuntimeException: %s (GameProtocolHandler.java Line 65)\n", e.getTargetException().toString());
                        System.err.println(e.getTargetException().toString());
                    }
                } else {
                    Serializable reply = null;
                    try {
                        Object theReply = method.invoke(toInvoke, args);
                        if (theReply instanceof Serializable) {
                            protocolMethod.checkReturnValue(theReply);
                            reply = (Serializable)theReply;
                        } else if (theReply != null) {
                            System.err.printf("Non-serializable return type %s for method %s, returning null%n", returnType.getName(), methodName);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        System.err.printf("Unknown protocol method %s with %d args, replying with null%n", methodName, args == null ? 0 : args.length);
                    }
                    catch (NullPointerException | InvocationTargetException e) {
                        catchedError[0] = catchedError[0] + e.toString();
                        SOptionPane.showMessageDialog(catchedError[0], "Error", FSkinProp.ICO_WARNING);
                        System.err.println(e.toString());
                    }
                    this.getRemote(ctx).send(new ReplyEvent(event.getId(), reply));
                }
            };
            if (this.runInEdt) {
                FThreads.invokeInEdtNowOrLater(toRun);
            } else {
                FThreads.invokeInBackgroundThread(toRun);
            }
        }
    }

    @Override
    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

