/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.gui.FThreads;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.PlayerControllerHuman;
import forge.player.PlayerZoneUpdate;
import forge.player.PlayerZoneUpdates;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.ITriggerEvent;
import forge.util.Lang;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;

public final class InputSelectTargets
extends InputSyncronizedBase {
    private final List<Card> choices;
    private final Set<GameEntity> targets = Sets.newHashSet();
    private final TargetRestrictions tgt;
    private final SpellAbility sa;
    private final Integer numTargets;
    private final Collection<Integer> divisionValues;
    private Card lastTarget = null;
    private boolean bCancel = false;
    private boolean bOk = false;
    private final boolean mandatory;
    private Predicate<GameObject> filter;
    private boolean mustTargetFiltered;
    private static final long serialVersionUID = -1091595663541356356L;

    public boolean hasCancelled() {
        return this.bCancel;
    }

    public boolean hasPressedOk() {
        return this.bOk;
    }

    public InputSelectTargets(PlayerControllerHuman controller, List<Card> choices, SpellAbility sa, boolean mandatory, Integer numTargets, Collection<Integer> divisionValues, Predicate<GameObject> filter, boolean mustTargetFiltered) {
        super(controller);
        this.choices = choices;
        this.tgt = sa.getTargetRestrictions();
        this.sa = sa;
        this.mandatory = mandatory;
        this.numTargets = numTargets;
        this.divisionValues = divisionValues;
        this.filter = filter;
        this.mustTargetFiltered = mustTargetFiltered;
        for (Card card : sa.getTargets().getTargetCards()) {
            this.targets.add(card);
            this.lastTarget = card;
        }
        controller.getGui().setSelectables(CardView.getCollection(choices));
        PlayerZoneUpdates zonesToUpdate = new PlayerZoneUpdates();
        for (Card c : choices) {
            zonesToUpdate.add(new PlayerZoneUpdate(c.getZone().getPlayer().getView(), c.getZone().getZoneType()));
        }
        FThreads.invokeInEdtNowOrLater(() -> {
            for (GameEntity c : this.targets) {
                if (!(c instanceof Card)) continue;
                controller.getGui().setUsedToPay(CardView.get((Card)c), true);
            }
            controller.getGui().updateZones(zonesToUpdate);
        });
    }

    @Override
    public void showMessage() {
        this.getController().getGui().setCard(CardView.get(this.sa.getHostCard()));
        StringBuilder sb = new StringBuilder();
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DETAILED_SPELLDESC_IN_PROMPT)) {
            sb.append(this.sa.getHostCard().toString()).append(" - ");
            sb.append(this.sa.toString()).append("\n");
            if (!ForgeConstants.isGdxPortLandscape) {
                sb.append("\n");
            }
            sb.append(this.tgt.getVTSelection());
        } else {
            sb.append(this.sa.getHostCard()).append(" - ").append(this.tgt.getVTSelection());
        }
        if (!this.targets.isEmpty()) {
            sb.append("\nTargeted: ");
        }
        for (GameEntity o : this.targets) {
            if (!ForgeConstants.isGdxPortLandscape) {
                sb.append("\n");
            }
            sb.append(o);
            if (!ForgeConstants.isGdxPortLandscape) continue;
            sb.append(", ");
        }
        if (!this.sa.getUniqueTargets().isEmpty()) {
            sb.append("\nParent Targeted:");
            sb.append(this.sa.getUniqueTargets());
        }
        int maxTargets = ObjectUtils.firstNonNull(this.numTargets, this.sa.getMaxTargets());
        int targeted = this.sa.getTargets().size();
        if (maxTargets > 1) {
            sb.append(TextUtil.concatNoSpace("\n(", String.valueOf(maxTargets - targeted), " more can be targeted)"));
        }
        String name = CardTranslation.getTranslatedName(this.sa.getHostCard().getName());
        String message = TextUtil.fastReplace(TextUtil.fastReplace(sb.toString(), "CARDNAME", name), "(Targeting ERROR)", "");
        message = TextUtil.fastReplace(message, "NICKNAME", Lang.getInstance().getNickName(name));
        this.showMessage(message, this.sa.getView());
        if (this.divisionValues != null && !this.divisionValues.isEmpty() && this.sa.getMinTargets() == 0 && this.sa.getTargets().size() == 0) {
            this.getController().getGui().updateButtons(this.getOwner(), true, true, false);
        } else if (!this.sa.isMinTargetChosen() || this.numTargets != null && this.targets.size() != this.numTargets.intValue() || this.divisionValues != null && !this.divisionValues.isEmpty()) {
            if (this.mandatory && this.tgt.hasCandidates(this.sa)) {
                this.getController().getGui().updateButtons(this.getOwner(), false, false, false);
            } else {
                this.getController().getGui().updateButtons(this.getOwner(), false, true, false);
            }
        } else if (this.mandatory && this.tgt.hasCandidates(this.sa)) {
            this.getController().getGui().updateButtons(this.getOwner(), true, false, true);
        } else {
            this.getController().getGui().updateButtons(this.getOwner(), true, true, true);
        }
    }

    @Override
    protected void onCancel() {
        this.bCancel = true;
        this.done();
    }

    @Override
    protected void onOk() {
        this.bOk = true;
        this.done();
    }

    @Override
    protected boolean onCardSelected(Card card, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        Boolean val;
        Integer cmc;
        Player p;
        int maxTotalPower;
        int soFar;
        int maxTotalCMC;
        if (this.targets.contains(card)) {
            this.removeTarget(card);
            return false;
        }
        if (!card.canBeTargetedBy(this.sa)) {
            this.showMessage(this.sa.getHostCard() + " - Cannot target this card (Shroud? Protection? Restrictions).");
            return false;
        }
        if (this.tgt.isSingleZone() && this.lastTarget != null && !card.getController().equals(this.lastTarget.getController())) {
            this.showMessage(this.sa.getHostCard() + " - Cannot target this card (not in the same zone)");
            return false;
        }
        if (this.tgt.isWithoutSameCreatureType() && this.lastTarget != null && card.sharesCreatureTypeWith(this.lastTarget)) {
            this.showMessage(this.sa.getHostCard() + " - Cannot target this card (should not share a creature type)");
            return false;
        }
        if (this.tgt.isWithSameCreatureType() && this.lastTarget != null && !card.sharesCreatureTypeWith(this.lastTarget)) {
            this.showMessage(this.sa.getHostCard() + " - Cannot target this card (should share a creature type)");
            return false;
        }
        if (this.tgt.isWithSameCardType() && this.lastTarget != null && !card.sharesCardTypeWith(this.lastTarget)) {
            this.showMessage(this.sa.getHostCard() + " - Cannot target this card (should share a Card type)");
            return false;
        }
        if (this.sa.hasParam("MaxTotalTargetCMC") && (maxTotalCMC = this.tgt.getMaxTotalCMC(this.sa.getHostCard(), this.sa)) > 0) {
            soFar = Aggregates.sum(this.sa.getTargets().getTargetCards(), Card::getCMC);
            if (!this.sa.isTargeting(card)) {
                soFar += card.getCMC();
            }
            if (soFar > maxTotalCMC) {
                this.showMessage(this.sa.getHostCard() + " - Cannot target this card (mana value limit exceeded)");
                return false;
            }
        }
        if (this.sa.hasParam("MaxTotalTargetPower") && (maxTotalPower = this.tgt.getMaxTotalPower(this.sa.getHostCard(), this.sa)) > 0) {
            soFar = Aggregates.sum(this.sa.getTargets().getTargetCards(), Card::getNetPower);
            if (!this.sa.isTargeting(card)) {
                soFar += card.getNetPower();
            }
            if (soFar > maxTotalPower) {
                this.showMessage(this.sa.getHostCard() + " - Cannot target this card (power limit exceeded)");
                return false;
            }
        }
        if (this.tgt.isSameController()) {
            ArrayList<Player> targetedControllers = new ArrayList<Player>();
            for (GameObject gameObject : this.targets) {
                if (!(gameObject instanceof Card)) continue;
                p = ((Card)gameObject).getController();
                targetedControllers.add(p);
            }
            if (!targetedControllers.isEmpty() && !targetedControllers.contains(card.getController())) {
                this.showMessage(this.sa.getHostCard() + " - Cannot target this card (must have same controller)");
                return false;
            }
        }
        if (this.tgt.isDifferentControllers() || this.tgt.isForEachPlayer()) {
            ArrayList<Player> targetedControllers = new ArrayList<Player>();
            for (GameObject gameObject : this.targets) {
                if (!(gameObject instanceof Card)) continue;
                p = ((Card)gameObject).getController();
                targetedControllers.add(p);
            }
            if (targetedControllers.contains(card.getController())) {
                this.showMessage(this.sa.getHostCard() + " - Cannot target this card (must have different controllers)");
                return false;
            }
        }
        if (this.tgt.isEqualToughness()) {
            ArrayList<Integer> tgtTs = new ArrayList<Integer>();
            for (GameObject gameObject : this.targets) {
                if (!(gameObject instanceof Card)) continue;
                cmc = ((Card)gameObject).getNetToughness();
                tgtTs.add(cmc);
            }
            if (!tgtTs.isEmpty() && !tgtTs.contains(card.getNetToughness())) {
                this.showMessage(this.sa.getHostCard() + " - Cannot target this card (must have equal toughness)");
                return false;
            }
        }
        if (this.tgt.isDifferentCMC()) {
            ArrayList<Integer> targetedCMCs = new ArrayList<Integer>();
            for (GameObject gameObject : this.targets) {
                if (!(gameObject instanceof Card)) continue;
                cmc = ((Card)gameObject).getCMC();
                targetedCMCs.add(cmc);
            }
            if (targetedCMCs.contains(card.getCMC())) {
                this.showMessage(this.sa.getHostCard() + " - Cannot target this card (must have different mana values)");
                return false;
            }
        }
        if (!this.choices.contains(card)) {
            this.showMessage(this.sa.getHostCard() + " - The selected card is not a valid choice to be targeted.");
            return false;
        }
        if (this.divisionValues != null && !this.divisionValues.isEmpty() && (val = this.onDividedAsYouChoose(card)) != null) {
            return val;
        }
        this.addTarget(card);
        return true;
    }

    @Override
    public String getActivateAction(Card card) {
        if (!this.tgt.isUniqueTargets() && this.targets.contains(card)) {
            return null;
        }
        if (this.choices.contains(card)) {
            return "select card as target";
        }
        return null;
    }

    @Override
    protected void onPlayerSelected(Player player, ITriggerEvent triggerEvent) {
        Boolean val;
        if (this.targets.contains(player)) {
            this.removeTarget(player);
            return;
        }
        if (player.hasLost()) {
            this.showMessage(this.sa.getHostCard() + " - Cannot target this player - already lost.");
            return;
        }
        if (!this.sa.canTarget(player) || this.mustTargetFiltered) {
            this.showMessage(this.sa.getHostCard() + " - Cannot target this player (Hexproof? Protection? Restrictions?).");
            return;
        }
        if (this.filter != null && !this.filter.apply(player)) {
            this.showMessage(this.sa.getHostCard() + " - Cannot target this player (Hexproof? Protection? Restrictions?).");
            return;
        }
        if (this.divisionValues != null && !this.divisionValues.isEmpty() && (val = this.onDividedAsYouChoose(player)) != null) {
            return;
        }
        this.addTarget(player);
    }

    protected Boolean onDividedAsYouChoose(GameObject go) {
        String apiBasedMessage = "Distribute how much to ";
        if (this.sa.getApi() == ApiType.DealDamage) {
            apiBasedMessage = "Select how much damage to deal to ";
        } else if (this.sa.getApi() == ApiType.PreventDamage) {
            apiBasedMessage = "Select how much damage to prevent to ";
        } else if (this.sa.getApi() == ApiType.PutCounter) {
            apiBasedMessage = "Select how many counters to distribute to ";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(apiBasedMessage);
        sb.append(go.toString());
        Integer chosen = this.getController().getGui().oneOrNone(sb.toString(), Lists.newArrayList(this.divisionValues));
        if (chosen == null) {
            return true;
        }
        this.divisionValues.remove(chosen);
        this.sa.addDividedAllocation(go, chosen);
        return null;
    }

    private void addTarget(GameEntity ge) {
        this.sa.getTargets().add(ge);
        if (ge instanceof Card) {
            this.getController().getGui().setUsedToPay(CardView.get((Card)ge), true);
            this.lastTarget = (Card)ge;
        } else if (ge instanceof Player) {
            this.getController().getGui().setHighlighted(PlayerView.get((Player)ge), true);
        }
        this.targets.add(ge);
        if (this.hasAllTargets()) {
            this.bOk = true;
            this.done();
        } else if (ge instanceof Card && this.mustTargetFiltered) {
            this.done();
        } else {
            this.showMessage();
        }
    }

    private void removeTarget(GameEntity ge) {
        this.targets.remove(ge);
        this.sa.getTargets().remove(ge);
        if (ge instanceof Card) {
            this.getController().getGui().setUsedToPay(CardView.get((Card)ge), false);
            this.lastTarget = Iterables.getLast(Iterables.filter(this.targets, Card.class), null);
        } else if (ge instanceof Player) {
            this.getController().getGui().setHighlighted(PlayerView.get((Player)ge), false);
        }
        this.showMessage();
    }

    private void done() {
        for (GameEntity c : this.targets) {
            if (c instanceof Card) {
                this.getController().getGui().setUsedToPay(CardView.get((Card)c), false);
                continue;
            }
            if (!(c instanceof Player)) continue;
            this.getController().getGui().setHighlighted(PlayerView.get((Player)c), false);
        }
        this.stop();
    }

    private boolean hasAllTargets() {
        return this.sa.isMaxTargetChosen() || this.numTargets != null && this.numTargets.intValue() == this.targets.size() || this.divisionValues != null && this.sa.getStillToDivide() <= 0 || this.divisionValues == null && this.sa.isDividedAsYouChoose() && this.targets.size() == this.sa.getStillToDivide();
    }

    @Override
    protected void onStop() {
        this.getController().getGui().clearSelectables();
        super.onStop();
    }
}

