/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.card.CardView;
import forge.game.cost.CostExile;
import forge.game.cost.CostTapType;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.Zone;
import forge.gamemodes.match.input.InputSelectManyBase;
import forge.gui.FThreads;
import forge.player.PlayerControllerHuman;
import forge.player.PlayerZoneUpdate;
import forge.player.PlayerZoneUpdates;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InputSelectEntitiesFromList<T extends GameEntity>
extends InputSelectManyBase<T> {
    private static final long serialVersionUID = -6609493252672573139L;
    private final FCollectionView<T> validChoices;
    protected final FCollection<T> selected = new FCollection();
    protected Iterable<PlayerZoneUpdate> zonesShown;

    public InputSelectEntitiesFromList(PlayerControllerHuman controller, int min2, int max, FCollectionView<T> validChoices0) {
        this(controller, min2, max, validChoices0, null, "", 0);
    }

    public InputSelectEntitiesFromList(PlayerControllerHuman controller, int min2, int max, FCollectionView<T> validChoices0, SpellAbility sa0) {
        this(controller, min2, max, validChoices0, sa0, "", 0);
    }

    public InputSelectEntitiesFromList(PlayerControllerHuman controller, int min2, int max, FCollectionView<T> validChoices0, SpellAbility sa0, String tallyType0, int tally0) {
        super(controller, Math.min(min2, validChoices0.size()), Math.min(max, validChoices0.size()), sa0, tallyType0, tally0);
        this.validChoices = validChoices0;
        if (min2 > this.validChoices.size()) {
            System.out.printf("Trying to choose at least %d things from a list with only %d things!%n", min2, this.validChoices.size());
        }
        ArrayList<CardView> vCards = new ArrayList<CardView>();
        for (GameEntity c : validChoices0) {
            if (!(c instanceof Card)) continue;
            vCards.add(((Card)c).getView());
        }
        this.getController().getGui().setSelectables(vCards);
        PlayerZoneUpdates zonesToUpdate = new PlayerZoneUpdates();
        for (GameEntity c : this.validChoices) {
            Zone cz = c instanceof Card ? ((Card)c).getLastKnownZone() : null;
            if (cz == null) continue;
            zonesToUpdate.add(new PlayerZoneUpdate(cz.getPlayer().getView(), cz.getZoneType()));
        }
        FThreads.invokeInEdtNowOrLater(() -> {
            this.getController().getGui().updateZones(zonesToUpdate);
            this.zonesShown = this.getController().getGui().tempShowZones(controller.getPlayer().getView(), zonesToUpdate);
        });
    }

    @Override
    protected boolean onCardSelected(Card c, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        if (!this.selectEntity(c)) {
            return false;
        }
        this.refresh();
        return true;
    }

    @Override
    public String getActivateAction(Card card) {
        if (this.validChoices.contains(card)) {
            if (this.selected.contains(card)) {
                return "unselect card";
            }
            return "select card";
        }
        return null;
    }

    @Override
    protected void onPlayerSelected(Player p, ITriggerEvent triggerEvent) {
        if (!this.selectEntity(p)) {
            return;
        }
        this.refresh();
    }

    @Override
    public final Collection<T> getSelected() {
        return this.selected;
    }

    protected boolean selectEntity(GameEntity c) {
        if (!this.validChoices.contains(c)) {
            return false;
        }
        boolean entityWasSelected = this.selected.contains(c);
        if (entityWasSelected) {
            this.selected.remove(c);
        } else {
            this.selected.add(c);
        }
        this.onSelectStateChanged(c, !entityWasSelected);
        return true;
    }

    @Override
    protected boolean hasEnoughTargets() {
        return this.selected.size() >= this.min;
    }

    @Override
    protected boolean hasAllTargets() {
        return this.selected.size() >= this.max;
    }

    @Override
    protected String getMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.max == Integer.MAX_VALUE ? String.format(this.message, this.selected.size()) : String.format(this.message, this.max - this.selected.size()));
        if (this.sa != null) {
            if (this.sa.getPayCosts().hasSpecificCostType(CostTapType.class) && (this.sa.isCrew() || this.sa.isKeyword(Keyword.SADDLE))) {
                msg.append(this.sa.isCrew() ? "\nCrewing: " : "\nSaddling: ");
                msg.append(CardLists.getTotalPower((FCollection)this.getSelected(), true, true));
                msg.append(" / ").append(TextUtil.fastReplace(this.sa.getPayCosts().getCostPartByType(CostTapType.class).getType(), "Creature.Other+withTotalPowerGE", ""));
            } else if (this.sa.getPayCosts().hasSpecificCostType(CostExile.class) && this.tally > 0) {
                msg.append("\n");
                if (this.tallyType.equals("CMC")) {
                    msg.append(Localizer.getInstance().getMessage("lblCMC", new Object[0])).append(": ");
                    msg.append(CardLists.getTotalCMC((FCollection)this.getSelected())).append(" / ").append(this.tally);
                } else if (this.tallyType.equals("Types")) {
                    msg.append(Localizer.getInstance().getMessage("lblTypes", new Object[0])).append(": ");
                    msg.append(AbilityUtils.countCardTypesFromList((FCollection)this.getSelected(), false));
                    msg.append(" / ").append(this.tally);
                }
            }
        }
        return msg.toString();
    }

    @Override
    protected void onStop() {
        this.getController().getGui().hideZones(this.getController().getPlayer().getView(), this.zonesShown);
        this.getController().getGui().clearSelectables();
        super.onStop();
    }
}

