/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.gamemodes.match.input.Input;
import forge.gamemodes.match.input.InputAttack;
import forge.gamemodes.match.input.InputLockUI;
import forge.gui.FThreads;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicReference;

public class InputProxy
implements Observer {
    private AtomicReference<Input> input = new AtomicReference();
    private final PlayerControllerHuman controller;

    public InputProxy(PlayerControllerHuman controller0) {
        this.controller = controller0;
    }

    @Override
    public final void update(Observable observable, Object obj) {
        Input nextInput = this.controller.getInputQueue().getActualInput(this.controller);
        this.input.set(nextInput);
        if (!(nextInput instanceof InputLockUI)) {
            this.controller.getGui().setCurrentPlayer(nextInput.getOwner());
        }
        Runnable showMessage = () -> {
            Input current = this.getInput();
            this.controller.getInputQueue().syncPoint();
            current.showMessageInitial();
        };
        FThreads.invokeInEdtLater(showMessage);
    }

    public final void selectButtonOK() {
        Input inp = this.getInput();
        if (inp != null) {
            inp.selectButtonOK();
        }
    }

    public final void selectButtonCancel() {
        Input inp = this.getInput();
        if (inp != null) {
            inp.selectButtonCancel();
        }
    }

    public final void selectPlayer(PlayerView playerView, ITriggerEvent triggerEvent) {
        Player player;
        Input inp = this.getInput();
        if (inp != null && (player = this.controller.getGame().getPlayer(playerView)) != null) {
            inp.selectPlayer(player, triggerEvent);
        }
    }

    private Card getCard(CardView cardView) {
        return this.controller.getCard(cardView);
    }

    public final String getActivateAction(CardView cardView) {
        Card card;
        Input inp = this.getInput();
        if (inp != null && (card = this.getCard(cardView)) != null) {
            return inp.getActivateAction(card);
        }
        return null;
    }

    public final boolean selectCard(CardView cardView, List<CardView> otherCardViewsToSelect, ITriggerEvent triggerEvent) {
        Card card;
        Input inp = this.getInput();
        if (inp != null && (card = this.getCard(cardView)) != null) {
            ArrayList<Card> otherCardsToSelect = null;
            if (otherCardViewsToSelect != null) {
                for (CardView cv : otherCardViewsToSelect) {
                    Card c = this.getCard(cv);
                    if (c == null) continue;
                    if (otherCardsToSelect == null) {
                        otherCardsToSelect = new ArrayList<Card>();
                    }
                    otherCardsToSelect.add(c);
                }
            }
            return inp.selectCard(card, otherCardsToSelect, triggerEvent);
        }
        return false;
    }

    public final void selectAbility(SpellAbility sa) {
        Input inp = this.getInput();
        if (inp != null && sa != null) {
            inp.selectAbility(sa);
        }
    }

    public final void alphaStrike() {
        Input inp = this.getInput();
        if (inp instanceof InputAttack) {
            ((InputAttack)inp).alphaStrike();
        }
    }

    public final String toString() {
        Input inp = this.getInput();
        return null == inp ? "(null)" : inp.toString();
    }

    public Input getInput() {
        return this.input.get();
    }
}

